/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.event.powers;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.KeyInputRegistry;
import net.hydra.jojomod.client.KeyboardPilotInput;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.AbilityIconInstance;
import net.hydra.jojomod.event.ModGamerules;
import net.hydra.jojomod.event.index.OffsetIndex;
import net.hydra.jojomod.event.powers.CooldownInstance;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.event.powers.StandUserClient;
import net.hydra.jojomod.event.powers.TimeStop;
import net.hydra.jojomod.event.powers.stand.presets.TWAndSPSharedPowers;
import net.hydra.jojomod.item.MaxStandDiscItem;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.item.StandDiscItem;
import net.hydra.jojomod.networking.ModPacketHandler;
import net.hydra.jojomod.sound.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class StandPowers {
    public final LivingEntity self;
    public int attackTime = -1;
    public int attackTimeDuring = -1;
    public int attackTimeMax = -1;
    public byte activePower = 0;
    public byte activePowerPhase = 0;
    public final byte activePowerPhaseMax = (byte)3;
    public boolean kickStarted = true;
    public int summonCD = 0;
    private byte activePowerPhaseCheck = (byte)-1;
    private int chargedTSTicks = 0;
    public boolean hasActedInTS = false;
    public int storedInt = 0;
    public int interruptCD = 0;
    public boolean forwardBarrage = false;
    public boolean suspendGuard = false;
    public int scopeLevel = 0;
    public int scopeTime = -1;
    public List<CooldownInstance> StandCooldowns = this.initStandCooldowns();
    public int iconSize = 18;
    public int iconSize2 = 16;
    int squareHeight = 24;
    int squareWidth = 24;
    public static final byte TIME_STOP_NOISE = 40;
    public static final byte TIME_STOP_NOISE_2 = 41;
    public static final byte TIME_STOP_NOISE_3 = 42;
    public static final byte TIME_STOP_NOISE_4 = 43;
    public static final byte TIME_STOP_NOISE_5 = 44;
    public static final byte TIME_STOP_NOISE_6 = 45;
    public static final byte TIME_STOP_NOISE_7 = 46;
    public static final byte TIME_STOP_NOISE_8 = 47;
    public static final byte TIME_STOP_NOISE_9 = 48;
    public static final byte TIME_STOP_NOISE_10 = 49;
    public static final byte TIME_STOP_TICKING = 53;
    public static final byte TIME_RESUME_NOISE = 60;
    public static final byte TIME_RESUME_NOISE_2 = 61;
    private int clashIncrement = 0;
    private int clashMod = 0;
    public boolean clashDone = false;
    public float clashProgress = 0.0f;
    private float clashOpProgress = 0.0f;
    @Nullable
    private LivingEntity clashOp;
    public boolean moveStarted = false;
    public Entity storeEnt = null;
    public int clashStarter = 0;
    public boolean isHoldingSneakToggle = false;
    public boolean heldDownSwitch = false;

    public void playerSetProperties(Player PE) {
    }

    public StandPowers(LivingEntity self) {
        this.self = self;
    }

    public StandPowers generateStandPowers(LivingEntity entity) {
        return null;
    }

    public LivingEntity getSelf() {
        return this.self;
    }

    public int getAttackTime() {
        return this.attackTime;
    }

    public int getAttackTimeDuring() {
        return this.attackTimeDuring;
    }

    public byte getActivePower() {
        return this.activePower;
    }

    public byte getActivePowerPhase() {
        return this.activePowerPhase;
    }

    public byte getActivePowerPhaseMax() {
        return this.activePowerPhaseMax;
    }

    public void setAttackTime(int attackTime) {
        this.attackTime = attackTime;
    }

    public void setAttackTimeDuring(int attackTimeDuring) {
        this.attackTimeDuring = attackTimeDuring;
    }

    public void setAttackTimeMax(int attackTimeMax) {
        this.attackTimeMax = attackTimeMax;
    }

    public int getAttackTimeMax() {
        return this.attackTimeMax;
    }

    public void setMaxAttackTime(int attackTimeMax) {
        this.attackTimeMax = attackTimeMax;
    }

    public void setActivePower(byte activeMove) {
        this.activePower = activeMove;
    }

    public void setActivePowerPhase(byte activePowerPhase) {
        this.activePowerPhase = activePowerPhase;
    }

    public float getTimestopRange() {
        return ClientNetworking.getAppropriateConfig().timeStopSettings.blockRangeNegativeOneIsInfinite.intValue();
    }

    public float getPermaCastRange() {
        return 100.0f;
    }

    public byte getPermaCastContext() {
        return -1;
    }

    public boolean canSeeThroughFog() {
        return false;
    }

    public void onStandSwitch() {
    }

    public Component getStandName() {
        Item item;
        ItemStack disc = ((StandUser)this.getSelf()).roundabout$getStandDisc();
        if (!disc.m_41619_() && (item = disc.m_41720_()) instanceof StandDiscItem) {
            StandDiscItem SDI = (StandDiscItem)item;
            return SDI.getDisplayName2();
        }
        return Component.m_237119_();
    }

    public int getChargedTSTicks() {
        return this.chargedTSTicks;
    }

    public void setChargedTSTicks(int chargedTSSeconds) {
        this.chargedTSTicks = chargedTSSeconds;
    }

    public int getMaxTSTime() {
        return 0;
    }

    public int getMaxChargeTSTime() {
        return 0;
    }

    public boolean getIsTsCharging() {
        return false;
    }

    public boolean canLightFurnace() {
        return false;
    }

    public int getDisplayPowerInventoryScale() {
        return 30;
    }

    public int getDisplayPowerInventoryYOffset() {
        return 0;
    }

    public boolean getSummonCD() {
        return this.summonCD <= 0;
    }

    public void setSummonCD(int summonCD) {
        this.summonCD = summonCD;
    }

    public int getSummonCD2() {
        return this.summonCD;
    }

    public boolean getInterruptCD() {
        return this.interruptCD <= 0;
    }

    public void setInterruptCD(int interruptCD) {
        this.interruptCD = interruptCD;
    }

    public boolean canBeTimeStopped() {
        return ((TimeStop)this.self.m_9236_()).inTimeStopRange((Entity)this.self);
    }

    public void buttonInput4(boolean keyIsDown, Options options) {
    }

    public void buttonInput3(boolean keyIsDown, Options options) {
    }

    public void buttonInput2(boolean keyIsDown, Options options) {
    }

    public void buttonInput1(boolean keyIsDown, Options options) {
    }

    public void preButtonInput4(boolean keyIsDown, Options options) {
        if (this.hasStandActive(this.getSelf()) && !this.isClashing() && !((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity((Entity)this.getSelf())) {
            this.buttonInput4(keyIsDown, options);
        }
    }

    public int getMobRecoilTime() {
        return -30;
    }

    public void preButtonInput3(boolean keyIsDown, Options options) {
        if (this.hasStandActive(this.getSelf()) && !this.isClashing() && !((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity((Entity)this.getSelf())) {
            this.buttonInput3(keyIsDown, options);
        }
    }

    public void preButtonInput2(boolean keyIsDown, Options options) {
        if (this.hasStandActive(this.getSelf()) && !this.isClashing() && !((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity((Entity)this.getSelf())) {
            this.buttonInput2(keyIsDown, options);
        }
    }

    public void preButtonInput1(boolean keyIsDown, Options options) {
        if (this.hasStandActive(this.getSelf()) && !this.isClashing() && !((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity((Entity)this.getSelf())) {
            this.buttonInput1(keyIsDown, options);
        }
    }

    public void updateGuard(boolean yeet) {
        if (this.suspendGuard && !yeet) {
            this.suspendGuard = false;
        }
    }

    public boolean cancelItemUse() {
        return false;
    }

    public boolean cancelCollision(Entity et) {
        return false;
    }

    public boolean buttonInputGuard(boolean keyIsDown, Options options) {
        return false;
    }

    public void preCheckButtonInputAttack(boolean keyIsDown, Options options) {
        if (this.hasStandActive(this.getSelf()) && !this.isGuarding()) {
            this.buttonInputAttack(keyIsDown, options);
        }
    }

    public void preCheckButtonInputUse(boolean keyIsDown, Options options) {
        if (this.hasStandActive(this.getSelf())) {
            this.buttonInputUse(keyIsDown, options);
        }
    }

    public void preCheckButtonInputBarrage(boolean keyIsDown, Options options) {
        if (this.hasStandActive(this.getSelf())) {
            this.buttonInputBarrage(keyIsDown, options);
        }
    }

    public boolean preCheckButtonInputGuard(boolean keyIsDown, Options options) {
        if (this.hasStandActive(this.getSelf())) {
            return this.buttonInputGuard(keyIsDown, options);
        }
        return false;
    }

    public void buttonInputAttack(boolean keyIsDown, Options options) {
        if (keyIsDown && this.canAttack()) {
            this.tryPower(1, true);
            ModPacketHandler.PACKET_ACCESS.StandPowerPacket((byte)1);
        }
    }

    public void buttonInputUse(boolean keyIsDown, Options options) {
        if (keyIsDown) {
            // empty if block
        }
    }

    public void buttonInputBarrage(boolean keyIsDown, Options options) {
        if (keyIsDown && (this.getAttackTime() >= this.getAttackTimeMax() || this.getActivePowerPhase() != this.getActivePowerPhaseMax())) {
            this.tryPower(4, true);
            ModPacketHandler.PACKET_ACCESS.StandPowerPacket((byte)4);
        }
    }

    public void addEXP(int amt, LivingEntity ent) {
        if (!((StandUser)ent).roundabout$getStandDisc().m_41619_() && (ent instanceof Monster || ent instanceof NeutralMob)) {
            if (ent.m_21233_() >= 100.0f) {
                amt = (int)((double)amt * 0.5);
            }
            this.addEXP(amt * 5);
        } else {
            if (ent.m_21233_() >= 100.0f) {
                amt = (int)((double)amt * 0.5);
            }
            this.addEXP(amt);
        }
    }

    public void addEXP(int amt) {
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            Player PE = (Player)livingEntity;
            StandUser user = (StandUser)PE;
            ItemStack stack = ((StandUser)PE).roundabout$getStandDisc();
            if (!stack.m_41619_() && !(stack.m_41720_() instanceof MaxStandDiscItem)) {
                IPlayerEntity ipe = (IPlayerEntity)PE;
                ipe.roundabout$addStandExp(amt);
            }
        }
    }

    public void pilotInputAttack() {
    }

    public boolean pilotInputInteract() {
        return false;
    }

    public int getPilotMode() {
        return 2;
    }

    public int getMaxPilotRange() {
        return 100;
    }

    public void levelUp() {
        if (!this.getSelf().m_9236_().m_5776_()) {
            ((ServerLevel)this.self.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123810_, this.getSelf().m_20185_(), this.getSelf().m_20186_() + (double)this.getSelf().m_20192_(), this.getSelf().m_20189_(), 20, 0.4, 0.4, 0.4, 0.4);
            this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.LEVELUP_EVENT, SoundSource.PLAYERS, 0.95f, (float)(0.8 + Math.random() * 0.4));
        }
    }

    public void setScopeLevel(int level) {
        if (this.scopeLevel <= 0 && level > 0) {
            if (this.getSelf().m_9236_().m_5776_()) {
                ModPacketHandler.PACKET_ACCESS.singleByteToServerPacket((byte)4);
            }
        } else if (this.scopeLevel > 0 && level <= 0 && this.getSelf().m_9236_().m_5776_()) {
            ModPacketHandler.PACKET_ACCESS.singleByteToServerPacket((byte)5);
        }
        this.scopeLevel = level;
    }

    public boolean canScope() {
        return false;
    }

    public List<CooldownInstance> initStandCooldowns() {
        ArrayList<CooldownInstance> Cooldowns2 = new ArrayList<CooldownInstance>();
        for (int i = 0; i < 10; i = (int)((byte)(i + 1))) {
            Cooldowns2.add(new CooldownInstance(-1, -1));
        }
        return Cooldowns2;
    }

    public List<Byte> getSkinList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)0);
        return $$1;
    }

    public Component getSkinName(byte skinId) {
        return Component.m_237119_();
    }

    public List<Byte> getPosList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)0);
        $$1.add((byte)1);
        return $$1;
    }

    public void setCooldown(byte power, int cooldown) {
        if (!this.StandCooldowns.isEmpty() && this.StandCooldowns.size() >= power) {
            this.StandCooldowns.get((int)power).time = cooldown;
            this.StandCooldowns.get((int)power).maxTime = cooldown;
        }
    }

    public CooldownInstance getCooldown(byte power) {
        if (!this.StandCooldowns.isEmpty() && this.StandCooldowns.size() >= power) {
            return this.StandCooldowns.get(power);
        }
        return null;
    }

    public boolean onCooldown(byte power) {
        if (!this.StandCooldowns.isEmpty() && this.StandCooldowns.size() >= power) {
            return this.StandCooldowns.get((int)power).time >= 0;
        }
        return false;
    }

    public void renderIcons(GuiGraphics context, int x, int y) {
    }

    public void renderAttackHud(GuiGraphics context, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
    }

    public List<AbilityIconInstance> drawGUIIcons(GuiGraphics context, float delta, int mouseX, int mouseY, int leftPos, int topPos, byte level, boolean bypas) {
        ArrayList $$1 = Lists.newArrayList();
        return $$1;
    }

    public boolean canExecuteMoveWithLevel(int minLevel) {
        if (!ClientNetworking.getAppropriateConfig().enableStandLeveling.booleanValue()) {
            return true;
        }
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            Player pl = (Player)livingEntity;
            return ((IPlayerEntity)pl).roundabout$getStandLevel() >= minLevel || !((StandUser)pl).roundabout$getStandDisc().m_41619_() && ((StandUser)pl).roundabout$getStandDisc().m_41720_() instanceof MaxStandDiscItem || pl.m_7500_();
        }
        return true;
    }

    public AbilityIconInstance drawSingleGUIIcon(GuiGraphics context, int size, int startingLeft, int startingTop, int levelToUnlock, String nameSTR, String instructionStr, ResourceLocation draw, int extra, byte level, boolean bypass) {
        MutableComponent name;
        if (level < levelToUnlock && !bypass) {
            context.m_280163_(StandIcons.LOCKED_SQUARE_ICON, startingLeft, startingTop, 0.0f, 0.0f, size, size, size, size);
            context.m_280163_(StandIcons.LOCKED, startingLeft + 2, startingTop + 2, 0.0f, 0.0f, size - 4, size - 4, size - 4, size - 4);
            name = Component.m_237115_((String)"ability.roundabout.locked").m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.DARK_GRAY);
        } else {
            context.m_280163_(StandIcons.SQUARE_ICON, startingLeft, startingTop, 0.0f, 0.0f, size, size, size, size);
            context.m_280163_(draw, startingLeft + 2, startingTop + 2, 0.0f, 0.0f, size - 4, size - 4, size - 4, size - 4);
            name = Component.m_237115_((String)nameSTR).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.DARK_PURPLE);
        }
        MutableComponent instruction = level < levelToUnlock && !bypass ? Component.m_237115_((String)"ability.roundabout.locked.ctrl").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.RED) : (extra <= 0 ? Component.m_237115_((String)instructionStr).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.BLUE) : Component.m_237110_((String)instructionStr, (Object[])new Object[]{"" + extra}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.BLUE));
        MutableComponent description = level < levelToUnlock && !bypass ? Component.m_237110_((String)"ability.roundabout.locked.desc", (Object[])new Object[]{"" + levelToUnlock}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.RED) : Component.m_237115_((String)(nameSTR + ".desc"));
        return new AbilityIconInstance(size, startingLeft, startingTop, levelToUnlock, (Component)name, (Component)instruction, (Component)description, extra);
    }

    public void setSkillIcon(GuiGraphics context, int x, int y, int slot, ResourceLocation rl, byte CDI) {
        this.setSkillIcon(context, x, y, slot, rl, CDI, false);
    }

    public void setSkillIcon(GuiGraphics context, int x, int y, int slot, ResourceLocation rl, byte CDI, boolean locked) {
        CooldownInstance cd = null;
        if (CDI >= 0 && !this.StandCooldowns.isEmpty() && this.StandCooldowns.size() >= CDI) {
            cd = this.StandCooldowns.get(CDI);
        }
        if (slot == 4) {
            x += 100;
        } else if (slot == 3) {
            x += 75;
        } else if (slot == 2) {
            x += 50;
        } else if (slot == 1) {
            x += 25;
        }
        --y;
        if (locked) {
            context.m_280163_(StandIcons.LOCKED_SQUARE_ICON, x - 3, y - 3, 0.0f, 0.0f, this.squareWidth, this.squareHeight, this.squareWidth, this.squareHeight);
        } else {
            Component special1Key;
            context.m_280163_(StandIcons.SQUARE_ICON, x - 3, y - 3, 0.0f, 0.0f, this.squareWidth, this.squareHeight, this.squareWidth, this.squareHeight);
            Font renderer = Minecraft.m_91087_().f_91062_;
            if (slot == 4) {
                Component special4Key = KeyInputRegistry.abilityFourKey.m_90863_();
                special4Key = StandPowers.fixKey(special4Key);
                context.m_280614_(renderer, special4Key, x - 1, y + 11, 0xFFFFFF, true);
            } else if (slot == 3) {
                Component special3Key = KeyInputRegistry.abilityThreeKey.m_90863_();
                special3Key = StandPowers.fixKey(special3Key);
                context.m_280614_(renderer, special3Key, x - 1, y + 11, 0xFFFFFF, true);
            } else if (slot == 2) {
                Component special2Key = KeyInputRegistry.abilityTwoKey.m_90863_();
                special2Key = StandPowers.fixKey(special2Key);
                context.m_280614_(renderer, special2Key, x - 1, y + 11, 0xFFFFFF, true);
            } else if (slot == 1) {
                special1Key = KeyInputRegistry.abilityOneKey.m_90863_();
                special1Key = StandPowers.fixKey(special1Key);
                context.m_280614_(renderer, special1Key, x - 1, y + 11, 0xFFFFFF, true);
            }
            special1Key = KeyInputRegistry.abilityOneKey.m_90863_();
        }
        if (cd != null && cd.time >= 0 || this.isAttackIneptVisually(CDI, slot)) {
            context.m_280246_(0.62f, 0.62f, 0.62f, 0.8f);
            context.m_280163_(rl, x, y, 0.0f, 0.0f, 18, 18, 18, 18);
            if (cd != null && cd.time >= 0) {
                float blit = 20.0f * (1.0f - (float)(1 + cd.time) / (float)(1 + cd.maxTime));
                int b = Math.round(blit);
                RenderSystem.enableBlend();
                context.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                ResourceLocation COOLDOWN_TEX = StandIcons.COOLDOWN_ICON;
                if (cd.isFrozen()) {
                    COOLDOWN_TEX = StandIcons.FROZEN_COOLDOWN_ICON;
                }
                context.m_280163_(COOLDOWN_TEX, x - 1, y - 1 + b, 0.0f, (float)b, 20, 20 - b, 20, 20);
                int num = (int)(Math.floor((double)cd.time / 20.0) + 1.0);
                int offset = x + 3;
                if (num <= 9) {
                    offset = x + 7;
                }
                if (!cd.isFrozen()) {
                    context.m_280056_(Minecraft.m_91087_().f_91062_, "" + num, offset, y, 0xFFFFFF, true);
                }
                RenderSystem.disableBlend();
            }
            context.m_280246_(1.0f, 1.0f, 1.0f, 0.9f);
        } else {
            context.m_280163_(rl, x, y, 0.0f, 0.0f, 18, 18, 18, 18);
        }
    }

    public static Component fixKey(Component textIn) {
        String X = textIn.getString();
        if (X.length() > 1) {
            String[] split = X.split("\\s");
            if (split.length > 1) {
                return Component.m_130674_((String)("" + split[0].charAt(0) + split[1].charAt(0)));
            }
            if (split[0].length() > 1) {
                return Component.m_130674_((String)("" + split[0].charAt(0) + split[0].charAt(1)));
            }
            return Component.m_130674_((String)("" + split[0].charAt(0)));
        }
        return textIn;
    }

    public SoundEvent getSoundFromByte(byte soundChoice) {
        if (soundChoice == 1) {
            return this.getBarrageChargeSound();
        }
        if (soundChoice == -2) {
            return ModSounds.GLAIVE_CHARGE_EVENT;
        }
        if (soundChoice == 40) {
            return ModSounds.TIME_STOP_STAR_PLATINUM_EVENT;
        }
        if (soundChoice == 43) {
            return ModSounds.TIME_STOP_THE_WORLD_EVENT;
        }
        if (soundChoice == 44) {
            return ModSounds.TWAU_TIMESTOP_EVENT;
        }
        if (soundChoice == 46) {
            return ModSounds.OVA_LONG_TS_EVENT;
        }
        if (soundChoice == 47) {
            return ModSounds.OVA_SP_TS_EVENT;
        }
        if (soundChoice == 48) {
            return ModSounds.OVA_SHORT_TS_EVENT;
        }
        if (soundChoice == 60) {
            return ModSounds.TIME_RESUME_EVENT;
        }
        if (soundChoice == 41) {
            return ModSounds.TIME_STOP_THE_WORLD2_EVENT;
        }
        if (soundChoice == 42) {
            return ModSounds.TIME_STOP_THE_WORLD3_EVENT;
        }
        if (soundChoice == 14) {
            return ModSounds.TIME_RESUME_EVENT;
        }
        if (soundChoice == 61) {
            return ModSounds.OVA_TIME_RESUME_EVENT;
        }
        if (soundChoice == -3) {
            return ModSounds.STAND_ARROW_CHARGE_EVENT;
        }
        if (soundChoice == -4) {
            return ModSounds.CACKLE_EVENT;
        }
        return null;
    }

    public float getSoundPitchFromByte(byte soundChoice) {
        if (soundChoice == 1) {
            return this.getBarrageChargePitch();
        }
        return 1.0f;
    }

    public float getSoundVolumeFromByte(byte soundChoice) {
        if (soundChoice == 40) {
            return 0.7f;
        }
        if (soundChoice == -4) {
            return 120.0f;
        }
        if (soundChoice == 43 || soundChoice == 44 || soundChoice == 46 || soundChoice == 47 || soundChoice == 48) {
            return 0.7f;
        }
        return 1.0f;
    }

    protected Byte getSummonSound() {
        return (byte)-1;
    }

    public void playSummonSound() {
        if (this.self.m_6047_()) {
            return;
        }
        this.playStandUserOnlySoundsIfNearby(this.getSummonSound(), 10.0, false, false);
    }

    public byte chooseBarrageSound() {
        return 0;
    }

    private float getBarrageChargePitch() {
        return 1.0f / ((float)this.getBarrageWindup() / 20.0f);
    }

    public ResourceLocation getBarrageCryID() {
        return ModSounds.STAND_THEWORLD_MUDA1_SOUND_ID;
    }

    public SoundEvent getBarrageChargeSound() {
        return ModSounds.STAND_BARRAGE_WINDUP_EVENT;
    }

    public boolean glowingEyes() {
        return false;
    }

    public boolean fullTSChargeBonus() {
        return false;
    }

    public ResourceLocation getBarrageChargeID() {
        return ModSounds.STAND_BARRAGE_WINDUP_ID;
    }

    public Byte getLastHitSound() {
        return (byte)-1;
    }

    public ResourceLocation getLastHitID() {
        return ModSounds.STAND_THEWORLD_MUDA3_SOUND_ID;
    }

    public ResourceLocation getSoundID(byte soundNumber) {
        if (soundNumber == 6) {
            return this.getBarrageCryID();
        }
        if (soundNumber == 1) {
            return this.getBarrageChargeID();
        }
        return null;
    }

    public boolean isAttackInept(byte activeP) {
        return this.self.m_6117_() || this.isDazed(this.self) || ((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity((Entity)this.getSelf());
    }

    public boolean isAttackIneptVisually(byte activeP, int slot) {
        return this.isDazed(this.self) || ((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity((Entity)this.getSelf());
    }

    public void tickPowerEnd() {
    }

    public void setAirAmount(int airAmount) {
    }

    public int getAirAmount() {
        return -1;
    }

    public int getMaxAirAmount() {
        return 300;
    }

    public boolean isPiloting() {
        return false;
    }

    public StandEntity getPilotingStand() {
        return this.getStandEntity(this.self);
    }

    public void setPiloting(int ID) {
    }

    public void tickPower() {
        Player PE;
        LivingEntity livingEntity = this.self;
        if (livingEntity instanceof Player && (PE = (Player)livingEntity).m_5833_()) {
            ((StandUser)this.getSelf()).roundabout$setActive(false);
        }
        if (this.self.m_6084_() && !this.self.m_213877_()) {
            if (this.self.m_9236_().f_46443_ && !this.kickStarted && this.getAttackTimeDuring() <= -1) {
                this.kickStarted = true;
            }
            if (this.isClashing()) {
                if (this.attackTimeDuring != -1) {
                    ++this.attackTimeDuring;
                    this.updateClashing();
                }
            } else if (!this.self.m_9236_().f_46443_ || this.kickStarted) {
                if (this.attackTimeDuring != -1) {
                    ++this.attackTimeDuring;
                    if (this.attackTimeDuring == -1) {
                        ((StandUser)this.self).roundabout$tryPower(0, true);
                    } else if (!this.isAttackInept(this.activePower)) {
                        if (this.activePower == 1) {
                            this.updateAttack();
                        } else if (this.isBarraging()) {
                            if (this.bonusBarrageConditions()) {
                                if (this.isBarrageCharging()) {
                                    this.updateBarrageCharge();
                                } else {
                                    this.updateBarrage();
                                }
                            } else {
                                ((StandUser)this.self).roundabout$tryPower(0, true);
                            }
                        } else {
                            this.updateUniqueMoves();
                        }
                    } else {
                        this.resetAttackState();
                    }
                }
                ++this.attackTime;
                if (this.attackTime > this.attackTimeMax) {
                    this.setActivePowerPhase((byte)0);
                }
                if (this.interruptCD > 0) {
                    --this.interruptCD;
                }
            }
            this.tickDash();
            this.tickCooldowns();
        } else {
            StandUser user = (StandUser)this.getSelf();
            StandEntity stnd = user.roundabout$getStand();
            if (stnd != null) {
                user.roundabout$setStand(null);
            }
        }
        if (this.self.m_9236_().f_46443_) {
            this.tickSounds();
        }
        if (this.scopeLevel != 0 && !this.canScope()) {
            this.setScopeLevel(0);
            this.scopeTime = -1;
        }
    }

    public void tickMobAi() {
    }

    public void tickDash() {
        if (this.getSelf() instanceof Player) {
            byte pos;
            if (((IPlayerEntity)this.getSelf()).roundabout$getDodgeTime() >= 0) {
                this.cancelConsumableItem(this.getSelf());
            }
            if (((IPlayerEntity)this.getSelf()).roundabout$getClientDodgeTime() >= 10) {
                ((IPlayerEntity)this.getSelf()).roundabout$setClientDodgeTime(-1);
                if (!this.getSelf().m_9236_().f_46443_) {
                    ((IPlayerEntity)this.getSelf()).roundabout$setDodgeTime(-1);
                    pos = ((IPlayerEntity)this.getSelf()).roundabout$GetPos();
                    if (pos == 2 || pos == 3) {
                        ((IPlayerEntity)this.getSelf()).roundabout$SetPos((byte)0);
                    }
                }
            } else if (((IPlayerEntity)this.getSelf()).roundabout$getClientDodgeTime() >= 0) {
                ((IPlayerEntity)this.getSelf()).roundabout$setClientDodgeTime(((IPlayerEntity)this.getSelf()).roundabout$getClientDodgeTime() + 1);
            }
            if (((IPlayerEntity)this.getSelf()).roundabout$getDodgeTime() >= 10) {
                ((IPlayerEntity)this.getSelf()).roundabout$setDodgeTime(-1);
                pos = ((IPlayerEntity)this.getSelf()).roundabout$GetPos();
                if (pos == 2 || pos == 3) {
                    ((IPlayerEntity)this.getSelf()).roundabout$SetPos((byte)0);
                }
            } else if (((IPlayerEntity)this.getSelf()).roundabout$getDodgeTime() >= 0 && this.getSelf().m_9236_().f_46443_) {
                ((IPlayerEntity)this.getSelf()).roundabout$setDodgeTime(((IPlayerEntity)this.getSelf()).roundabout$getDodgeTime() + 1);
            }
        }
    }

    public void tickCooldowns() {
        int amt = 1;
        boolean isDrowning = false;
        if (this.self instanceof Player) {
            isDrowning = this.self.m_20146_() <= 0;
            int idle = ((StandUser)this.getSelf()).roundabout$getIdleTime();
            if (idle > 300) {
                amt *= 4;
            } else if (idle > 200) {
                amt *= 3;
            } else if (idle > 40) {
                amt *= 2;
            }
            if (isDrowning && !ClientNetworking.getAppropriateConfig().cooldownsInTicks.canRechargeWhileDrowning.booleanValue()) {
                amt = 0;
            }
        }
        for (CooldownInstance ci : this.StandCooldowns) {
            if (ci.time < 0) continue;
            ci.setFrozen(isDrowning && ClientNetworking.getAppropriateConfig().cooldownsInTicks.canRechargeWhileDrowning == false);
            if (!ci.isFrozen()) {
                ci.time -= amt;
            }
            if (ci.time < -1) {
                ci.time = -1;
            }
            if (!(this.self instanceof Player) || !((Player)this.self).m_7500_() || !ClientNetworking.getAppropriateConfig().cooldownsInTicks.creativeModeRefreshesCooldowns.booleanValue() || ci.time <= 2) continue;
            ci.time = 2;
        }
    }

    public boolean hasCooldowns() {
        ArrayList<CooldownInstance> CDCopy = new ArrayList<CooldownInstance>(this.StandCooldowns){};
        for (int i = 0; i < CDCopy.size(); i = (int)((byte)(i + 1))) {
            CooldownInstance ci = (CooldownInstance)CDCopy.get(i);
            if (ci.time < 0) continue;
            return true;
        }
        return false;
    }

    public void timeTick() {
        if (this.getSelf().m_9236_().f_46443_) {
            this.tickSounds();
        }
    }

    public void timeTickStopPower() {
    }

    public void tickPermaCast() {
    }

    public void updatePowerFloat(byte activePower, float data) {
    }

    public void updatePowerInt(byte activePower, int data) {
    }

    public void tickSounds() {
        if (this.self.m_9236_().f_46443_) {
            ((StandUserClient)this.self).roundabout$clientPlaySound();
            ((StandUserClient)this.self).roundabout$clientSoundCancel();
        }
    }

    private void RoundaboutEnemyClash() {
        if (this.isClashing()) {
            if (this.clashIncrement < 0) {
                ++this.clashIncrement;
                if (this.clashIncrement == 0) {
                    this.setClashProgress(0.0f);
                }
            }
            ++this.clashIncrement;
            if (this.clashIncrement < 6 + this.clashMod) {
                this.setClashProgress(this.clashIncrement < 10 ? (float)this.clashIncrement * 0.1f : 0.8f + 2.0f / (float)(this.clashIncrement - 9) * 0.1f);
            } else {
                this.setClashDone(true);
            }
        }
    }

    public void breakClash(LivingEntity winner, LivingEntity loser) {
        if (this.StandDamageEntityAttack((Entity)loser, this.getClashBreakStrength((Entity)loser), 1.0E-4f, (Entity)winner)) {
            ((StandUser)winner).roundabout$getStandPowers().stopSoundsIfNearby((byte)100, 100.0, false);
            ((StandUser)loser).roundabout$getStandPowers().stopSoundsIfNearby((byte)100, 100.0, false);
            ((StandUser)winner).roundabout$getStandPowers().playBarrageEndNoise(0.0f, (Entity)loser);
            this.takeDeterminedKnockbackWithY(winner, (Entity)loser, this.getBarrageFinisherKnockback());
            ((StandUser)winner).roundabout$getStandPowers().animateStand((byte)13);
            ((StandUser)loser).roundabout$tryPower(0, true);
        }
    }

    public void TieClash(LivingEntity user1, LivingEntity user2) {
        ((StandUser)user1).roundabout$getStandPowers().stopSoundsIfNearby((byte)100, 100.0, false);
        ((StandUser)user2).roundabout$getStandPowers().stopSoundsIfNearby((byte)100, 100.0, false);
        ((StandUser)user1).roundabout$getStandPowers().playBarrageEndNoise(0.0f, (Entity)user2);
        ((StandUser)user2).roundabout$getStandPowers().playBarrageEndNoise(-0.05f, (Entity)user1);
        user1.f_19864_ = true;
        user2.f_19864_ = true;
        user1.m_147240_((double)0.55f, user2.m_20185_() - user1.m_20185_(), user2.m_20189_() - user1.m_20189_());
        user2.m_147240_((double)0.55f, user1.m_20185_() - user2.m_20185_(), user1.m_20189_() - user2.m_20189_());
    }

    public boolean canInterruptPower() {
        return false;
    }

    public float levelupDamageMod(float damage) {
        LivingEntity livingEntity;
        int percent = ClientNetworking.getAppropriateConfig().damageMultipliers.bonusStandDmgByMaxLevel;
        if (percent > 0 && (livingEntity = this.self) instanceof Player) {
            byte maxlevel;
            Player PE = (Player)livingEntity;
            if (this.getMaxLevel() >= 1 && (maxlevel = this.getMaxLevel()) > 1) {
                byte level = ((IPlayerEntity)PE).roundabout$getStandLevel();
                ItemStack sdisc = ((StandUser)PE).roundabout$getStandDisc();
                if (!sdisc.m_41619_() && sdisc.m_41720_() instanceof MaxStandDiscItem) {
                    level = maxlevel;
                }
                damage *= (float)(1.0 + (double)(((float)(maxlevel - 1) - (float)(maxlevel - 1 - (level - 1))) / (float)(maxlevel - 1)) * (0.01 * (double)percent));
            }
        }
        return damage;
    }

    public boolean preCanInterruptPower(Entity interrupter, boolean isStandDamage) {
        boolean interrupt = false;
        if (interrupter instanceof LivingEntity) {
            if (this.isBarraging() && ClientNetworking.getAppropriateConfig().chargeSettings.barragesAreAlwaysInterruptable.booleanValue()) {
                if (this.self instanceof Player) {
                    ((StandUser)this.getSelf()).roundabout$tryPower(3, true);
                } else {
                    ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
                }
                return true;
            }
            if (isStandDamage && ClientNetworking.getAppropriateConfig().chargeSettings.standsInterruptSomeStandAttacks.booleanValue()) {
                interrupt = true;
            } else if (this instanceof TWAndSPSharedPowers && this.getActivePower() == 7 && ClientNetworking.getAppropriateConfig().chargeSettings.timeStopIsAlwaysInterruptable.booleanValue()) {
                interrupt = true;
            } else if (interrupter instanceof Player && ClientNetworking.getAppropriateConfig().chargeSettings.playersInterruptSomeStandAttacks.booleanValue()) {
                interrupt = true;
            } else if (interrupter instanceof Mob && ClientNetworking.getAppropriateConfig().chargeSettings.mobsInterruptSomeStandAttacks.booleanValue()) {
                interrupt = true;
            }
        } else {
            interrupt = true;
        }
        if (interrupt) {
            return this.canInterruptPower();
        }
        return false;
    }

    public float inputSpeedModifiers(float basis) {
        StandUser standUser = (StandUser)this.getSelf();
        if (standUser.roundabout$isDazed()) {
            basis = 0.0f;
        } else if ((this.getSelf().m_20202_() == null || this.getSelf().m_275832_() != null) && standUser.roundabout$isGuarding() && this.getSelf().m_20202_() == null) {
            basis *= 0.3f;
        } else if (this.isBarrageAttacking() || standUser.roundabout$isClashing()) {
            basis *= 0.2f;
        } else if (this.isBarrageCharging()) {
            basis *= 0.5f;
        }
        return basis;
    }

    public void updateClashing() {
        if (this.getStandEntity(this.self) != null) {
            // empty if block
        }
        if (this.getClashOp() != null) {
            if (this.attackTimeDuring <= 60) {
                LivingEntity entity = this.getClashOp();
                StandEntity standEntity = ((StandUser)entity).roundabout$getStand();
                StandEntity standSelf = ((StandUser)this.self).roundabout$getStand();
                if (standSelf != null && standEntity != null && !this.self.m_9236_().f_46443_) {
                    standSelf.m_146926_(this.getLookAtEntityPitch((Entity)standSelf, (Entity)standEntity));
                    standSelf.m_146922_(this.getLookAtEntityYaw((Entity)standSelf, (Entity)standEntity));
                    standEntity.m_146926_(this.getLookAtEntityPitch((Entity)standEntity, (Entity)standSelf));
                    standEntity.m_146922_(this.getLookAtEntityYaw((Entity)standEntity, (Entity)standSelf));
                }
                if (!(this.self instanceof Player)) {
                    this.RoundaboutEnemyClash();
                }
                if (!this.self.m_9236_().f_46443_) {
                    if (this.getClashDone() && ((StandUser)entity).roundabout$getStandPowers().getClashDone() || !((StandUser)this.self).roundabout$getActive() || !((StandUser)entity).roundabout$getActive()) {
                        this.updateClashing2();
                    } else {
                        this.playBarrageNoise(this.attackTimeDuring + this.clashStarter, (Entity)entity);
                    }
                }
            } else if (!this.self.m_9236_().f_46443_) {
                this.updateClashing2();
            }
        } else if (!this.self.m_9236_().f_46443_) {
            ((StandUser)this.self).roundabout$tryPower(14, true);
        }
    }

    private void updateClashing2() {
        if (this.getClashOp() != null) {
            boolean thisActive = ((StandUser)this.self).roundabout$getActive();
            boolean opActive = ((StandUser)this.getClashOp()).roundabout$getActive();
            if (thisActive && !opActive) {
                this.breakClash(this.self, this.getClashOp());
            } else if (!thisActive && opActive) {
                this.breakClash(this.getClashOp(), this.self);
            } else if (thisActive && opActive) {
                if (this.getClashProgress() == ((StandUser)this.getClashOp()).roundabout$getStandPowers().getClashProgress()) {
                    this.TieClash(this.self, this.getClashOp());
                } else if (this.getClashProgress() > ((StandUser)this.getClashOp()).roundabout$getStandPowers().getClashProgress()) {
                    this.breakClash(this.self, this.getClashOp());
                } else {
                    this.breakClash(this.getClashOp(), this.self);
                }
            }
            ((StandUser)this.self).roundabout$setAttackTimeDuring(-10);
            ((StandUser)this.getClashOp()).roundabout$setAttackTimeDuring(-10);
            ((StandUser)this.self).roundabout$getStandPowers().syncCooldowns();
            ((StandUser)this.getClashOp()).roundabout$getStandPowers().syncCooldowns();
        }
    }

    public void updateBarrageCharge() {
        if (this.attackTimeDuring >= this.getBarrageWindup()) {
            ((StandUser)this.self).roundabout$tryPower(5, true);
        }
    }

    public void updateBarrage() {
        if (this.attackTimeDuring == -2 && this.getSelf() instanceof Player) {
            ((StandUser)this.self).roundabout$tryPower(3, true);
        } else if (this.attackTimeDuring > this.getBarrageLength()) {
            this.attackTimeDuring = -20;
        } else if (this.attackTimeDuring > 0) {
            this.setAttackTime(this.getBarrageRecoilTime() - 1 - Math.round((float)this.attackTimeDuring / (float)this.getBarrageLength() * (float)(this.getBarrageRecoilTime() - 1)));
            this.standBarrageHit();
        }
    }

    public boolean isWip() {
        return false;
    }

    public void updateAttack() {
    }

    public void pilotStandControls(KeyboardPilotInput kpi, LivingEntity entity) {
    }

    public boolean onCreateProjectile(Projectile proj) {
        return false;
    }

    public boolean interceptDamageDealtEvent(DamageSource $$0, float $$1, LivingEntity target) {
        return false;
    }

    public boolean interceptSuccessfulDamageDealtEvent(DamageSource $$0, float $$1, LivingEntity target) {
        return false;
    }

    public boolean interceptDamageEvent(DamageSource $$0, float $$1) {
        return false;
    }

    public void poseStand(byte r) {
        StandEntity stand = this.getStandEntity(this.self);
        if (Objects.nonNull((Object)stand)) {
            stand.setOffsetType(r);
        }
    }

    public void animateStand(byte r) {
        StandEntity stand = this.getStandEntity(this.self);
        if (Objects.nonNull((Object)stand)) {
            stand.setAnimation(r);
        }
    }

    public byte getAnimation() {
        StandEntity stand = this.getStandEntity(this.self);
        if (Objects.nonNull((Object)stand)) {
            return stand.getAnimation();
        }
        return -1;
    }

    public StandUser getUserData(LivingEntity User) {
        return (StandUser)User;
    }

    public StandEntity getStandEntity(LivingEntity User) {
        return this.getUserData(User).roundabout$getStand();
    }

    public boolean hasStandEntity(LivingEntity User) {
        return this.getUserData(User).roundabout$hasStandOut();
    }

    public boolean hasStandActive(LivingEntity User) {
        return this.getUserData(User).roundabout$getActive();
    }

    public void tickStandRejection(MobEffectInstance effect) {
    }

    public float getReach() {
        return 5.0f;
    }

    public int getTargetEntityId() {
        Entity targetEntity = this.getTargetEntity(this.self, -1.0f);
        int id = targetEntity != null ? targetEntity.m_19879_() : -1;
        return id;
    }

    public int getTargetEntityId(float angle) {
        Entity targetEntity = this.getTargetEntity(this.self, -1.0f, angle);
        int id = targetEntity != null ? targetEntity.m_19879_() : -1;
        return id;
    }

    public int getTargetEntityId2(float distance) {
        Entity targetEntity = this.getTargetEntity(this.self, distance);
        int id = targetEntity != null ? targetEntity.m_19879_() : -1;
        return id;
    }

    public int getTargetEntityId2(float distance, LivingEntity userr, float angle) {
        Entity targetEntity = this.getTargetEntityGenerous(userr, distance, angle);
        int id = targetEntity != null ? targetEntity.m_19879_() : -1;
        return id;
    }

    public void standBarrageHit() {
        block6: {
            block5: {
                if (!(this.self instanceof Player)) break block5;
                if (!this.isPacketPlayer()) break block6;
                List<Entity> listE = this.getTargetEntityList(this.self, -1.0f);
                int id = -1;
                if (this.storeEnt != null) {
                    id = this.storeEnt.m_19879_();
                }
                ModPacketHandler.PACKET_ACCESS.StandBarrageHitPacket(id, this.attackTimeDuring);
                if (!listE.isEmpty() && ClientNetworking.getAppropriateConfig().barrageHasAreaOfEffect.booleanValue()) {
                    for (int i = 0; i < listE.size(); ++i) {
                        if (this.storeEnt != null && listE.get(i).m_7306_(this.storeEnt) || listE.get(i) instanceof StandEntity || !((double)listE.get(i).m_20270_((Entity)this.self) < 3.5)) continue;
                        ModPacketHandler.PACKET_ACCESS.StandBarrageHitPacket(listE.get(i).m_19879_(), this.attackTimeDuring + 1000);
                    }
                }
                if (this.attackTimeDuring != this.getBarrageLength()) break block6;
                this.attackTimeDuring = -10;
                break block6;
            }
            Entity targetEntity = this.getTargetEntity(this.self, -1.0f);
            List<Entity> listE = this.getTargetEntityList(this.self, -1.0f);
            this.barrageImpact(this.storeEnt, this.attackTimeDuring);
            if (!listE.isEmpty()) {
                for (int i = 0; i < listE.size(); ++i) {
                    if (this.storeEnt != null && listE.get(i).m_7306_(this.storeEnt) || listE.get(i) instanceof StandEntity || !((double)listE.get(i).m_20270_((Entity)this.self) < 3.5)) continue;
                    this.barrageImpact(listE.get(i), this.attackTimeDuring + 1000);
                }
            }
        }
    }

    public boolean isPacketPlayer() {
        if (this.self.m_9236_().f_46443_) {
            Minecraft mc = Minecraft.m_91087_();
            return mc.f_91074_ != null && mc.f_91074_.m_19879_() == this.self.m_19879_();
        }
        return false;
    }

    public boolean isDazed(LivingEntity entity) {
        return this.getUserData(entity).roundabout$isDazed();
    }

    public void setDazed(LivingEntity entity, byte dazeTime) {
        if (1.0 - entity.m_21133_(Attributes.f_22278_) <= 0.0) {
            return;
        }
        if (entity instanceof EnderDragon || entity instanceof WitherBoss) {
            return;
        }
        if (dazeTime > 0) {
            ((StandUser)entity).roundabout$tryPower(0, true);
            ((StandUser)entity).roundabout$getStandPowers().animateStand((byte)14);
        } else {
            ((StandUser)entity).roundabout$getStandPowers().animateStand((byte)0);
        }
        this.getUserData(entity).roundabout$setDazed(dazeTime);
    }

    public void setDazedSafely(LivingEntity entity, byte dazeTime) {
        if (dazeTime > 0) {
            ((StandUser)entity).roundabout$tryPower(0, true);
            ((StandUser)entity).roundabout$getStandPowers().animateStand((byte)14);
        } else {
            ((StandUser)entity).roundabout$getStandPowers().animateStand((byte)0);
        }
        this.getUserData(entity).roundabout$setDazed(dazeTime);
    }

    public boolean knockShield(Entity entity, int duration) {
        if (entity != null && entity.m_6084_() && !entity.m_213877_() && entity instanceof LivingEntity && ((LivingEntity)entity).m_21254_()) {
            StandUser standUser = this.getUserData((LivingEntity)entity);
            if (standUser.roundabout$isGuarding() && !standUser.roundabout$getGuardBroken()) {
                standUser.roundabout$breakGuard();
            }
            if (entity instanceof Player) {
                ItemStack itemStack = ((LivingEntity)entity).m_21211_();
                Item item = itemStack.m_41720_();
                if (item.m_6164_(itemStack) == UseAnim.BLOCK) {
                    ((LivingEntity)entity).m_21253_();
                    ((Player)entity).m_5810_();
                }
                ((Player)entity).m_36335_().m_41524_(Items.f_42740_, duration);
                entity.m_9236_().m_7605_(entity, (byte)30);
            }
            return true;
        }
        return false;
    }

    public void cancelConsumableItem(LivingEntity entity) {
        ItemStack itemStack = entity.m_21211_();
        Item item = itemStack.m_41720_();
        if (item.m_41472_() || item instanceof PotionItem) {
            entity.m_21253_();
            if (entity instanceof Player) {
                entity.m_5810_();
            }
        }
    }

    public boolean knockShield2(Entity entity, int duration) {
        if (entity != null && entity.m_6084_() && !entity.m_213877_() && entity instanceof LivingEntity && ((LivingEntity)entity).m_21254_()) {
            if (entity instanceof Player) {
                ItemStack itemStack = ((LivingEntity)entity).m_21211_();
                Item item = itemStack.m_41720_();
                if (item.m_6164_(itemStack) == UseAnim.BLOCK) {
                    ((LivingEntity)entity).m_21253_();
                    ((Player)entity).m_5810_();
                }
                ((Player)entity).m_36335_().m_41524_(Items.f_42740_, duration);
                entity.m_9236_().m_7605_(entity, (byte)30);
            }
            return true;
        }
        return false;
    }

    public float getPunchStrength(Entity entity) {
        if (this.getReducedDamage(entity)) {
            return 1.75f;
        }
        return 5.0f;
    }

    public float getHeavyPunchStrength(Entity entity) {
        if (this.getReducedDamage(entity)) {
            return 2.5f;
        }
        return 6.0f;
    }

    public float getBarrageFinisherStrength(Entity entity) {
        if (this.getReducedDamage(entity)) {
            return 3.0f;
        }
        return 8.0f;
    }

    public float getBarrageFinisherKnockback() {
        return 2.8f;
    }

    private float getClashBreakStrength(Entity entity) {
        if (this.getReducedDamage(entity)) {
            return 4.0f;
        }
        return 10.0f;
    }

    public float getBarrageHitStrength(Entity entity) {
        float barrageLength = this.getBarrageLength();
        float power = this.getReducedDamage(entity) ? 9.0f / barrageLength : 20.0f / barrageLength;
        if (entity instanceof LivingEntity && power >= ((LivingEntity)entity).m_21223_()) {
            power = entity instanceof Player ? 1.0E-5f : 0.0f;
        }
        return power;
    }

    public boolean getReducedDamage(Entity entity) {
        LivingEntity LE;
        return entity instanceof Player || entity instanceof StandEntity || entity instanceof LivingEntity && !((StandUser)(LE = (LivingEntity)entity)).roundabout$getStandDisc().m_41619_() && ClientNetworking.getAppropriateConfig().damageMultipliers.standUserMobsTakePlayerDamageMultipliers != false;
    }

    public void initiateClash(Entity entity) {
        ((StandUser)entity).roundabout$getStandPowers().setClashOp(this.self);
        ((StandUser)this.self).roundabout$getStandPowers().setClashOp((LivingEntity)entity);
        this.clashStarter = 0;
        ((StandUser)entity).roundabout$getStandPowers().clashStarter = 1;
        ((StandUser)entity).roundabout$tryPower(6, true);
        ((StandUser)this.self).roundabout$tryPower(6, true);
        StandEntity standEntity = ((StandUser)entity).roundabout$getStand();
        StandEntity standSelf = ((StandUser)this.self).roundabout$getStand();
        if (standEntity != null && standSelf != null) {
            ((StandUser)entity).roundabout$getStandPowers().playBarrageClashSound();
            ((StandUser)this.self).roundabout$getStandPowers().playBarrageClashSound();
            Vec3 CenterPoint = entity.m_20182_().m_82549_(this.self.m_20182_()).m_82490_(0.5);
            Vec3 entityPoint = this.offsetBarrageVector(CenterPoint.m_82546_(CenterPoint.m_82546_(entity.m_20182_()).m_82541_().m_82490_(0.95)), this.getLookAtEntityYaw(entity, (Entity)this.self));
            Vec3 selfPoint = this.offsetBarrageVector(CenterPoint.m_82546_(CenterPoint.m_82546_(this.self.m_20182_()).m_82541_().m_82490_(0.95)), this.getLookAtEntityYaw((Entity)this.self, entity));
            standEntity.m_20343_(entityPoint.m_7096_(), entityPoint.m_7098_() + (double)this.getYOffSet((LivingEntity)standEntity), entityPoint.m_7094_());
            standEntity.m_146926_(this.getLookAtEntityPitch((Entity)standEntity, (Entity)standSelf));
            standEntity.m_146922_(this.getLookAtEntityYaw((Entity)standEntity, (Entity)standSelf));
            standSelf.m_20343_(selfPoint.m_7096_(), selfPoint.m_7098_() + (double)this.getYOffSet((LivingEntity)standSelf), selfPoint.m_7094_());
            standSelf.m_146926_(this.getLookAtEntityPitch((Entity)standSelf, (Entity)standEntity));
            standSelf.m_146922_(this.getLookAtEntityYaw((Entity)standSelf, (Entity)standEntity));
        }
    }

    private Vec3 offsetBarrageVector(Vec3 vec3d, float yaw) {
        Vec3 vec3d2 = DamageHandler.getRotationVector(0.0f, yaw + 90.0f);
        return vec3d.m_82520_(vec3d2.f_82479_ * 0.3, 0.0, vec3d2.f_82481_ * 0.3);
    }

    private float getYOffSet(LivingEntity stand) {
        float yy = 0.1f;
        if (stand.m_6069_() || stand.m_20143_() || stand.m_21255_()) {
            yy -= 1.0f;
        }
        return yy;
    }

    public boolean clickRelease() {
        return false;
    }

    public void barrageImpact(Entity entity, int hitNumber) {
        if (this.isBarrageAttacking()) {
            if (this.bonusBarrageConditions()) {
                boolean lastHit;
                boolean sideHit = false;
                if (hitNumber > 1000) {
                    if (!ClientNetworking.getAppropriateConfig().barrageHasAreaOfEffect.booleanValue()) {
                        return;
                    }
                    hitNumber -= 1000;
                    sideHit = true;
                }
                boolean bl = lastHit = hitNumber >= this.getBarrageLength();
                if (entity != null) {
                    if (entity instanceof LivingEntity && ((StandUser)entity).roundabout$isBarraging() && ((StandUser)entity).roundabout$getAttackTimeDuring() > -1 && !((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity(entity)) {
                        this.initiateClash(entity);
                    } else {
                        float pow;
                        float knockbackStrength = 0.0f;
                        Vec3 prevVelocity = entity.m_20184_();
                        if (lastHit) {
                            pow = this.getBarrageFinisherStrength(entity);
                            knockbackStrength = this.getBarrageFinisherKnockback();
                        } else {
                            pow = this.getBarrageHitStrength(entity);
                            float mn = this.getBarrageLength() - hitNumber;
                            mn = mn == 0.0f ? 0.015f : 0.015f / mn;
                            knockbackStrength = 0.014f - mn;
                        }
                        if (sideHit) {
                            pow /= 4.0f;
                            knockbackStrength /= 6.0f;
                        }
                        if (this.StandRushDamageEntityAttack(entity, pow, 1.0E-4f, (Entity)this.self)) {
                            if (entity instanceof LivingEntity) {
                                LivingEntity LE = (LivingEntity)entity;
                                if (lastHit) {
                                    this.setDazed((LivingEntity)entity, (byte)0);
                                    if (!sideHit) {
                                        this.addEXP(8, LE);
                                        this.playBarrageEndNoise(0.0f, entity);
                                    }
                                } else {
                                    this.setDazed((LivingEntity)entity, (byte)3);
                                    if (!sideHit) {
                                        this.playBarrageNoise(hitNumber, entity);
                                    }
                                }
                            }
                            this.barrageImpact2(entity, lastHit, knockbackStrength);
                        } else if (lastHit) {
                            this.knockShield2(entity, 200);
                            if (!sideHit) {
                                this.playBarrageBlockEndNoise(0.0f, entity);
                            }
                        } else {
                            entity.m_20256_(prevVelocity);
                            this.playBarrageBlockNoise();
                        }
                    }
                } else if (!sideHit) {
                    this.playBarrageMissNoise(hitNumber);
                }
                if (lastHit) {
                    this.animateStand((byte)13);
                    this.attackTimeDuring = -10;
                }
            } else {
                ((StandUser)this.self).roundabout$tryPower(0, true);
            }
        } else {
            ((StandUser)this.self).roundabout$tryPower(0, true);
        }
    }

    public boolean cancelSprintJump() {
        return this.isBarraging();
    }

    public void barrageImpact2(Entity entity, boolean lastHit, float knockbackStrength) {
        if (entity instanceof LivingEntity) {
            if (lastHit) {
                this.takeDeterminedKnockbackWithY(this.self, entity, knockbackStrength);
            } else {
                this.takeKnockbackUp(entity, knockbackStrength);
            }
        }
    }

    public boolean bonusBarrageConditions() {
        return true;
    }

    public void takeDeterminedKnockbackWithY(LivingEntity user, Entity target, float knockbackStrength) {
        float xRot = !target.m_20096_() ? user.m_146909_() : -15.0f;
        this.takeKnockbackWithY(target, knockbackStrength, Mth.m_14031_((float)(user.m_146908_() * ((float)Math.PI / 180))), Mth.m_14031_((float)(xRot * ((float)Math.PI / 180))), -Mth.m_14089_((float)(user.m_146908_() * ((float)Math.PI / 180))));
    }

    public void takeDeterminedKnockback(LivingEntity user, Entity target, float knockbackStrength) {
        if (target instanceof LivingEntity) {
            float f;
            knockbackStrength *= (float)(1.0 - ((LivingEntity)target).m_21133_(Attributes.f_22278_));
            if ((double)f <= 0.0) {
                return;
            }
        }
        target.f_19864_ = true;
        Vec3 vec3d2 = new Vec3((double)Mth.m_14031_((float)(user.m_146908_() * ((float)Math.PI / 180))), 0.0, (double)(-Mth.m_14089_((float)(user.m_146908_() * ((float)Math.PI / 180))))).m_82541_().m_82490_((double)knockbackStrength);
        target.m_20334_(-vec3d2.f_82479_, target.m_20096_() ? 0.28 : 0.0, -vec3d2.f_82481_);
        target.f_19812_ = true;
    }

    public void playBarrageMissNoise(int hitNumber) {
        if (!this.self.m_9236_().m_5776_() && hitNumber % 2 == 0) {
            this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.STAND_BARRAGE_MISS_EVENT, SoundSource.PLAYERS, 0.95f, (float)(0.8 + Math.random() * 0.4));
        }
    }

    public void playBarrageNoise(int hitNumber, Entity entity) {
        if (!this.self.m_9236_().m_5776_() && hitNumber % 2 == 0) {
            this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.STAND_BARRAGE_HIT_EVENT, SoundSource.PLAYERS, 0.9f, (float)(0.9 + Math.random() * 0.25));
        }
    }

    public void playBarrageNoise2(int hitNumber, Entity entity) {
        if (!this.self.m_9236_().m_5776_() && hitNumber % 2 == 0) {
            this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.STAND_BARRAGE_HIT2_EVENT, SoundSource.PLAYERS, 0.95f, (float)(0.9 + Math.random() * 0.25));
        }
    }

    public void playBarrageEndNoise(float mod, Entity entity) {
        if (!this.self.m_9236_().m_5776_()) {
            this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.STAND_BARRAGE_END_EVENT, SoundSource.PLAYERS, 0.95f + mod, 1.0f);
        }
    }

    public void playBarrageBlockEndNoise(float mod, Entity entity) {
        if (!this.self.m_9236_().m_5776_()) {
            this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.STAND_BARRAGE_END_BLOCK_EVENT, SoundSource.PLAYERS, 0.88f + mod, 1.7f);
        }
    }

    public void playBarrageBlockNoise() {
        if (!this.self.m_9236_().m_5776_()) {
            this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.STAND_BARRAGE_BLOCK_EVENT, SoundSource.PLAYERS, 0.95f, (float)(0.8 + Math.random() * 0.4));
        }
    }

    public boolean getClashDone() {
        return this.clashDone;
    }

    public void setClashDone(boolean clashDone) {
        this.clashDone = clashDone;
    }

    public void updateMove() {
    }

    public void updateMove(float flot) {
    }

    public void updateIntMove(int in) {
    }

    @Nullable
    public LivingEntity getClashOp() {
        return this.clashOp;
    }

    public void setClashOp(@Nullable LivingEntity clashOp) {
        this.clashOp = clashOp;
    }

    public float getClashOpProgress() {
        return this.clashOpProgress;
    }

    public void setClashOpProgress(float clashOpProgress1) {
        this.clashOpProgress = clashOpProgress1;
    }

    public float getClashProgress() {
        return this.clashProgress;
    }

    public void setClashProgress(float clashProgress1) {
        this.clashProgress = clashProgress1;
        if (!this.self.m_9236_().f_46443_ && this.clashOp != null && this.clashOp instanceof ServerPlayer) {
            ModPacketHandler.PACKET_ACCESS.updateClashPacket((ServerPlayer)this.clashOp, this.self.m_19879_(), this.clashProgress);
        }
    }

    public void punchImpact(Entity entity) {
    }

    public void damage(Entity entity) {
    }

    public List<Entity> getTargetEntityList(LivingEntity User, float distMax) {
        return this.getTargetEntityList(User, distMax, 25.0f);
    }

    public List<Entity> getTargetEntityList(LivingEntity User, float distMax, float angle) {
        StandEntity SE;
        StandEntity SE2;
        Entity targetEntity;
        if (!(distMax >= 0.0f)) {
            distMax = this.getDistanceOut(User, this.getReach(), false);
        }
        if ((targetEntity = this.rayCastEntity(User, distMax)) != null && User instanceof StandEntity && (SE2 = (StandEntity)User).getUser() != null && SE2.getUser().m_7306_(targetEntity) || targetEntity != null && (!targetEntity.m_6084_() || targetEntity.m_213877_())) {
            targetEntity = null;
        }
        float halfReach = (float)((double)distMax * 0.5);
        Vec3 pointVec = DamageHandler.getRayPoint(User, halfReach);
        List<Entity> listE = this.StandGrabHitbox(User, DamageHandler.genHitbox(User, pointVec.f_82479_, pointVec.f_82480_, pointVec.f_82481_, halfReach, halfReach, halfReach), distMax);
        if (targetEntity == null) {
            targetEntity = this.StandAttackHitboxNear(User, listE, angle);
        }
        if (targetEntity instanceof StandEntity && (SE = (StandEntity)targetEntity).getUser() != null) {
            targetEntity = SE.getUser();
        }
        if (targetEntity instanceof EnderDragonPart) {
            EnderDragonPart EDP = (EnderDragonPart)targetEntity;
            targetEntity = EDP.f_31010_;
        }
        this.storeEnt = targetEntity;
        return listE;
    }

    public Entity getTargetEntity(LivingEntity User, float distMax) {
        return this.getTargetEntity(User, distMax, 25.0f);
    }

    public Entity getTargetEntity(LivingEntity User, float distMax, float angle) {
        StandEntity SE;
        Entity targetEntity;
        if (!(distMax >= 0.0f)) {
            distMax = this.getDistanceOut(User, this.getReach(), false);
        }
        if ((targetEntity = this.rayCastEntity(User, distMax)) != null && User instanceof StandEntity && (SE = (StandEntity)User).getUser() != null && SE.getUser().m_7306_(targetEntity) || targetEntity != null && (!targetEntity.m_6084_() || targetEntity.m_213877_())) {
            targetEntity = null;
        }
        if (targetEntity == null) {
            float halfReach = (float)((double)distMax * 0.5);
            Vec3 pointVec = DamageHandler.getRayPoint(User, halfReach);
            targetEntity = this.StandAttackHitboxNear(User, this.StandGrabHitbox(User, DamageHandler.genHitbox(User, pointVec.f_82479_, pointVec.f_82480_, pointVec.f_82481_, halfReach, halfReach, halfReach), distMax), angle);
        }
        if (targetEntity instanceof StandEntity && (SE = (StandEntity)targetEntity).getUser() != null) {
            targetEntity = SE.getUser();
        }
        if (targetEntity instanceof EnderDragonPart) {
            EnderDragonPart EDP = (EnderDragonPart)targetEntity;
            targetEntity = EDP.f_31010_;
        }
        return targetEntity;
    }

    public boolean hasMoreThanOneSkin() {
        Player PE;
        LivingEntity livingEntity = this.getSelf();
        return livingEntity instanceof Player && (((IPlayerEntity)(PE = (Player)livingEntity)).roundabout$getStandLevel() > 1 || ((IPlayerEntity)PE).roundabout$getUnlockedBonusSkin() || PE.m_7500_() || this.hasGoldenDisc());
    }

    public boolean hasGoldenDisc() {
        ItemStack stack = ((StandUser)this.getSelf()).roundabout$getStandDisc();
        return !stack.m_41619_() && stack.m_41720_() instanceof MaxStandDiscItem;
    }

    public void getSkinInDirection(boolean right) {
        StandUser SE = (StandUser)this.getSelf();
        byte currentSkin = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        List<Byte> skins = this.getSkinList();
        if (!skins.isEmpty() && skins.size() > 1) {
            int skinind = 0;
            for (int i = 0; i < skins.size(); ++i) {
                if (skins.get(i) != currentSkin) continue;
                skinind = i;
            }
            if (right) {
                if (++skinind >= skins.size()) {
                    skinind = 0;
                }
                SE.roundabout$setStandSkin(skins.get(skinind));
            } else {
                if (--skinind < 0) {
                    skinind = skins.size() - 1;
                }
                SE.roundabout$setStandSkin(skins.get(skinind));
            }
            SE.roundabout$summonStand(this.getSelf().m_9236_(), true, false);
        }
    }

    public void getPoseInDirection(boolean right) {
        StandUser SE = (StandUser)this.getSelf();
        byte currentSkin = ((StandUser)this.getSelf()).roundabout$getIdlePos();
        List<Byte> poses = this.getPosList();
        if (!poses.isEmpty() && poses.size() > 1) {
            int skinind = 0;
            for (int i = 0; i < poses.size(); ++i) {
                if (poses.get(i) != currentSkin) continue;
                skinind = i;
            }
            if (right) {
                if (++skinind >= poses.size()) {
                    skinind = 0;
                }
                SE.roundabout$setIdlePosX(poses.get(skinind));
            } else {
                if (--skinind < 0) {
                    skinind = poses.size() - 1;
                }
                SE.roundabout$setIdlePosX(poses.get(skinind));
            }
        }
    }

    public Entity getTargetEntityGenerous(LivingEntity User, float distMax, float angle) {
        StandEntity SE;
        Entity targetEntity;
        if (!(distMax >= 0.0f)) {
            distMax = this.getDistanceOut(User, this.getReach(), false);
        }
        if ((targetEntity = this.rayCastEntity(User, distMax)) != null && User instanceof StandEntity && (SE = (StandEntity)User).getUser() != null && SE.getUser().m_7306_(targetEntity) || targetEntity != null && targetEntity.m_7306_((Entity)User)) {
            targetEntity = null;
        }
        if (targetEntity == null) {
            float halfReach = (float)((double)distMax * 0.5);
            Vec3 pointVec = DamageHandler.getRayPoint(User, halfReach);
            targetEntity = this.StandAttackHitboxNear(User, this.StandGrabHitbox(User, DamageHandler.genHitbox(User, pointVec.f_82479_, pointVec.f_82480_, pointVec.f_82481_, halfReach, halfReach, halfReach), distMax, angle), angle);
        }
        if (targetEntity instanceof StandEntity && (SE = (StandEntity)targetEntity).getUser() != null) {
            targetEntity = SE.getUser();
        }
        return targetEntity;
    }

    public double getBlockDistanceOut(LivingEntity entity, double range) {
        Vec3 vec3dST = entity.m_20299_(0.0f);
        Vec3 vec3d2ST = entity.m_20252_(0.0f);
        Vec3 vec3d3ST = vec3dST.m_82520_(vec3d2ST.f_82479_ * range, vec3d2ST.f_82480_ * range, vec3d2ST.f_82481_ * range);
        BlockHitResult blockHit = entity.m_9236_().m_45547_(new ClipContext(vec3dST, vec3d3ST, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)entity));
        double bhit = Math.sqrt(blockHit.m_82448_((Entity)entity));
        if (bhit < range) {
            range = bhit;
        }
        return range;
    }

    public float getDistanceOut(LivingEntity entity, float range, boolean offset) {
        float distanceFront = this.getRayDistance((Entity)entity, range);
        if (offset) {
            Entity targetEntity = this.rayCastEntity(entity, this.getReach());
            if (targetEntity != null && targetEntity.m_20270_((Entity)entity) < distanceFront) {
                distanceFront = targetEntity.m_20270_((Entity)entity);
            }
            distanceFront -= 1.0f;
            distanceFront = Math.max(Math.min(distanceFront, 1.7f), 0.4f);
        }
        return distanceFront;
    }

    public float getDistanceOutAccurate(Entity entity, float range, boolean offset) {
        float distanceFront = this.getRayDistance(entity, range);
        if (offset) {
            Entity targetEntity = this.getTargetEntity(this.self, this.getReach());
            if (targetEntity != null && targetEntity.m_20270_(entity) < distanceFront) {
                distanceFront = targetEntity.m_20270_(entity);
            }
            distanceFront -= 1.0f;
            distanceFront = Math.max(Math.min(distanceFront, 1.7f), 0.4f);
        }
        return distanceFront;
    }

    public float getRayDistance(Entity entity, float range) {
        Vec3 vec3d = entity.m_20299_(0.0f);
        Vec3 vec3d2 = entity.m_20252_(0.0f);
        Vec3 vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * (double)range, vec3d2.f_82480_ * (double)range, vec3d2.f_82481_ * (double)range);
        BlockHitResult blockHit = entity.m_9236_().m_45547_(new ClipContext(vec3d, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
        if (blockHit.m_6662_() != HitResult.Type.MISS) {
            return Mth.m_14116_((float)((float)entity.m_20238_(blockHit.m_82450_())));
        }
        return range;
    }

    public Vec3 getRayBlock(Entity entity, float range) {
        Vec3 vec3d = entity.m_20299_(0.0f);
        Vec3 vec3d2 = entity.m_20252_(0.0f);
        Vec3 vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * (double)range, vec3d2.f_82480_ * (double)range, vec3d2.f_82481_ * (double)range);
        BlockHitResult blockHit = entity.m_9236_().m_45547_(new ClipContext(vec3d, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
        return blockHit.m_82450_();
    }

    public float getPivotPoint(Vector3d pointToRotate, Vector3d axisStart, Vector3d axisEnd) {
        Vector3d d = new Vector3d(axisEnd.x - axisStart.x, axisEnd.y - axisStart.y, axisEnd.z - axisStart.z).normalize();
        Vector3d v = new Vector3d(pointToRotate.x - axisStart.x, pointToRotate.y - axisStart.y, pointToRotate.z - axisStart.z).normalize();
        double t = v.dot((Vector3dc)d);
        return (float)pointToRotate.distance((Vector3dc)axisStart.add((Vector3dc)d.mul(t)));
    }

    public static float angleDistance(float alpha, float beta) {
        float phi = Math.abs(beta - alpha) % 360.0f;
        float distance = phi > 180.0f ? 360.0f - phi : phi;
        return distance;
    }

    public float getLookAtEntityPitch(Entity user, Entity targetEntity) {
        double f;
        double d = targetEntity.m_20185_() - user.m_20185_();
        double e = targetEntity.m_20189_() - user.m_20189_();
        if (targetEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)targetEntity;
            f = livingEntity.m_20188_() - user.m_20188_();
        } else {
            f = (targetEntity.m_20191_().f_82289_ + targetEntity.m_20191_().f_82292_) / 2.0 - user.m_20188_();
        }
        double g = Math.sqrt(d * d + e * e);
        return (float)(-(Mth.m_14136_((double)f, (double)g) * 57.2957763671875));
    }

    public float getLookAtEntityYaw(Entity user, Entity targetEntity) {
        double d = targetEntity.m_20185_() - user.m_20185_();
        double e = targetEntity.m_20189_() - user.m_20189_();
        return (float)(Mth.m_14136_((double)e, (double)d) * 57.2957763671875) - 90.0f;
    }

    public float getLookAtPlacePitch(Entity user, Vec3 vec) {
        double d = vec.m_7096_() - user.m_20185_();
        double e = vec.m_7094_() - user.m_20189_();
        double f = vec.m_7098_() - user.m_20188_();
        double g = Math.sqrt(d * d + e * e);
        return (float)(-(Mth.m_14136_((double)f, (double)g) * 57.2957763671875));
    }

    public float getLookAtPlaceYaw(Entity user, Vec3 vec) {
        double d = vec.m_7096_() - user.m_20185_();
        double e = vec.m_7094_() - user.m_20189_();
        return (float)(Mth.m_14136_((double)e, (double)d) * 57.2957763671875) - 90.0f;
    }

    public BlockHitResult getAheadVec(float distOut) {
        Vec3 vec3d = this.self.m_20299_(0.0f);
        Vec3 vec3d2 = this.self.m_20252_(0.0f);
        return this.getSelf().m_9236_().m_45547_(new ClipContext(vec3d, vec3d.m_82520_(vec3d2.f_82479_ * (double)distOut, vec3d2.f_82480_ * (double)distOut, vec3d2.f_82481_ * (double)distOut), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.getSelf()));
    }

    public Entity rayCastEntity(LivingEntity User, float reach) {
        Entity hitResult;
        float tickDelta = 0.0f;
        if (this.self.m_9236_().m_5776_()) {
            Minecraft mc = Minecraft.m_91087_();
            tickDelta = mc.m_91297_();
        }
        Vec3 vec3d = User.m_20299_(tickDelta);
        Vec3 vec3d2 = User.m_20252_(1.0f);
        Vec3 vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * (double)reach, vec3d2.f_82480_ * (double)reach, vec3d2.f_82481_ * (double)reach);
        float f = 1.0f;
        AABB box = new AABB(vec3d.f_82479_ + (double)reach, vec3d.f_82480_ + (double)reach, vec3d.f_82481_ + (double)reach, vec3d.f_82479_ - (double)reach, vec3d.f_82480_ - (double)reach, vec3d.f_82481_ - (double)reach);
        EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)User, (Vec3)vec3d, (Vec3)vec3d3, (AABB)box, entity -> !entity.m_5833_() && entity.m_6087_() && !entity.m_20147_(), (double)(reach * reach));
        if (entityHitResult != null && (hitResult = entityHitResult.m_82443_()).m_6084_() && !hitResult.m_213877_() && !hitResult.m_7306_((Entity)User)) {
            return hitResult;
        }
        return null;
    }

    public List<Entity> StandGrabHitbox(LivingEntity User, List<Entity> entities, float maxDistance) {
        return this.StandGrabHitbox(User, entities, maxDistance, 25.0f);
    }

    public List<Entity> StandGrabHitbox(LivingEntity User, List<Entity> entities, float maxDistance, float angle) {
        ArrayList<Entity> hitEntities = new ArrayList<Entity>(entities){};
        for (Entity value : entities) {
            StandEntity SE;
            if (!value.m_20152_() || !value.m_6087_() && !(value instanceof StandEntity) || !value.m_6097_() && !(value instanceof StandEntity) || value.m_20147_() || !value.m_6084_() || User.m_20159_() && User.m_20202_().m_20148_() == value.m_20148_() || value.m_7306_((Entity)User) || ((StandUser)User).roundabout$getStand() != null && ((StandUser)User).roundabout$getStand().m_7306_((Entity)User) || User instanceof StandEntity && (SE = (StandEntity)User).getUser() != null && SE.getUser().m_7306_(value)) {
                hitEntities.remove(value);
                continue;
            }
            if (StandPowers.angleDistance(this.getLookAtEntityYaw((Entity)User, value), User.m_6080_() % 360.0f) <= angle && StandPowers.angleDistance(this.getLookAtEntityPitch((Entity)User, value), User.m_146909_()) <= angle) continue;
            hitEntities.remove(value);
        }
        return hitEntities;
    }

    public boolean StandAttackHitbox(List<Entity> entities, float pow, float knockbackStrength) {
        boolean hitSomething = false;
        float nearestDistance = -1.0f;
        if (entities != null) {
            for (Entity value : entities) {
                if (!this.StandDamageEntityAttack(value, pow, knockbackStrength, (Entity)this.self)) continue;
                hitSomething = true;
            }
        }
        return hitSomething;
    }

    public int getExpForLevelUp(int currentLevel) {
        return 100;
    }

    public byte getMaxLevel() {
        return 1;
    }

    public boolean StandDamageEntityAttack(Entity target, float pow, float knockbackStrength, Entity attacker) {
        if (attacker instanceof TamableAnimal) {
            TamableAnimal TT;
            TamableAnimal TA = (TamableAnimal)attacker;
            if (target instanceof TamableAnimal && (TT = (TamableAnimal)target).m_269323_() != null && TA.m_269323_() != null && TT.m_269323_().m_7306_((Entity)TA.m_269323_())) {
                return false;
            }
        } else if (attacker instanceof AbstractVillager && target instanceof AbstractVillager) {
            return false;
        }
        if (DamageHandler.StandDamageEntity(target, pow, attacker)) {
            if (attacker instanceof LivingEntity) {
                LivingEntity LE = (LivingEntity)attacker;
                LE.m_21335_(target);
            }
            if (target instanceof LivingEntity && knockbackStrength > 0.0f) {
                ((LivingEntity)target).m_147240_((double)(knockbackStrength * 0.5f), (double)Mth.m_14031_((float)(attacker.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(attacker.m_146908_() * ((float)Math.PI / 180)))));
            }
            return true;
        }
        return false;
    }

    public boolean StandRushDamageEntityAttack(Entity target, float pow, float knockbackStrength, Entity attacker) {
        if (attacker instanceof TamableAnimal) {
            TamableAnimal TT;
            TamableAnimal TA = (TamableAnimal)attacker;
            if (target instanceof TamableAnimal && (TT = (TamableAnimal)target).m_269323_() != null && TA.m_269323_() != null && TT.m_269323_().m_7306_((Entity)TA.m_269323_())) {
                return false;
            }
        } else if (attacker instanceof AbstractVillager && target instanceof AbstractVillager) {
            return false;
        }
        if (DamageHandler.StandRushDamageEntity(target, pow, attacker)) {
            if (attacker instanceof LivingEntity) {
                LivingEntity LE = (LivingEntity)attacker;
                LE.m_21335_(target);
            }
            if (target instanceof LivingEntity && knockbackStrength > 0.0f) {
                ((LivingEntity)target).m_147240_((double)(knockbackStrength * 0.5f), (double)Mth.m_14031_((float)(attacker.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(attacker.m_146908_() * ((float)Math.PI / 180)))));
            }
            return true;
        }
        return false;
    }

    public void takeKnockbackWithY(Entity entity, double strength, double x, double y, double z) {
        if (entity instanceof LivingEntity) {
            double d;
            strength *= (double)((float)(1.0 - ((LivingEntity)entity).m_21133_(Attributes.f_22278_)));
            if (d <= 0.0) {
                return;
            }
        }
        entity.f_19864_ = true;
        Vec3 vec3d2 = new Vec3(x, y, z).m_82541_().m_82490_(strength);
        entity.m_20334_(-vec3d2.f_82479_, -vec3d2.f_82480_, -vec3d2.f_82481_);
        entity.f_19812_ = true;
    }

    public void takeKnockbackUp(Entity entity, double strength) {
        if (entity instanceof LivingEntity) {
            double d;
            strength *= (double)((float)(1.0 - ((LivingEntity)entity).m_21133_(Attributes.f_22278_)));
            if (d <= 0.0) {
                return;
            }
        }
        entity.f_19812_ = true;
        Vec3 vec3d2 = new Vec3(0.0, strength, 0.0).m_82541_().m_82490_(strength);
        entity.m_20334_(vec3d2.f_82479_, vec3d2.f_82480_, vec3d2.f_82481_);
    }

    public Entity StandAttackHitboxNear(LivingEntity User, List<Entity> entities, float angle) {
        float nearestDistance = -1.0f;
        Entity nearestMob = null;
        if (entities != null) {
            for (Entity value : entities) {
                StandEntity SE;
                StandEntity SE1;
                if (value.m_20147_() || !value.m_6084_() || value.m_20148_() == User.m_20148_() || !value.m_6087_() && !(value instanceof StandEntity) || value instanceof StandEntity && (SE1 = (StandEntity)value).getUser() != null && SE1.getUser().m_7306_((Entity)User)) continue;
                float distanceTo = value.m_20270_((Entity)User);
                float range = this.getReach();
                if (value instanceof StandEntity && OffsetIndex.OffsetStyle((SE = (StandEntity)value).getOffsetType()) == 0) {
                    range /= 2.0f;
                }
                if (!(nearestDistance < 0.0f) && !(distanceTo < nearestDistance) || !(distanceTo <= range)) continue;
                nearestDistance = distanceTo;
                nearestMob = value;
            }
        }
        return nearestMob;
    }

    public void updateUniqueMoves() {
    }

    public void kickStartClient() {
        this.kickStarted = true;
    }

    public boolean interceptAttack() {
        return false;
    }

    public boolean interceptGuard() {
        return false;
    }

    public boolean canChangePower(int move, boolean forced) {
        return !(this.isClashing() && move != 14 || this.activePower != 0 && !forced || this.isDazed(this.self) && move != 6);
    }

    public boolean tryPower(int move, boolean forced) {
        if (!this.self.m_9236_().f_46443_ && (this.isBarraging() || this.isClashing()) && move != 5 && move != 6 && move != 4 && move != 3 && this.attackTimeDuring > -1) {
            this.stopSoundsIfNearby((byte)100, 100.0, false);
        }
        if (this.canChangePower(move, forced)) {
            if (move == 0 || move == 14) {
                return this.setPowerNone();
            }
            if (move == 1) {
                return this.setPowerAttack();
            }
            if (move == 3) {
                return this.setPowerGuard();
            }
            if (move == 4) {
                return this.setPowerBarrageCharge();
            }
            if (move == 5) {
                return this.setPowerBarrage();
            }
            if (move == 6) {
                return this.setPowerClash();
            }
            if (move == 7) {
                return this.setPowerSpecial(move);
            }
            if (move == 12) {
                return this.setPowerMovement(move);
            }
            if (move == 13) {
                return this.setPowerSneakMovement(move);
            }
            if (move == 39) {
                return this.setPowerMining(move);
            }
            return this.setPowerOther(move, this.getActivePower());
        }
        return false;
    }

    public boolean tryPosPower(int move, boolean forced, BlockPos blockPos) {
        this.tryPower(move, forced);
        return true;
    }

    public boolean tryChargedPower(int move, boolean forced, int chargeTime) {
        this.tryPower(move, forced);
        return true;
    }

    public boolean canSummonStand() {
        return false;
    }

    public StandEntity getNewStandEntity() {
        return null;
    }

    public void playSummonEffects(boolean forced) {
    }

    public final void playStandUserOnlySoundsIfNearby(byte soundNo, double range, boolean onSelf, boolean isVoice) {
        Player PE;
        LivingEntity livingEntity;
        if (isVoice && (livingEntity = this.getSelf()) instanceof Player && ((IPlayerEntity)(PE = (Player)livingEntity)).roundabout$getMaskInventory().m_8020_(1).m_150930_(ModItems.BLANK_MASK)) {
            return;
        }
        if (!this.self.m_9236_().f_46443_) {
            ServerLevel serverWorld = (ServerLevel)this.self.m_9236_();
            Vec3 userLocation = new Vec3(this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_());
            for (int j = 0; j < serverWorld.m_6907_().size(); ++j) {
                BlockPos blockPos;
                ServerPlayer serverPlayerEntity = (ServerPlayer)((ServerLevel)this.self.m_9236_()).m_6907_().get(j);
                if ((ServerLevel)serverPlayerEntity.m_9236_() != serverWorld || !(blockPos = serverPlayerEntity.m_20183_()).m_203195_((Position)userLocation, range) || ((StandUser)serverPlayerEntity).roundabout$getStandDisc().m_41619_()) continue;
                if (onSelf) {
                    ModPacketHandler.PACKET_ACCESS.startSoundPacket(serverPlayerEntity, serverPlayerEntity.m_19879_(), soundNo);
                    continue;
                }
                ModPacketHandler.PACKET_ACCESS.startSoundPacket(serverPlayerEntity, this.self.m_19879_(), soundNo);
            }
        }
    }

    public final void playSoundsIfNearby(byte soundNo, double range, boolean onSelf, boolean isVoice) {
        Player PE;
        LivingEntity livingEntity;
        if (isVoice && (livingEntity = this.getSelf()) instanceof Player && ((IPlayerEntity)(PE = (Player)livingEntity)).roundabout$getMaskInventory().m_8020_(1).m_150930_(ModItems.BLANK_MASK)) {
            return;
        }
        if (!this.self.m_9236_().f_46443_) {
            ServerLevel serverWorld = (ServerLevel)this.self.m_9236_();
            Vec3 userLocation = new Vec3(this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_());
            for (int j = 0; j < serverWorld.m_6907_().size(); ++j) {
                BlockPos blockPos;
                ServerPlayer serverPlayerEntity = (ServerPlayer)((ServerLevel)this.self.m_9236_()).m_6907_().get(j);
                if ((ServerLevel)serverPlayerEntity.m_9236_() != serverWorld || !(blockPos = serverPlayerEntity.m_20183_()).m_203195_((Position)userLocation, range)) continue;
                if (onSelf) {
                    ModPacketHandler.PACKET_ACCESS.startSoundPacket(serverPlayerEntity, serverPlayerEntity.m_19879_(), soundNo);
                    continue;
                }
                ModPacketHandler.PACKET_ACCESS.startSoundPacket(serverPlayerEntity, this.self.m_19879_(), soundNo);
            }
        }
    }

    public final void playSoundsIfNearby(byte soundNo, double range, boolean onSelf) {
        this.playSoundsIfNearby(soundNo, range, onSelf, false);
    }

    public void playBarrageCrySound() {
        byte barrageCrySound;
        if (!this.self.m_9236_().m_5776_() && (barrageCrySound = this.chooseBarrageSound()) != -1) {
            this.playStandUserOnlySoundsIfNearby(barrageCrySound, 27.0, false, true);
        }
    }

    public void playBarrageClashSound() {
        if (!this.self.m_9236_().m_5776_()) {
            // empty if block
        }
    }

    public void playBarrageChargeSound() {
        SoundEvent barrageChargeSound;
        if (!this.self.m_9236_().m_5776_() && (barrageChargeSound = this.getBarrageChargeSound()) != null) {
            this.playSoundsIfNearby((byte)1, 27.0, false);
        }
    }

    public void handleStandAttack(Player player, Entity target) {
    }

    public void handleStandAttack2(Player player, Entity target) {
    }

    public final void stopSoundsIfNearby(byte soundNumber, double range, boolean onSelf) {
        if (!this.self.m_9236_().f_46443_) {
            ServerLevel serverWorld = (ServerLevel)this.self.m_9236_();
            Vec3 userLocation = new Vec3(this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_());
            for (int j = 0; j < serverWorld.m_6907_().size(); ++j) {
                BlockPos blockPos;
                ServerPlayer serverPlayerEntity = (ServerPlayer)((ServerLevel)this.self.m_9236_()).m_6907_().get(j);
                if ((ServerLevel)serverPlayerEntity.m_9236_() != serverWorld || !(blockPos = serverPlayerEntity.m_20183_()).m_203195_((Position)userLocation, range)) continue;
                if (!onSelf) {
                    ModPacketHandler.PACKET_ACCESS.stopSoundPacket(serverPlayerEntity, this.self.m_19879_(), soundNumber);
                    continue;
                }
                ModPacketHandler.PACKET_ACCESS.stopSoundPacket(serverPlayerEntity, serverPlayerEntity.m_19879_(), soundNumber);
            }
        }
    }

    public boolean setPowerNone() {
        this.attackTimeDuring = -1;
        this.setActivePower((byte)0);
        this.poseStand((byte)0);
        this.animateStand((byte)0);
        return true;
    }

    public void resetAttackState() {
        if (this.shouldReset(this.getActivePower())) {
            this.interruptCD = 3;
            ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
        }
    }

    public boolean shouldReset(byte activeP) {
        return this.self.m_6117_() && this.getActivePower() != 6 || this.isDazed(this.self) || ((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity((Entity)this.getSelf());
    }

    public void updateMovesFromPacket(byte activePower) {
    }

    public boolean canAttack() {
        if (this.attackTimeDuring <= -1) {
            return this.activePowerPhase < this.activePowerPhaseMax || this.attackTime >= this.attackTimeMax;
        }
        return false;
    }

    public boolean setPowerGuard() {
        if (((StandUser)this.self).roundabout$getGuardBroken()) {
            this.animateStand((byte)15);
        } else {
            this.animateStand((byte)10);
        }
        this.attackTimeDuring = 0;
        this.setActivePower((byte)3);
        this.poseStand((byte)2);
        return true;
    }

    public boolean setPowerBarrageCharge() {
        return true;
    }

    public boolean setPowerBarrage() {
        return true;
    }

    public boolean setPowerSpecial(int lastMove) {
        return false;
    }

    public boolean setPowerMovement(int lastMove) {
        return false;
    }

    public boolean setPowerSneakMovement(int lastMove) {
        return false;
    }

    public boolean setPowerOther(int move, int lastMove) {
        return false;
    }

    public boolean setPowerMining(int lastMove) {
        this.attackTimeDuring = 0;
        this.setActivePower((byte)39);
        this.poseStand((byte)1);
        this.animateStand((byte)16);
        return true;
    }

    public boolean isMiningStand() {
        return false;
    }

    public boolean canUseMiningStand() {
        return this.isMiningStand() && (!(this.getSelf().m_21205_().m_41720_() instanceof DiggerItem) || this.getActivePower() == 39);
    }

    public void gainExpFromStandardMining(BlockState $$1, BlockPos $$2) {
    }

    public void gainExpFromSpecialMining(BlockState $$1, BlockPos $$2) {
        if (!($$1.m_60734_() instanceof IceBlock) && Math.random() > 0.62) {
            this.addEXP(1);
        }
    }

    public float getBonusPassiveMiningSpeed() {
        return 1.0f;
    }

    public float getBonusAttackSpeed() {
        return 1.0f;
    }

    public float getPickMiningSpeed() {
        return 5.0f;
    }

    public float getAxeMiningSpeed() {
        return 5.0f;
    }

    public float getSwordMiningSpeed() {
        return 5.0f;
    }

    public float getShovelMiningSpeed() {
        return 5.0f;
    }

    public boolean setPowerClash() {
        this.attackTimeDuring = 0;
        this.setActivePower((byte)6);
        this.poseStand((byte)3);
        this.setClashProgress(0.0f);
        this.clashIncrement = 0;
        this.clashMod = (int)Math.round(Math.random() * 8.0);
        this.animateStand((byte)12);
        if (this.self instanceof Player && !this.self.m_9236_().f_46443_) {
            ((ServerPlayer)this.self).m_5661_((Component)Component.m_237115_((String)"text.roundabout.barrage_clash"), true);
        }
        return true;
    }

    public int getBarrageRecoilTime() {
        return ClientNetworking.getAppropriateConfig().cooldownsInTicks.barrageRecoil;
    }

    public boolean isGuarding() {
        return this.activePower == 3;
    }

    public boolean isBarrageCharging() {
        return this.activePower == 4;
    }

    public boolean isBarraging() {
        return this.activePower == 5 || this.activePower == 4;
    }

    public boolean isBarrageAttacking() {
        return this.activePower == 5;
    }

    public boolean isClashing() {
        return this.activePower == 6 && this.attackTimeDuring > -1;
    }

    public boolean disableMobAiAttack() {
        return this.activePower == 6 && this.attackTimeDuring > -1 || this.isBarraging();
    }

    public void tickMobAI(LivingEntity attackTarget) {
    }

    public int getKickBarrageWindup() {
        return ClientNetworking.getAppropriateConfig().cooldownsInTicks.finalPunchAndKickMinimum;
    }

    public int getBarrageWindup() {
        return ClientNetworking.getAppropriateConfig().chargeSettings.barrageWindup;
    }

    public int getBarrageLength() {
        return 60;
    }

    public boolean setPowerAttack() {
        return false;
    }

    public void syncCooldowns() {
        if (!this.self.m_9236_().f_46443_ && this.self instanceof ServerPlayer) {
            ModPacketHandler.PACKET_ACCESS.syncCooldownPacket((ServerPlayer)this.self, this.attackTime, this.attackTimeMax, this.attackTimeDuring, this.activePower, this.activePowerPhase);
        }
    }

    public boolean isStoppingTime() {
        return false;
    }

    public void runExtraSoundCode(byte soundChoice) {
    }

    public boolean isHoldingSneak() {
        if (this.self.m_9236_().f_46443_) {
            Minecraft mc = Minecraft.m_91087_();
            return mc.f_91066_.f_92090_.m_90857_() && !this.isHoldingSneakToggle || this.isHoldingSneakToggle && !mc.f_91066_.f_92090_.m_90857_();
        }
        return this.getSelf().m_6047_();
    }

    public boolean dealWithProjectile(Entity ent) {
        return false;
    }

    public boolean getIsGamemodeApproriateForGrief() {
        return (!(this.getSelf() instanceof Player) || ((ServerPlayer)this.getSelf()).f_8941_.m_9290_() != GameType.SPECTATOR && ((ServerPlayer)this.getSelf()).f_8941_.m_9290_() != GameType.ADVENTURE) && this.getSelf().m_9236_().m_46469_().m_46207_(ModGamerules.ROUNDABOUT_STAND_GRIEFING);
    }

    public boolean tryPlaceBlock(BlockPos pos) {
        BlockState state;
        return !(this.self.m_9236_().m_5776_() || !(state = this.getSelf().m_9236_().m_8055_(pos)).m_60795_() && (!state.m_247087_() || !this.getIsGamemodeApproriateForGrief() || !this.getSelf().m_9236_().m_46469_().m_46207_(ModGamerules.ROUNDABOUT_STAND_GRIEFING) || this.getSelf() instanceof Player && ((Player)this.getSelf()).m_36187_(this.getSelf().m_9236_(), pos, ((ServerPlayer)this.getSelf()).f_8941_.m_9290_()) || this.getSelf() instanceof Player && !this.getSelf().m_9236_().m_7966_((Player)this.getSelf(), pos)));
    }

    public void switchRowsKey(boolean keyIsDown, Options options) {
        if (!this.heldDownSwitch) {
            if (keyIsDown) {
                this.heldDownSwitch = true;
                this.isHoldingSneakToggle = !this.isHoldingSneakToggle;
            }
        } else if (!keyIsDown) {
            this.heldDownSwitch = false;
        }
    }

    public void rollSkin() {
    }

    public byte getSoundCancelingGroupByte(byte soundChoice) {
        if (soundChoice == 1) {
            return 100;
        }
        if (soundChoice <= -2) {
            return 104;
        }
        return soundChoice;
    }
}

