/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.event.powers.stand;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.hydra.jojomod.access.IAbstractArrowAccess;
import net.hydra.jojomod.access.IEntityAndData;
import net.hydra.jojomod.access.IMob;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.projectile.ThrownObjectEntity;
import net.hydra.jojomod.entity.stand.JusticeEntity;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.entity.stand.StarPlatinumEntity;
import net.hydra.jojomod.event.AbilityIconInstance;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.event.powers.TimeStop;
import net.hydra.jojomod.event.powers.stand.presets.TWAndSPSharedPowers;
import net.hydra.jojomod.item.MaxStandDiscItem;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.networking.ModPacketHandler;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class PowersStarPlatinum
extends TWAndSPSharedPowers {
    public int scopeTicks = -1;
    boolean letServerKnowScopeCatchIsReady = false;
    public int ticksForFinger = 0;
    public boolean glowingEye = false;
    public static final byte STAR_FINGER = 80;
    public static final byte STAR_FINGER_2 = 81;
    public static final byte STAR_FINGER_SILENT = 82;
    public static final byte LAST_HIT_1_NOISE = 120;
    public static final byte LAST_HIT_2_NOISE = 121;
    public static final byte LAST_HIT_3_NOISE = 122;
    public static final byte LAST_HIT_4_NOISE = 123;
    public static final byte LAST_HIT_5_NOISE = 124;
    public static final byte LAST_HIT_6_NOISE = 125;

    public PowersStarPlatinum(LivingEntity self) {
        super(self);
    }

    @Override
    public StandPowers generateStandPowers(LivingEntity entity) {
        return new PowersStarPlatinum(entity);
    }

    @Override
    protected Byte getSummonSound() {
        return (byte)18;
    }

    @Override
    public StandEntity getNewStandEntity() {
        if (((StandUser)this.getSelf()).roundabout$getStandSkin() == 5) {
            return (StandEntity)ModEntities.STAR_PLATINUM_BASEBALL.m_20615_(this.getSelf().m_9236_());
        }
        return (StandEntity)ModEntities.STAR_PLATINUM.m_20615_(this.getSelf().m_9236_());
    }

    @Override
    public void playSummonEffects(boolean forced) {
        if (!forced && ((StandUser)this.getSelf()).roundabout$getStandSkin() == 10 && !this.getSelf().m_9236_().m_5776_()) {
            ((ServerLevel)this.self.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.getSelf().m_20185_(), this.getSelf().m_20186_() + (double)this.getSelf().m_20192_(), this.getSelf().m_20189_(), 5, 0.4, 0.4, 0.4, 0.4);
        }
    }

    @Override
    public void levelUp() {
        LivingEntity livingEntity;
        if (!this.getSelf().m_9236_().m_5776_() && (livingEntity = this.getSelf()) instanceof Player) {
            Player PE = (Player)livingEntity;
            IPlayerEntity ipe = (IPlayerEntity)PE;
            byte level = ipe.roundabout$getStandLevel();
            if (level == 7) {
                ((ServerPlayer)this.self).m_5661_((Component)Component.m_237115_((String)"leveling.roundabout.levelup.max.skins").m_130940_(ChatFormatting.AQUA), true);
            } else if (level == 2 || level == 3 || level == 4 || level == 6 || level == 5) {
                ((ServerPlayer)this.self).m_5661_((Component)Component.m_237115_((String)"leveling.roundabout.levelup.both").m_130940_(ChatFormatting.AQUA), true);
            }
        }
        super.levelUp();
    }

    @Override
    public Byte getLastHitSound() {
        double rand = Math.random();
        if (((StandUser)this.getSelf()).roundabout$getStandSkin() == 3) {
            if (rand > 0.66) {
                return (byte)123;
            }
            if (rand > 0.33) {
                return (byte)124;
            }
            return (byte)125;
        }
        if (rand > 0.66) {
            return (byte)120;
        }
        if (rand > 0.33) {
            return (byte)121;
        }
        return (byte)122;
    }

    @Override
    public SoundEvent getLastRejectionHitSound() {
        return ModSounds.STAR_PLATINUM_ORA_SOUND_EVENT;
    }

    @Override
    public void rollSkin() {
        StandUser user = this.getUserData(this.self);
        if (this.self instanceof Zombie) {
            user.roundabout$setStandSkin((byte)7);
        } else if (this.self instanceof Creeper) {
            user.roundabout$setStandSkin((byte)4);
        } else if (this.self instanceof WanderingTrader) {
            user.roundabout$setStandSkin((byte)5);
        } else if (this.self instanceof Warden) {
            user.roundabout$setStandSkin((byte)10);
        } else if (this.self instanceof Raider) {
            user.roundabout$setStandSkin((byte)3);
        } else if (this.self instanceof Piglin || this.self instanceof Rabbit) {
            user.roundabout$setStandSkin((byte)6);
        } else if (this.self instanceof IronGolem) {
            user.roundabout$setStandSkin((byte)8);
        } else if (this.self instanceof EnderMan || this.self instanceof EnderDragon) {
            user.roundabout$setStandSkin((byte)2);
        }
    }

    @Override
    public boolean canScope() {
        return this.isGuarding() || this.hasBlock() || this.hasEntity() || this.getSelf().m_6117_() && this.getSelf().m_21211_().m_150930_(Items.f_151059_) || this.getSelf().m_6117_() && this.getSelf().m_21211_().m_41720_() instanceof ProjectileWeaponItem;
    }

    @Override
    public float getFinalPunchStrength(Entity entity) {
        float punchD = this.getPunchStrength(entity) * 2.0f + this.getHeavyPunchStrength(entity);
        if (this.getReducedDamage(entity)) {
            return (float)this.chargedFinal / (float)maxSuperHitTime * punchD;
        }
        return (float)this.chargedFinal / (float)maxSuperHitTime * punchD + 3.0f;
    }

    @Override
    public float getBarrageHitStrength(Entity entity) {
        float str = super.getBarrageHitStrength(entity);
        str = this.getReducedDamage(entity) ? (str *= this.levelupDamageMod((float)((double)ClientNetworking.getAppropriateConfig().damageMultipliers.starPlatinumAttacksOnPlayers.intValue() * 0.01))) : (str *= this.levelupDamageMod((float)((double)ClientNetworking.getAppropriateConfig().damageMultipliers.starPlatinumAttacksOnMobs.intValue() * 0.01)));
        if (this.forwardBarrage) {
            str *= 0.6f;
        }
        return str;
    }

    @Override
    public float getBarrageFinisherStrength(Entity entity) {
        float str = super.getBarrageFinisherStrength(entity);
        str = this.getReducedDamage(entity) ? (str *= this.levelupDamageMod((float)((double)ClientNetworking.getAppropriateConfig().damageMultipliers.starPlatinumAttacksOnPlayers.intValue() * 0.01))) : (str *= this.levelupDamageMod((float)((double)ClientNetworking.getAppropriateConfig().damageMultipliers.starPlatinumAttacksOnMobs.intValue() * 0.01)));
        if (this.forwardBarrage && !(entity instanceof Player)) {
            str *= 0.6f;
        } else if (this.forwardBarrage) {
            str *= 0.8f;
        }
        return str;
    }

    @Override
    public void playBarrageClashSound() {
        if (!this.self.m_9236_().m_5776_()) {
            byte skn = ((StandUser)this.getSelf()).roundabout$getStandSkin();
            if (skn == 3) {
                this.playSoundsIfNearby((byte)22, 27.0, false);
                return;
            }
            this.playSoundsIfNearby((byte)20, 27.0, false);
        }
    }

    @Override
    public void playSPandTWTSSounds() {
        byte bt = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (bt == 3) {
            this.playSoundsIfNearby((byte)47, 100.0, true);
        } else {
            this.playSoundsIfNearby((byte)40, 100.0, true);
        }
    }

    @Override
    public void tickPower() {
        if (this.getSelf().m_9236_().m_5776_()) {
            if (this.onCooldown((byte)8)) {
                if (!this.letServerKnowScopeCatchIsReady) {
                    this.letServerKnowScopeCatchIsReady = true;
                }
            } else if (this.letServerKnowScopeCatchIsReady) {
                ModPacketHandler.PACKET_ACCESS.byteToServerPacket((byte)8, (byte)8);
                this.letServerKnowScopeCatchIsReady = false;
            }
        }
        super.tickPower();
        if (this.self.m_6084_() && !this.self.m_213877_()) {
            StarPlatinumEntity SE;
            StandEntity stand;
            if (this.getActivePower() != 21 && Objects.nonNull((Object)(stand = this.getStandEntity(this.self))) && stand instanceof StarPlatinumEntity && (double)(SE = (StarPlatinumEntity)stand).getFingerLength() > 1.01) {
                if (this.getSelf() instanceof Player && this.isPacketPlayer()) {
                    ModPacketHandler.PACKET_ACCESS.floatToServerPacket(1.0f, (byte)2);
                }
                if (!this.self.m_9236_().m_5776_()) {
                    SE.setFingerLength(1.0f);
                }
            }
            if (this.scopeTicks > -1) {
                --this.scopeTicks;
            }
            if (this.scopeLevel > 0) {
                if (this.scopeTime < 10) {
                    ++this.scopeTime;
                }
            } else if (this.scopeTime > -1) {
                --this.scopeTime;
            }
        }
    }

    @Override
    public boolean isAttackIneptVisually(byte activeP, int slot) {
        return this.isDazed(this.getSelf()) || slot == 3 && this.isGuarding() && ((TimeStop)this.getSelf().m_9236_()).isTimeStoppingEntity(this.getSelf()) || activeP != 3 && ((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity((Entity)this.getSelf()) || this.getActivePower() == 24 && this.getAttackTimeDuring() >= 0 && slot != 1 || (this.hasBlock() || this.hasEntity()) && slot != 1;
    }

    @Override
    public float inputSpeedModifiers(float basis) {
        if (this.scopeLevel > -1) {
            basis *= 0.85f;
        }
        if (this.activePower == 21 && this.getAttackTimeDuring() >= 0 && this.getAttackTimeDuring() <= 26) {
            basis *= 0.74f;
        }
        if (this.activePower == 25 && !(this.getSelf() instanceof Creeper)) {
            basis *= 0.5f;
        }
        return super.inputSpeedModifiers(basis);
    }

    @Override
    public void updateIntMove(int in) {
        this.ticksForFinger = in;
        this.stopSoundsIfNearby((byte)80, 100.0, false);
        this.stopSoundsIfNearby((byte)81, 100.0, false);
        this.stopSoundsIfNearby((byte)82, 100.0, false);
        this.animateStand((byte)83);
        this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.DSP_SUMMON_EVENT, SoundSource.PLAYERS, 0.5f, (float)(1.5 + Math.random() * 0.04));
    }

    @Override
    public void buttonInputAttack(boolean keyIsDown, Options options) {
        if (this.getActivePower() != 21 || this.attackTimeDuring >= 26) {
            super.buttonInputAttack(keyIsDown, options);
        } else if (keyIsDown && this.ticksForFinger == 100) {
            this.holdDownClick = true;
            this.ticksForFinger = 101;
            this.animateStand((byte)83);
            ModPacketHandler.PACKET_ACCESS.intToServerPacket(this.attackTimeDuring, (byte)7);
            this.attackTimeDuring = 26;
        }
    }

    @Override
    public void buttonInput3(boolean keyIsDown, Options options) {
        if (keyIsDown) {
            if (!(this.inputDash || this.getActivePower() == 26 || !this.getSelf().m_9236_().f_46443_ || this.isClashing() || this.getActivePower() == 23 || this.getActivePower() == 29 && this.getAttackTimeDuring() >= 0 || this.hasEntity() || this.getActivePower() == 24 && this.getAttackTimeDuring() >= 0 || this.hasBlock())) {
                if (this.isGuarding()) {
                    if (this.activePower != 25 && !this.getSelf().m_5842_() && this.canExecuteMoveWithLevel(this.getInhaleLevel())) {
                        ((StandUser)this.getSelf()).roundabout$tryPower(25, true);
                        ModPacketHandler.PACKET_ACCESS.StandPowerPacket((byte)25);
                    }
                } else if (this.activePower != 25) {
                    super.buttonInput3(keyIsDown, options);
                }
            }
        } else {
            this.inputDash = false;
        }
    }

    @Override
    public void buttonInput1(boolean keyIsDown, Options options) {
        if (!this.isBarrageAttacking() && this.getActivePower() != 42 || this.getAttackTimeDuring() < 0) {
            if (this.getSelf().m_9236_().f_46443_ && !this.isClashing() && !((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity((Entity)this.getSelf())) {
                if (keyIsDown) {
                    if (this.canScope()) {
                        if (this.scopeTicks == -1) {
                            this.scopeTicks = 6;
                            int newLevel = this.scopeLevel + 1;
                            if (newLevel > 3) {
                                this.setScopeLevel(0);
                            } else {
                                this.getSelf().m_5496_(ModSounds.STAR_PLATINUM_SCOPE_EVENT, 1.0f, (float)((double)0.98f + Math.random() * (double)0.04f));
                                this.setScopeLevel(newLevel);
                            }
                        }
                    } else if (!(this.isGuarding() || this.hold1 || this.forwardBarrage || this.isBarrageCharging() || this.getActivePower() == 41)) {
                        if (!this.isHoldingSneak() && !this.isBarrageAttacking() && this.getActivePower() != 42) {
                            this.hold1 = true;
                            if (!this.onCooldown((byte)0) && this.canExecuteMoveWithLevel(this.getFingerLevel()) && this.activePower != 21) {
                                this.ticksForFinger = 0;
                                ((StandUser)this.getSelf()).roundabout$tryPower(21, true);
                                ModPacketHandler.PACKET_ACCESS.StandPowerPacket((byte)21);
                            }
                        }
                        super.buttonInput1(keyIsDown, options);
                    }
                } else {
                    this.hold1 = false;
                }
            }
        } else {
            super.buttonInput1(keyIsDown, options);
        }
    }

    @Override
    public int getExpForLevelUp(int currentLevel) {
        int amt = currentLevel == 1 ? 25 : 100 + (currentLevel - 1) * 50;
        amt = (int)((double)amt * ((double)ClientNetworking.getAppropriateConfig().standExperienceNeededForLevelupMultiplier.intValue() * 0.01));
        return amt;
    }

    @Override
    public void updateUniqueMoves() {
        if (this.getActivePower() == 21) {
            this.updateStarFinger();
        } else if (this.getActivePower() == 25) {
            this.updateInhale();
        }
        super.updateUniqueMoves();
    }

    public void updateInhale() {
        float dist = 8.0f;
        Vec3 pointVec = DamageHandler.getRayPoint(this.self, dist);
        Vec3 pointVec2 = DamageHandler.getRayPoint(this.self, Math.max(0.6, (double)dist - 1.5));
        if (!this.self.m_9236_().f_46443_) {
            if (this.getSelf().m_5842_()) {
                ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
                return;
            }
            if (this.attackTimeDuring % 7 == 0) {
                this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.INHALE_EVENT, SoundSource.PLAYERS, 0.5f, (float)(0.98 + Math.random() * 0.04));
            }
            double random = Math.random() * 1.8 - 0.9;
            double random2 = Math.random() * 1.8 - 0.9;
            double random3 = Math.random() * 1.8 - 0.9;
            ((ServerLevel)this.self.m_9236_()).m_8767_((ParticleOptions)ModParticles.VACUUM, pointVec2.f_82479_ + random, pointVec2.f_82480_ + random2, pointVec2.f_82481_ + random3, 0, (this.getSelf().m_20185_() - pointVec2.f_82479_) * (double)1.4f, (this.getSelf().m_20188_() - pointVec2.f_82480_) * (double)1.4f, (this.getSelf().m_20189_() - pointVec2.f_82481_) * (double)1.4f, 0.08);
            float dst = (float)pointVec.m_82554_(this.getSelf().m_20182_());
            float halfReach = (float)((double)dst * 0.5);
            Vec3 pointVec3 = DamageHandler.getRayPoint(this.self, halfReach);
            List<Entity> listEnt = DamageHandler.genHitbox(this.self, pointVec3.f_82479_, pointVec3.f_82480_, pointVec3.f_82481_, halfReach, halfReach, halfReach);
            for (Entity value : listEnt) {
                IPlayerEntity ipe;
                Player PE;
                StandUser user;
                ItemStack stack;
                LivingEntity ybias2;
                if (value instanceof JusticeEntity) {
                    JusticeEntity JE = (JusticeEntity)value;
                    if (!(PowersStarPlatinum.angleDistance(this.getLookAtEntityYaw((Entity)this.self, value), this.self.m_6080_() % 360.0f) <= 60.0f) || !(PowersStarPlatinum.angleDistance(this.getLookAtEntityPitch((Entity)this.self, value), this.self.m_146909_()) <= 60.0f)) continue;
                    JE.inhaleTick();
                    continue;
                }
                if (value instanceof StarPlatinumEntity || value.m_20147_() || !(PowersStarPlatinum.angleDistance(this.getLookAtEntityYaw((Entity)this.self, value), this.self.m_6080_() % 360.0f) <= 60.0f) || !(PowersStarPlatinum.angleDistance(this.getLookAtEntityPitch((Entity)this.self, value), this.self.m_146909_()) <= 60.0f)) continue;
                double strength = 0.05;
                if (value instanceof ItemEntity || value instanceof ExperienceOrb) {
                    ((IEntityAndData)value).roundabout$setNoGravTicks(2);
                    strength = 0.7;
                    float degrees = Mth.m_14177_((float)(this.getLookAtEntityYaw((Entity)this.getSelf(), value) - 180.0f));
                    float degreesY = -1.0f * this.getLookAtEntityPitch((Entity)this.getSelf(), value);
                    float ybias2 = (90.0f - Math.abs(degreesY)) / 90.0f;
                    MainUtil.takeUnresistableKnockbackWithYBias(value, strength * (0.5 + (double)(ybias2 / 2.0f)), Mth.m_14031_((float)(degrees * ((float)Math.PI / 180))), Mth.m_14031_((float)(degreesY * ((float)Math.PI / 180))), -Mth.m_14089_((float)(degrees * ((float)Math.PI / 180))), ybias2);
                    continue;
                }
                if (value instanceof Projectile) continue;
                if (value instanceof LivingEntity) {
                    double d;
                    LivingEntity LE = (LivingEntity)value;
                    strength *= (double)((float)(1.0 - LE.m_21133_(Attributes.f_22278_)));
                    if (d <= 0.0) {
                        strength = 0.0;
                        continue;
                    }
                }
                if (value instanceof PrimedTnt && (ybias2 = this.getSelf()) instanceof Player && !(stack = (user = (StandUser)(PE = (Player)ybias2)).roundabout$getStandDisc()).m_41619_() && stack.m_150930_(ModItems.STAND_DISC_STAR_PLATINUM) && !(ipe = (IPlayerEntity)PE).roundabout$getUnlockedBonusSkin() && value.m_20270_((Entity)this.getSelf()) < 1.0f && !this.getSelf().m_9236_().m_5776_()) {
                    ipe.roundabout$setUnlockedBonusSkin(true);
                    this.getSelf().m_9236_().m_6263_(null, this.getSelf().m_20185_(), this.getSelf().m_20186_(), this.getSelf().m_20189_(), ModSounds.UNLOCK_SKIN_EVENT, this.getSelf().m_5720_(), 2.0f, 1.0f);
                    this.getSelf().m_9236_().m_6263_(null, this.getSelf().m_20185_(), this.getSelf().m_20186_(), this.getSelf().m_20189_(), SoundEvents.f_11913_, this.getSelf().m_5720_(), 2.0f, 1.0f);
                    ((ServerLevel)this.getSelf().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.getSelf().m_20185_(), this.getSelf().m_20186_() + (double)this.getSelf().m_20192_(), this.getSelf().m_20189_(), 20, 0.7, 0.7, 0.7, 0.2);
                    user.roundabout$setStandSkin((byte)10);
                    ((ServerPlayer)ipe).m_5661_((Component)Component.m_237115_((String)"unlock_skin.roundabout.star_platinum.atomic"), true);
                    user.roundabout$summonStand(this.getSelf().m_9236_(), true, false);
                    value.m_146870_();
                    return;
                }
                float degrees = Mth.m_14177_((float)(this.getLookAtEntityYaw((Entity)this.getSelf(), value) - 180.0f));
                MainUtil.knockbackWithoutBumpUp(value, strength, Mth.m_14031_((float)(degrees * ((float)Math.PI / 180))), -Mth.m_14089_((float)(degrees * ((float)Math.PI / 180))));
            }
        }
    }

    public List<Entity> doFinger(float distance) {
        float halfReach = (float)((double)distance * 0.5);
        Vec3 pointVec = DamageHandler.getRayPoint(this.self, halfReach);
        return this.FingerGrabHitbox(DamageHandler.genHitbox(this.self, pointVec.f_82479_, pointVec.f_82480_, pointVec.f_82481_, halfReach, halfReach, halfReach), distance);
    }

    @Override
    public void handleStandAttack(Player player, Entity target) {
        super.handleStandAttack(player, target);
    }

    @Override
    public void handleStandAttack2(Player player, Entity target) {
        if (this.getActivePower() == 21) {
            this.fingerDamage(target);
        }
    }

    @Override
    public boolean dealWithProjectile(Entity ent) {
        StandEntity stand;
        if (!ent.m_9236_().m_5776_() && Objects.nonNull((Object)(stand = this.getStandEntity(this.self))) && stand instanceof StarPlatinumEntity) {
            StarPlatinumEntity SE = (StarPlatinumEntity)stand;
            LivingEntity livingEntity = this.self;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer PE = (ServerPlayer)livingEntity;
                if (SE.getScoping() && !this.onCooldown((byte)8) && !this.hasBlock() && !this.hasEntity() && ((StandUser)this.getSelf()).roundabout$getActivePower() == 3) {
                    ThrownPotion TP;
                    ItemStack ii;
                    boolean success = false;
                    if (ent instanceof AbstractArrow) {
                        AbstractArrow AA = (AbstractArrow)ent;
                        ItemStack ii2 = ((IAbstractArrowAccess)ent).roundabout$GetPickupItem();
                        if (!ii2.m_41619_()) {
                            success = true;
                            ModPacketHandler.PACKET_ACCESS.sendSimpleByte(PE, (byte)3);
                            ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
                            SE.canAcquireHeldItem = AA.f_36705_.equals((Object)AbstractArrow.Pickup.ALLOWED);
                            SE.setHeldItem(ii2.m_278832_());
                        }
                    } else if (ent instanceof ThrownObjectEntity) {
                        ThrownObjectEntity TO = (ThrownObjectEntity)ent;
                        ItemStack ii3 = TO.m_7846_();
                        if (!ii3.m_41619_()) {
                            success = true;
                            ModPacketHandler.PACKET_ACCESS.sendSimpleByte(PE, (byte)3);
                            ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
                            SE.canAcquireHeldItem = TO.places;
                            SE.setHeldItem(ii3.m_278832_());
                        }
                    } else if (ent instanceof ThrownPotion && !(ii = (TP = (ThrownPotion)ent).m_7846_()).m_41619_()) {
                        success = true;
                        ModPacketHandler.PACKET_ACCESS.sendSimpleByte(PE, (byte)3);
                        ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
                        SE.canAcquireHeldItem = TP.m_19749_() == null || TP.m_19749_() instanceof Player;
                        SE.setHeldItem(ii.m_278832_());
                    }
                    if (success) {
                        int cdr = ClientNetworking.getAppropriateConfig().cooldownsInTicks.starPlatinumGuardian;
                        ModPacketHandler.PACKET_ACCESS.syncSkillCooldownPacket((ServerPlayer)this.getSelf(), (byte)8, cdr);
                        ((StarPlatinumEntity)stand).setScoping(false);
                        this.setCooldown((byte)8, cdr);
                        this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.ITEM_CATCH_EVENT, SoundSource.PLAYERS, 1.7f, 1.2f);
                        this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.BLOCK_GRAB_EVENT, SoundSource.PLAYERS, 1.7f, 0.5f);
                        this.poseStand((byte)7);
                        if (MainUtil.isThrownBlockItem(SE.getHeldItem().m_41720_())) {
                            this.animateStand((byte)32);
                        } else {
                            this.animateStand((byte)34);
                        }
                        ((ServerLevel)this.self.m_9236_()).m_8767_((ParticleOptions)ModParticles.AIR_CRACKLE, ent.m_20185_(), ent.m_20186_(), ent.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void doFingerHit(List<Entity> entities) {
        ArrayList<Entity> hitEntities = new ArrayList<Entity>(entities){};
        for (Entity value : hitEntities) {
            if (this.isPacketPlayer()) {
                ModPacketHandler.PACKET_ACCESS.intToServerPacket(value.m_19879_(), (byte)5);
                continue;
            }
            this.fingerDamage(value);
        }
    }

    @Override
    public int getFinalAttackKnockShieldTime() {
        return 80;
    }

    @Override
    public void dspStuff(Entity ent) {
        if (((StandUser)this.getSelf()).roundabout$getStandSkin() == 10) {
            ((ServerLevel)this.self.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, ent.m_20185_(), ent.m_20186_() + (double)ent.m_20192_(), ent.m_20189_(), 5, 0.6, 0.6, 0.6, 0.4);
        }
    }

    @Override
    public SoundEvent getFinalAttackSound() {
        if (((StandUser)this.getSelf()).roundabout$getStandSkin() == 5) {
            return ModSounds.EXPLOSIVE_BAT_EVENT;
        }
        return ModSounds.EXPLOSIVE_PUNCH_EVENT;
    }

    public void fingerDamage(Entity entity) {
        float pow = this.getFingerDamage(entity);
        float knockbackStrength = 0.3f;
        if (this.ticksForFinger < 26) {
            pow *= 1.0f - (float)(26 - this.ticksForFinger) / 26.0f;
        }
        if (this.ticksForFinger < 26) {
            if (this.StandDamageEntityAttack(entity, pow, 0.0f, (Entity)this.self)) {
                this.takeDeterminedKnockback(this.self, entity, knockbackStrength);
                if (entity instanceof LivingEntity) {
                    LivingEntity LE = (LivingEntity)entity;
                    this.addEXP(1, LE);
                }
            }
        } else if (this.StarFingerDamageEntityAttack(entity, pow, 0.0f, (Entity)this.self)) {
            this.takeDeterminedKnockback(this.self, entity, knockbackStrength);
            if (entity instanceof LivingEntity) {
                LivingEntity LE = (LivingEntity)entity;
                this.addEXP(2, LE);
                MainUtil.makeBleed((Entity)LE, 0, 200, (Entity)this.self);
            }
        } else {
            this.knockShield2(entity, 40);
        }
    }

    public boolean StarFingerDamageEntityAttack(Entity target, float pow, float knockbackStrength, Entity attacker) {
        if (attacker instanceof TamableAnimal) {
            TamableAnimal TT;
            TamableAnimal TA = (TamableAnimal)attacker;
            if (target instanceof TamableAnimal && (TT = (TamableAnimal)target).m_269323_() != null && TA.m_269323_() != null && TT.m_269323_().m_7306_((Entity)TA.m_269323_())) {
                return false;
            }
        } else if (attacker instanceof AbstractVillager && target instanceof AbstractVillager) {
            return false;
        }
        if (DamageHandler.StarFingerStandDamageEntity(target, pow, attacker)) {
            if (attacker instanceof LivingEntity) {
                LivingEntity LE = (LivingEntity)attacker;
                LE.m_21335_(target);
            }
            if (target instanceof LivingEntity && knockbackStrength > 0.0f) {
                ((LivingEntity)target).m_147240_((double)(knockbackStrength * 0.5f), (double)Mth.m_14031_((float)(this.self.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.self.m_146908_() * ((float)Math.PI / 180)))));
            }
            return true;
        }
        return false;
    }

    @Override
    public float getPunchStrength(Entity entity) {
        if (this.getReducedDamage(entity)) {
            return this.levelupDamageMod((float)(1.75 * ((double)ClientNetworking.getAppropriateConfig().damageMultipliers.starPlatinumAttacksOnPlayers.intValue() * 0.01)));
        }
        return this.levelupDamageMod((float)(5.0 * ((double)ClientNetworking.getAppropriateConfig().damageMultipliers.starPlatinumAttacksOnMobs.intValue() * 0.01)));
    }

    @Override
    public float getHeavyPunchStrength(Entity entity) {
        if (this.getReducedDamage(entity)) {
            return this.levelupDamageMod((float)(2.5 * ((double)ClientNetworking.getAppropriateConfig().damageMultipliers.starPlatinumAttacksOnPlayers.intValue() * 0.01)));
        }
        return this.levelupDamageMod((float)(6.0 * ((double)ClientNetworking.getAppropriateConfig().damageMultipliers.starPlatinumAttacksOnMobs.intValue() * 0.01)));
    }

    public float getFingerDamage(Entity entity) {
        if (this.getReducedDamage(entity)) {
            return this.levelupDamageMod((float)(1.5 * ((double)ClientNetworking.getAppropriateConfig().damageMultipliers.starPlatinumAttacksOnPlayers.intValue() * 0.01)));
        }
        return this.levelupDamageMod((float)(10.0 * ((double)ClientNetworking.getAppropriateConfig().damageMultipliers.starPlatinumAttacksOnMobs.intValue() * 0.01)));
    }

    public List<Entity> FingerGrabHitbox(List<Entity> entities, float maxDistance) {
        ArrayList<Entity> hitEntities = new ArrayList<Entity>(entities){};
        for (Entity value : entities) {
            StandEntity SE;
            if (value.m_20147_() || (!value.m_6097_() || !value.m_6087_()) && !(value instanceof StandEntity) || !value.m_6084_() || this.self.m_20159_() && this.self.m_20202_().m_20148_() == value.m_20148_() || value instanceof StandEntity && (SE = (StandEntity)value).getUser() != null && SE.getUser().m_20148_() == this.self.m_20148_()) {
                hitEntities.remove(value);
                continue;
            }
            int angle = 14;
            if (PowersStarPlatinum.angleDistance(this.getLookAtEntityYaw((Entity)this.self, value), this.self.m_6080_() % 360.0f) <= (float)angle && PowersStarPlatinum.angleDistance(this.getLookAtEntityPitch((Entity)this.self, value), this.self.m_146909_()) <= (float)angle) continue;
            hitEntities.remove(value);
        }
        ArrayList<Entity> hitEntities2 = new ArrayList<Entity>((Collection)hitEntities){};
        for (Entity value : hitEntities) {
            StandEntity SE;
            if (!(value instanceof StandEntity) || (SE = (StandEntity)value).getUser() == null) continue;
            for (Entity value2 : hitEntities) {
                if (!value2.m_7306_((Entity)SE.getUser())) continue;
                hitEntities2.remove(value);
            }
        }
        return hitEntities2;
    }

    @Override
    public boolean glowingEyes() {
        return this.glowingEye;
    }

    public void updateStarFinger() {
        if (this.attackTimeDuring > -1) {
            StandEntity stand = this.getStandEntity(this.self);
            if (this.attackTimeDuring > 40) {
                if (Objects.nonNull((Object)stand) && stand instanceof StarPlatinumEntity) {
                    StarPlatinumEntity SE = (StarPlatinumEntity)stand;
                    if (this.self instanceof Player && this.isPacketPlayer()) {
                        ModPacketHandler.PACKET_ACCESS.floatToServerPacket(1.0f, (byte)2);
                    }
                }
                this.setAttackTimeDuring(-10);
            } else if (this.attackTimeDuring >= 24) {
                float distanceOut = 0.0f;
                distanceOut = this.attackTimeDuring <= 35 ? Math.min(2.5f * (float)(this.attackTimeDuring - 23), 8.0f) : Math.max(2.5f * (float)(40 - this.attackTimeDuring), 1.0f);
                if (this.self instanceof Player) {
                    if (this.isPacketPlayer()) {
                        BlockHitResult dd = this.getAheadVec(distanceOut);
                        double maxDist = Math.max(Math.sqrt(dd.m_82448_((Entity)this.getSelf())), 1.0);
                        double maxDist2 = Math.max(Math.sqrt(dd.m_82448_((Entity)this.getSelf())) * 16.0 - 32.0, 1.0);
                        ModPacketHandler.PACKET_ACCESS.floatToServerPacket((float)maxDist2, (byte)2);
                        if (this.attackTimeDuring == 27) {
                            int cdr = ClientNetworking.getAppropriateConfig().cooldownsInTicks.starFinger;
                            this.setCooldown((byte)0, cdr);
                            this.ticksForFinger = 101;
                            List<Entity> fingerTargets = this.doFinger((float)maxDist);
                            if (!fingerTargets.isEmpty()) {
                                this.doFingerHit(fingerTargets);
                            }
                        }
                    }
                } else {
                    BlockHitResult dd = this.getAheadVec(distanceOut);
                    if (Objects.nonNull((Object)stand) && stand instanceof StarPlatinumEntity) {
                        StarPlatinumEntity SE = (StarPlatinumEntity)stand;
                        if (!this.getSelf().m_9236_().f_46443_) {
                            SE.setFingerLength((float)Math.max(Math.sqrt(dd.m_82448_((Entity)this.getSelf())) * 16.0 - 32.0, 1.0));
                        }
                        if (this.attackTimeDuring == 27) {
                            int cdr = ClientNetworking.getAppropriateConfig().cooldownsInTicks.starFinger;
                            this.setCooldown((byte)0, cdr);
                            double maxDist = Math.max(Math.sqrt(dd.m_82448_((Entity)this.getSelf())) * 16.0 - 32.0, 1.0);
                            List<Entity> fingerTargets = this.doFinger((float)maxDist);
                            if (!fingerTargets.isEmpty()) {
                                this.doFingerHit(fingerTargets);
                            }
                        }
                    }
                }
            }
        }
    }

    public Vec3 getAheadVec2(float distOut) {
        Vec3 vec3d = this.self.m_20299_(0.0f);
        Vec3 vec3d2 = this.self.m_20252_(0.0f);
        return vec3d.m_82520_(vec3d2.f_82479_ * (double)distOut, vec3d2.f_82480_ * (double)distOut, vec3d2.f_82481_ * (double)distOut);
    }

    @Override
    public boolean cancelSprintJump() {
        if (this.getActivePower() == 21 && this.getAttackTimeDuring() >= 0 && this.getAttackTimeDuring() <= 26) {
            return true;
        }
        if (this.getActivePower() == 25) {
            return true;
        }
        return super.cancelSprintJump();
    }

    @Override
    public boolean fullTSChargeBonus() {
        if (this.canExecuteMoveWithLevel(this.getMaxTSFactorLevel())) {
            return this.maxChargedTSTicks >= ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksStarPlatinum;
        }
        return false;
    }

    @Override
    public Component getSkinName(byte skinId) {
        return StarPlatinumEntity.getSkinNameT(skinId);
    }

    @Override
    public boolean canInterruptPower() {
        if (this.getActivePower() == 21 && this.getAttackTimeDuring() >= 0 && this.getAttackTimeDuring() <= 26) {
            int cdr = ClientNetworking.getAppropriateConfig().cooldownsInTicks.starFingerInterrupt;
            if (this.getSelf() instanceof Player) {
                ModPacketHandler.PACKET_ACCESS.syncSkillCooldownPacket((ServerPlayer)this.getSelf(), (byte)0, cdr);
            }
            this.setCooldown((byte)0, cdr);
            return true;
        }
        return super.canInterruptPower();
    }

    @Override
    public void renderAttackHud(GuiGraphics context, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        if (this.getActivePower() == 21) {
            float distanceOut = 8.0f;
            BlockHitResult dd = this.getAheadVec(distanceOut);
            List<Entity> fingerTargets = this.doFinger((float)Math.sqrt(dd.m_82448_((Entity)this.getSelf())));
            if (!fingerTargets.isEmpty()) {
                int j = scaledHeight / 2 - 7 - 4;
                int k = scaledWidth / 2 - 8;
                context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 0, 15, 6);
            }
        } else {
            super.renderAttackHud(context, playerEntity, scaledWidth, scaledHeight, ticks, vehicleHeartCount, flashAlpha, otherFlashAlpha);
        }
    }

    @Override
    public List<Byte> getSkinList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)1);
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            boolean bypass;
            Player PE = (Player)livingEntity;
            byte Level2 = ((IPlayerEntity)PE).roundabout$getStandLevel();
            ItemStack goldDisc = ((StandUser)PE).roundabout$getStandDisc();
            boolean bl = bypass = PE.m_7500_() || !goldDisc.m_41619_() && goldDisc.m_41720_() instanceof MaxStandDiscItem;
            if (Level2 > 1 || bypass) {
                $$1.add((byte)7);
            }
            if (Level2 > 2 || bypass) {
                $$1.add((byte)3);
            }
            if (Level2 > 3 || bypass) {
                $$1.add((byte)4);
            }
            if (Level2 > 4 || bypass) {
                $$1.add((byte)5);
                $$1.add((byte)11);
            }
            if (Level2 > 5 || bypass) {
                $$1.add((byte)6);
            }
            if (Level2 > 6 || bypass) {
                $$1.add((byte)8);
                $$1.add((byte)2);
                $$1.add((byte)9);
            }
            if (((IPlayerEntity)PE).roundabout$getUnlockedBonusSkin() || bypass) {
                $$1.add((byte)10);
            }
        }
        return $$1;
    }

    @Override
    public void tickMobAI(LivingEntity attackTarget) {
        if (!(this.attackTimeDuring > -1 || !(this.getSelf().f_19789_ > 4.0f) || this.self instanceof FlyingMob || this.getSelf().m_20068_() || this.getSelf().f_19794_ || this.self instanceof EnderDragon || this.self instanceof WitherBoss)) {
            ((StandUser)this.getSelf()).roundabout$summonStand(this.getSelf().m_9236_(), true, false);
            LivingEntity livingEntity = this.getSelf();
            if (livingEntity instanceof Mob) {
                Mob MB = (Mob)livingEntity;
                ((IMob)MB).roundabout$setRetractTicks(140);
            }
            ((StandUser)this.getSelf()).roundabout$tryPower(15, true);
            return;
        }
        if (attackTarget != null && attackTarget.m_6084_() && !this.isDazed(this.getSelf())) {
            double dist = attackTarget.m_20270_((Entity)this.getSelf());
            boolean isCreeper = this.getSelf() instanceof Creeper;
            if (isCreeper) {
                boolean inhaling;
                boolean bl = inhaling = this.getActivePower() == 25;
                if (dist <= 8.0) {
                    if (!inhaling) {
                        ((StandUser)this.getSelf()).roundabout$tryPower(25, true);
                    }
                } else if (inhaling) {
                    ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
                }
            } else {
                if (this.getActivePower() != 0 || dist <= 5.0) {
                    this.getSelf().m_146926_(this.getLookAtEntityPitch((Entity)this.getSelf(), (Entity)attackTarget));
                    float yrot = this.getLookAtEntityYaw((Entity)this.getSelf(), (Entity)attackTarget);
                    this.getSelf().m_146922_(yrot);
                    this.getSelf().m_5616_(yrot);
                }
                if (this.attackTimeDuring == -1 || this.attackTimeDuring < -1 && this.activePower == 1) {
                    Entity targetEntity = this.getTargetEntity(this.self, -1.0f);
                    if (targetEntity != null && targetEntity.m_7306_((Entity)attackTarget)) {
                        double RNG = Math.random();
                        if (RNG < 0.4 && targetEntity instanceof Player && this.activePowerPhase <= 0 && !this.wentForCharge) {
                            this.wentForCharge = true;
                            if (RNG < 0.1) {
                                ((StandUser)this.getSelf()).roundabout$tryPower(41, true);
                            } else {
                                ((StandUser)this.getSelf()).roundabout$tryPower(4, true);
                            }
                        } else {
                            Objects.requireNonNull(this);
                            if (this.activePowerPhase < 3 || this.attackTime >= this.attackTimeMax) {
                                if (RNG < 0.85 && (this.getSelf() instanceof Hoglin || this.getSelf() instanceof Ravager)) {
                                    ((StandUser)this.getSelf()).roundabout$tryPower(43, true);
                                    this.wentForCharge = false;
                                } else if (!this.onCooldown((byte)4) && RNG >= 0.85 && dist <= 3.0 && !this.wentForCharge) {
                                    ((StandUser)this.getSelf()).roundabout$tryPower(22, true);
                                    this.wentForCharge = true;
                                } else {
                                    ((StandUser)this.getSelf()).roundabout$tryPower(1, true);
                                    this.wentForCharge = false;
                                }
                            }
                        }
                    } else if ((this.getSelf().m_21223_() > 20.0f || this.getSelf() instanceof Piglin || this.getSelf() instanceof AbstractVillager) && dist <= 8.0 && dist >= 5.0) {
                        if (!this.onCooldown((byte)0)) {
                            ((StandUser)this.getSelf()).roundabout$tryPower(21, true);
                        }
                    } else if ((this.getSelf() instanceof Spider || this.getSelf() instanceof Slime || this.getSelf() instanceof Rabbit || this.getSelf() instanceof AbstractVillager || this.getSelf() instanceof Piglin || this.getSelf() instanceof Vindicator) && this.getSelf().m_20096_() && dist <= 19.0 && dist >= 5.0 && !this.onCooldown((byte)6) && !this.onCooldown((byte)6)) {
                        this.setCooldown((byte)6, 300);
                        this.bonusLeapCount = 3;
                        this.getSelf().m_146926_(this.getLookAtEntityPitch((Entity)this.getSelf(), (Entity)attackTarget));
                        float yrot = this.getLookAtEntityYaw((Entity)this.getSelf(), (Entity)attackTarget);
                        this.getSelf().m_146922_(yrot);
                        this.getSelf().m_146922_(yrot);
                        this.getSelf().m_5616_(yrot);
                        this.bigLeap(this.getSelf(), 20.0f, 1.0f);
                        ((StandUser)this.getSelf()).roundabout$setLeapTicks(((StandUser)this.getSelf()).roundabout$getMaxLeapTicks());
                        ((StandUser)this.getSelf()).roundabout$tryPower(13, true);
                    }
                }
            }
        }
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        if (this.getActivePower() == 21) {
            StarPlatinumEntity SE;
            this.stopSoundsIfNearby((byte)80, 100.0, false);
            this.stopSoundsIfNearby((byte)81, 100.0, false);
            this.stopSoundsIfNearby((byte)82, 100.0, false);
            StandEntity stand = this.getStandEntity(this.self);
            if (Objects.nonNull((Object)stand) && stand instanceof StarPlatinumEntity && (double)(SE = (StarPlatinumEntity)stand).getFingerLength() > 1.01) {
                if (this.getSelf() instanceof Player && this.isPacketPlayer()) {
                    ModPacketHandler.PACKET_ACCESS.floatToServerPacket(1.0f, (byte)2);
                }
                SE.setFingerLength(1.0f);
            }
        }
        return super.tryPower(move, forced);
    }

    @Override
    public List<AbilityIconInstance> drawGUIIcons(GuiGraphics context, float delta, int mouseX, int mouseY, int leftPos, int topPos, byte level, boolean bypas) {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 80, 0, "ability.roundabout.punch", "instruction.roundabout.press_attack", StandIcons.STAR_PLATINUM_PUNCH, 0, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 99, 0, "ability.roundabout.guard", "instruction.roundabout.hold_block", StandIcons.STAR_PLATINUM_GUARD, 0, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 118, 0, "ability.roundabout.final_punch", "instruction.roundabout.hold_attack_crouch", StandIcons.STAR_PLATINUM_FINAL_PUNCH, 0, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 80, 0, "ability.roundabout.barrage", "instruction.roundabout.barrage", StandIcons.STAR_PLATINUM_BARRAGE, 0, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 99, 0, "ability.roundabout.kick_barrage", "instruction.roundabout.kick_barrage", StandIcons.STAR_PLATINUM_KICK_BARRAGE, 0, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 118, 0, "ability.roundabout.forward_barrage", "instruction.roundabout.forward_barrage", StandIcons.STAR_PLATINUM_TRAVEL_BARRAGE, 1, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 58, topPos + 80, this.getFingerLevel(), "ability.roundabout.star_finger", "instruction.roundabout.press_skill", StandIcons.STAR_PLATINUM_FINGER, 1, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 58, topPos + 99, this.getImpaleLevel(), "ability.roundabout.impale", "instruction.roundabout.press_skill_crouch", StandIcons.STAR_PLATINUM_IMPALE, 1, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 58, topPos + 118, 0, "ability.roundabout.scope", "instruction.roundabout.press_skill_block", StandIcons.STAR_PLATINUM_SCOPE, 1, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 77, topPos + 80, 0, "ability.roundabout.block_grab", "instruction.roundabout.press_skill", StandIcons.STAR_PLATINUM_GRAB_BLOCK, 2, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 77, topPos + 99, 0, "ability.roundabout.item_grab", "instruction.roundabout.press_skill_crouch", StandIcons.STAR_PLATINUM_GRAB_ITEM, 2, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 77, topPos + 118, 0, "ability.roundabout.mob_grab", "instruction.roundabout.press_skill_near_mob", StandIcons.STAR_PLATINUM_GRAB_MOB, 2, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 96, topPos + 80, 0, "ability.roundabout.phase_grab", "instruction.roundabout.press_skill_block", StandIcons.STAR_PLATINUM_PHASE_GRAB, 2, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 96, topPos + 99, 0, "ability.roundabout.dodge", "instruction.roundabout.press_skill", StandIcons.DODGE, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 96, topPos + 118, 0, "ability.roundabout.fall_brace", "instruction.roundabout.press_skill_falling", StandIcons.STAR_PLATINUM_FALL_CATCH, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 115, topPos + 80, 0, "ability.roundabout.vault", "instruction.roundabout.press_skill_air", StandIcons.STAR_PLATINUM_LEDGE_GRAB, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 115, topPos + 99, this.getLeapLevel(), "ability.roundabout.stand_leap", "instruction.roundabout.press_skill_crouch", StandIcons.STAND_LEAP_STAR_PLATINUM, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 115, topPos + 118, this.getLeapLevel(), "ability.roundabout.stand_leap_rebound", "instruction.roundabout.press_skill_rebound", StandIcons.STAND_LEAP_REBOUND_STAR_PLATINUM, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 134, topPos + 80, this.getInhaleLevel(), "ability.roundabout.inhale", "instruction.roundabout.press_skill_block", StandIcons.STAR_PLATINUM_INHALE, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 134, topPos + 99, 6, "ability.roundabout.time_stop", "instruction.roundabout.press_skill", StandIcons.STAR_PLATINUM_TIME_STOP, 4, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 134, topPos + 118, 6, "ability.roundabout.time_stop_impulse", "instruction.roundabout.press_skill_crouch", StandIcons.STAR_PLATINUM_TIME_STOP_IMPULSE, 4, level, bypas));
        return $$1;
    }

    public int getFingerLevel() {
        return 2;
    }

    public int getInhaleLevel() {
        return 4;
    }

    @Override
    public void renderIcons(GuiGraphics context, int x, int y) {
        boolean rendered1 = false;
        if (this.canScope()) {
            rendered1 = true;
            if (this.scopeLevel == 1) {
                this.setSkillIcon(context, x, y, 1, StandIcons.STAR_PLATINUM_SCOPE_1, (byte)8);
            } else if (this.scopeLevel == 2) {
                this.setSkillIcon(context, x, y, 1, StandIcons.STAR_PLATINUM_SCOPE_2, (byte)8);
            } else if (this.scopeLevel == 3) {
                this.setSkillIcon(context, x, y, 1, StandIcons.STAR_PLATINUM_SCOPE_3, (byte)8);
            } else {
                this.setSkillIcon(context, x, y, 1, StandIcons.STAR_PLATINUM_SCOPE, (byte)8);
            }
        } else if (this.isBarrageAttacking() || this.getActivePower() == 42) {
            this.setSkillIcon(context, x, y, 1, StandIcons.STAR_PLATINUM_TRAVEL_BARRAGE, (byte)-1);
        } else if (this.isHoldingSneak()) {
            if (this.canExecuteMoveWithLevel(this.getImpaleLevel())) {
                this.setSkillIcon(context, x, y, 1, StandIcons.STAR_PLATINUM_IMPALE, (byte)4);
            } else {
                this.setSkillIcon(context, x, y, 1, StandIcons.LOCKED, (byte)-1, true);
            }
        } else if (this.canExecuteMoveWithLevel(this.getFingerLevel())) {
            this.setSkillIcon(context, x, y, 1, StandIcons.STAR_PLATINUM_FINGER, (byte)0);
        } else {
            this.setSkillIcon(context, x, y, 1, StandIcons.LOCKED, (byte)-1, true);
        }
        if (this.isHoldingSneak()) {
            if (this.isGuarding()) {
                this.setSkillIcon(context, x, y, 2, StandIcons.STAR_PLATINUM_PHASE_GRAB, (byte)1);
            } else {
                this.setSkillIcon(context, x, y, 2, StandIcons.STAR_PLATINUM_GRAB_ITEM, (byte)1);
            }
            if (this.isGuarding()) {
                if (this.canExecuteMoveWithLevel(this.getInhaleLevel())) {
                    this.setSkillIcon(context, x, y, 3, StandIcons.STAR_PLATINUM_INHALE, (byte)0);
                } else {
                    this.setSkillIcon(context, x, y, 3, StandIcons.LOCKED, (byte)-1, true);
                }
            } else {
                boolean done = false;
                if (((StandUser)this.getSelf()).roundabout$getLeapTicks() > -1) {
                    if (!this.getSelf().m_20096_() && this.canStandRebound()) {
                        done = true;
                        if (this.canExecuteMoveWithLevel(this.getLeapLevel())) {
                            this.setSkillIcon(context, x, y, 3, StandIcons.STAND_LEAP_REBOUND_STAR_PLATINUM, (byte)6);
                        } else {
                            this.setSkillIcon(context, x, y, 3, StandIcons.LOCKED, (byte)-1, true);
                        }
                    }
                } else if (!this.getSelf().m_20096_()) {
                    if (this.canVault()) {
                        done = true;
                        this.setSkillIcon(context, x, y, 3, StandIcons.STAR_PLATINUM_LEDGE_GRAB, (byte)6);
                    } else if (this.getSelf().f_19789_ > 3.0f) {
                        done = true;
                        this.setSkillIcon(context, x, y, 3, StandIcons.STAR_PLATINUM_FALL_CATCH, (byte)8);
                    }
                }
                if (!done) {
                    if (this.canExecuteMoveWithLevel(this.getLeapLevel())) {
                        boolean jojoveinLikeKeys;
                        boolean bl = jojoveinLikeKeys = ClientNetworking.getAppropriateConfig().cooldownsInTicks.standJumpAndDashShareCooldown == false;
                        if (jojoveinLikeKeys) {
                            this.setSkillIcon(context, x, y, 3, StandIcons.STAND_LEAP_STAR_PLATINUM, (byte)2);
                        } else {
                            this.setSkillIcon(context, x, y, 3, StandIcons.STAND_LEAP_STAR_PLATINUM, (byte)6);
                        }
                    } else {
                        this.setSkillIcon(context, x, y, 3, StandIcons.LOCKED, (byte)-1, true);
                    }
                }
            }
        } else {
            if (this.isGuarding()) {
                this.setSkillIcon(context, x, y, 2, StandIcons.STAR_PLATINUM_PHASE_GRAB, (byte)1);
            } else {
                Entity targetEntity = MainUtil.getTargetEntity(this.getSelf(), 2.1f);
                if (targetEntity != null && this.canGrab(targetEntity)) {
                    this.setSkillIcon(context, x, y, 2, StandIcons.STAR_PLATINUM_GRAB_MOB, (byte)1);
                } else {
                    this.setSkillIcon(context, x, y, 2, StandIcons.STAR_PLATINUM_GRAB_BLOCK, (byte)1);
                }
            }
            if (this.isGuarding()) {
                if (this.canExecuteMoveWithLevel(this.getInhaleLevel())) {
                    this.setSkillIcon(context, x, y, 3, StandIcons.STAR_PLATINUM_INHALE, (byte)0);
                } else {
                    this.setSkillIcon(context, x, y, 3, StandIcons.LOCKED, (byte)-1, true);
                }
            } else if (((StandUser)this.getSelf()).roundabout$getLeapTicks() > -1 && !this.getSelf().m_20096_() && this.canStandRebound()) {
                this.setSkillIcon(context, x, y, 3, StandIcons.STAND_LEAP_REBOUND_STAR_PLATINUM, (byte)6);
            } else if (((StandUser)this.getSelf()).roundabout$getLeapTicks() <= -1 && !this.getSelf().m_20096_() && this.canVault()) {
                this.setSkillIcon(context, x, y, 3, StandIcons.STAR_PLATINUM_LEDGE_GRAB, (byte)6);
            } else if (!this.getSelf().m_20096_() && this.getSelf().f_19789_ > 3.0f) {
                this.setSkillIcon(context, x, y, 3, StandIcons.STAR_PLATINUM_FALL_CATCH, (byte)8);
            } else {
                this.setSkillIcon(context, x, y, 3, StandIcons.DODGE, (byte)6);
            }
        }
        boolean exTS = this.canExecuteMoveWithLevel(this.getTSLevel());
        boolean exImpTS = this.canExecuteMoveWithLevel(this.getImpulseTSLevel());
        if (((TimeStop)this.getSelf().m_9236_()).isTimeStoppingEntity(this.getSelf())) {
            this.setSkillIcon(context, x, y, 4, StandIcons.STAR_PLATINUM_TIME_STOP_RESUME, (byte)-1);
        } else if (this.isHoldingSneak()) {
            if (exImpTS) {
                this.setSkillIcon(context, x, y, 4, StandIcons.STAR_PLATINUM_TIME_STOP_IMPULSE, (byte)3);
            } else {
                this.setSkillIcon(context, x, y, 4, StandIcons.LOCKED, (byte)-1, true);
            }
        } else if (exTS) {
            this.setSkillIcon(context, x, y, 4, StandIcons.STAR_PLATINUM_TIME_STOP, (byte)3);
        } else {
            this.setSkillIcon(context, x, y, 4, StandIcons.LOCKED, (byte)-1, true);
        }
    }

    @Override
    public boolean clickRelease() {
        if (this.getActivePower() == 25) {
            return true;
        }
        return super.clickRelease();
    }

    @Override
    public boolean buttonInputGuard(boolean keyIsDown, Options options) {
        if (this.suspendGuard) {
            return false;
        }
        if (this.activePower == 25) {
            return false;
        }
        return super.buttonInputGuard(keyIsDown, options);
    }

    @Override
    public boolean setPowerOther(int move, int lastMove) {
        if (move == 21) {
            return this.starFinger();
        }
        if (move == 25) {
            return this.inhale();
        }
        return super.setPowerOther(move, lastMove);
    }

    public boolean inhale() {
        StandEntity stand = this.getStandEntity(this.self);
        if (Objects.nonNull((Object)stand) && !((TimeStop)this.getSelf().m_9236_()).inTimeStopRange((Entity)this.self)) {
            this.setAttackTimeDuring(0);
            this.setActivePower((byte)25);
            this.animateStand((byte)15);
            this.poseStand((byte)9);
            return true;
        }
        return false;
    }

    public boolean starFinger() {
        StandEntity stand = this.getStandEntity(this.self);
        if (Objects.nonNull((Object)stand)) {
            Player PE;
            LivingEntity livingEntity;
            this.setAttackTimeDuring(0);
            this.setActivePower((byte)21);
            this.ticksForFinger = 100;
            double rand = Math.random();
            byte skn = ((StandUser)this.getSelf()).roundabout$getStandSkin();
            if (skn == 3 || (livingEntity = this.getSelf()) instanceof Player && ((IPlayerEntity)(PE = (Player)livingEntity)).roundabout$getMaskInventory().m_8020_(1).m_150930_(ModItems.BLANK_MASK)) {
                this.playStandUserOnlySoundsIfNearby((byte)82, 32.0, false, false);
            } else if (rand > 0.5) {
                this.playStandUserOnlySoundsIfNearby((byte)80, 32.0, false, true);
            } else {
                this.playStandUserOnlySoundsIfNearby((byte)81, 32.0, false, true);
            }
            this.animateStand((byte)82);
            this.poseStand((byte)8);
            return true;
        }
        return false;
    }

    @Override
    public int getMaxTSTime() {
        return ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksStarPlatinum;
    }

    @Override
    public void setChargeTicksMult() {
        this.setChargedTSTicks(this.getChargedTSTicks() * (1 + (ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksStarPlatinum - 100) / 100));
    }

    @Override
    public int setCurrentMaxTSTime(int chargedTSSeconds) {
        if (chargedTSSeconds >= ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksStarPlatinum) {
            this.maxChargeTSTime = ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksStarPlatinum;
            this.setChargedTSTicks(this.maxChargeTSTime);
        } else {
            this.maxChargeTSTime = chargedTSSeconds == Math.min(ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksStarPlatinum, ClientNetworking.getAppropriateConfig().timeStopSettings.impulseTimeStopLength) ? Math.min(ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksStarPlatinum, ClientNetworking.getAppropriateConfig().timeStopSettings.impulseTimeStopLength) : ClientNetworking.getAppropriateConfig().timeStopSettings.maxTimeStopTicksStarPlatinum;
        }
        return 0;
    }

    @Override
    public boolean canSnipe() {
        return true;
    }

    @Override
    public float getShotAccuracy() {
        return 0.0f;
    }

    @Override
    public float getBundleAccuracy() {
        return 0.3f;
    }

    @Override
    public float getThrowAngle2() {
        return 0.0f;
    }

    @Override
    public float getThrowAngle3() {
        return 0.0f;
    }

    @Override
    public float getThrowAngle() {
        return 0.0f;
    }

    @Override
    public byte chooseBarrageSound() {
        double rand = Math.random();
        byte skn = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (skn == 3) {
            return 22;
        }
        if (rand > 0.5) {
            return 20;
        }
        return 21;
    }

    @Override
    public void animateFinalAttack() {
        if (((StandUser)this.getSelf()).roundabout$getStandSkin() == 5) {
            this.animateStand((byte)50);
        } else {
            super.animateFinalAttack();
        }
    }

    @Override
    public void animateFinalAttackHit() {
        if (((StandUser)this.getSelf()).roundabout$getStandSkin() == 5) {
            this.animateStand((byte)51);
        } else {
            super.animateFinalAttackHit();
        }
    }

    @Override
    public byte getTimeResumeNoise() {
        byte bt = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (bt == 3) {
            return 61;
        }
        return 60;
    }

    @Override
    public byte getTimeStopShortNoise() {
        byte bt = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (bt == 3) {
            return 48;
        }
        return 41;
    }

    @Override
    public SoundEvent getSoundFromByte(byte soundChoice) {
        if (soundChoice == 20) {
            return ModSounds.STAR_PLATINUM_ORA_RUSH_2_SOUND_EVENT;
        }
        if (soundChoice == 18) {
            if (((StandUser)this.getSelf()).roundabout$getStandSkin() == 3) {
                return ModSounds.OVA_SUMMON_EVENT;
            }
            if (((StandUser)this.getSelf()).roundabout$getStandSkin() == 10) {
                return ModSounds.DSP_SUMMON_EVENT;
            }
            return ModSounds.STAR_SUMMON_SOUND_EVENT;
        }
        if (soundChoice == 120) {
            return ModSounds.STAR_PLATINUM_ORA_SOUND_EVENT;
        }
        if (soundChoice == 121) {
            return ModSounds.STAR_PLATINUM_ORA_2_SOUND_EVENT;
        }
        if (soundChoice == 122) {
            return ModSounds.STAR_PLATINUM_ORA_3_SOUND_EVENT;
        }
        if (soundChoice == 123) {
            return ModSounds.OVA_PLATINUM_ORA_3_EVENT;
        }
        if (soundChoice == 124) {
            return ModSounds.OVA_PLATINUM_ORA_2_EVENT;
        }
        if (soundChoice == 125) {
            return ModSounds.OVA_PLATINUM_ORA_EVENT;
        }
        if (soundChoice == 2) {
            return ModSounds.STAND_BARRAGE_WINDUP_EVENT;
        }
        if (soundChoice == 21) {
            return ModSounds.STAR_PLATINUM_ORA_RUSH_SOUND_EVENT;
        }
        if (soundChoice == 22) {
            return ModSounds.OVA_PLATINUM_BARRAGE_EVENT;
        }
        if (soundChoice == 80) {
            return ModSounds.STAR_FINGER_EVENT;
        }
        if (soundChoice == 81) {
            return ModSounds.STAR_FINGER_2_EVENT;
        }
        if (soundChoice == 82) {
            return ModSounds.STAR_FINGER_SILENT_EVENT;
        }
        if (soundChoice == 105) {
            return ModSounds.IMPALE_CHARGE_EVENT;
        }
        if (soundChoice == 30) {
            return ModSounds.TIME_STOP_CHARGE_THE_WORLD_EVENT;
        }
        if (soundChoice == 31) {
            if (((StandUser)this.getSelf()).roundabout$getStandSkin() == 3) {
                return ModSounds.OVA_PLATINUM_ORA_4_EVENT;
            }
            return ModSounds.STAR_PLATINUM_TIMESTOP_SOUND_EVENT;
        }
        if (soundChoice == 32) {
            if (((StandUser)this.getSelf()).roundabout$getStandSkin() == 3) {
                return ModSounds.OVA_PLATINUM_ORA_4_EVENT;
            }
            return ModSounds.STAR_PLATINUM_TIMESTOP_2_SOUND_EVENT;
        }
        if (soundChoice == 33) {
            return ModSounds.TIME_STOP_VOICE_THE_WORLD3_EVENT;
        }
        if (soundChoice == 51) {
            return ModSounds.TIME_STOP_RESUME_THE_WORLD_EVENT;
        }
        if (soundChoice == 50) {
            return ModSounds.TIME_STOP_RESUME_THE_WORLD2_EVENT;
        }
        if (soundChoice == 53) {
            return ModSounds.TIME_STOP_TICKING_EVENT;
        }
        return super.getSoundFromByte(soundChoice);
    }

    @Override
    public float getImpalePunchStrength(Entity entity) {
        if (this.getReducedDamage(entity)) {
            return this.levelupDamageMod((float)(3.0 * ((double)ClientNetworking.getAppropriateConfig().damageMultipliers.starPlatinumAttacksOnPlayers.intValue() * 0.01)));
        }
        return this.levelupDamageMod((float)(17.0 * ((double)ClientNetworking.getAppropriateConfig().damageMultipliers.starPlatinumAttacksOnMobs.intValue() * 0.01)));
    }
}

