/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.networking.s2c;

import java.util.function.Supplier;
import net.hydra.jojomod.Roundabout;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class ForgeDynamicWorldSync {
    private final String serial;
    private final int player;

    public ForgeDynamicWorldSync(String serial, String player) {
        this.serial = serial;
        this.player = Integer.getInteger(player);
    }

    public ForgeDynamicWorldSync(FriendlyByteBuf buf) {
        this.serial = buf.m_130277_();
        this.player = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.serial);
        buf.writeInt(this.player);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ResourceKey LEVEL_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)Roundabout.location(this.serial));
            Roundabout.LOGGER.info("Got packet for dimension {}", (Object)LEVEL_KEY.toString());
            LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
            if (localPlayer == null) {
                Roundabout.LOGGER.error("Errored while synchronizing Dynamic World: \"player\" is null!");
                return;
            }
            localPlayer.f_108617_.m_105151_().add(LEVEL_KEY);
        });
        return true;
    }
}

