/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.networking.s2c;

import java.util.function.Supplier;
import net.hydra.jojomod.client.ClientUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ForgePlaySoundPacket {
    private final int startPlayerID;
    private final byte soundQue;

    public ForgePlaySoundPacket(int cancelPlayerID, byte soundQue) {
        this.startPlayerID = cancelPlayerID;
        this.soundQue = soundQue;
    }

    public ForgePlaySoundPacket(FriendlyByteBuf buf) {
        this.startPlayerID = buf.readInt();
        this.soundQue = buf.readByte();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.startPlayerID);
        buf.writeByte((int)this.soundQue);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> ClientUtil.handlePlaySoundPacket(this.startPlayerID, this.soundQue));
        return true;
    }
}

