/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.stand;

import com.mojang.blaze3d.vertex.PoseStack;
import net.hydra.jojomod.entity.client.ModEntityRendererClient;
import net.hydra.jojomod.entity.stand.D4CEntity;
import net.hydra.jojomod.entity.stand.D4CModel;
import net.hydra.jojomod.entity.stand.StandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class D4CRenderer
extends StandRenderer<D4CEntity> {
    private static final ResourceLocation MANGA_SKIN = new ResourceLocation("roundabout", "textures/stand/d4c.png");
    private static final ResourceLocation WONDER_FESTIVAL = new ResourceLocation("roundabout", "textures/stand/d4c_wf.png");

    public D4CRenderer(EntityRendererProvider.Context context) {
        super(context, new D4CModel(context.m_174023_(ModEntityRendererClient.D4C_LAYER)), 0.0f);
    }

    @Override
    public ResourceLocation getTextureLocation(D4CEntity entity) {
        switch (entity.getSkin()) {
            case 0: {
                return MANGA_SKIN;
            }
            case 1: {
                return WONDER_FESTIVAL;
            }
        }
        return null;
    }

    @Override
    public void render(D4CEntity mobEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        float factor = 0.5f + mobEntity.getSizePercent() / 2.0f;
        if (mobEntity.m_6162_()) {
            matrixStack.m_85841_(0.5f * factor, 0.5f * factor, 0.5f * factor);
        } else {
            matrixStack.m_85841_(0.87f * factor, 0.87f * factor, 0.87f * factor);
        }
        super.render(mobEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    @Nullable
    protected RenderType getRenderType(D4CEntity entity, boolean showBody, boolean translucent, boolean showOutline) {
        return super.m_7225_((LivingEntity)entity, showBody, true, showOutline);
    }
}

