/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.stand;

import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.networking.ModPacketHandler;
import net.hydra.jojomod.util.ConfigManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class JusticeEntity
extends StandEntity {
    protected static final EntityDataAccessor<Integer> JUSTICE_SZ = SynchedEntityData.m_135353_(JusticeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Byte> JUSTICE_TEAM = SynchedEntityData.m_135353_(JusticeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final byte PART_3_SKIN = 1;
    public static final byte MANGA_SKIN = 2;
    public static final byte SKELETON_SKIN = 3;
    public static final byte OVA_SKIN = 4;
    public static final byte BOGGED = 5;
    public static final byte STRAY_SKIN = 6;
    public static final byte FLAMED = 7;
    public static final byte TAROT = 8;
    public static final byte WITHER = 9;
    public static final byte TWILIGHT = 10;
    public static final byte PIRATE = 11;
    public static final byte BLUE_FLAMED = 12;
    public static final byte DARK_MIRAGE = 13;
    public static final byte JOJONIUM = 14;
    public final AnimationState idleAnimation = new AnimationState();
    public final AnimationState idleAnimation2 = new AnimationState();
    public final AnimationState cackleAnimation = new AnimationState();
    public int tsReleaseTime = 0;
    public int cackleTime = 0;
    public boolean stuck = false;

    public JusticeEntity(EntityType<? extends Mob> entityType, Level world) {
        super(entityType, world);
    }

    public final void setJusticeTeam(Byte team) {
        this.f_19804_.m_135381_(JUSTICE_TEAM, (Object)team);
    }

    public byte getJusticeTeam() {
        return (Byte)this.f_19804_.m_135370_(JUSTICE_TEAM);
    }

    public final void setJusticeSize(Integer size) {
        this.f_19804_.m_135381_(JUSTICE_SZ, (Object)size);
    }

    public int getJusticeSize() {
        return (Integer)this.f_19804_.m_135370_(JUSTICE_SZ);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(JUSTICE_SZ, (Object)100);
        this.f_19804_.m_135372_(JUSTICE_TEAM, (Object)0);
    }

    public boolean m_20068_() {
        return true;
    }

    @Override
    public boolean lockPos() {
        return false;
    }

    @Override
    public Component getSkinName(byte skinId) {
        return JusticeEntity.getSkinNameT(skinId);
    }

    public static Component getSkinNameT(byte skinId) {
        if (skinId == 1) {
            return Component.m_237115_((String)"skins.roundabout.justice.base");
        }
        if (skinId == 2) {
            return Component.m_237115_((String)"skins.roundabout.justice.manga");
        }
        if (skinId == 3) {
            return Component.m_237115_((String)"skins.roundabout.justice.skeleton");
        }
        if (skinId == 4) {
            return Component.m_237115_((String)"skins.roundabout.justice.ova");
        }
        if (skinId == 6) {
            return Component.m_237115_((String)"skins.roundabout.justice.stray");
        }
        if (skinId == 5) {
            return Component.m_237115_((String)"skins.roundabout.justice.bogged");
        }
        if (skinId == 8) {
            return Component.m_237115_((String)"skins.roundabout.justice.tarot");
        }
        if (skinId == 9) {
            return Component.m_237115_((String)"skins.roundabout.justice.wither");
        }
        if (skinId == 7) {
            return Component.m_237115_((String)"skins.roundabout.justice.flamed");
        }
        if (skinId == 12) {
            return Component.m_237115_((String)"skins.roundabout.justice.flamed_blue");
        }
        if (skinId == 10) {
            return Component.m_237115_((String)"skins.roundabout.justice.twilight");
        }
        if (skinId == 11) {
            return Component.m_237115_((String)"skins.roundabout.justice.pirate");
        }
        if (skinId == 13) {
            return Component.m_237115_((String)"skins.roundabout.justice.dark_mirage");
        }
        if (skinId == 14) {
            return Component.m_237115_((String)"skins.roundabout.justice.jojonium");
        }
        return Component.m_237115_((String)"skins.roundabout.justice.base");
    }

    @Override
    public void setupAnimationStates() {
        if (this.getUser() != null) {
            if (this.getAnimation() == 0 && this.getIdleAnimation() == 1) {
                this.idleAnimation2.m_216982_(this.f_19797_);
            } else {
                this.idleAnimation2.m_216973_();
            }
            if (this.getAnimation() == 0 && this.getIdleAnimation() == 0) {
                this.idleAnimation.m_216982_(this.f_19797_);
            } else {
                this.idleAnimation.m_216973_();
            }
            if (this.getAnimation() == 2) {
                this.cackleAnimation.m_216982_(this.f_19797_);
            } else {
                this.cackleAnimation.m_216973_();
            }
        }
    }

    @Override
    public boolean m_20147_() {
        return true;
    }

    @Override
    public Component getPosName(byte posID) {
        if (posID == 1) {
            return Component.m_237115_((String)"idle.roundabout.battle_justice");
        }
        return Component.m_237115_((String)"idle.roundabout.passive_justice");
    }

    public void inhaleTick() {
        int perc = this.getJusticeSize() - 2;
        if (perc < 0) {
            if (this.getUser() != null) {
                StandUser user = (StandUser)this.getUser();
                user.roundabout$setMaxSealedTicks(400);
                user.roundabout$setSealedTicks(400);
                user.roundabout$setDrowning(true);
                if (!this.m_9236_().m_5776_() && user instanceof Player) {
                    Player PE = (Player)user;
                    ModPacketHandler.PACKET_ACCESS.sendIntPacket((ServerPlayer)PE, (byte)7, 400);
                }
                user.roundabout$setActive(false);
            }
            this.m_146870_();
        }
        this.setJusticeSize(perc);
    }

    @Override
    public void playerSetProperties(Player PE) {
        this.setJusticeTeam(((IPlayerEntity)PE).roundabout$getTeamColor());
        super.playerSetProperties(PE);
    }

    @Override
    public void m_8119_() {
        block10: {
            block9: {
                int perc;
                if (this.m_9236_().f_46443_) break block9;
                if (this.cackleTime > 0) {
                    --this.cackleTime;
                    if (this.cackleTime <= 0) {
                        this.setAnimation((byte)0);
                    }
                }
                if ((perc = this.getJusticeSize() + 1) <= 100) {
                    this.setJusticeSize(perc);
                }
                if (this.getAnimation() != 31) break block10;
                ++this.tsReleaseTime;
                if (this.tsReleaseTime <= 24) break block10;
                this.setAnimation((byte)0);
                this.tsReleaseTime = 0;
                break block10;
            }
            if (!(!ConfigManager.getClientConfig().particleSettings.renderJusticeParticlesInFirstPerson.booleanValue() && ClientUtil.checkIfStandIsYoursAndFirstPerson(this) || !ConfigManager.getClientConfig().particleSettings.renderJusticeParticlesWhilePilotingInFirstPerson.booleanValue() && ClientUtil.checkIfStandIsYoursAndFirstPersonandPiloting(this) || this.getSkin() == 13)) {
                int i;
                if (this.getSkin() == 7) {
                    for (i = 0; i < ConfigManager.getClientConfig().particleSettings.justiceSkinFlameParticlesPerTick; ++i) {
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(1.1), this.m_20187_(), this.m_20262_(1.1), 0.0, 0.1, 0.0);
                    }
                }
                if (this.getSkin() == 12) {
                    for (i = 0; i < ConfigManager.getClientConfig().particleSettings.justiceSkinFlameParticlesPerTick; ++i) {
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, this.m_20208_(1.1), this.m_20187_(), this.m_20262_(1.1), 0.0, 0.1, 0.0);
                    }
                }
                for (i = 0; i < ConfigManager.getClientConfig().particleSettings.justiceFogParticlesPerTick; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ModParticles.FOG_CHAIN, this.m_20208_(1.1), this.m_20187_(), this.m_20262_(1.1), 0.0, 0.1, 0.0);
                }
            }
        }
        super.m_8119_();
    }

    public boolean m_6109_() {
        StandEntity ent;
        LivingEntity user = this.getUser();
        if (user != null && (ent = this.getUserData(user).roundabout$getStandPowers().getPilotingStand()) != null && ent.m_7306_((Entity)this)) {
            boolean bl;
            if (user instanceof Player) {
                Player $$0 = (Player)user;
                bl = $$0.m_7578_();
            } else {
                bl = this.m_21515_();
            }
            return bl;
        }
        return super.m_6109_();
    }

    protected float m_274460_() {
        return 0.1f;
    }

    public void m_6478_(MoverType $$0, Vec3 $$1) {
        StandEntity entX;
        Player PE;
        StandUser user;
        StandPowers powers;
        LivingEntity ent;
        if (this.f_19794_ && (ent = this.getUser()) != null && ent instanceof Player && (powers = (user = (StandUser)(PE = (Player)ent)).roundabout$getStandPowers()).isPiloting() && (entX = powers.getPilotingStand()) != null && entX.m_7306_((Entity)this)) {
            BlockPos veci = BlockPos.m_274446_((Position)new Vec3(this.m_20185_() + $$1.f_82479_, this.m_20186_() + (double)this.m_20192_() + $$1.f_82480_, this.m_20189_() + $$1.f_82481_));
            BlockPos veci2 = BlockPos.m_274446_((Position)new Vec3(this.m_20185_() + $$1.f_82479_ * 2.0, this.m_20186_() + (double)this.m_20192_() + $$1.f_82480_ * 2.0, this.m_20189_() + $$1.f_82481_ * 2.0));
            BlockPos veci3 = BlockPos.m_274446_((Position)new Vec3(this.m_20185_() + $$1.f_82479_ * 3.0, this.m_20186_() + (double)this.m_20192_() + $$1.f_82480_ * 2.0, this.m_20189_() + $$1.f_82481_ * 3.0));
            BlockState bl = this.m_9236_().m_8055_(veci);
            BlockState bl2 = this.m_9236_().m_8055_(veci2);
            BlockState bl3 = this.m_9236_().m_8055_(veci3);
            if (this.getFullBlock(bl, veci) || this.getFullBlock(bl2, veci2) || this.getFullBlock(bl3, veci3)) {
                this.m_20256_(Vec3.f_82478_);
                if (!this.stuck) {
                    this.stuck = true;
                    this.m_6034_(this.m_20185_() - $$1.f_82479_, this.m_20186_(), this.m_20189_() - $$1.f_82481_);
                }
                return;
            }
        }
        super.m_6478_($$0, $$1);
    }

    public boolean getFullBlock(BlockState bs, BlockPos bp) {
        Block blk = bs.m_60734_();
        return bs.m_280296_() && (blk.m_180643_(bs, (BlockGetter)this.m_9236_(), bp) || blk instanceof SlabBlock || blk instanceof StairBlock);
    }

    public void m_7023_(Vec3 vec3) {
        if (this.m_6109_()) {
            double d = 0.08;
            boolean bl = this.m_20184_().f_82480_ <= 0.0;
            boolean bl2 = bl;
            if (bl && this.m_21023_(MobEffects.f_19591_)) {
                d = 0.01;
            }
            FluidState fluidState = this.m_9236_().m_6425_(this.m_20183_());
            BlockPos blockPos = this.m_20099_();
            float p = this.m_9236_().m_8055_(blockPos).m_60734_().m_49958_();
            float f = this.m_20096_() ? p * 0.91f : 0.91f;
            Vec3 vec37 = this.m_21074_(vec3, p);
            double q = vec37.f_82480_;
            if (this.m_21023_(MobEffects.f_19620_)) {
                q += (0.05 * (double)(this.m_21124_(MobEffects.f_19620_).m_19564_() + 1) - vec37.f_82480_) * 0.2;
            } else if (!this.m_9236_().f_46443_ || this.m_9236_().m_46805_(blockPos)) {
                if (!this.m_20068_()) {
                    q -= d;
                }
            } else {
                double d2 = q = this.m_20186_() > (double)this.m_9236_().m_141937_() ? -0.1 : 0.0;
            }
            if (this.m_147223_()) {
                this.m_20334_(vec37.f_82479_, q, vec37.f_82481_);
            } else {
                this.m_20334_(vec37.f_82479_ * (double)f, q * (double)0.98f, vec37.f_82481_ * (double)f);
            }
            LivingEntity livingEntity = this.getUser();
            if (livingEntity instanceof Player) {
                Player PE = (Player)livingEntity;
                if (this.m_9236_().m_5776_()) {
                    ModPacketHandler.PACKET_ACCESS.updatePilot((LivingEntity)this);
                }
            }
        }
        this.m_267651_(this instanceof FlyingAnimal);
    }

    @Override
    public Vec3 getIdleOffset(LivingEntity standUser) {
        if (this.getSkin() != 13) {
            int vis = this.getFadeOut();
            double r = (double)vis / 8.0 * (double)(standUser.m_20205_() / 2.0f + 2.0f * this.getDistanceOut());
            if (r < 0.5) {
                r = 0.5;
            }
            double yawfix = standUser.m_146908_();
            if ((yawfix += (double)(this.getAnchorPlace() + 125)) > 360.0) {
                yawfix -= 360.0;
            } else if (yawfix < 0.0) {
                yawfix += 360.0;
            }
            double ang = (yawfix - 180.0) * Math.PI;
            double mcap = 0.3;
            Vec3 xyz = standUser.m_20184_();
            double yy = xyz.m_7098_() * 0.3;
            if (yy > mcap) {
                yy = mcap;
            } else if (yy < -mcap) {
                yy = -mcap;
            }
            if (this.m_6069_() || this.m_20143_() || this.m_21255_()) {
                yy += 1.0;
            }
            double x1 = standUser.m_20185_() - -1.0 * (r * Math.sin(ang / 180.0));
            double y1 = standUser.m_20186_() + (double)this.getIdleYOffset() - yy + 0.6;
            double z1 = standUser.m_20189_() - r * Math.cos(ang / 180.0);
            return new Vec3(x1, y1, z1);
        }
        return super.getIdleOffset(standUser);
    }
}

