/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.event.powers.stand;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.hydra.jojomod.access.ICreeper;
import net.hydra.jojomod.access.IPermaCasting;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.access.IRaider;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.client.KeyboardPilotInput;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.FogCloneEntity;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.corpses.FallenCreeper;
import net.hydra.jojomod.entity.corpses.FallenMob;
import net.hydra.jojomod.entity.stand.JusticeEntity;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.AbilityIconInstance;
import net.hydra.jojomod.event.ModEffects;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.PermanentZoneCastInstance;
import net.hydra.jojomod.event.index.ShapeShifts;
import net.hydra.jojomod.event.index.Tactics;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.event.powers.TimeStop;
import net.hydra.jojomod.event.powers.stand.presets.DashPreset;
import net.hydra.jojomod.item.MaxStandDiscItem;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.networking.ModPacketHandler;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.hoglin.HoglinBase;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class PowersJustice
extends DashPreset {
    private List<LivingEntity> fogControlledEntities = new ArrayList<LivingEntity>();
    public int lastHeldAge = 0;
    public boolean hold1 = false;
    public BlockPos bpos;
    public boolean hold3 = false;
    public boolean hold2 = false;
    public boolean hold4 = false;
    private float flyingSpeed = 0.075f;
    private float walkingSpeed = 0.05f;
    public FogCloneEntity clone1;
    public FogCloneEntity clone2;

    public PowersJustice(LivingEntity self) {
        super(self);
    }

    @Override
    public StandPowers generateStandPowers(LivingEntity entity) {
        return new PowersJustice(entity);
    }

    @Override
    public boolean canSummonStand() {
        return !(this.getSelf() instanceof Creeper) && !(this.getSelf() instanceof Raider);
    }

    @Override
    public boolean interceptAttack() {
        return false;
    }

    @Override
    public boolean interceptGuard() {
        return false;
    }

    @Override
    public boolean isMiningStand() {
        return false;
    }

    public void cycleThroughJusticeEntities() {
        ArrayList<LivingEntity> fogControlledEntities2;
        if (this.fogControlledEntities == null) {
            this.fogControlledEntities = new ArrayList<LivingEntity>();
        }
        if (!(fogControlledEntities2 = new ArrayList<LivingEntity>(this.fogControlledEntities){}).isEmpty()) {
            for (LivingEntity value : fogControlledEntities2) {
                if (value.m_213877_() || !value.m_6084_()) {
                    this.removeJusticeEntities(value);
                    continue;
                }
                if (value instanceof FallenMob) {
                    FallenMob fm = (FallenMob)value;
                    if (fm.controller != null && fm.controller.m_7306_((Entity)this.getSelf())) continue;
                    this.removeJusticeEntities(value);
                    continue;
                }
                this.removeJusticeEntities(value);
            }
        }
    }

    public void cycleThroughJusticeEntities2() {
        ArrayList<LivingEntity> fogControlledEntities2;
        if (this.fogControlledEntities == null) {
            this.fogControlledEntities = new ArrayList<LivingEntity>();
        }
        if (!(fogControlledEntities2 = new ArrayList<LivingEntity>(this.fogControlledEntities){}).isEmpty()) {
            for (LivingEntity value : fogControlledEntities2) {
                LivingEntity livingEntity;
                if (value.m_213877_() || !value.m_6084_() || !(value instanceof FallenMob)) continue;
                FallenMob fm = (FallenMob)value;
                if (fm.controller == null || !fm.controller.m_7306_((Entity)this.getSelf()) || !((livingEntity = this.getSelf()) instanceof Player)) continue;
                Player PE = (Player)livingEntity;
                byte bt = ((IPlayerEntity)PE).roundabout$getTeamColor();
                if (fm.getJusticeTeamColor() == bt) continue;
                fm.setJusticeTeamColor(bt);
            }
        }
    }

    public List<LivingEntity> queryJusticeEntities() {
        if (this.fogControlledEntities == null) {
            this.fogControlledEntities = new ArrayList<LivingEntity>();
        }
        return this.fogControlledEntities;
    }

    public List<LivingEntity> addJusticeEntities(LivingEntity LE) {
        if (this.fogControlledEntities == null) {
            this.fogControlledEntities = new ArrayList<LivingEntity>();
        }
        this.fogControlledEntities.add(LE);
        return this.fogControlledEntities;
    }

    public List<LivingEntity> removeJusticeEntities(LivingEntity LE) {
        if (this.fogControlledEntities == null) {
            this.fogControlledEntities = new ArrayList<LivingEntity>();
        }
        this.fogControlledEntities.remove(LE);
        return this.fogControlledEntities;
    }

    public List<LivingEntity> clearJusticeEntities() {
        this.fogControlledEntities = new ArrayList<LivingEntity>();
        return this.fogControlledEntities;
    }

    @Override
    public void onStandSwitch() {
        Player PE;
        IPlayerEntity ipe;
        byte morph;
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player && !ShapeShifts.getShiftFromByte(morph = (ipe = (IPlayerEntity)(PE = (Player)livingEntity)).roundabout$getShapeShift()).equals((Object)ShapeShifts.PLAYER)) {
            ipe.roundabout$shapeShift();
            ipe.roundabout$setShapeShift(ShapeShifts.PLAYER.id);
        }
    }

    @Override
    public void pilotInputAttack() {
        Entity TE;
        StandEntity ent = this.getPilotingStand();
        if (ent != null && (TE = MainUtil.getTargetEntity((LivingEntity)ent, 100.0f, 10)) != null && (!(TE instanceof StandEntity) || TE.m_6097_())) {
            Vec3 vec3d = ent.m_20299_(0.0f);
            Vec3 vec3d2 = ent.m_20252_(0.0f);
            Vec3 vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * 100.0, vec3d2.f_82480_ * 100.0, vec3d2.f_82481_ * 100.0);
            BlockHitResult blockHit = ent.m_9236_().m_45547_(new ClipContext(vec3d, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)ent));
            if (!(blockHit.m_82448_((Entity)ent) - 1.0 < ent.m_20280_(TE))) {
                FallenMob fm;
                if (TE instanceof FallenMob && (fm = (FallenMob)TE).getController() == this.self.m_19879_()) {
                    this.self.m_5496_(ModSounds.JUSTICE_SELECT_EVENT, 200.0f, 1.0f);
                    ModPacketHandler.PACKET_ACCESS.intToServerPacket(fm.m_19879_(), (byte)4);
                } else if (!ClientUtil.isPlayer(TE)) {
                    this.self.m_5496_(ModSounds.JUSTICE_SELECT_ATTACK_EVENT, 200.0f, 1.0f);
                    ModPacketHandler.PACKET_ACCESS.intToServerPacket(TE.m_19879_(), (byte)4);
                }
            }
        }
    }

    @Override
    public void handleStandAttack(Player player, Entity target) {
        FallenMob fm;
        if (target instanceof FallenMob && (fm = (FallenMob)target).getController() == this.self.m_19879_()) {
            if (fm.getSelected()) {
                fm.setSelected(false);
            } else {
                fm.setSelected(true);
            }
        } else {
            ArrayList<LivingEntity> fogControlledEntities2;
            if (this.fogControlledEntities == null) {
                this.fogControlledEntities = new ArrayList<LivingEntity>();
            }
            if (!(fogControlledEntities2 = new ArrayList<LivingEntity>(this.fogControlledEntities){}).isEmpty()) {
                for (LivingEntity value : fogControlledEntities2) {
                    if (value.m_213877_() || !value.m_6084_() || !(value instanceof FallenMob)) continue;
                    FallenMob fm2 = (FallenMob)value;
                    if (!(target instanceof LivingEntity)) continue;
                    LivingEntity LE = (LivingEntity)target;
                    if (fm2.controller == null || !fm2.controller.m_7306_((Entity)this.getSelf()) || !fm2.getSelected()) continue;
                    fm2.corpseTarget = LE;
                    if (LE instanceof Player) {
                        Player pl = (Player)LE;
                        fm2.m_6598_(pl);
                    }
                    fm2.manualTarget = LE;
                    fm2.m_6703_(LE);
                    fm2.m_6710_(LE);
                    fm2.setSelected(false);
                }
            }
        }
    }

    @Override
    public void handleStandAttack2(Player player, Entity target) {
        FallenCreeper fm;
        if (target instanceof FallenCreeper && (fm = (FallenCreeper)target).getController() == this.self.m_19879_()) {
            fm.ignite();
        }
    }

    public LivingEntity rollCorpse() {
        double rand;
        LivingEntity corpse = null;
        corpse = this.getSelf() instanceof Skeleton ? (LivingEntity)ModEntities.FALLEN_SKELETON.m_20615_(this.getSelf().m_9236_()) : (this.getSelf() instanceof Creeper ? (LivingEntity)ModEntities.FALLEN_CREEPER.m_20615_(this.getSelf().m_9236_()) : (this.getSelf() instanceof Zombie ? (LivingEntity)ModEntities.FALLEN_ZOMBIE.m_20615_(this.getSelf().m_9236_()) : (this.getSelf() instanceof Spider ? (LivingEntity)ModEntities.FALLEN_SPIDER.m_20615_(this.getSelf().m_9236_()) : (this.getSelf() instanceof Vindicator ? (LivingEntity)ModEntities.FALLEN_VILLAGER.m_20615_(this.getSelf().m_9236_()) : ((rand = Math.random()) < 0.2 ? (LivingEntity)ModEntities.FALLEN_VILLAGER.m_20615_(this.getSelf().m_9236_()) : (rand < 0.4 ? (LivingEntity)ModEntities.FALLEN_SPIDER.m_20615_(this.getSelf().m_9236_()) : (rand < 0.6 ? (LivingEntity)ModEntities.FALLEN_ZOMBIE.m_20615_(this.getSelf().m_9236_()) : (rand < 0.8 ? (this.self instanceof Villager || this.self instanceof IronGolem ? (LivingEntity)ModEntities.FALLEN_VILLAGER.m_20615_(this.getSelf().m_9236_()) : (LivingEntity)ModEntities.FALLEN_SKELETON.m_20615_(this.getSelf().m_9236_())) : (this.self instanceof Villager || this.self instanceof IronGolem || this.self instanceof SnowGolem || this.self instanceof TamableAnimal ? (LivingEntity)ModEntities.FALLEN_SPIDER.m_20615_(this.getSelf().m_9236_()) : (LivingEntity)ModEntities.FALLEN_CREEPER.m_20615_(this.getSelf().m_9236_()))))))))));
        return corpse;
    }

    public void initializeCorpse(LivingEntity corpse, LivingEntity attackTarget) {
        if (corpse instanceof FallenMob) {
            FallenMob fm = (FallenMob)corpse;
            fm.m_20248_(this.getSelf().m_20185_(), this.getSelf().m_20186_(), this.getSelf().m_20189_());
            fm.diesWhenUncontrolled = true;
            this.getSelf().m_9236_().m_7967_((Entity)fm);
            this.addJusticeEntities((LivingEntity)fm);
            fm.setActivated(true);
            fm.setMovementTactic(Tactics.FOLLOW.id);
            fm.m_6710_(attackTarget);
            fm.setController((Entity)this.getSelf());
        }
    }

    @Override
    public void tickMobAI(LivingEntity attackTarget) {
        block18: {
            Raider rd;
            Creeper cr;
            Object ic;
            Object ir2;
            block17: {
                block21: {
                    Raider rd2;
                    IRaider ir2;
                    Object ic2;
                    Creeper cr2;
                    LivingEntity livingEntity;
                    block19: {
                        block20: {
                            boolean check;
                            boolean bl = check = attackTarget != null && attackTarget.m_6084_();
                            if (!check) break block17;
                            if (this.isDazed(this.getSelf())) break block18;
                            if (this.isCastingFog()) break block19;
                            livingEntity = this.getSelf();
                            if (!(livingEntity instanceof Creeper)) break block20;
                            cr2 = (Creeper)livingEntity;
                            if (this.getSelf().m_21233_() <= this.getSelf().m_21223_()) break block19;
                        }
                        this.castFog();
                    }
                    if ((livingEntity = this.getSelf()) instanceof Creeper) {
                        cr2 = (Creeper)livingEntity;
                        ic2 = (ICreeper)cr2;
                        if (this.getSelf().m_21233_() <= this.getSelf().m_21223_()) {
                            if (!ic2.roundabout$isTransformed()) {
                                ic2.roundabout$setTransformed(true);
                                this.particleSpew();
                            }
                        } else if (ic2.roundabout$isTransformed()) {
                            ic2.roundabout$setTransformed(false);
                            this.particleSpew();
                        }
                    }
                    if ((ic2 = this.getSelf()) instanceof Raider && !(ir2 = (IRaider)(rd2 = (Raider)ic2)).roundabout$isTransformed()) {
                        ir2.roundabout$setTransformed(true);
                        this.particleSpew();
                    }
                    if (this.fogControlledEntities == null) {
                        this.fogControlledEntities = new ArrayList<LivingEntity>();
                    }
                    if (this.fogControlledEntities.size() >= ClientNetworking.getAppropriateConfig().justiceStandUserMobMinionCount || this.getSelf().f_19797_ % 20 != 0) break block18;
                    ir2 = this.getSelf();
                    if (!(ir2 instanceof Creeper)) break block21;
                    cr2 = (Creeper)ir2;
                    if (this.getSelf().m_21233_() <= this.getSelf().m_21223_()) break block18;
                }
                this.initializeCorpse(this.rollCorpse(), attackTarget);
                break block18;
            }
            if (this.isCastingFog()) {
                this.castFog();
            }
            if ((ir2 = this.getSelf()) instanceof Creeper && (ic = (ICreeper)(cr = (Creeper)ir2)).roundabout$isTransformed()) {
                ic.roundabout$setTransformed(false);
                this.particleSpew();
            }
            if ((ic = this.getSelf()) instanceof Raider && (ir2 = (IRaider)(rd = (Raider)ic)).roundabout$isTransformed()) {
                ir2.roundabout$setTransformed(false);
                this.particleSpew();
            }
        }
    }

    public void particleSpew() {
        this.self.m_9236_().m_6269_(null, (Entity)this.self, ModSounds.FOG_MORPH_EVENT, SoundSource.PLAYERS, 0.36f, 1.0f);
        ((ServerLevel)this.self.m_9236_()).m_8767_((ParticleOptions)ModParticles.FOG_CHAIN, this.self.m_20185_(), this.self.m_20186_() + (double)this.self.m_20205_() * 0.6, this.self.m_20189_(), 14, 0.4, 0.2, 0.4, 0.35);
    }

    @Override
    public boolean pilotInputInteract() {
        StandEntity ent;
        if (Math.abs(this.lastHeldAge - this.getSelf().f_19797_) >= 6 && (ent = this.getPilotingStand()) != null) {
            BlockHitResult blockHit;
            Vec3 vec3d3;
            Vec3 vec3d2;
            Vec3 vec3d;
            Entity TE = MainUtil.getTargetEntity((LivingEntity)ent, 100.0f, 10);
            if (TE != null && (!(TE instanceof StandEntity) || TE.m_6097_())) {
                FallenCreeper fm;
                vec3d = ent.m_20299_(0.0f);
                vec3d2 = ent.m_20252_(0.0f);
                vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * 100.0, vec3d2.f_82480_ * 100.0, vec3d2.f_82481_ * 100.0);
                blockHit = ent.m_9236_().m_45547_(new ClipContext(vec3d, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)ent));
                if (!(blockHit.m_82448_((Entity)ent) - 1.0 < ent.m_20280_(TE)) && TE instanceof FallenCreeper && (fm = (FallenCreeper)TE).getController() == this.self.m_19879_()) {
                    this.self.m_5496_(ModSounds.JUSTICE_SELECT_ATTACK_EVENT, 200.0f, 1.0f);
                    ModPacketHandler.PACKET_ACCESS.intToServerPacket(TE.m_19879_(), (byte)5);
                    return true;
                }
            }
            vec3d = ent.m_20299_(0.0f);
            vec3d2 = ent.m_20252_(0.0f);
            vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * 100.0, vec3d2.f_82480_ * 100.0, vec3d2.f_82481_ * 100.0);
            blockHit = ent.m_9236_().m_45547_(new ClipContext(vec3d, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)ent));
            BlockPos bpos = blockHit.m_82425_().m_121945_(blockHit.m_82434_());
            ModPacketHandler.PACKET_ACCESS.StandPosPowerPacket((byte)31, bpos);
            this.self.m_5496_(ModSounds.JUSTICE_SELECT_EVENT, 200.0f, 1.2f);
            this.self.m_9236_().m_7106_((ParticleOptions)ModParticles.POINTER, (double)bpos.m_123341_() + 0.5, (double)bpos.m_123342_() + 0.5, (double)bpos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        }
        this.lastHeldAge = this.getSelf().f_19797_;
        return false;
    }

    @Override
    public void tickPower() {
        IPlayerEntity ipe;
        Player PE;
        LivingEntity getPilotInt2;
        LivingEntity livingEntity;
        if (!this.self.m_9236_().m_5776_() && ((StandUser)this.self).roundabout$getSealedTicks() >= 0 && this.isCastingFog()) {
            this.castFog();
        }
        if ((livingEntity = this.self) instanceof Player) {
            Player PL = (Player)livingEntity;
            this.cycleThroughJusticeEntities2();
            int getPilotInt2 = ((IPlayerEntity)PL).roundabout$getControlling();
            Entity getPilotEntity = this.self.m_9236_().m_6815_(getPilotInt2);
            if (this.self.m_9236_().m_5776_() && this.isPacketPlayer()) {
                if (getPilotEntity instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)getPilotEntity;
                    if (le.m_213877_() || !le.m_6084_() || MainUtil.cheapDistanceTo2(le.m_20185_(), le.m_20189_(), PL.m_20185_(), PL.m_20189_()) > (double)this.getMaxPilotRange()) {
                        IPlayerEntity ipe2 = (IPlayerEntity)PL;
                        ipe2.roundabout$setIsControlling(0);
                        ModPacketHandler.PACKET_ACCESS.intToServerPacket(0, (byte)8);
                        ClientUtil.setCameraEntity(null);
                    } else {
                        StandEntity SE = this.getStandEntity(this.self);
                        if (SE != null && le.m_7306_((Entity)SE)) {
                            ClientUtil.setCameraEntity((Entity)le);
                        }
                    }
                } else {
                    ClientUtil.setCameraEntity(null);
                }
            }
        }
        if ((getPilotInt2 = this.self) instanceof Player && (PE = (Player)getPilotInt2).m_5833_() && (ipe = (IPlayerEntity)PE).roundabout$getShapeShift() != ShapeShifts.PLAYER.id) {
            ipe.roundabout$shapeShift();
            ipe.roundabout$setShapeShift(ShapeShifts.PLAYER.id);
        }
        super.tickPower();
    }

    @Override
    protected Byte getSummonSound() {
        return (byte)18;
    }

    @Override
    public StandEntity getNewStandEntity() {
        if (((StandUser)this.getSelf()).roundabout$getStandSkin() == 11) {
            return (StandEntity)ModEntities.JUSTICE_PIRATE.m_20615_(this.getSelf().m_9236_());
        }
        if (((StandUser)this.getSelf()).roundabout$getStandSkin() == 13) {
            return (StandEntity)ModEntities.DARK_MIRAGE.m_20615_(this.getSelf().m_9236_());
        }
        return (StandEntity)ModEntities.JUSTICE.m_20615_(this.getSelf().m_9236_());
    }

    @Override
    public byte getMaxLevel() {
        return 5;
    }

    @Override
    public int getExpForLevelUp(int currentLevel) {
        int amt = currentLevel == 1 ? 50 : (currentLevel == 2 ? 150 : 100 + (currentLevel - 1) * 100);
        amt = (int)((double)amt * ((double)ClientNetworking.getAppropriateConfig().standExperienceNeededForLevelupMultiplier.intValue() * 0.01));
        return amt;
    }

    @Override
    public void levelUp() {
        LivingEntity livingEntity;
        if (!this.getSelf().m_9236_().m_5776_() && (livingEntity = this.getSelf()) instanceof Player) {
            Player PE = (Player)livingEntity;
            IPlayerEntity ipe = (IPlayerEntity)PE;
            byte level = ipe.roundabout$getStandLevel();
            if (level == 5) {
                ((ServerPlayer)this.self).m_5661_((Component)Component.m_237115_((String)"leveling.roundabout.levelup.max.both").m_130940_(ChatFormatting.AQUA), true);
            } else if (level == 2 || level == 3 || level == 4) {
                ((ServerPlayer)this.self).m_5661_((Component)Component.m_237115_((String)"leveling.roundabout.levelup.both").m_130940_(ChatFormatting.AQUA), true);
            }
        }
        super.levelUp();
    }

    @Override
    public SoundEvent getSoundFromByte(byte soundChoice) {
        byte bt = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (soundChoice == 18) {
            if (bt == 7 || bt == 12) {
                return ModSounds.SUMMON_JUSTICE_2_EVENT;
            }
            return ModSounds.SUMMON_JUSTICE_EVENT;
        }
        return super.getSoundFromByte(soundChoice);
    }

    @Override
    public void playSummonEffects(boolean forced) {
        if (!forced) {
            Level lv = this.getSelf().m_9236_();
            LivingEntity livingEntity = this.getSelf();
            if (livingEntity instanceof Player) {
                IPlayerEntity ipe;
                StandUser user;
                ItemStack stack;
                Player PE = (Player)livingEntity;
                if (lv.m_204166_(this.getSelf().m_20097_()).m_203565_(Biomes.f_48175_) && !(stack = (user = (StandUser)PE).roundabout$getStandDisc()).m_41619_() && stack.m_150930_(ModItems.STAND_DISC_JUSTICE) && !(ipe = (IPlayerEntity)PE).roundabout$getUnlockedBonusSkin() && !lv.m_5776_()) {
                    ipe.roundabout$setUnlockedBonusSkin(true);
                    lv.m_6263_(null, PE.m_20185_(), PE.m_20186_(), PE.m_20189_(), ModSounds.UNLOCK_SKIN_EVENT, PE.m_5720_(), 2.0f, 1.0f);
                    ((ServerLevel)lv).m_8767_((ParticleOptions)ParticleTypes.f_123810_, PE.m_20185_(), PE.m_20186_() + (double)PE.m_20192_(), PE.m_20189_(), 10, 0.5, 0.5, 0.5, 0.2);
                    user.roundabout$setStandSkin((byte)7);
                    ((ServerPlayer)ipe).m_5661_((Component)Component.m_237115_((String)"unlock_skin.roundabout.justice.bad_bone"), true);
                }
            }
        }
    }

    @Override
    public int getDisplayPowerInventoryScale() {
        byte skn = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (skn == 13) {
            return super.getDisplayPowerInventoryScale();
        }
        return 14;
    }

    @Override
    public int getDisplayPowerInventoryYOffset() {
        byte skn = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (skn == 13) {
            return super.getDisplayPowerInventoryYOffset();
        }
        return -7;
    }

    @Override
    public void renderIcons(GuiGraphics context, int x, int y) {
        if (this.isPiloting()) {
            this.setSkillIcon(context, x, y, 1, StandIcons.JUSTICE_CAST_FOG, (byte)0);
            this.setSkillIcon(context, x, y, 2, StandIcons.JUSTICE_FOG_CHAIN, (byte)1);
            this.setSkillIcon(context, x, y, 3, StandIcons.JUSTICE_TACTICS, (byte)-1);
            this.setSkillIcon(context, x, y, 4, StandIcons.JUSTICE_PILOT_EXIT, (byte)3);
        } else {
            if (this.isHoldingSneak()) {
                if (this.canExecuteMoveWithLevel(this.getVillagerMorphLevel()) || this.canExecuteMoveWithLevel(this.getZombieMorphLevel()) || this.canExecuteMoveWithLevel(this.getSkeletonMorphLevel())) {
                    this.setSkillIcon(context, x, y, 1, StandIcons.JUSTICE_DISGUISE, (byte)2);
                } else {
                    this.setSkillIcon(context, x, y, 1, StandIcons.LOCKED, (byte)-1, true);
                }
            } else {
                this.setSkillIcon(context, x, y, 1, StandIcons.JUSTICE_CAST_FOG, (byte)-1);
            }
            if (this.isHoldingSneak()) {
                this.setSkillIcon(context, x, y, 2, StandIcons.JUSTICE_FOG_BLOCKS, (byte)5);
            } else {
                this.setSkillIcon(context, x, y, 2, StandIcons.JUSTICE_FOG_CHAIN, (byte)1);
            }
            if (this.isHoldingSneak()) {
                if (this.canExecuteMoveWithLevel(this.getFogCloneLevel())) {
                    this.setSkillIcon(context, x, y, 3, StandIcons.JUSTICE_FOG_CLONES, (byte)2);
                } else {
                    this.setSkillIcon(context, x, y, 3, StandIcons.LOCKED, (byte)-1, true);
                }
            } else {
                this.setSkillIcon(context, x, y, 3, StandIcons.DODGE, (byte)6);
            }
            this.setSkillIcon(context, x, y, 4, StandIcons.JUSTICE_PILOT, (byte)3);
        }
    }

    @Override
    public List<AbilityIconInstance> drawGUIIcons(GuiGraphics context, float delta, int mouseX, int mouseY, int leftPos, int topPos, byte level, boolean bypass) {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 80, 0, "ability.roundabout.fog_sword", "instruction.roundabout.passive", StandIcons.JUSTICE_FOG_SWORD, 0, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 99, 0, "ability.roundabout.cast_fog", "instruction.roundabout.press_skill", StandIcons.JUSTICE_CAST_FOG, 1, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 118, 0, "ability.roundabout.fog_chain", "instruction.roundabout.press_skill", StandIcons.JUSTICE_FOG_CHAIN, 2, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 80, this.getVillagerMorphLevel(), "ability.roundabout.fog_morph_2", "instruction.roundabout.press_skill_crouch", StandIcons.JUSTICE_DISGUISE_2, 1, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 99, this.getZombieMorphLevel(), "ability.roundabout.fog_morph_3", "instruction.roundabout.press_skill_crouch", StandIcons.JUSTICE_DISGUISE_3, 1, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 118, this.getSkeletonMorphLevel(), "ability.roundabout.fog_morph_4", "instruction.roundabout.press_skill_crouch", StandIcons.JUSTICE_DISGUISE_4, 1, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 58, topPos + 80, 0, "ability.roundabout.fog_blocks", "instruction.roundabout.press_skill_crouch", StandIcons.JUSTICE_FOG_BLOCKS, 2, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 58, topPos + 99, 0, "ability.roundabout.dodge", "instruction.roundabout.press_skill", StandIcons.DODGE, 3, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 58, topPos + 118, 0, "ability.roundabout.fog_pilot", "instruction.roundabout.press_skill", StandIcons.JUSTICE_PILOT, 4, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 77, topPos + 80, 0, "ability.roundabout.corpse_army", "instruction.roundabout.passive", StandIcons.JUSTICE_CORPSE_ARMY, 3, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 77, topPos + 99, 0, "ability.roundabout.tactics", "instruction.roundabout.press_skill", StandIcons.JUSTICE_TACTICS, 3, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 77, topPos + 118, this.getFogCloneLevel(), "ability.roundabout.fog_clones", "instruction.roundabout.press_skill_crouch", StandIcons.JUSTICE_FOG_CLONES, 3, level, bypass));
        return $$1;
    }

    @Override
    public float getBonusAttackSpeed() {
        return 1.3f;
    }

    public int getFogCloneLevel() {
        return 5;
    }

    public int getVillagerMorphLevel() {
        return 2;
    }

    public int getZombieMorphLevel() {
        return 3;
    }

    public int getSkeletonMorphLevel() {
        return 4;
    }

    @Override
    public boolean hasMoreThanOneSkin() {
        return true;
    }

    @Override
    public float getBonusPassiveMiningSpeed() {
        return 1.3f;
    }

    @Override
    public List<Byte> getSkinList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)1);
        $$1.add((byte)3);
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            boolean bypass;
            Player PE = (Player)livingEntity;
            byte Level2 = ((IPlayerEntity)PE).roundabout$getStandLevel();
            ItemStack goldDisc = ((StandUser)PE).roundabout$getStandDisc();
            boolean bl = bypass = PE.m_7500_() || !goldDisc.m_41619_() && goldDisc.m_41720_() instanceof MaxStandDiscItem;
            if (Level2 > 1 || bypass) {
                $$1.add((byte)2);
                $$1.add((byte)4);
            }
            if (Level2 > 2 || bypass) {
                $$1.add((byte)6);
                $$1.add((byte)5);
            }
            if (Level2 > 3 || bypass) {
                $$1.add((byte)9);
                $$1.add((byte)10);
                $$1.add((byte)14);
            }
            if (Level2 > 4 || bypass) {
                $$1.add((byte)8);
                $$1.add((byte)11);
                $$1.add((byte)13);
            }
            if (((IPlayerEntity)PE).roundabout$getUnlockedBonusSkin() || bypass) {
                $$1.add((byte)7);
                $$1.add((byte)12);
            }
        }
        return $$1;
    }

    @Override
    public int getMaxPilotRange() {
        return ClientNetworking.getAppropriateConfig().justiceFogAndPilotRange;
    }

    @Override
    public void buttonInput1(boolean keyIsDown, Options options) {
        if (this.getSelf().m_9236_().f_46443_) {
            if (!this.isHoldingSneak() || this.isPiloting()) {
                if (keyIsDown) {
                    if (!this.hold1) {
                        this.hold1 = true;
                        ((StandUser)this.getSelf()).roundabout$tryPower(21, true);
                        ModPacketHandler.PACKET_ACCESS.StandPowerPacket((byte)21);
                    }
                } else {
                    this.hold1 = false;
                }
            } else if (keyIsDown) {
                if (!this.hold1 && !this.onCooldown((byte)2)) {
                    this.hold1 = true;
                    if (this.canExecuteMoveWithLevel(this.getVillagerMorphLevel()) || this.canExecuteMoveWithLevel(this.getZombieMorphLevel()) || this.canExecuteMoveWithLevel(this.getSkeletonMorphLevel())) {
                        ClientUtil.setJusticeScreen();
                    }
                }
            } else {
                this.hold1 = false;
            }
        }
        super.buttonInput1(keyIsDown, options);
    }

    @Override
    public void buttonInputUse(boolean keyIsDown, Options options) {
        if (keyIsDown) {
            // empty if block
        }
    }

    @Override
    public void tickStandRejection(MobEffectInstance effect) {
        if (!this.getSelf().m_9236_().m_5776_()) {
            boolean done = false;
            Vec3 vector = null;
            if (effect.m_19557_() == 13) {
                vector = new Vec3(0.0, this.self.m_20186_() + 10.0 - this.self.m_20186_(), 0.0).m_82541_().m_82490_((double)1.8f);
                done = true;
                this.self.m_20256_(this.self.m_20184_().m_82520_(vector.f_82479_, vector.f_82480_ + (double)0.2f, vector.f_82481_));
            } else if (effect.m_19557_() == 2) {
                vector = new Vec3(0.0, this.self.m_20186_() - 10.0 - this.self.m_20186_(), 0.0).m_82541_().m_82490_((double)1.8f);
                done = true;
                this.self.m_20256_(this.self.m_20184_().m_82520_(vector.f_82479_, vector.f_82480_ + (double)0.2f, vector.f_82481_));
            }
            if (done) {
                this.self.f_19864_ = true;
                this.self.f_19812_ = true;
                double random = Math.random() * 1.2 - 0.6;
                double random2 = Math.random() * 1.2 - 0.6;
                double random3 = Math.random() * 1.2 - 0.6;
                ((ServerLevel)this.self.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.self.m_20185_(), this.self.m_20186_() + (double)this.self.m_20192_(), this.self.m_20189_(), 0, vector.f_82479_ + random, vector.f_82480_ + random2, vector.f_82481_ + random3, 0.15);
                this.self.m_9236_().m_6263_(null, this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_(), ModSounds.INHALE_EVENT, this.self.m_5720_(), 100.0f, 0.5f);
            }
        }
    }

    public void justiceTacticsUse(byte context) {
        if (this.fogControlledEntities == null) {
            this.fogControlledEntities = new ArrayList<LivingEntity>();
        }
        if (context == Tactics.CHANGE_TEAM.id) {
            LivingEntity livingEntity = this.getSelf();
            if (livingEntity instanceof Player) {
                Player PE = (Player)livingEntity;
                byte bt = ((IPlayerEntity)PE).roundabout$getTeamColor();
                if ((bt = (byte)(bt + 1)) > 4) {
                    bt = 0;
                }
                ((IPlayerEntity)PE).roundabout$setTeamColor(bt);
                StandEntity SE = this.getStandEntity(this.self);
                if (SE instanceof JusticeEntity) {
                    JusticeEntity JE = (JusticeEntity)SE;
                    JE.setJusticeTeam(bt);
                }
            }
            return;
        }
        if (context == Tactics.CACKLE.id) {
            StandEntity SE = this.getStandEntity(this.self);
            if (SE instanceof JusticeEntity) {
                JusticeEntity JE = (JusticeEntity)SE;
                JE.setAnimation((byte)2);
                JE.cackleTime = 54;
                this.self.m_9236_().m_6263_(null, JE.m_20185_(), JE.m_20186_(), JE.m_20189_(), ModSounds.CACKLE_EVENT, this.self.m_5720_(), 15.0f, 1.0f);
            }
            return;
        }
        ArrayList<LivingEntity> fogControlledEntities2 = new ArrayList<LivingEntity>(this.fogControlledEntities){};
        if (!fogControlledEntities2.isEmpty()) {
            for (LivingEntity value : fogControlledEntities2) {
                if (value.m_213877_() || !value.m_6084_()) {
                    this.removeJusticeEntities(value);
                    continue;
                }
                if (value instanceof FallenMob) {
                    FallenMob fm = (FallenMob)value;
                    if (fm.controller != null && fm.controller.m_7306_((Entity)this.getSelf())) {
                        if (context == Tactics.SELECT_ALL.id) {
                            if (fm.getSelected()) continue;
                            fm.setSelected(true);
                            continue;
                        }
                        if (context == Tactics.DESELECT_ALL.id) {
                            if (!fm.getSelected()) continue;
                            fm.setSelected(false);
                            continue;
                        }
                        if (context == Tactics.ROAM.id || context == Tactics.FOLLOW.id || context == Tactics.STAY_PUT.id) {
                            if (!fm.getSelected()) continue;
                            fm.setMovementTactic(context);
                            continue;
                        }
                        if (context == Tactics.KILL_ALL.id) {
                            if (!fm.getSelected()) continue;
                            fm.m_6074_();
                            continue;
                        }
                        if (!fm.getSelected()) continue;
                        fm.setTargetTactic(context);
                        if (context == Tactics.PEACEFUL.id) {
                            fm.m_21561_(false);
                            fm.m_6598_(null);
                            fm.manualTarget = null;
                            fm.m_6703_(null);
                            fm.m_6710_(null);
                            continue;
                        }
                        if (context != Tactics.HUNT_TARGET.id || fm.manualTarget == null || fm.manualTarget.m_213877_() || !fm.manualTarget.m_6084_()) continue;
                        LivingEntity livingEntity = fm.manualTarget;
                        if (livingEntity instanceof Player) {
                            Player PE = (Player)livingEntity;
                            fm.m_6598_(PE);
                        }
                        fm.m_6703_(fm.manualTarget);
                        fm.m_6710_(fm.manualTarget);
                        continue;
                    }
                    this.removeJusticeEntities(value);
                    continue;
                }
                this.removeJusticeEntities(value);
            }
        }
    }

    @Override
    public void rollSkin() {
        StandUser user = this.getUserData(this.self);
        if (this.self instanceof Skeleton) {
            user.roundabout$setStandSkin((byte)3);
        } else if (this.self instanceof MushroomCow) {
            user.roundabout$setStandSkin((byte)5);
        } else if (this.self instanceof Stray) {
            user.roundabout$setStandSkin((byte)6);
        } else if (this.self instanceof Spider) {
            user.roundabout$setStandSkin((byte)4);
        } else if (this.self instanceof WitherSkeleton || this.self instanceof WitherBoss) {
            user.roundabout$setStandSkin((byte)9);
        } else if (this.self instanceof Sniffer) {
            user.roundabout$setStandSkin((byte)10);
        } else if (this.self instanceof Camel) {
            user.roundabout$setStandSkin((byte)8);
        } else if (this.self instanceof Drowned || this.self instanceof WaterAnimal || this.self instanceof Guardian) {
            user.roundabout$setStandSkin((byte)11);
        } else if (this.self instanceof Piglin || this.self instanceof ZombifiedPiglin || this.self instanceof HoglinBase || this.self instanceof Blaze) {
            user.roundabout$setStandSkin((byte)7);
        } else if (this.self instanceof Zombie) {
            user.roundabout$setStandSkin((byte)2);
        } else if (this.self instanceof Strider) {
            user.roundabout$setStandSkin((byte)12);
        }
    }

    @Override
    public boolean isPiloting() {
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            Player PE = (Player)livingEntity;
            IPlayerEntity ipe = (IPlayerEntity)PE;
            int zint = ipe.roundabout$getControlling();
            StandEntity sde = ((StandUser)PE).roundabout$getStand();
            if (sde != null && zint == sde.m_19879_()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void buttonInput3(boolean keyIsDown, Options options) {
        if (!this.isPiloting()) {
            if (keyIsDown) {
                if (!this.inputDash) {
                    if (this.isHoldingSneak()) {
                        if (!this.onCooldown((byte)2) && this.getSelf().m_20096_() && this.canExecuteMoveWithLevel(this.getFogCloneLevel())) {
                            Player PE;
                            LivingEntity livingEntity = this.getSelf();
                            if (livingEntity instanceof Player && ((IPlayerEntity)(PE = (Player)livingEntity)).roundabout$getShapeShift() > ShapeShifts.PLAYER.id) {
                                ModPacketHandler.PACKET_ACCESS.byteToServerPacket((byte)0, (byte)6);
                            }
                            this.setCooldown((byte)2, ClientNetworking.getAppropriateConfig().cooldownsInTicks.justiceFogClone);
                            ModPacketHandler.PACKET_ACCESS.StandPowerPacket((byte)25);
                        }
                        this.inputDash = true;
                    } else {
                        super.buttonInput3(keyIsDown, options);
                    }
                }
            } else {
                this.inputDash = false;
            }
        } else if (keyIsDown) {
            if (!this.hold3) {
                this.hold3 = true;
                ClientUtil.setJusticeTacticsScreen();
            }
        } else if (this.hold3) {
            this.hold3 = false;
        }
    }

    @Override
    public void buttonInput2(boolean keyIsDown, Options options) {
        if (this.getSelf().m_9236_().f_46443_) {
            if (!this.isHoldingSneak()) {
                if (keyIsDown) {
                    if (!this.hold2) {
                        IPermaCasting icast;
                        this.hold2 = true;
                        if (!this.onCooldown((byte)1) && (icast = (IPermaCasting)this.getSelf().m_9236_()).roundabout$isPermaCastingEntity(this.getSelf())) {
                            int cdr = ClientNetworking.getAppropriateConfig().cooldownsInTicks.fogChain;
                            this.setCooldown((byte)1, cdr);
                            StandEntity piloting = this.getPilotingStand();
                            if (this.isPiloting() && piloting != null && piloting.m_6084_() && !piloting.m_213877_()) {
                                Vec3 vec3d = piloting.m_20299_(0.0f);
                                Vec3 vec3d2 = piloting.m_20252_(0.0f);
                                Vec3 vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * 100.0, vec3d2.f_82480_ * 100.0, vec3d2.f_82481_ * 100.0);
                                BlockHitResult blockHit = this.self.m_9236_().m_45547_(new ClipContext(vec3d, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)piloting));
                                ((StandUser)this.getSelf()).roundabout$tryPower(23, true);
                                ModPacketHandler.PACKET_ACCESS.StandPosPowerPacket((byte)23, blockHit.m_82425_());
                            } else {
                                Vec3 vec3d = this.self.m_20299_(0.0f);
                                Vec3 vec3d2 = this.self.m_20252_(0.0f);
                                Vec3 vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * 100.0, vec3d2.f_82480_ * 100.0, vec3d2.f_82481_ * 100.0);
                                BlockHitResult blockHit = this.self.m_9236_().m_45547_(new ClipContext(vec3d, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.self));
                                ((StandUser)this.getSelf()).roundabout$tryPower(23, true);
                                ModPacketHandler.PACKET_ACCESS.StandPosPowerPacket((byte)23, blockHit.m_82425_());
                            }
                        }
                    }
                } else {
                    this.hold2 = false;
                }
            } else if (keyIsDown) {
                if (!(this.hold1 || this.isPiloting() || this.onCooldown((byte)4))) {
                    this.hold1 = true;
                    ClientUtil.setJusticeBlockScreen();
                }
            } else {
                this.hold1 = false;
            }
        }
    }

    @Override
    public void buttonInput4(boolean keyIsDown, Options options) {
        if (this.getSelf().m_9236_().f_46443_) {
            if (keyIsDown) {
                if (!this.hold4) {
                    this.hold4 = true;
                    if (this.isPiloting()) {
                        LivingEntity livingEntity = this.self;
                        if (livingEntity instanceof Player) {
                            Player PE = (Player)livingEntity;
                            IPlayerEntity ipe = (IPlayerEntity)PE;
                            ipe.roundabout$setIsControlling(0);
                        }
                        ModPacketHandler.PACKET_ACCESS.intToServerPacket(0, (byte)8);
                    } else {
                        StandEntity entity = this.getStandEntity(this.self);
                        int L = 0;
                        if (entity != null) {
                            L = entity.m_19879_();
                        }
                        ModPacketHandler.PACKET_ACCESS.intToServerPacket(L, (byte)8);
                    }
                }
            } else {
                this.hold4 = false;
            }
        }
    }

    @Override
    public void poseStand(byte r) {
        StandEntity stand = this.getStandEntity(this.self);
        if (Objects.nonNull((Object)stand) && !this.isPiloting()) {
            stand.setOffsetType(r);
        }
    }

    @Override
    public void setPiloting(int ID) {
        LivingEntity livingEntity = this.self;
        if (livingEntity instanceof Player) {
            Player PE = (Player)livingEntity;
            IPlayerEntity ipe = (IPlayerEntity)PE;
            Entity ent = this.self.m_9236_().m_6815_(ID);
            if (ent != null && ent.m_7306_((Entity)this.getPilotingStand())) {
                this.poseStand((byte)3);
                ipe.roundabout$setIsControlling(ID);
            } else {
                ipe.roundabout$setIsControlling(ID);
                this.poseStand((byte)0);
            }
        }
    }

    @Override
    public void pilotStandControls(KeyboardPilotInput kpi, LivingEntity entity) {
        int $$13 = 0;
        if (entity instanceof JusticeEntity) {
            JusticeEntity JE = (JusticeEntity)entity;
            entity.f_20900_ = kpi.f_108566_;
            entity.f_20902_ = kpi.f_108567_;
            Vec3 vec32 = new Vec3((double)(entity.f_20900_ * this.walkingSpeed), 0.0, (double)(entity.f_20902_ * this.walkingSpeed));
            Vec3 delta = entity.m_20184_();
            if (kpi.f_108573_) {
                --$$13;
            }
            if (kpi.f_108572_) {
                ++$$13;
            }
            if ($$13 != 0) {
                entity.m_20334_(delta.f_82479_, (double)((float)$$13 * this.flyingSpeed * 5.0f), delta.f_82481_);
            } else {
                entity.m_20334_(delta.f_82479_, 0.0, delta.f_82481_);
            }
        }
    }

    @Override
    public boolean tryPosPower(int move, boolean forced, BlockPos blockPos) {
        if (move == 23) {
            this.bpos = blockPos;
            return this.tryPower(move, forced);
        }
        if (move == 31) {
            ArrayList<LivingEntity> fogControlledEntities2;
            if (this.fogControlledEntities == null) {
                this.fogControlledEntities = new ArrayList<LivingEntity>();
            }
            if (!(fogControlledEntities2 = new ArrayList<LivingEntity>(this.fogControlledEntities){}).isEmpty()) {
                for (LivingEntity value : fogControlledEntities2) {
                    if (value.m_213877_() || !value.m_6084_()) {
                        this.removeJusticeEntities(value);
                        continue;
                    }
                    if (!(value instanceof FallenMob)) continue;
                    FallenMob fm = (FallenMob)value;
                    if (fm.controller == null || !fm.controller.m_7306_((Entity)this.getSelf()) || !fm.getSelected()) continue;
                    fm.m_21573_().m_26536_(fm.m_21573_().m_7864_(blockPos, 0), 1.0);
                    if (fm.m_5448_() == null) continue;
                    fm.manualTarget = null;
                    fm.m_6703_(null);
                    fm.m_6710_(null);
                }
            }
        }
        return false;
    }

    @Override
    public float getPermaCastRange() {
        return ClientNetworking.getAppropriateConfig().justiceFogAndPilotRange.intValue();
    }

    @Override
    public boolean setPowerOther(int move, int lastMove) {
        if (move == 21) {
            return this.castFog();
        }
        if (move == 25) {
            return this.spawnClones();
        }
        if (move == 23) {
            return this.yankChain();
        }
        return super.setPowerOther(move, lastMove);
    }

    public boolean spawnClones() {
        LivingEntity livingEntity;
        if (!this.getSelf().m_9236_().m_5776_() && (livingEntity = this.getSelf()) instanceof Player) {
            Player PE = (Player)livingEntity;
            FogCloneEntity fclone = (FogCloneEntity)ModEntities.FOG_CLONE.m_20615_(this.getSelf().m_9236_());
            FogCloneEntity fclone2 = (FogCloneEntity)ModEntities.FOG_CLONE.m_20615_(this.getSelf().m_9236_());
            fclone.m_20248_(this.getSelf().m_20185_(), this.getSelf().m_20186_(), this.getSelf().m_20189_());
            fclone2.m_20248_(this.getSelf().m_20185_(), this.getSelf().m_20186_(), this.getSelf().m_20189_());
            fclone.setPlayer(PE);
            fclone2.setPlayer(PE);
            fclone.setTimer(100);
            fclone2.setTimer(101);
            float first = (this.getSelf().m_6080_() - 25.0f) % 360.0f;
            float second = (this.getSelf().m_6080_() + 25.0f) % 360.0f;
            fclone.m_146922_(first);
            fclone2.m_146922_(second);
            fclone.lockedYRot = first;
            fclone2.lockedYRot = second;
            fclone.f_19859_ = first;
            fclone2.f_19859_ = second;
            this.getSelf().m_9236_().m_7967_((Entity)fclone);
            this.getSelf().m_9236_().m_7967_((Entity)fclone2);
            fclone.m_146922_(first);
            fclone2.m_146922_(second);
            fclone.lockedYRot = first;
            fclone2.lockedYRot = second;
            fclone.f_19859_ = first;
            fclone2.f_19859_ = second;
            fclone.m_20256_(fclone.m_20156_().m_82490_(0.3));
            fclone2.m_20256_(fclone2.m_20156_().m_82490_(0.3));
            this.clone1 = fclone;
            this.clone2 = fclone2;
            this.setCooldown((byte)2, ClientNetworking.getAppropriateConfig().cooldownsInTicks.justiceFogClone);
            ((ServerLevel)this.self.m_9236_()).m_8767_((ParticleOptions)ModParticles.FOG_CHAIN, this.self.m_20185_(), this.self.m_20186_() + (double)this.self.m_20192_(), this.self.m_20189_(), 50, 1.0, 1.0, 1.0, 0.1);
            this.self.m_9236_().m_6263_(null, this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_(), ModSounds.FOG_CLONE_EVENT, this.self.m_5720_(), 2.0f, 1.0f);
        }
        return true;
    }

    @Override
    public Component getSkinName(byte skinId) {
        return JusticeEntity.getSkinNameT(skinId);
    }

    @Override
    public boolean onCreateProjectile(Projectile proj) {
        if (this.clone1 != null && this.clone1.m_6084_()) {
            this.clone1.goPoof();
        }
        if (this.clone2 != null && this.clone2.m_6084_()) {
            this.clone2.goPoof();
        }
        return false;
    }

    @Override
    public boolean interceptDamageDealtEvent(DamageSource $$0, float $$1, LivingEntity target) {
        if (this.clone1 != null && this.clone1.m_6084_()) {
            this.clone1.goPoof();
        }
        if (this.clone2 != null && this.clone2.m_6084_()) {
            this.clone2.goPoof();
        }
        return false;
    }

    @Override
    public void gainExpFromStandardMining(BlockState $$1, BlockPos $$2) {
        if (this.hasStandActive(this.getSelf()) && !($$1.m_60734_() instanceof IceBlock) && Math.random() > 0.62) {
            this.addEXP(1);
        }
    }

    @Override
    public boolean interceptSuccessfulDamageDealtEvent(DamageSource $$0, float $$1, LivingEntity target) {
        if (this.hasStandActive(this.getSelf()) || $$0.m_276093_(ModDamageTypes.CORPSE) || $$0.m_276093_(ModDamageTypes.CORPSE_ARROW) || $$0.m_276093_(ModDamageTypes.CORPSE_EXPLOSION)) {
            this.addEXP(1);
        }
        return false;
    }

    @Override
    public boolean interceptDamageEvent(DamageSource $$0, float $$1) {
        if (this.clone1 != null && this.clone1.m_6084_() && ((StandUser)((Object)this.clone1)).roundabout$getStoredDamage() <= 0.0f) {
            if (!((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity((Entity)this.getSelf())) {
                this.clone1.switchPlaces();
                return true;
            }
        } else if (this.clone2 != null && this.clone2.m_6084_() && ((StandUser)((Object)this.clone2)).roundabout$getStoredDamage() <= 0.0f && !((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity((Entity)this.getSelf())) {
            this.clone2.switchPlaces();
            return true;
        }
        return false;
    }

    @Override
    public boolean cancelCollision(Entity et) {
        if (et instanceof FogCloneEntity) {
            FogCloneEntity FC = (FogCloneEntity)et;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAttackIneptVisually(byte activeP, int slot) {
        IPermaCasting icast;
        if (slot == 2 && (!this.isHoldingSneak() || this.isPiloting()) ? !(icast = (IPermaCasting)this.getSelf().m_9236_()).roundabout$isPermaCastingEntity(this.getSelf()) : slot == 3 && this.isHoldingSneak() && !this.isPiloting() && !this.getSelf().m_20096_()) {
            return true;
        }
        return super.isAttackIneptVisually(activeP, slot);
    }

    @Override
    public void tickPermaCast() {
        this.cycleThroughJusticeEntities();
    }

    public void tickJusticeInput() {
    }

    public boolean yankChain() {
        if (!this.getSelf().m_9236_().m_5776_()) {
            IPermaCasting icast = (IPermaCasting)this.getSelf().m_9236_();
            if (icast.roundabout$isPermaCastingEntity(this.getSelf())) {
                List<Entity> entities = DamageHandler.genHitbox(this.self, this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_(), 50.0, 50.0, 50.0);
                boolean success = false;
                for (Entity value : entities) {
                    LivingEntity LE;
                    if (!value.m_20152_() || !value.m_6097_() || value.m_20147_() || !value.m_6084_() || !icast.roundabout$inPermaCastFogRange(value) || this.bpos == null || !(value instanceof LivingEntity) || !(LE = (LivingEntity)value).m_21023_(ModEffects.BLEED) && (!ClientNetworking.getAppropriateConfig().disableBleedingAndBloodSplatters.booleanValue() || !(LE.m_21223_() < LE.m_21233_()))) continue;
                    double random = Math.random() * 1.2 - 0.6;
                    double random2 = Math.random() * 1.2 - 0.6;
                    double random3 = Math.random() * 1.2 - 0.6;
                    Vec3 vector = new Vec3((double)this.bpos.m_123341_() - LE.m_20185_(), (double)(this.bpos.m_123342_() + 2) - LE.m_20186_(), (double)this.bpos.m_123343_() - LE.m_20189_()).m_82541_().m_82490_((double)1.8f);
                    ((ServerLevel)this.self.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123759_, value.m_20185_(), value.m_20186_() + (double)value.m_20192_(), value.m_20189_(), 0, vector.f_82479_ + random, vector.f_82480_ + random2, vector.f_82481_ + random3, 0.15);
                    LE.m_20256_(LE.m_20184_().m_82520_(vector.f_82479_, vector.f_82480_ * 0.55 + (double)0.2f, vector.f_82481_));
                    LE.f_19864_ = true;
                    LE.f_19812_ = true;
                    success = true;
                }
                if (success) {
                    this.addEXP(4);
                    int cdr = ClientNetworking.getAppropriateConfig().cooldownsInTicks.fogChain;
                    this.setCooldown((byte)1, cdr);
                    this.self.m_9236_().m_6263_(null, this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_(), ModSounds.INHALE_EVENT, this.self.m_5720_(), 100.0f, 0.5f);
                    return true;
                }
            }
            ModPacketHandler.PACKET_ACCESS.syncSkillCooldownPacket((ServerPlayer)this.getSelf(), (byte)1, 10);
        }
        return true;
    }

    @Override
    public byte getPermaCastContext() {
        return PermanentZoneCastInstance.FOG_FIELD;
    }

    @Override
    public boolean canSeeThroughFog() {
        return true;
    }

    public boolean castFog() {
        if (!this.getSelf().m_9236_().m_5776_()) {
            IPermaCasting icast = (IPermaCasting)this.getSelf().m_9236_();
            if (!icast.roundabout$isPermaCastingEntity(this.getSelf())) {
                icast.roundabout$addPermaCaster(this.getSelf());
            } else {
                icast.roundabout$removePermaCastingEntity(this.getSelf());
            }
        }
        return true;
    }

    public boolean isCastingFog() {
        IPermaCasting icast = (IPermaCasting)this.getSelf().m_9236_();
        return icast.roundabout$isPermaCastingEntity(this.getSelf());
    }
}

