/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.networking.c2s;

import java.util.function.Supplier;
import net.hydra.jojomod.event.powers.StandUser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class ForgeChargedPowerPacket {
    private final byte power;
    private final int chargedTime;

    public ForgeChargedPowerPacket(byte power, int chargedTime) {
        this.power = power;
        this.chargedTime = chargedTime;
    }

    public ForgeChargedPowerPacket(FriendlyByteBuf buf) {
        this.power = buf.readByte();
        this.chargedTime = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeByte((int)this.power);
        buf.writeInt(this.chargedTime);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                ServerLevel level = (ServerLevel)player.m_9236_();
                ((StandUser)player).roundabout$tryChargedPower(this.power, true, this.chargedTime);
            }
        });
        return true;
    }
}

