/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.networking.s2c;

import java.util.function.Supplier;
import net.hydra.jojomod.client.ClientUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ForgeClashUpdatePacket {
    private final int clashOpID;
    private final float progress;

    public ForgeClashUpdatePacket(int clashOpID, float progress) {
        this.clashOpID = clashOpID;
        this.progress = progress;
    }

    public ForgeClashUpdatePacket(FriendlyByteBuf buf) {
        this.clashOpID = buf.readInt();
        this.progress = buf.readFloat();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.clashOpID);
        buf.writeFloat(this.progress);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> ClientUtil.clashUpdatePacket(this.clashOpID, this.progress));
        return true;
    }
}

