/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.networking.s2c;

import java.util.function.Supplier;
import net.hydra.jojomod.client.ClientUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ForgePowerIntPacket {
    private final byte activePower;
    private final int data;

    public ForgePowerIntPacket(byte activePowers, int data) {
        this.activePower = activePowers;
        this.data = data;
    }

    public ForgePowerIntPacket(FriendlyByteBuf buf) {
        this.activePower = buf.readByte();
        this.data = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeByte((int)this.activePower);
        buf.writeInt(this.data);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> ClientUtil.handlePowerIntPacket(this.activePower, this.data));
        return true;
    }
}

