/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.networking.s2c;

import java.util.function.Supplier;
import net.hydra.jojomod.client.ClientUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ForgeSkillCDSyncPacket {
    private final byte power;
    private final int cooldown;

    public ForgeSkillCDSyncPacket(byte power, int cooldown) {
        this.power = power;
        this.cooldown = cooldown;
    }

    public ForgeSkillCDSyncPacket(FriendlyByteBuf buf) {
        this.power = buf.readByte();
        this.cooldown = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeByte((int)this.power);
        buf.writeInt(this.cooldown);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> ClientUtil.skillCDSyncPacket(this.power, this.cooldown));
        return true;
    }
}

