/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.networking.s2c;

import java.util.function.Supplier;
import net.hydra.jojomod.client.ClientUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ForgeStopSoundPacket {
    private final int cancelPlayerID;
    private final byte soundID;

    public ForgeStopSoundPacket(int cancelPlayerID, byte soundID) {
        this.cancelPlayerID = cancelPlayerID;
        this.soundID = soundID;
    }

    public ForgeStopSoundPacket(FriendlyByteBuf buf) {
        this.cancelPlayerID = buf.readInt();
        this.soundID = buf.readByte();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.cancelPlayerID);
        buf.writeByte((int)this.soundID);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> ClientUtil.handleStopSoundPacket(this.cancelPlayerID, this.soundID));
        return true;
    }
}

