/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.shader;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Optional;
import java.util.stream.Collectors;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.client.shader.GLResource;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_5912;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL32C;

public class RShader
extends GLResource {
    public RShader(class_5912 provider, class_2960 location, int type) throws Exception {
        super(RShader.createShader(provider, location, type));
    }

    private static int createShader(class_5912 provider, class_2960 location, int type) throws Exception {
        if (type <= 0 || type > 2) {
            throw new Exception("Unsupported ShaderType passed to new TSShader");
        }
        int handle = 0;
        try {
            handle = type == 1 ? GlStateManager.glCreateShader((int)35633) : GlStateManager.glCreateShader((int)35632);
        }
        catch (Exception e) {
            Roundabout.LOGGER.error("Exception caught while attempting to create shader \"{}\"", (Object)location.toString());
            return 0;
        }
        if (handle == 0) {
            throw new Exception("Failed to create shader \"" + location.toString() + "\"");
        }
        RenderSystem.assertOnRenderThreadOrInit();
        GL20C.glShaderSource((int)handle, (CharSequence)RShader.readShaderSource(provider, location));
        GlStateManager.glCompileShader((int)handle);
        if (GlStateManager.glGetShaderi((int)handle, (int)35713) != 1) {
            throw new Exception("Failed to compile shader \"" + location.toString() + "\" with error: \"" + GL32C.glGetShaderInfoLog((int)handle) + "\"");
        }
        Roundabout.LOGGER.info("Successfully registered shader \"{}\"", (Object)location.toString());
        return handle;
    }

    @Nullable
    private static String readShaderSource(class_5912 provider, class_2960 identifier) {
        Optional r = provider.method_14486(identifier);
        if (r.isPresent()) {
            String string;
            block9: {
                BufferedReader file = ((class_3298)r.get()).method_43039();
                try {
                    string = file.lines().collect(Collectors.joining("\n"));
                    if (file == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (file != null) {
                            try {
                                file.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
                file.close();
            }
            return string;
        }
        return null;
    }
}

