/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.util;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.item.StandDiscItem;
import net.hydra.jojomod.util.ClientConfig;
import net.hydra.jojomod.util.Config;
import net.hydra.jojomod.util.Networking;
import net.hydra.jojomod.util.annotation.BooleanOption;
import net.hydra.jojomod.util.annotation.FloatOption;
import net.hydra.jojomod.util.annotation.IntOption;
import net.hydra.jojomod.util.annotation.NestedOption;
import net.hydra.jojomod.util.option.ConfigOptionReference;
import net.hydra.jojomod.util.option.Reflection;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public abstract class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    private static Path clientConfigPath;
    private static Path localConfigPath;
    private static Path serverConfigPath;
    private static boolean loaded;

    public static Config getConfig() {
        if (Networking.isDedicated()) {
            return Config.getServerInstance();
        }
        return Config.getLocalInstance();
    }

    public static ClientConfig getClientConfig() {
        return ClientConfig.getLocalInstance();
    }

    public static void loadConfigs(Path client, Path server, Path actualClient) {
        clientConfigPath = actualClient;
        localConfigPath = client;
        serverConfigPath = server;
        ConfigManager.loadClientConfig();
        ConfigManager.loadLocalConfig();
        ConfigManager.loadServerConfig();
        loaded = true;
    }

    public static void loadStandArrowPool() {
        class_2960 identifier;
        class_1792 i;
        String[] split;
        if (ConfigManager.getConfig().standArrowPool != null) {
            ModItems.STAND_ARROW_POOL.clear();
            for (String disc : ConfigManager.getConfig().standArrowPool) {
                split = disc.split(":");
                if (split.length != 2 || (i = (class_1792)class_7923.field_41178.method_10223(identifier = new class_2960(split[0], split[1]))).getClass() != StandDiscItem.class) continue;
                ModItems.STAND_ARROW_POOL.add((StandDiscItem)i);
            }
        }
        if (ConfigManager.getConfig().naturalStandUserMobPool != null) {
            ModItems.STAND_ARROW_POOL_FOR_MOBS.clear();
            for (String disc : ConfigManager.getConfig().naturalStandUserMobPool) {
                split = disc.split(":");
                if (split.length != 2 || (i = (class_1792)class_7923.field_41178.method_10223(identifier = new class_2960(split[0], split[1]))).getClass() != StandDiscItem.class) continue;
                ModItems.STAND_ARROW_POOL_FOR_MOBS.add((StandDiscItem)i);
            }
        }
    }

    private static void loadClientConfig() {
        ClientConfig config = ConfigManager.loadClient();
        ConfigManager.validateFields(config);
        ClientConfig.updateLocal(config);
        ConfigManager.saveClientConfig();
        Roundabout.LOGGER.info("Loaded local config");
    }

    private static void loadLocalConfig() {
        Config config = ConfigManager.loadLocal();
        ConfigManager.validateFields(config);
        Config.updateLocal(config);
        ConfigManager.saveLocalConfig();
        Roundabout.LOGGER.info("Loaded local config");
    }

    private static void loadServerConfig() {
        Config config = ConfigManager.loadServer();
        ConfigManager.validateFields(config);
        Config.updateServer(config);
        ConfigManager.saveServerConfig();
        Roundabout.LOGGER.info("Loaded server config");
    }

    private static void validateFields(Object instance) {
        ConfigManager.validateFloatFields(instance);
        ConfigManager.validateIntFields(instance);
        ConfigManager.validateBooleanFields(instance);
        ConfigManager.validateNestedFields(instance);
    }

    private static void validateFloatFields(Object instance) {
        Reflection.forEachFieldByAnnotation(instance, FloatOption.class, (field, annotation) -> {
            ConfigOptionReference reference = ConfigOptionReference.of(instance, field);
            ConfigManager.setIfNull(reference, Float.valueOf(annotation.value()));
            if (reference.floatValue().floatValue() < annotation.min()) {
                reference.floatValue(Float.valueOf(annotation.min()));
            }
            if (reference.floatValue().floatValue() > annotation.max()) {
                reference.floatValue(Float.valueOf(annotation.max()));
            }
        });
    }

    private static void validateIntFields(Object instance) {
        Reflection.forEachFieldByAnnotation(instance, IntOption.class, (field, annotation) -> {
            ConfigOptionReference reference = ConfigOptionReference.of(instance, field);
            ConfigManager.setIfNull(reference, annotation.value());
            if (reference.intValue() < annotation.min()) {
                reference.intValue(annotation.min());
            }
            if (reference.intValue() > annotation.max()) {
                reference.intValue(annotation.max());
            }
        });
    }

    private static void validateBooleanFields(Object instance) {
        Reflection.forEachFieldByAnnotation(instance, BooleanOption.class, (field, annotation) -> {
            ConfigOptionReference reference = ConfigOptionReference.of(instance, field);
            ConfigManager.setIfNull(reference, annotation.value());
        });
    }

    private static void validateNestedFields(Object instance) {
        Reflection.forEachFieldByAnnotation(instance, NestedOption.class, (field, annotation) -> {
            ConfigOptionReference reference = ConfigOptionReference.of(instance, field);
            ConfigManager.setIfNull(reference, Reflection.newInstance(field.getType()));
            Object nestedOption = Reflection.accessField(field, instance, Object.class);
            ConfigManager.validateFields(nestedOption);
        });
    }

    private static void setIfNull(ConfigOptionReference reference, Object value) {
        if (reference.isValueNull()) {
            reference.setConfigValue(value);
        }
    }

    public static String serializeConfig() {
        return GSON.toJson((Object)Config.getServerInstance());
    }

    public static void deserializeConfig(String serialized) {
        Config.updateServer((Config)GSON.fromJson(serialized, Config.class));
        ConfigManager.saveServerConfig();
    }

    private static ClientConfig loadClient() {
        return ConfigManager.loadClient(ClientConfig.getLocalInstance(), clientConfigPath);
    }

    private static Config loadLocal() {
        return ConfigManager.load(Config.getLocalInstance(), localConfigPath);
    }

    private static Config loadServer() {
        return ConfigManager.load(Config.getServerInstance(), serverConfigPath);
    }

    private static Config load(Config defaultConfig, Path path) {
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.createFile(path, new FileAttribute[0]);
                return defaultConfig;
            }
            try {
                return (Config)GSON.fromJson((Reader)Files.newBufferedReader(path), Config.class);
            }
            catch (JsonSyntaxException e) {
                Roundabout.LOGGER.error("Failed to parse defaultConfig file, using default config");
            }
        }
        catch (IOException e) {
            Roundabout.LOGGER.error("Failed to load config", (Throwable)e);
        }
        return defaultConfig;
    }

    private static ClientConfig loadClient(ClientConfig defaultConfig, Path path) {
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.createFile(path, new FileAttribute[0]);
                return defaultConfig;
            }
            try {
                return (ClientConfig)GSON.fromJson((Reader)Files.newBufferedReader(path), ClientConfig.class);
            }
            catch (JsonSyntaxException e) {
                Roundabout.LOGGER.error("Failed to parse defaultConfig file, using default config");
            }
        }
        catch (IOException e) {
            Roundabout.LOGGER.error("Failed to load config", (Throwable)e);
        }
        return defaultConfig;
    }

    public static boolean loaded() {
        return loaded;
    }

    public static void saveClientConfig() {
        ConfigManager.saveClient(ClientConfig.getLocalInstance(), clientConfigPath);
    }

    public static void saveLocalConfig() {
        ConfigManager.save(Config.getLocalInstance(), localConfigPath);
    }

    public static void saveServerConfig() {
        ConfigManager.save(Config.getServerInstance(), serverConfigPath);
    }

    private static void save(Config config, Path path) {
        try {
            Files.write(path, GSON.toJson((Object)config).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            Roundabout.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    private static void saveClient(ClientConfig config, Path path) {
        try {
            Files.write(path, GSON.toJson((Object)config).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            Roundabout.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    static {
        loaded = false;
    }
}

