/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.world;

import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.networking.ModPacketHandler;
import net.hydra.jojomod.world.DynamicWorldAccessor;
import net.minecraft.class_1937;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2780;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class DynamicWorld {
    private class_3218 level;
    private final String name;
    public static HashMap<String, class_3218> levels = new HashMap();

    public DynamicWorld(MinecraftServer server, String name, @Nullable class_3222 player) {
        this.name = name;
        DynamicWorldAccessor accessor = DynamicWorldAccessor.getFrom(server);
        class_5321 LEVEL_KEY = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)Roundabout.location(name));
        class_2370<class_5363> manager = DynamicWorld.getLevelStemRegistry(server);
        DynamicWorldAccessor managerAccessor = DynamicWorldAccessor.getFrom(manager);
        boolean isFrozen = managerAccessor.roundabout$isFrozen();
        managerAccessor.roundabout$setFrozen(false);
        class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41224, (class_2960)LEVEL_KEY.method_29177());
        if (!manager.method_35842(key)) {
            manager.method_10272(key, (Object)new class_5363(server.method_30002().method_8410().method_40134(), server.method_30002().method_14178().method_12129()), Lifecycle.stable());
        }
        managerAccessor.roundabout$setFrozen(isFrozen);
        this.level = new class_3218(server, accessor.roundabout$getExecutor(), accessor.roundabout$getLevelStorageAccess(), accessor.roundabout$getLevelData(), LEVEL_KEY, accessor.roundabout$getLevelStem(), accessor.roundabout$getProgressListener(), false, accessor.roundabout$getObfuscatedSeed(), new ArrayList(), false, null);
        server.method_30002().method_8621().method_11983((class_2780)new class_2780.class_3976(this.level.method_8621()));
        accessor.roundabout$addWorld((class_5321<class_1937>)LEVEL_KEY, this.level);
        this.level.method_18765(() -> true);
        levels.put(name, this.level);
        for (class_3222 sp : server.method_3760().method_14571()) {
            ModPacketHandler.PACKET_ACCESS.sendNewDynamicWorld(sp, name, this.level, player);
        }
    }

    public class_3218 getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    private static class_2370<class_5363> getLevelStemRegistry(MinecraftServer server) {
        class_5455.class_6890 registryManager = server.method_30611();
        class_2378 temp = registryManager.method_30530(class_7924.field_41224);
        return (class_2370)temp;
    }

    private static String generateRandomStringByWords(int numWords) {
        String[] words = new String[]{"boat", "ship", "airplane", "sword", "car", "train", "bike", "rocket", "submarine", "zeppelin", "spiral-staircase", "desolation-row", "fig-tart", "rhinoceros-beetle", "singularity-point", "giotto", "angel", "hydrangea", "secret-emperor"};
        Random random = new Random();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < numWords; ++i) {
            if (i > 0) {
                result.append("-");
            }
            result.append(words[random.nextInt(words.length)]);
        }
        return result.toString();
    }

    public static DynamicWorld generateD4CWorld(MinecraftServer server) {
        return new DynamicWorld(server, "d4c-" + DynamicWorld.generateRandomStringByWords(7) + "-" + server.method_30002().method_8409().method_39332(0, 999999), null);
    }

    public static DynamicWorld generateD4CWorld(MinecraftServer server, class_3222 player) {
        DynamicWorld world = new DynamicWorld(server, "d4c-" + DynamicWorld.generateRandomStringByWords(7) + "-" + server.method_30002().method_8409().method_39332(0, 999999), player);
        return world;
    }
}

