/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LanternWallBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    protected static final VoxelShape SHAPE;
    private static final VoxelShape SOUTH_SHAPE;
    private static final VoxelShape WEST_SHAPE;
    private static final VoxelShape NORTH_SHAPE;
    private static final VoxelShape EAST_SHAPE;

    public LanternWallBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean m_7898_(BlockState $$0, LevelReader $$1, BlockPos $$2) {
        Direction $$3 = ((Direction)$$0.m_61143_((Property)FACING)).m_122424_();
        BlockPos $$4 = $$2.m_121945_($$3.m_122424_());
        BlockState $$5 = $$1.m_8055_($$4);
        return $$5.m_60783_((BlockGetter)$$1, $$4, $$3);
    }

    public BlockState m_7417_(BlockState $$0, Direction $$1, BlockState $$2, LevelAccessor $$3, BlockPos $$4, BlockPos $$5) {
        return $$1.m_122424_() == ((Direction)$$0.m_61143_((Property)FACING)).m_122424_() && !$$0.m_60710_((LevelReader)$$3, $$4) ? Blocks.f_50016_.m_49966_() : $$0;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        double baseY = 0.7;
        double offsetX = 0.0;
        double offsetZ = 0.0;
        switch (dir) {
            case NORTH: {
                offsetX = 0.5;
                offsetZ = 0.15;
                break;
            }
            case SOUTH: {
                offsetX = 0.5;
                offsetZ = 0.85;
                break;
            }
            case EAST: {
                offsetX = 0.85;
                offsetZ = 0.5;
                break;
            }
            case WEST: {
                offsetX = 0.15;
                offsetZ = 0.5;
            }
        }
        double x = (double)pos.m_123341_() + offsetX;
        double y = (double)pos.m_123342_() + baseY;
        double z = (double)pos.m_123343_() + offsetZ;
        level.m_7106_((ParticleOptions)ParticleTypes.f_175834_, x, y, z, 0.0, 0.0, 0.0);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction clickedFace = context.m_43719_();
        if (clickedFace.m_122434_().m_122479_()) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)clickedFace.m_122424_());
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> NORTH_SHAPE;
        };
    }

    public boolean m_6104_(BlockState p_53972_, BlockState p_53973_, Direction p_53974_) {
        return false;
    }

    public VoxelShape m_7952_(BlockState $$0, BlockGetter $$1, BlockPos $$2) {
        return Shapes.m_83040_();
    }

    private static VoxelShape rotateShape(VoxelShape shape, Direction to) {
        VoxelShape rotated = shape;
        int times = switch (to) {
            case Direction.EAST -> 1;
            case Direction.SOUTH -> 2;
            case Direction.WEST -> 3;
            default -> 0;
        };
        for (int i = 0; i < times; ++i) {
            VoxelShape next = Shapes.m_83040_();
            for (AABB box : rotated.m_83299_()) {
                double minX = box.f_82288_;
                double minY = box.f_82289_;
                double minZ = box.f_82290_;
                double maxX = box.f_82291_;
                double maxY = box.f_82292_;
                double maxZ = box.f_82293_;
                double nMinX = 1.0 - maxZ;
                double nMinZ = minX;
                double nMaxX = 1.0 - minZ;
                double nMaxZ = maxX;
                next = Shapes.m_83110_((VoxelShape)next, (VoxelShape)Block.m_49796_((double)(nMinX * 16.0), (double)(minY * 16.0), (double)(nMinZ * 16.0), (double)(nMaxX * 16.0), (double)(maxY * 16.0), (double)(nMaxZ * 16.0)));
            }
            rotated = next.m_83296_();
        }
        return rotated;
    }

    static {
        SOUTH_SHAPE = SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)7.0, (double)3.0, (double)15.0, (double)9.0, (double)9.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)7.5, (double)4.375, (double)13.01, (double)8.5, (double)9.625, (double)14.01), Block.m_49796_((double)6.45, (double)9.65, (double)12.0, (double)9.45, (double)12.65, (double)15.0)});
        WEST_SHAPE = LanternWallBlock.rotateShape(SHAPE, Direction.EAST);
        NORTH_SHAPE = LanternWallBlock.rotateShape(SHAPE, Direction.SOUTH);
        EAST_SHAPE = LanternWallBlock.rotateShape(SHAPE, Direction.WEST);
    }
}

