/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import net.hydra.jojomod.access.IKeyMapping;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.client.KeyInputRegistry;
import net.hydra.jojomod.client.gui.NoCancelInputScreen;
import net.hydra.jojomod.event.index.PlunderTypes;
import net.hydra.jojomod.event.index.ShapeShifts;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.util.config.ClientConfig;
import net.hydra.jojomod.util.config.ConfigManager;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;

public class PlunderScreen
extends Screen
implements NoCancelInputScreen {
    static final ResourceLocation MOB_SWITCHER_LOCATION = new ResourceLocation("roundabout", "textures/gui/pose_switcher.png");
    private static final int SPRITE_SHEET_WIDTH = 256;
    private static final int SPRITE_SHEET_HEIGHT = 256;
    private static final int SLOT_AREA = 26;
    private static final int SLOT_PADDING = 5;
    private static final int SLOT_AREA_PADDED = 31;
    private static final int HELP_TIPS_OFFSET_Y = 5;
    private static final int ALL_SLOTS_WIDTH = standRerollIcon.VALUES.length * 31 - 5;
    private standRerollIcon currentlyHovered = null;
    private int firstMouseX;
    private int firstMouseY;
    private boolean setFirstMousePos;
    public boolean zHeld;
    public ItemStack arrow = ItemStack.f_41583_;
    private final List<PlunderSlot> slots = Lists.newArrayList();
    boolean caughtSomething = false;

    public PlunderScreen() {
        super(GameNarrator.f_93310_);
    }

    public PlunderScreen(ItemStack arrow) {
        super(GameNarrator.f_93310_);
        this.arrow = arrow;
    }

    private ShapeShifts getDefaultSelected() {
        LocalPlayer pl = Minecraft.m_91087_().f_91074_;
        if (pl != null) {
            return ShapeShifts.getShiftFromByte(((IPlayerEntity)pl).roundabout$getShapeShift());
        }
        return ShapeShifts.PLAYER;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.zHeld = true;
        LocalPlayer pl = Minecraft.m_91087_().f_91074_;
        this.currentlyHovered = standRerollIcon.NONE;
        for (int i = 0; i < standRerollIcon.VALUES.length; ++i) {
            standRerollIcon pIcon = standRerollIcon.VALUES[i];
            this.slots.add(new PlunderSlot(pIcon, this.f_96543_ / 2 + pIcon.xoff - 13, this.f_96544_ / 2 + pIcon.yoff - 44));
        }
    }

    public boolean m_7920_(int $$0, int $$1, int $$2) {
        if (this.f_96541_ != null && !this.roundabout$sameKeyOne(KeyInputRegistry.abilityOneKey)) {
            StandUser SU;
            this.switchToHoveredGameMode();
            this.f_96541_.m_91152_(null);
            if (this.f_96541_.f_91074_ != null && !(SU = (StandUser)this.f_96541_.f_91074_).roundabout$getStandPowers().isBarraging()) {
                this.f_96541_.f_91066_.f_92095_.m_7249_(false);
            }
        }
        return false;
    }

    public boolean m_6348_(double $$0, double $$1, int $$2) {
        if ($$2 == 0) {
            this.switchToHoveredGameMode();
            this.f_96541_.m_91152_(null);
            this.f_96541_.f_91066_.f_92095_.m_7249_(false);
            return false;
        }
        if ($$2 == 1) {
            // empty if block
        }
        return false;
    }

    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        if (this.checkToClose()) {
            return;
        }
        guiGraphics.m_280168_().m_85836_();
        RenderSystem.enableBlend();
        int k = this.f_96543_ / 2 - 62;
        int l = this.f_96544_ / 2 - 90;
        guiGraphics.m_280163_(MOB_SWITCHER_LOCATION, k, l, 0.0f, 63.0f, 125, 22, 256, 256);
        guiGraphics.m_280168_().m_85849_();
        super.m_88315_(guiGraphics, i, j, f);
        if (this.currentlyHovered != null) {
            guiGraphics.m_280653_(this.f_96547_, this.currentlyHovered.getName(), this.f_96543_ / 2, l + 7, -1);
            if (this.currentlyHovered.id != 0) {
                String[] strung2;
                ArrayList compList = Lists.newArrayList();
                for (String s : strung2 = this.splitIntoLine(this.currentlyHovered.desc.getString(), 30)) {
                    compList.add(Component.m_237113_((String)s));
                }
                guiGraphics.m_280677_(this.f_96547_, (List)compList, Optional.empty(), i, j);
            }
        }
        if (!this.setFirstMousePos) {
            this.firstMouseX = i;
            this.firstMouseY = j;
            this.setFirstMousePos = true;
        }
        this.caughtSomething = false;
        boolean bl = this.firstMouseX == i && this.firstMouseY == j;
        for (PlunderSlot MobSlot2 : this.slots) {
            MobSlot2.m_88315_(guiGraphics, i, j, f);
            MobSlot2.setSelected(this.currentlyHovered == MobSlot2.icon);
            if (bl || !MobSlot2.m_198029_()) continue;
            this.caughtSomething = true;
            if (MobSlot2.icon != standRerollIcon.NONE) {
                this.setWidgetNumber(MobSlot2.icon.id);
                if (this.currentlyHovered == standRerollIcon.NONE) {
                    SoundManager soundmanager = Minecraft.m_91087_().m_91106_();
                    soundmanager.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)ModSounds.BUBBLE_HOVERED_OVER_EVENT, (float)((float)(0.95 + Math.random() * (double)0.1f))));
                }
            }
            this.currentlyHovered = MobSlot2.icon;
        }
        if (!this.caughtSomething) {
            this.currentlyHovered = standRerollIcon.NONE;
        }
    }

    public String[] splitIntoLine(String input, int maxCharInLine) {
        StringTokenizer tok = new StringTokenizer(input, " ");
        StringBuilder output = new StringBuilder(input.length());
        int lineLen = 0;
        while (tok.hasMoreTokens()) {
            String word = tok.nextToken();
            while (word.length() > maxCharInLine) {
                output.append(word.substring(0, maxCharInLine - lineLen) + "\n");
                word = word.substring(maxCharInLine - lineLen);
                lineLen = 0;
            }
            if (lineLen + word.length() > maxCharInLine) {
                output.append("\n");
                lineLen = 0;
            }
            output.append(word + " ");
            lineLen += word.length() + 1;
        }
        return output.toString().split("\n");
    }

    private void switchToHoveredGameMode() {
        this.switchToHoveredGameMode(this.f_96541_, this.currentlyHovered);
    }

    private void switchToHoveredGameMode(Minecraft minecraft, standRerollIcon pIcon) {
        if (minecraft.f_91072_ == null || minecraft.f_91074_ == null) {
            return;
        }
    }

    public boolean roundabout$sameKeyOne(KeyMapping key1) {
        return key1.m_90857_() || key1.m_90850_(this.f_96541_.f_91066_.f_92058_) && this.f_96541_.f_91066_.f_92058_.m_90857_() || key1.m_90850_(this.f_96541_.f_91066_.f_92057_) && this.f_96541_.f_91066_.f_92057_.m_90857_();
    }

    public boolean sameKeyOne(KeyMapping key1, Options options) {
        return key1.m_90857_() || key1.m_90850_(options.f_92058_) && options.f_92058_.m_90857_() || key1.m_90850_(options.f_92057_) && options.f_92057_.m_90857_();
    }

    public boolean sameKeyOneX(KeyMapping key1, Options options) {
        return InputConstants.m_84830_((long)this.f_96541_.m_91268_().m_85439_(), (int)((IKeyMapping)key1).roundabout$justTellMeTheKey().m_84873_()) || key1.m_90850_(options.f_92058_) && InputConstants.m_84830_((long)this.f_96541_.m_91268_().m_85439_(), (int)((IKeyMapping)options.f_92058_).roundabout$justTellMeTheKey().m_84873_()) || key1.m_90850_(options.f_92057_) && InputConstants.m_84830_((long)this.f_96541_.m_91268_().m_85439_(), (int)((IKeyMapping)options.f_92057_).roundabout$justTellMeTheKey().m_84873_());
    }

    private boolean checkToClose() {
        if (this.f_96541_ != null && this.sameKeyOneX(KeyInputRegistry.abilityTwoKey, this.f_96541_.f_91066_)) {
            this.switchToHoveredGameMode();
            this.f_96541_.m_91152_(null);
            return true;
        }
        Options options = Minecraft.m_91087_().f_91066_;
        return false;
    }

    public void m_86600_() {
        super.m_86600_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (Minecraft.m_91087_().f_91066_.f_92085_.m_90832_(keyCode, scanCode) || Minecraft.m_91087_().f_91066_.f_92087_.m_90832_(keyCode, scanCode) || Minecraft.m_91087_().f_91066_.f_92086_.m_90832_(keyCode, scanCode) || Minecraft.m_91087_().f_91066_.f_92088_.m_90832_(keyCode, scanCode) || Minecraft.m_91087_().f_91066_.f_92089_.m_90832_(keyCode, scanCode) || Minecraft.m_91087_().f_91066_.f_92090_.m_90832_(keyCode, scanCode)) {
            return false;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return false;
    }

    public void setWidgetNumber(byte swap) {
        ClientConfig clientConfig = ConfigManager.getClientConfig();
        if (clientConfig != null && clientConfig.dynamicSettings != null && clientConfig.dynamicSettings.SoftAndWetCurrentlySelectedBubble != swap) {
            clientConfig.dynamicSettings.SoftAndWetCurrentlySelectedBubble = swap;
            ConfigManager.saveClientConfig();
        }
    }

    public byte getWidgetNumber() {
        ClientConfig clientConfig = ConfigManager.getClientConfig();
        if (clientConfig != null && clientConfig.dynamicSettings != null) {
            return clientConfig.dynamicSettings.SoftAndWetCurrentlySelectedBubble.byteValue();
        }
        return 0;
    }

    protected boolean isSurelyHovering(int p_97768_, int p_97769_, int p_97770_, int p_97771_, double p_97772_, double p_97773_) {
        return p_97772_ >= (double)p_97768_ && p_97772_ < (double)(p_97768_ + p_97770_) && p_97773_ >= (double)p_97769_ && p_97773_ < (double)(p_97769_ + p_97771_);
    }

    public static enum standRerollIcon {
        ITEM_PLUNDER((Component)Component.m_237115_((String)"roundabout.soft_and_wet_plunder.items"), new ResourceLocation("roundabout", "textures/gui/plunder_icons/item.png"), PlunderTypes.ITEM.id, -43, 31, (Component)Component.m_237115_((String)"roundabout.soft_and_wet_plunder.items.desc")),
        SOUND_PLUNDER((Component)Component.m_237115_((String)"roundabout.soft_and_wet_plunder.sound"), new ResourceLocation("roundabout", "textures/gui/plunder_icons/sound.png"), PlunderTypes.SOUND.id, -28, 1, (Component)Component.m_237115_((String)"roundabout.soft_and_wet_plunder.sound.desc")),
        FRICTION_PLUNDER((Component)Component.m_237115_((String)"roundabout.soft_and_wet_plunder.friction"), new ResourceLocation("roundabout", "textures/gui/plunder_icons/friction.png"), PlunderTypes.FRICTION.id, 42, 31, (Component)Component.m_237115_((String)"roundabout.soft_and_wet_plunder.friction.desc")),
        SIGHT_PLUNDER((Component)Component.m_237115_((String)"roundabout.soft_and_wet_plunder.sight"), new ResourceLocation("roundabout", "textures/gui/plunder_icons/sight.png"), PlunderTypes.SIGHT.id, 0, -16, (Component)Component.m_237115_((String)"roundabout.soft_and_wet_plunder.sight.desc")),
        OXYGEN_PLUNDER((Component)Component.m_237115_((String)"roundabout.soft_and_wet_plunder.oxygen"), new ResourceLocation("roundabout", "textures/gui/plunder_icons/oxygen.png"), PlunderTypes.OXYGEN.id, 28, 1, (Component)Component.m_237115_((String)"roundabout.soft_and_wet_plunder.oxygen.desc")),
        MOB_PLUNDER((Component)Component.m_237115_((String)"roundabout.soft_and_wet_plunder.mobs"), new ResourceLocation("roundabout", "textures/gui/plunder_icons/mobs.png"), PlunderTypes.MOBS.id, 28, 61, (Component)Component.m_237115_((String)"roundabout.soft_and_wet_plunder.mobs.desc")),
        POTION_EFFECT_PLUNDER((Component)Component.m_237115_((String)"roundabout.soft_and_wet_plunder.potion_effects"), new ResourceLocation("roundabout", "textures/gui/plunder_icons/effects.png"), PlunderTypes.POTION_EFFECTS.id, -28, 61, (Component)Component.m_237115_((String)"roundabout.soft_and_wet_plunder.potion_effects.desc")),
        MOISTURE_PLUNDER((Component)Component.m_237115_((String)"roundabout.soft_and_wet_plunder.moisture"), new ResourceLocation("roundabout", "textures/gui/plunder_icons/moisture.png"), PlunderTypes.MOISTURE.id, 0, 78, (Component)Component.m_237115_((String)"roundabout.soft_and_wet_plunder.moisture.desc")),
        NONE((Component)Component.m_237115_((String)"roundabout.soft_and_wet_plunder.none"), new ResourceLocation("roundabout", "textures/gui/plunder_icons/main_stand.png"), 0, 0, 31, (Component)Component.m_237115_((String)"roundabout.stand_switch.main.desc"));

        protected static final standRerollIcon[] VALUES;
        private static final int ICON_AREA = 16;
        protected static final int ICON_TOP_LEFT = 5;
        final Component name;
        final Component desc;
        final ResourceLocation rl;
        final byte id;
        final int xoff;
        final int yoff;

        static standRerollIcon getByte(PlunderTypes pose) {
            return switch (pose) {
                default -> throw new IncompatibleClassChangeError();
                case PlunderTypes.NONE -> NONE;
                case PlunderTypes.ITEM -> ITEM_PLUNDER;
                case PlunderTypes.SOUND -> SOUND_PLUNDER;
                case PlunderTypes.FRICTION -> FRICTION_PLUNDER;
                case PlunderTypes.OXYGEN -> OXYGEN_PLUNDER;
                case PlunderTypes.SIGHT -> SIGHT_PLUNDER;
                case PlunderTypes.MOISTURE -> MOISTURE_PLUNDER;
                case PlunderTypes.POTION_EFFECTS -> POTION_EFFECT_PLUNDER;
                case PlunderTypes.MOBS -> MOB_PLUNDER;
            };
        }

        private standRerollIcon(Component component, ResourceLocation rl, byte id, int xoff, int yoff, Component desc) {
            this.name = component;
            this.rl = rl;
            this.id = id;
            this.xoff = xoff;
            this.yoff = yoff;
            this.desc = desc;
        }

        void drawIcon(GuiGraphics guiGraphics, int i, int j) {
            guiGraphics.m_280163_(this.rl, i - 1, j - 1, 0.0f, 0.0f, 18, 18, 18, 18);
        }

        Component getName() {
            return this.name;
        }

        static {
            VALUES = new standRerollIcon[]{ITEM_PLUNDER, SOUND_PLUNDER, FRICTION_PLUNDER, OXYGEN_PLUNDER, SIGHT_PLUNDER, MOB_PLUNDER, POTION_EFFECT_PLUNDER, MOISTURE_PLUNDER, NONE};
        }
    }

    public class PlunderSlot
    extends AbstractWidget {
        final standRerollIcon icon;
        private boolean isSelected;

        public PlunderSlot(standRerollIcon pIcon, int i, int j) {
            super(i, j, 26, 26, pIcon.getName());
            this.icon = pIcon;
        }

        public void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
            RenderSystem.enableBlend();
            if (!this.icon.equals((Object)standRerollIcon.NONE)) {
                if (this.icon.id == PlunderScreen.this.getWidgetNumber()) {
                    if (this.isSelected) {
                        this.drawSlot4(guiGraphics);
                    } else {
                        this.drawSlot3(guiGraphics);
                    }
                } else if (this.isSelected) {
                    this.drawSlot2(guiGraphics);
                } else {
                    this.drawSlot(guiGraphics);
                }
                this.icon.drawIcon(guiGraphics, this.m_252754_() + 5, this.m_252907_() + 5);
            }
            RenderSystem.disableBlend();
        }

        public void m_168797_(NarrationElementOutput narrationElementOutput) {
            this.m_168802_(narrationElementOutput);
        }

        public void setSelected(boolean bl) {
            this.isSelected = bl;
        }

        private void drawSlot(GuiGraphics guiGraphics) {
            guiGraphics.m_280163_(MOB_SWITCHER_LOCATION, this.m_252754_(), this.m_252907_(), 133.0f, 63.0f, 26, 26, 256, 256);
        }

        private void drawSlot2(GuiGraphics guiGraphics) {
            guiGraphics.m_280163_(MOB_SWITCHER_LOCATION, this.m_252754_() - 3, this.m_252907_() - 3, 160.0f, 60.0f, 32, 32, 256, 256);
        }

        private void drawSlot3(GuiGraphics guiGraphics) {
            guiGraphics.m_280163_(MOB_SWITCHER_LOCATION, this.m_252754_(), this.m_252907_(), 196.0f, 63.0f, 26, 26, 256, 256);
        }

        private void drawSlot4(GuiGraphics guiGraphics) {
            guiGraphics.m_280163_(MOB_SWITCHER_LOCATION, this.m_252754_() - 3, this.m_252907_() - 3, 223.0f, 60.0f, 32, 32, 256, 256);
        }

        private void drawSelection(GuiGraphics guiGraphics) {
            guiGraphics.m_280163_(MOB_SWITCHER_LOCATION, this.m_252754_(), this.m_252907_(), 170.0f, 0.0f, 26, 26, 256, 256);
        }
    }
}

