/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.models.projectile.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.entity.projectile.SoftAndWetBubbleEntity;
import net.hydra.jojomod.entity.projectile.SoftAndWetExplosiveBubbleEntity;
import net.hydra.jojomod.entity.projectile.SoftAndWetItemLaunchingBubbleEntity;
import net.hydra.jojomod.entity.projectile.SoftAndWetPlunderBubbleEntity;
import net.hydra.jojomod.event.index.PlunderTypes;
import net.hydra.jojomod.event.powers.TimeStop;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class SoftAndWetBubbleRenderer
extends EntityRenderer<SoftAndWetBubbleEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("roundabout", "textures/stand/soft_and_wet/projectiles/bubble_plunder.png");
    private static final ResourceLocation SHOOTING_1 = new ResourceLocation("roundabout", "textures/stand/soft_and_wet/projectiles/shooting_bubble_1.png");
    private static final ResourceLocation SHOOTING_2 = new ResourceLocation("roundabout", "textures/stand/soft_and_wet/projectiles/shooting_bubble_2.png");
    private static final ResourceLocation SHOOTING_3 = new ResourceLocation("roundabout", "textures/stand/soft_and_wet/projectiles/shooting_bubble_3.png");
    private static final ResourceLocation SHOOTING_4 = new ResourceLocation("roundabout", "textures/stand/soft_and_wet/projectiles/shooting_bubble_4.png");
    private static final ResourceLocation ITEM_1 = new ResourceLocation("roundabout", "textures/stand/soft_and_wet/projectiles/explosive_item_bubble_1.png");
    private static final ResourceLocation ITEM_2 = new ResourceLocation("roundabout", "textures/stand/soft_and_wet/projectiles/explosive_item_bubble_2.png");
    private static final ResourceLocation ITEM_3 = new ResourceLocation("roundabout", "textures/stand/soft_and_wet/projectiles/explosive_item_bubble_3.png");
    private static final ResourceLocation ITEM_4 = new ResourceLocation("roundabout", "textures/stand/soft_and_wet/projectiles/explosive_item_bubble_4.png");
    private static final ResourceLocation MOB = new ResourceLocation("roundabout", "textures/stand/soft_and_wet/projectiles/bubble_plunder_mob.png");
    private static final ResourceLocation BUBBLE = new ResourceLocation("roundabout", "textures/stand/soft_and_wet/projectiles/bubble.png");
    private static final ResourceLocation GAS_BUBBLE = new ResourceLocation("roundabout", "textures/stand/soft_and_wet/projectiles/gasoline_bubble.png");
    private static final ResourceLocation WATER_BUBBLE = new ResourceLocation("roundabout", "textures/stand/soft_and_wet/projectiles/water_bubble.png");
    private static final ResourceLocation LAVA_BUBBLE = new ResourceLocation("roundabout", "textures/stand/soft_and_wet/projectiles/lava_bubble.png");
    private static final ResourceLocation FIRE_BUBBLE = new ResourceLocation("roundabout", "textures/stand/soft_and_wet/projectiles/fire_bubble.png");
    private static final ResourceLocation BLOOD_BUBBLE = new ResourceLocation("roundabout", "textures/stand/soft_and_wet/projectiles/blood_bubble.png");
    private static final ResourceLocation BLUE_BLOOD_BUBBLE = new ResourceLocation("roundabout", "textures/stand/soft_and_wet/projectiles/hemolymph_bubble.png");
    private static final ResourceLocation ENDER_BLOOD_BUBBLE = new ResourceLocation("roundabout", "textures/stand/soft_and_wet/projectiles/ender_blood_bubble.png");
    private final float scale;
    private final ItemRenderer itemRenderer;

    public SoftAndWetBubbleRenderer(EntityRendererProvider.Context context, float scale) {
        super(context);
        this.itemRenderer = context.m_174025_();
        this.scale = scale;
    }

    public SoftAndWetBubbleRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.m_174025_();
        this.scale = 1.0f;
    }

    public void render(SoftAndWetBubbleEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        block19: {
            SoftAndWetItemLaunchingBubbleEntity launch;
            SoftAndWetPlunderBubbleEntity plunder;
            float size;
            Vector3f coursecorrect;
            Matrix4f matrix;
            VertexConsumer vertexConsumer;
            block22: {
                float scaleIt;
                block21: {
                    block20: {
                        SoftAndWetPlunderBubbleEntity sp;
                        if (!ClientUtil.canSeeStands(ClientUtil.getPlayer())) break block19;
                        if (((TimeStop)entity.m_9236_()).inTimeStopRange((Entity)entity)) {
                            partialTicks = 0.0f;
                        }
                        if (entity instanceof SoftAndWetPlunderBubbleEntity && (sp = (SoftAndWetPlunderBubbleEntity)entity).isPopPlunderBubbble()) break block19;
                        poseStack.m_85836_();
                        poseStack.m_85841_(this.scale, this.scale, this.scale);
                        poseStack.m_252781_(this.f_114476_.m_253208_());
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                        poseStack.m_252880_(0.0f, entity.m_20206_() / 2.0f, 0.0f);
                        vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity)));
                        matrix = poseStack.m_85850_().m_252922_();
                        Vector3f normal = Minecraft.m_91087_().f_91063_.m_109153_().m_253058_();
                        normal.normalize();
                        coursecorrect = new Vector3f(0.577f, 0.577f, 0.577f);
                        if (normal.y > 0.0f) {
                            coursecorrect = new Vector3f(0.01f, 1.0f, 0.01f);
                            if ((double)normal.y > 0.95) {
                                coursecorrect = new Vector3f(-0.577f, -0.577f, -0.577f);
                            }
                        }
                        scaleIt = 0.23f;
                        if (entity instanceof SoftAndWetPlunderBubbleEntity) {
                            SoftAndWetPlunderBubbleEntity sp2 = (SoftAndWetPlunderBubbleEntity)entity;
                            int ls = sp2.getLiquidStolen();
                            if (ls == 3) {
                                packedLight = 0xF000F0;
                            } else if (sp2.getActivated() && sp2.getPlunderType() == PlunderTypes.OXYGEN.id) {
                                packedLight = 0xF000F0;
                            }
                            if (!sp2.getHeldItem().m_41619_()) {
                                scaleIt = 0.33f;
                            }
                            if (sp2.getEntityStolen() > 0 && sp2.getPlunderType() == PlunderTypes.MOBS.id) {
                                scaleIt = 1.0f;
                            }
                        } else if (entity instanceof SoftAndWetItemLaunchingBubbleEntity) {
                            SoftAndWetItemLaunchingBubbleEntity itemn = (SoftAndWetItemLaunchingBubbleEntity)entity;
                            scaleIt = 0.33f;
                        }
                        size = (float)Math.min((double)scaleIt, (double)((float)entity.f_19797_ + partialTicks) * ((double)scaleIt * 0.1));
                        if (!(entity instanceof SoftAndWetExplosiveBubbleEntity)) break block20;
                        SoftAndWetExplosiveBubbleEntity seb = (SoftAndWetExplosiveBubbleEntity)entity;
                        break block21;
                    }
                    if (!(entity instanceof SoftAndWetItemLaunchingBubbleEntity)) break block22;
                    SoftAndWetItemLaunchingBubbleEntity softAndWetItemLaunchingBubbleEntity = (SoftAndWetItemLaunchingBubbleEntity)entity;
                }
                size = scaleIt;
            }
            vertexConsumer.m_252986_(matrix, -size, -size, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(coursecorrect.x, coursecorrect.y, coursecorrect.z).m_5752_();
            vertexConsumer.m_252986_(matrix, size, -size, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(coursecorrect.x, coursecorrect.y, coursecorrect.z).m_5752_();
            vertexConsumer.m_252986_(matrix, size, size, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(coursecorrect.x, coursecorrect.y, coursecorrect.z).m_5752_();
            vertexConsumer.m_252986_(matrix, -size, size, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(coursecorrect.x, coursecorrect.y, coursecorrect.z).m_5752_();
            if (entity instanceof SoftAndWetPlunderBubbleEntity && !(plunder = (SoftAndWetPlunderBubbleEntity)entity).getHeldItem().m_41619_()) {
                poseStack.m_85837_(0.0, -0.12, 0.0);
                this.itemRenderer.m_269128_(plunder.getHeldItem(), ItemDisplayContext.GROUND, packedLight, OverlayTexture.f_118083_, poseStack, buffer, entity.m_9236_(), entity.m_19879_());
            }
            if (entity instanceof SoftAndWetItemLaunchingBubbleEntity && !(launch = (SoftAndWetItemLaunchingBubbleEntity)entity).getHeldItem().m_41619_()) {
                if (launch.getHeldItem().m_41720_() instanceof BlockItem) {
                    poseStack.m_85837_(0.0, -0.19, 0.0);
                } else {
                    poseStack.m_85837_(0.0, -0.12, 0.0);
                }
                this.itemRenderer.m_269128_(launch.getHeldItem(), ItemDisplayContext.GROUND, packedLight, OverlayTexture.f_118083_, poseStack, buffer, entity.m_9236_(), entity.m_19879_());
            }
            poseStack.m_85849_();
            super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    public ResourceLocation getTextureLocation(SoftAndWetBubbleEntity entity) {
        if (entity instanceof SoftAndWetPlunderBubbleEntity) {
            SoftAndWetPlunderBubbleEntity sp = (SoftAndWetPlunderBubbleEntity)entity;
            int ls = sp.getLiquidStolen();
            if (ls == 1) {
                return GAS_BUBBLE;
            }
            if (ls == 2) {
                return WATER_BUBBLE;
            }
            if (ls == 3) {
                return LAVA_BUBBLE;
            }
            if (ls == 4) {
                return BLOOD_BUBBLE;
            }
            if (ls == 5) {
                return BLUE_BLOOD_BUBBLE;
            }
            if (ls == 6) {
                return ENDER_BLOOD_BUBBLE;
            }
            if (sp.getActivated() && sp.getPlunderType() == PlunderTypes.OXYGEN.id) {
                return FIRE_BUBBLE;
            }
            if (sp.getActivated() && sp.getPlunderType() == PlunderTypes.MOBS.id) {
                return MOB;
            }
            return TEXTURE;
        }
        if (entity instanceof SoftAndWetItemLaunchingBubbleEntity) {
            SoftAndWetItemLaunchingBubbleEntity seb = (SoftAndWetItemLaunchingBubbleEntity)entity;
            int div = seb.f_19797_ % 4;
            return switch (div) {
                case 1 -> ITEM_1;
                case 2 -> ITEM_2;
                case 3 -> ITEM_3;
                default -> ITEM_4;
            };
        }
        if (entity instanceof SoftAndWetExplosiveBubbleEntity) {
            SoftAndWetExplosiveBubbleEntity seb = (SoftAndWetExplosiveBubbleEntity)entity;
            int div = seb.f_19797_ % 4;
            return switch (div) {
                case 1 -> SHOOTING_2;
                case 2 -> SHOOTING_3;
                case 3 -> SHOOTING_4;
                default -> SHOOTING_1;
            };
        }
        return BUBBLE;
    }
}

