/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.models.stand.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.hydra.jojomod.client.models.layers.ModEntityRendererClient;
import net.hydra.jojomod.client.models.stand.CinderellaModel;
import net.hydra.jojomod.client.models.stand.renderers.StandRenderer;
import net.hydra.jojomod.entity.stand.CinderellaEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class CinderellaRenderer
extends StandRenderer<CinderellaEntity> {
    private static final ResourceLocation PART_4_SKIN = new ResourceLocation("roundabout", "textures/stand/cinderella/anime.png");
    private static final ResourceLocation MANGA_SKIN = new ResourceLocation("roundabout", "textures/stand/cinderella/manga.png");
    private static final ResourceLocation ZOMBIE_SKIN = new ResourceLocation("roundabout", "textures/stand/cinderella/zombie.png");
    private static final ResourceLocation JACK_SKIN = new ResourceLocation("roundabout", "textures/stand/cinderella/jack.png");
    private static final ResourceLocation BUSINESS_SKIN = new ResourceLocation("roundabout", "textures/stand/cinderella/business.png");
    private static final ResourceLocation FACE_OFF = new ResourceLocation("roundabout", "textures/stand/cinderella/face_off.png");

    public CinderellaRenderer(EntityRendererProvider.Context context) {
        super(context, new CinderellaModel(context.m_174023_(ModEntityRendererClient.CINDERELLA_LAYER)), 0.0f);
    }

    @Override
    public ResourceLocation getTextureLocation(CinderellaEntity entity) {
        switch (entity.getSkin()) {
            case 2: {
                return MANGA_SKIN;
            }
            case 3: {
                return ZOMBIE_SKIN;
            }
            case 4: {
                return JACK_SKIN;
            }
            case 5: {
                return BUSINESS_SKIN;
            }
            case 6: {
                return FACE_OFF;
            }
        }
        return PART_4_SKIN;
    }

    @Override
    public void render(CinderellaEntity mobEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        float factor = 0.5f + mobEntity.getSizePercent() / 2.0f;
        if (mobEntity.m_6162_()) {
            matrixStack.m_85841_(0.5f * factor, 0.5f * factor, 0.5f * factor);
        } else {
            matrixStack.m_85841_(0.8f * factor, 0.8f * factor, 0.8f * factor);
        }
        super.render(mobEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    @Override
    @Nullable
    protected RenderType getRenderType(CinderellaEntity entity, boolean showBody, boolean translucent, boolean showOutline) {
        return super.getRenderType(entity, showBody, true, showOutline);
    }
}

