/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.models.stand.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.hydra.jojomod.access.IEntityAndData;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.client.models.stand.StandModel;
import net.hydra.jojomod.client.models.stand.renderers.StandHeldItemLayer;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.item.MaskItem;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.config.ConfigManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class StandRenderer<T extends StandEntity>
extends MobRenderer<T, StandModel<T>> {
    public StandRenderer(EntityRendererProvider.Context context, StandModel<T> entityModel, float f) {
        super(context, entityModel, f);
        this.f_114477_ = 0.0f;
        this.f_114478_ = 0.0f;
        this.m_115326_(new StandHeldItemLayer(this, context.m_234598_()));
    }

    public ResourceLocation getTextureLocation(T entity) {
        return null;
    }

    public void render(T mobEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        Item item;
        Player PE;
        ItemStack stack;
        LocalPlayer lp = Minecraft.m_91087_().f_91074_;
        float maxfade = 100.0f;
        LivingEntity User = ((StandEntity)mobEntity).getUser();
        if (User != null && ((IEntityAndData)User).roundabout$getTrueInvisibility() > -1 || ((IEntityAndData)mobEntity).roundabout$getTrueInvisibility() > -1) {
            return;
        }
        if (lp != null) {
            IPlayerEntity ipe = (IPlayerEntity)lp;
            if (User != null && ((StandEntity)mobEntity).getUser().m_7306_((Entity)lp)) {
                StandUser standUser = (StandUser)((StandEntity)mobEntity).getUser();
                StandPowers powers = standUser.roundabout$getStandPowers();
                if (standUser.roundabout$getStandPowers().getActivePower() == 0) {
                    maxfade = ConfigManager.getClientConfig().opacitySettings.opacityOfStand.floatValue();
                    if (ConfigManager.getClientConfig().opacitySettings.opacityOfStand.floatValue() <= 0.1f) {
                        return;
                    }
                } else {
                    maxfade = ConfigManager.getClientConfig().opacitySettings.opacityWhileAttacking.floatValue();
                    if (ConfigManager.getClientConfig().opacitySettings.opacityWhileAttacking.floatValue() <= 0.1f) {
                        return;
                    }
                }
            } else {
                maxfade = ConfigManager.getClientConfig().opacitySettings.opacityOfOthers.floatValue();
                if (ConfigManager.getClientConfig().opacitySettings.opacityOfOthers.floatValue() <= 0.1f) {
                    return;
                }
            }
        }
        if (User != null && User.m_6162_()) {
            matrixStack.m_85841_(0.6f, 0.6f, 0.6f);
            ((StandModel)this.f_115290_).f_102610_ = true;
        } else {
            ((StandModel)this.f_115290_).f_102610_ = false;
        }
        if (User instanceof Player && !(stack = ((IPlayerEntity)(PE = (Player)User)).roundabout$getMaskSlot()).m_41619_() && (item = stack.m_41720_()) instanceof MaskItem) {
            MaskItem mi = (MaskItem)item;
            Vec3 vec = mi.visageData.generateVisageData((LivingEntity)PE).sizeModifier();
            matrixStack.m_85841_((float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_);
        }
        maxfade *= 0.01f;
        if (!ClientUtil.canSeeStands((Player)lp) && !((StandEntity)mobEntity).forceVisible) {
            ((StandEntity)mobEntity).fadePercent = MainUtil.controlledLerp(ClientUtil.getDelta(), ((StandEntity)mobEntity).fadePercent, 0.0f, 0.72f);
        } else {
            float opacity = this.getStandOpacity(mobEntity);
            ((StandEntity)mobEntity).fadePercent = MainUtil.controlledLerp(ClientUtil.getDelta(), ((StandEntity)mobEntity).fadePercent, (opacity *= (float)((StandEntity)mobEntity).getFadePercent() * 0.01f) * maxfade, 0.72f);
        }
        ((StandModel)this.f_115290_).setAlpha(((StandEntity)mobEntity).fadePercent);
        if (this.skipLighting(mobEntity)) {
            super.m_7392_(mobEntity, f, g, matrixStack, vertexConsumerProvider, 0xF000F0);
        } else {
            int tlight;
            int plight = i;
            LivingEntity owner = ((StandEntity)mobEntity).getUser();
            if (owner != null && plight < (tlight = this.getTrueLight((Entity)owner, g)) && plight < 1) {
                plight = tlight;
            }
            super.m_7392_(mobEntity, f, g, matrixStack, vertexConsumerProvider, plight);
        }
    }

    public boolean skipLighting(T entity) {
        return false;
    }

    public final int getTrueLight(Entity entity, float tickDelta) {
        BlockPos blockPos = BlockPos.m_274446_((Position)entity.m_7371_(tickDelta));
        return LightTexture.m_109885_((int)this.getTrueBlockLight(entity, blockPos), (int)this.getTrueSkyLight(entity, blockPos));
    }

    protected int getTrueSkyLight(Entity entity, BlockPos pos) {
        return entity.m_9236_().m_45517_(LightLayer.SKY, pos);
    }

    protected int getTrueBlockLight(Entity entity, BlockPos pos) {
        if (entity.m_6060_()) {
            return 15;
        }
        return entity.m_9236_().m_45517_(LightLayer.BLOCK, pos);
    }

    public float getStandOpacity(T entity) {
        if (((StandEntity)entity).forceVisible) {
            return ((StandEntity)entity).getMaxFade();
        }
        int vis = ((StandEntity)entity).getFadeOut();
        byte max = ((StandEntity)entity).getMaxFade();
        float tot = (float)((double)(Math.min((float)vis + ClientUtil.getDelta(), (float)max) / (float)max) * 1.3 - 0.3);
        if (tot < 0.0f) {
            tot = 0.0f;
        }
        return tot;
    }

    @Nullable
    protected RenderType getRenderType(T entity, boolean showBody, boolean translucent, boolean showOutline) {
        return super.m_7225_(entity, showBody, true, showOutline);
    }
}

