/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.event.powers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.hydra.jojomod.access.IGravityEntity;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.access.IProjectileAccess;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.KeyboardPilotInput;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.stand.FollowingStandEntity;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.ModGamerules;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.event.powers.TimeStop;
import net.hydra.jojomod.fates.powers.AbilityScapeBasis;
import net.hydra.jojomod.item.MaxStandDiscItem;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.item.StandDiscItem;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.presets.TWAndSPSharedPowers;
import net.hydra.jojomod.util.C2SPacketUtil;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.zetalasis.networking.message.api.ModMessageEvents;
import org.jetbrains.annotations.Nullable;

public class StandPowers
extends AbilityScapeBasis {
    public static final byte ALL_WORTHY = 1;
    public static final byte HUMANOID_WORTHY = 2;
    public boolean forwardBarrage = false;
    public int softenTicks = 0;
    public boolean suspendGuard = false;
    public boolean moveStarted = false;
    public int clashStarter = 0;
    public static final byte TIME_STOP_NOISE = 40;
    public static final byte TIME_STOP_NOISE_2 = 41;
    public static final byte TIME_STOP_NOISE_3 = 42;
    public static final byte TIME_STOP_NOISE_4 = 43;
    public static final byte TIME_STOP_NOISE_5 = 44;
    public static final byte TIME_STOP_NOISE_6 = 45;
    public static final byte TIME_STOP_NOISE_7 = 46;
    public static final byte TIME_STOP_NOISE_8 = 47;
    public static final byte TIME_STOP_NOISE_9 = 48;
    public static final byte TIME_STOP_NOISE_10 = 49;
    public static final byte TIME_STOP_NOISE_11 = 50;
    public static final byte TIME_STOP_NOISE_12 = 51;
    public static final byte TIME_STOP_TICKING = 56;
    public static final byte TIME_RESUME_NOISE = 60;
    public static final byte TIME_RESUME_NOISE_2 = 61;
    public static final byte TIME_RESUME_NOISE_3 = 62;
    public StandEntity displayStand = null;
    public boolean clashDone = false;
    public float clashProgress = 0.0f;
    private float clashOpProgress = 0.0f;
    @Nullable
    private LivingEntity clashOp;
    private int clashIncrement = 0;
    private int clashMod = 0;
    public static final int zenith = 10;
    public int timeRewindOverlayTicks = -1;
    public static final float maxOverlay = 0.45f;
    private int chargedTSTicks = 0;
    public boolean hasActedInTS = false;
    public Entity goBeyondTarget = null;
    public int summonCD = 0;

    public StandPowers generateStandPowers(LivingEntity entity) {
        return null;
    }

    public byte worthinessType() {
        return 1;
    }

    public boolean isSecondaryStand() {
        return false;
    }

    public boolean canSummonStandAsEntity() {
        return true;
    }

    public StandEntity getNewStandEntity() {
        return null;
    }

    public boolean canSummonStand() {
        return false;
    }

    public boolean interceptAttack() {
        return false;
    }

    public void buttonInputAttack(boolean keyIsDown, Options options) {
        if (keyIsDown && this.canAttack()) {
            this.tryPower(1);
            this.tryPowerPacket((byte)1);
        }
    }

    public boolean interceptGuard() {
        return false;
    }

    public boolean interceptAllInteractions() {
        return false;
    }

    public boolean buttonInputGuard(boolean keyIsDown, Options options) {
        return false;
    }

    public void tickPowerEnd() {
    }

    public void tickMobAI(LivingEntity attackTarget) {
    }

    public boolean disableMobAiAttack() {
        return this.activePower == 6 && this.attackTimeDuring > -1 || this.isBarraging();
    }

    public void tickStandRejection(MobEffectInstance effect) {
    }

    public void visualFrameTick() {
    }

    public int getMaxGuardPoints() {
        return 10;
    }

    public void onStandSwitch() {
        this.getStandUserSelf().roundabout$setUniqueStandModeToggle(false);
    }

    public void onStandSwitchInto() {
    }

    public boolean hasShootingModeVisually() {
        return false;
    }

    public float getPermaCastRange() {
        return 100.0f;
    }

    public byte getPermaCastContext() {
        return -1;
    }

    public void tickPermaCast() {
    }

    public boolean canSeeThroughFog() {
        return false;
    }

    public boolean isStandEnabled() {
        return true;
    }

    @Override
    public float inputSpeedModifiers(float basis) {
        StandUser standUser = (StandUser)this.getSelf();
        if (standUser.roundabout$isDazed()) {
            basis = 0.0f;
        } else if ((this.getSelf().m_20202_() == null || this.getSelf().m_275832_() != null) && standUser.roundabout$isGuarding() && this.getSelf().m_20202_() == null) {
            basis *= 0.3f;
        } else if (this.isBarrageAttacking() || standUser.roundabout$isClashing()) {
            basis *= 0.2f;
        } else if (this.isBarrageCharging()) {
            basis *= 0.5f;
        }
        if (this.impactSlowdown > -1) {
            basis = 0.0f;
        }
        return basis;
    }

    public boolean cancelSprintJump() {
        return this.isBarraging();
    }

    public boolean cancelSprint() {
        return false;
    }

    public boolean cancelJump() {
        return false;
    }

    public boolean cancelItemUse() {
        return false;
    }

    public boolean canInterruptPower() {
        return false;
    }

    public boolean canLightFurnace() {
        return false;
    }

    public int getMobRecoilTime() {
        return -30;
    }

    public void buttonInputBarrage(boolean keyIsDown, Options options) {
        if (keyIsDown && (this.getAttackTime() >= this.getAttackTimeMax() || this.getActivePowerPhase() != this.getActivePowerPhaseMax())) {
            this.tryPower(4, true);
            this.tryPowerPacket((byte)4);
        }
    }

    public boolean cancelCollision(Entity et) {
        return false;
    }

    public void buttonInputUse(boolean keyIsDown, Options options) {
        if (keyIsDown) {
            // empty if block
        }
    }

    public boolean isPiloting() {
        return false;
    }

    public StandEntity getPilotingStand() {
        return this.getStandEntity(this.self);
    }

    public void setPiloting(int ID) {
    }

    public void synchToCamera() {
    }

    public void pilotStandControls(KeyboardPilotInput kpi, LivingEntity entity) {
    }

    public void pilotInputAttack() {
    }

    public boolean pilotInputInteract() {
        return false;
    }

    public int getPilotMode() {
        return 2;
    }

    public int getMaxPilotRange() {
        return 100;
    }

    public boolean highlightsEntity(Entity ent, Player player) {
        return false;
    }

    public int highlightsEntityColor(Entity ent, Player player) {
        return 0;
    }

    public void setAirAmount(int airAmount) {
    }

    public int getAirAmount() {
        return -1;
    }

    public int getMaxAirAmount() {
        return ClientNetworking.getAppropriateConfig().theWorldSettings.oxygenTankAdditionalTicks;
    }

    public void timeTick() {
        if (this.getSelf().m_9236_().f_46443_) {
            this.tickSounds();
        } else {
            ++this.softenTicks;
        }
    }

    public void updatePowerFloat(byte activePower, float data) {
    }

    public void updatePowerInt(byte activePower, int data) {
    }

    public void updateIntMove(int in) {
    }

    public void updateGuard(boolean yeet) {
        if (this.suspendGuard && !yeet) {
            this.suspendGuard = false;
        }
    }

    public void updateMove(float flot) {
    }

    public boolean onCreateProjectile(Projectile proj) {
        return false;
    }

    public boolean interceptDamageDealtEvent(DamageSource $$0, float $$1, LivingEntity target) {
        return false;
    }

    public boolean interceptSuccessfulDamageDealtEvent(DamageSource $$0, float $$1, LivingEntity target) {
        return false;
    }

    public void onActuallyHurt(DamageSource $$0, float $$1) {
    }

    public boolean interceptDamageEvent(DamageSource $$0, float $$1) {
        return false;
    }

    public void eatEffectIntercept(ItemStack $$0, Level $$1, LivingEntity $$2) {
    }

    public boolean dealWithProjectile(Entity ent, HitResult res) {
        return false;
    }

    public void playSummonEffects(boolean forced) {
    }

    public void reactToAggro(Mob mob) {
    }

    public void onPlaceBlock(ServerPlayer $$0, BlockPos $$1, ItemStack $$2) {
    }

    public void onDestroyBlock(Level $$0, Player $$1, BlockPos $$2, BlockState $$3, BlockEntity $$4, ItemStack $$5) {
    }

    public boolean onKilledEntity(ServerLevel $$0, LivingEntity $$1) {
        return false;
    }

    public void deflectArrowsAndBullets(Entity ent) {
        Projectile PE;
        IProjectileAccess ipa;
        if (ent instanceof Projectile && !(ipa = (IProjectileAccess)(PE = (Projectile)ent)).roundabout$getIsDeflected()) {
            ipa.roundabout$setIsDeflected(true);
            ent.m_20256_(ent.m_20184_().m_82490_(-0.4));
            ent.m_146922_(ent.m_146908_() + 180.0f);
            ent.f_19859_ += 180.0f;
        }
    }

    public float multiplyPowerByStandConfigPlayers(float power) {
        return power;
    }

    public float multiplyPowerByStandConfigMobs(float power) {
        return power;
    }

    public float getPunchStrength(Entity entity) {
        if (this.getReducedDamage(entity)) {
            return 1.75f;
        }
        return 5.0f;
    }

    public float getHeavyPunchStrength(Entity entity) {
        if (this.getReducedDamage(entity)) {
            return 2.5f;
        }
        return 6.0f;
    }

    public float getBarrageFinisherStrength(Entity entity) {
        if (this.getReducedDamage(entity)) {
            return 3.0f;
        }
        return 8.0f;
    }

    public float getBarrageFinisherKnockback() {
        return 2.8f;
    }

    private float getClashBreakStrength(Entity entity) {
        if (this.getReducedDamage(entity)) {
            return 4.0f;
        }
        return 10.0f;
    }

    public float getBarrageDamagePlayer() {
        return 9.0f;
    }

    public float getBarrageDamageMob() {
        return 20.0f;
    }

    public float getBarrageHitStrength(Entity entity) {
        float barrageLength = this.getBarrageLength();
        float power = this.getReducedDamage(entity) ? this.getBarrageDamagePlayer() / barrageLength : this.getBarrageDamageMob() / barrageLength;
        if (entity instanceof LivingEntity && power >= ((LivingEntity)entity).m_21223_() && ClientNetworking.getAppropriateConfig().generalStandSettings.barragesOnlyKillOnLastHit.booleanValue()) {
            power = entity instanceof Player ? 1.0E-5f : 0.0f;
        }
        return power;
    }

    private float getYOffSet(LivingEntity stand) {
        float yy = 0.1f;
        if (stand.m_6069_() || stand.m_20143_() || stand.m_21255_()) {
            yy -= 1.0f;
        }
        return yy;
    }

    public boolean clickRelease() {
        return false;
    }

    public void punchImpact(Entity entity) {
    }

    @Override
    public boolean canChangePower(int move, boolean forced) {
        return !(this.isClashing() && move != 14 || this.activePower != 0 && !forced || this.isDazed(this.self) && move != 6);
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        if (move != 0 && this.self instanceof Mob && !this.hasStandEntity(this.self) && this.canSummonStand()) {
            ((StandUser)this.self).roundabout$setActive(true);
            ((StandUser)this.self).roundabout$summonStand(this.self.m_9236_(), true, false);
        }
        if (!this.self.m_9236_().f_46443_ && (this.isBarraging() || this.isClashing()) && move != 5 && move != 6 && move != 4 && move != 3 && this.attackTimeDuring > -1) {
            this.stopSoundsIfNearby((byte)100, 100.0, false);
        }
        if (this.canChangePower(move, forced)) {
            if (move == 0 || move == 14) {
                this.setPowerNone();
            } else if (move == 1) {
                this.setPowerAttack();
            } else if (move == 3) {
                this.setPowerGuard();
            } else if (move == 4) {
                this.setPowerBarrageCharge();
            } else if (move == 5) {
                this.setPowerBarrage();
            } else if (move == 6) {
                this.setPowerClash();
            } else if (move == 7) {
                this.setPowerSpecial(move);
            } else if (move == 12) {
                this.setPowerMovement(move);
            } else if (move == 13) {
                this.setPowerSneakMovement(move);
            } else if (move == 39) {
                this.setPowerMining(move);
            } else {
                this.setPowerOther(move, this.getActivePower());
            }
        }
        return false;
    }

    public void handleStandAttack(Player player, Entity target) {
    }

    public void handleStandAttack2(Player player, Entity target) {
    }

    public boolean isUsingShield(LivingEntity entity) {
        InteractionHand hand;
        ItemStack item;
        return entity.m_6117_() && (item = entity.m_21120_(hand = entity.m_7655_())).m_41720_() instanceof ShieldItem;
    }

    @Override
    public boolean shouldReset(byte activeP) {
        return this.self.m_6117_() && this.getActivePower() != 6 || this.isDazed(this.self) || ((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity((Entity)this.getSelf());
    }

    @Override
    public void xTryPower(byte index, boolean forced) {
        ((StandUser)this.self).roundabout$tryPower(index, true);
    }

    public boolean canAttack() {
        if (this.attackTimeDuring <= -1) {
            Objects.requireNonNull(this);
            return this.activePowerPhase < 3 || this.attackTime >= this.attackTimeMax;
        }
        return false;
    }

    public boolean setPowerGuard() {
        if (((StandUser)this.self).roundabout$getGuardBroken()) {
            this.animateStand((byte)15);
        } else {
            this.animateStand((byte)10);
        }
        this.attackTimeDuring = 0;
        this.setActivePower((byte)3);
        this.poseStand((byte)2);
        return true;
    }

    public boolean setPowerBarrageCharge() {
        return true;
    }

    public void setPowerBarrage() {
    }

    public boolean isMiningStand() {
        return false;
    }

    public boolean canUseMiningStand() {
        return this.isMiningStand() && (!(this.getSelf().m_21205_().m_41720_() instanceof DiggerItem) && !(this.getSelf().m_21205_().m_41720_() instanceof ShearsItem) || this.getActivePower() == 39 && !(this.getSelf().m_21205_().m_41720_() instanceof ShearsItem));
    }

    public float getPickMiningSpeed() {
        return 5.0f;
    }

    public float getAxeMiningSpeed() {
        return 5.0f;
    }

    public float getSwordMiningSpeed() {
        return 5.0f;
    }

    public float getShovelMiningSpeed() {
        return 5.0f;
    }

    public float getMiningMultiplier() {
        return 1.0f;
    }

    public int getMiningLevel() {
        return 0;
    }

    public void gainExpFromSpecialMining(BlockState $$1, BlockPos $$2) {
        if (!($$1.m_60734_() instanceof IceBlock) && !$$1.m_60713_(Blocks.f_50354_) && !((double)$$1.m_60800_((BlockGetter)this.self.m_9236_(), $$2) < 0.1) && Math.random() > 0.62) {
            this.addEXP(1);
        }
    }

    public boolean setPowerMining(int lastMove) {
        this.attackTimeDuring = 0;
        this.setActivePower((byte)39);
        this.poseStand((byte)1);
        this.animateStand((byte)16);
        return true;
    }

    public float getBonusAttackSpeed() {
        return 1.0f;
    }

    public float getBonusPassiveMiningSpeed() {
        return 1.0f;
    }

    public void gainExpFromStandardMining(BlockState $$1, BlockPos $$2) {
    }

    public int getExpForLevelUp(int currentLevel) {
        return 100;
    }

    public byte getMaxLevel() {
        return 1;
    }

    public void levelUp() {
        if (!this.getSelf().m_9236_().m_5776_()) {
            ((ServerLevel)this.self.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123810_, this.getSelf().m_146892_().f_82479_, this.getSelf().m_146892_().f_82480_, this.getSelf().m_146892_().f_82481_, 20, 0.4, 0.4, 0.4, 0.4);
            this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.LEVELUP_EVENT, SoundSource.PLAYERS, 0.95f, (float)(0.8 + Math.random() * 0.4));
        }
    }

    public int getBarrageRecoilTime() {
        return ClientNetworking.getAppropriateConfig().generalStandSettings.barrageRecoilCooldown;
    }

    @Override
    public boolean isGuarding() {
        return this.activePower == 3;
    }

    public int getKickBarrageWindup() {
        return ClientNetworking.getAppropriateConfig().generalStandSettings.kickBarrageWindup;
    }

    public int getBarrageWindup() {
        return ClientNetworking.getAppropriateConfig().generalStandSettings.barrageWindup;
    }

    public int getBarrageLength() {
        return 60;
    }

    public boolean setPowerAttack() {
        return false;
    }

    public SoundEvent getSoundFromByte(byte soundChoice) {
        if (soundChoice == 1) {
            return this.getBarrageChargeSound();
        }
        if (soundChoice == -2) {
            return ModSounds.GLAIVE_CHARGE_EVENT;
        }
        if (soundChoice == 40) {
            return ModSounds.TIME_STOP_STAR_PLATINUM_EVENT;
        }
        if (soundChoice == 43) {
            return ModSounds.TIME_STOP_THE_WORLD_EVENT;
        }
        if (soundChoice == 44) {
            return ModSounds.TWAU_TIMESTOP_EVENT;
        }
        if (soundChoice == 46) {
            return ModSounds.OVA_LONG_TS_EVENT;
        }
        if (soundChoice == 47) {
            return ModSounds.OVA_SP_TS_EVENT;
        }
        if (soundChoice == 48) {
            return ModSounds.OVA_SHORT_TS_EVENT;
        }
        if (soundChoice == 49) {
            return ModSounds.ARCADE_SHORT_TS_EVENT;
        }
        if (soundChoice == 50) {
            return ModSounds.ARCADE_TIMESTOP_EVENT;
        }
        if (soundChoice == 51) {
            return ModSounds.ARCADE_STAR_PLATINUM_SHORT_TS_EVENT;
        }
        if (soundChoice == 60) {
            return ModSounds.TIME_RESUME_EVENT;
        }
        if (soundChoice == 41) {
            return ModSounds.TIME_STOP_THE_WORLD2_EVENT;
        }
        if (soundChoice == 42) {
            return ModSounds.TIME_STOP_THE_WORLD3_EVENT;
        }
        if (soundChoice == 14) {
            return ModSounds.TIME_RESUME_EVENT;
        }
        if (soundChoice == 61) {
            return ModSounds.OVA_TIME_RESUME_EVENT;
        }
        if (soundChoice == 62) {
            return ModSounds.ARCADE_TIME_RESUME_EVENT;
        }
        if (soundChoice == -3) {
            return ModSounds.STAND_ARROW_CHARGE_EVENT;
        }
        if (soundChoice == -4) {
            return ModSounds.CACKLE_EVENT;
        }
        return null;
    }

    public void playBarrageMissNoise(int hitNumber) {
        if (!this.self.m_9236_().m_5776_() && hitNumber % 2 == 0) {
            this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.STAND_BARRAGE_MISS_EVENT, SoundSource.PLAYERS, 0.95f, (float)(0.8 + Math.random() * 0.4));
        }
    }

    public void playBarrageNoise(int hitNumber, Entity entity) {
        if (!this.self.m_9236_().m_5776_() && hitNumber % 2 == 0) {
            this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.STAND_BARRAGE_HIT_EVENT, SoundSource.PLAYERS, 0.9f, (float)(0.9 + Math.random() * 0.25));
        }
    }

    public void playBarrageEndNoise(float mod, Entity entity) {
        if (!this.self.m_9236_().m_5776_()) {
            this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.STAND_BARRAGE_END_EVENT, SoundSource.PLAYERS, 0.95f + mod, 1.0f);
        }
    }

    public void playBarrageBlockEndNoise(float mod, Entity entity) {
        if (!this.self.m_9236_().m_5776_()) {
            this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.STAND_BARRAGE_END_BLOCK_EVENT, SoundSource.PLAYERS, 0.88f + mod, 1.7f);
        }
    }

    public void playBarrageBlockNoise() {
        if (!this.self.m_9236_().m_5776_()) {
            this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.STAND_BARRAGE_BLOCK_EVENT, SoundSource.PLAYERS, 0.95f, (float)(0.8 + Math.random() * 0.4));
        }
    }

    public void runExtraSoundCode(byte soundChoice) {
    }

    public byte getSoundCancelingGroupByte(byte soundChoice) {
        if (soundChoice == 1) {
            return 100;
        }
        if (soundChoice <= -2) {
            return 104;
        }
        return soundChoice;
    }

    public float getSoundPitchFromByte(byte soundChoice) {
        if (soundChoice == 1) {
            return this.getBarrageChargePitch();
        }
        return 1.0f;
    }

    public float getSoundVolumeFromByte(byte soundChoice) {
        if (soundChoice == 40) {
            return 0.7f;
        }
        if (soundChoice == -4) {
            return 120.0f;
        }
        if (soundChoice == 43 || soundChoice == 44 || soundChoice == 46 || soundChoice == 47 || soundChoice == 48) {
            return 0.7f;
        }
        return 1.0f;
    }

    protected Byte getSummonSound() {
        return (byte)-1;
    }

    public void playSummonSound() {
        if (this.self.m_6047_()) {
            return;
        }
        this.playStandUserOnlySoundsIfNearby(this.getSummonSound(), 10.0, false, false);
    }

    public byte chooseBarrageSound() {
        return 0;
    }

    public float getBarrageChargePitch() {
        return 1.0f / ((float)this.getBarrageWindup() / 20.0f);
    }

    public ResourceLocation getBarrageCryID() {
        return ModSounds.STAND_THEWORLD_MUDA1_SOUND_ID;
    }

    public SoundEvent getBarrageChargeSound() {
        return ModSounds.STAND_BARRAGE_WINDUP_EVENT;
    }

    public ResourceLocation getBarrageChargeID() {
        return ModSounds.STAND_BARRAGE_WINDUP_ID;
    }

    public Byte getLastHitSound() {
        return (byte)-1;
    }

    public ResourceLocation getLastHitID() {
        return ModSounds.STAND_THEWORLD_MUDA3_SOUND_ID;
    }

    public ResourceLocation getSoundID(byte soundNumber) {
        if (soundNumber == 6) {
            return this.getBarrageCryID();
        }
        if (soundNumber == 1) {
            return this.getBarrageChargeID();
        }
        return null;
    }

    public final void playStandUserOnlySoundsIfNearby(byte soundNo, double range, boolean onSelf, boolean isVoice) {
        Player PE;
        LivingEntity livingEntity;
        if (isVoice && (livingEntity = this.getSelf()) instanceof Player && ((IPlayerEntity)(PE = (Player)livingEntity)).roundabout$getMaskInventory().m_8020_(1).m_150930_(ModItems.BLANK_MASK)) {
            return;
        }
        if (!this.self.m_9236_().f_46443_) {
            ServerLevel serverWorld = (ServerLevel)this.self.m_9236_();
            Vec3 userLocation = new Vec3(this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_());
            for (int j = 0; j < serverWorld.m_6907_().size(); ++j) {
                BlockPos blockPos;
                ServerPlayer serverPlayerEntity = (ServerPlayer)((ServerLevel)this.self.m_9236_()).m_6907_().get(j);
                if ((ServerLevel)serverPlayerEntity.m_9236_() != serverWorld || !(blockPos = serverPlayerEntity.m_20183_()).m_203195_((Position)userLocation, range) || ((StandUser)serverPlayerEntity).roundabout$getStandDisc().m_41619_()) continue;
                if (onSelf) {
                    S2CPacketUtil.sendPlaySoundPacket((Player)serverPlayerEntity, serverPlayerEntity.m_19879_(), soundNo);
                    continue;
                }
                S2CPacketUtil.sendPlaySoundPacket((Player)serverPlayerEntity, this.self.m_19879_(), soundNo);
            }
        }
    }

    public final void stopSoundsIfNearby(byte soundNumber, double range, boolean onSelf) {
        if (!this.self.m_9236_().f_46443_) {
            ServerLevel serverWorld = (ServerLevel)this.self.m_9236_();
            Vec3 userLocation = new Vec3(this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_());
            for (int j = 0; j < serverWorld.m_6907_().size(); ++j) {
                BlockPos blockPos;
                ServerPlayer serverPlayerEntity = (ServerPlayer)((ServerLevel)this.self.m_9236_()).m_6907_().get(j);
                if ((ServerLevel)serverPlayerEntity.m_9236_() != serverWorld || !(blockPos = serverPlayerEntity.m_20183_()).m_203195_((Position)userLocation, range)) continue;
                if (!onSelf) {
                    S2CPacketUtil.sendCancelSoundPacket((Player)serverPlayerEntity, this.self.m_19879_(), soundNumber);
                    continue;
                }
                S2CPacketUtil.sendCancelSoundPacket((Player)serverPlayerEntity, serverPlayerEntity.m_19879_(), soundNumber);
            }
        }
    }

    public final void playSoundsIfNearby(byte soundNo, double range, boolean onSelf, boolean isVoice) {
        Player PE;
        LivingEntity livingEntity;
        if (isVoice && (livingEntity = this.getSelf()) instanceof Player && ((IPlayerEntity)(PE = (Player)livingEntity)).roundabout$getMaskInventory().m_8020_(1).m_150930_(ModItems.BLANK_MASK)) {
            return;
        }
        if (!this.self.m_9236_().f_46443_) {
            ServerLevel serverWorld = (ServerLevel)this.self.m_9236_();
            Vec3 userLocation = new Vec3(this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_());
            for (int j = 0; j < serverWorld.m_6907_().size(); ++j) {
                BlockPos blockPos;
                ServerPlayer serverPlayerEntity = (ServerPlayer)((ServerLevel)this.self.m_9236_()).m_6907_().get(j);
                if ((ServerLevel)serverPlayerEntity.m_9236_() != serverWorld || !(blockPos = serverPlayerEntity.m_20183_()).m_203195_((Position)userLocation, range)) continue;
                if (onSelf) {
                    S2CPacketUtil.sendPlaySoundPacket((Player)serverPlayerEntity, serverPlayerEntity.m_19879_(), soundNo);
                    continue;
                }
                S2CPacketUtil.sendPlaySoundPacket((Player)serverPlayerEntity, this.self.m_19879_(), soundNo);
            }
        }
    }

    public final void playSoundsIfNearby(byte soundNo, double range, boolean onSelf) {
        this.playSoundsIfNearby(soundNo, range, onSelf, false);
    }

    public void playBarrageCrySound() {
        byte barrageCrySound;
        if (!this.self.m_9236_().m_5776_() && (barrageCrySound = this.chooseBarrageSound()) != -1) {
            this.playStandUserOnlySoundsIfNearby(barrageCrySound, 27.0, false, true);
        }
    }

    public void playBarrageClashSound() {
        if (!this.self.m_9236_().m_5776_()) {
            // empty if block
        }
    }

    public void playBarrageChargeSound() {
        SoundEvent barrageChargeSound;
        if (!this.self.m_9236_().m_5776_() && (barrageChargeSound = this.getBarrageChargeSound()) != null) {
            this.playSoundsIfNearby((byte)1, 27.0, false);
        }
    }

    public List<Byte> getSkinList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)0);
        return $$1;
    }

    public Component getSkinName(byte skinId) {
        return Component.m_237119_();
    }

    public void rollSkin() {
    }

    public List<Byte> getPosList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)0);
        $$1.add((byte)1);
        return $$1;
    }

    public Component getPosName(byte posID) {
        if (posID == 1) {
            return Component.m_237115_((String)"idle.roundabout.battle");
        }
        if (posID == 2) {
            return Component.m_237115_((String)"idle.roundabout.floaty");
        }
        if (posID == 3) {
            return Component.m_237115_((String)"idle.roundabout.star_platinum");
        }
        if (posID == 4) {
            return Component.m_237115_((String)"idle.roundabout.arms_only");
        }
        return Component.m_237115_((String)"idle.roundabout.passive");
    }

    public boolean replaceHudActively() {
        return false;
    }

    public void getReplacementHUD(GuiGraphics context, Player cameraPlayer, int screenWidth, int screenHeight, int x) {
    }

    public boolean returnFakeStandForHud() {
        return false;
    }

    public StandEntity getStandForHUDIfFake() {
        Player PL;
        LivingEntity livingEntity;
        if (this.displayStand == null) {
            this.displayStand = (StandEntity)ModEntities.SURVIVOR.m_20615_(this.getSelf().m_9236_());
        }
        if ((livingEntity = this.self) instanceof Player && ((IPlayerEntity)(PL = (Player)livingEntity)).roundabout$getStandSkin() != this.displayStand.getSkin()) {
            this.displayStand = (StandEntity)ModEntities.SURVIVOR.m_20615_(this.getSelf().m_9236_());
            this.displayStand.setSkin(((IPlayerEntity)PL).roundabout$getStandSkin());
        }
        return this.displayStand;
    }

    public boolean rendersPlayer() {
        return false;
    }

    public StandEntity getStandForHUD() {
        if (this.returnFakeStandForHud()) {
            return this.getStandForHUDIfFake();
        }
        return this.getStandUserSelf().roundabout$getStand();
    }

    public int getDisplayPowerInventoryScale() {
        return 30;
    }

    public int getDisplayPowerInventoryYOffset() {
        return 0;
    }

    public Component ifWipListDevStatus() {
        return null;
    }

    public Component ifWipListDev() {
        return null;
    }

    public boolean isWip() {
        return false;
    }

    public boolean getCreative() {
        Player PE;
        LivingEntity livingEntity = this.self;
        return livingEntity instanceof Player && (PE = (Player)livingEntity).m_7500_();
    }

    public void poseStand(byte r) {
        StandEntity stand = this.getStandEntity(this.self);
        if (stand instanceof FollowingStandEntity) {
            FollowingStandEntity FE = (FollowingStandEntity)stand;
            FE.setOffsetType(r);
        }
    }

    public void animateStand(byte r) {
        StandEntity stand = this.getStandEntity(this.self);
        if (Objects.nonNull(stand)) {
            stand.setAnimation(r);
        }
    }

    public byte getAnimation() {
        StandEntity stand = this.getStandEntity(this.self);
        if (Objects.nonNull(stand)) {
            return stand.getAnimation();
        }
        return -1;
    }

    @Override
    public boolean setPowerNone() {
        this.attackTimeDuring = -1;
        this.setActivePower((byte)0);
        this.poseStand((byte)0);
        this.animateStand((byte)0);
        return true;
    }

    public boolean canExecuteMoveWithLevel(int minLevel) {
        if (!ClientNetworking.getAppropriateConfig().standLevelingSettings.enableStandLeveling.booleanValue()) {
            return true;
        }
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            Player pl = (Player)livingEntity;
            return ((IPlayerEntity)pl).roundabout$getStandLevel() >= minLevel || this.hasGoldenDisc() || pl.m_7500_();
        }
        return true;
    }

    @Override
    public boolean isPacketPlayer() {
        if (this.self.m_9236_().f_46443_) {
            Minecraft mc = Minecraft.m_91087_();
            return mc.f_91074_ != null && mc.f_91074_.m_19879_() == this.self.m_19879_();
        }
        return false;
    }

    public void addEXP(int amt, LivingEntity ent) {
        if (!((StandUser)ent).roundabout$getStandDisc().m_41619_() && (ent instanceof Monster || ent instanceof NeutralMob)) {
            if (ent.m_21233_() >= 100.0f) {
                amt = (int)((double)amt * 0.5);
            }
            this.addEXP(amt * 5);
        } else {
            if (ent.m_21233_() >= 100.0f) {
                amt = (int)((double)amt * 0.5);
            }
            this.addEXP(amt);
        }
    }

    public void addEXP(int amt) {
        Player PE;
        ItemStack stack;
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player && !(stack = ((StandUser)(PE = (Player)livingEntity)).roundabout$getStandDisc()).m_41619_() && !this.hasGoldenDisc()) {
            IPlayerEntity ipe = (IPlayerEntity)PE;
            ipe.roundabout$addStandExp(amt);
        }
    }

    public boolean tryPlaceBlock(BlockPos pos) {
        BlockState state;
        if (!(this.self.m_9236_().m_5776_() || !(state = this.getSelf().m_9236_().m_8055_(pos)).m_60795_() && (!state.m_247087_() || !this.getIsGamemodeApproriateForGrief() || state.m_278721_() || !this.getSelf().m_9236_().m_46469_().m_46207_(ModGamerules.ROUNDABOUT_STAND_GRIEFING) || this.getSelf() instanceof Player && ((Player)this.getSelf()).m_36187_(this.getSelf().m_9236_(), pos, ((ServerPlayer)this.getSelf()).f_8941_.m_9290_()) || this.getSelf() instanceof Player && !this.getSelf().m_9236_().m_7966_((Player)this.getSelf(), pos)))) {
            LivingEntity livingEntity = this.self;
            if (livingEntity instanceof Player) {
                Player p = (Player)livingEntity;
                return MainUtil.canPlaceOnClaim(p, new BlockHitResult(new Vec3((double)pos.m_121945_(Direction.DOWN).m_123341_(), (double)pos.m_121945_(Direction.DOWN).m_123342_(), (double)pos.m_121945_(Direction.DOWN).m_123343_()), Direction.UP, pos.m_121945_(Direction.DOWN), false));
            }
            return true;
        }
        return false;
    }

    public boolean getIsGamemodeApproriateForGrief() {
        return (!(this.getSelf() instanceof Player) || ((ServerPlayer)this.getSelf()).f_8941_.m_9290_() != GameType.SPECTATOR && ((ServerPlayer)this.getSelf()).f_8941_.m_9290_() != GameType.ADVENTURE) && this.getSelf().m_9236_().m_46469_().m_46207_(ModGamerules.ROUNDABOUT_STAND_GRIEFING);
    }

    public void takeKnockbackWithY(Entity entity, double strength, double x, double y, double z) {
        if (entity instanceof LivingEntity) {
            double d;
            strength *= (double)((float)(1.0 - ((LivingEntity)entity).m_21133_(Attributes.f_22278_)));
            if (d <= 0.0) {
                return;
            }
        }
        if (MainUtil.isKnockbackImmune(entity)) {
            return;
        }
        entity.f_19864_ = true;
        Vec3 vec3d2 = new Vec3(x, y, z).m_82541_().m_82490_(strength);
        entity.m_20334_(-vec3d2.f_82479_, -vec3d2.f_82480_, -vec3d2.f_82481_);
        entity.f_19812_ = true;
    }

    public void takeKnockbackUp(Entity entity, double strength) {
        if (entity instanceof LivingEntity) {
            double d;
            strength *= (double)((float)(1.0 - ((LivingEntity)entity).m_21133_(Attributes.f_22278_)));
            if (d <= 0.0) {
                return;
            }
        }
        if (MainUtil.isKnockbackImmune(entity)) {
            return;
        }
        entity.f_19812_ = true;
        Vec3 vec3d2 = new Vec3(0.0, strength, 0.0).m_82541_().m_82490_(strength);
        entity.m_20334_(vec3d2.f_82479_, vec3d2.f_82480_, vec3d2.f_82481_);
    }

    public void takeDeterminedKnockbackWithY(LivingEntity user, Entity target, float knockbackStrength) {
        float xRot = !target.m_20096_() ? user.m_146909_() : -15.0f;
        this.takeKnockbackWithY(target, knockbackStrength, Mth.m_14031_((float)(user.m_146908_() * ((float)Math.PI / 180))), Mth.m_14031_((float)(xRot * ((float)Math.PI / 180))), -Mth.m_14089_((float)(user.m_146908_() * ((float)Math.PI / 180))));
    }

    public void takeDeterminedKnockback(LivingEntity user, Entity target, float knockbackStrength) {
        if (target instanceof LivingEntity) {
            float f;
            knockbackStrength *= (float)(1.0 - ((LivingEntity)target).m_21133_(Attributes.f_22278_));
            if ((double)f <= 0.0) {
                return;
            }
        }
        if (MainUtil.isKnockbackImmune(target)) {
            return;
        }
        target.f_19864_ = true;
        Vec3 vec3d2 = new Vec3((double)Mth.m_14031_((float)(user.m_146908_() * ((float)Math.PI / 180))), 0.0, (double)(-Mth.m_14089_((float)(user.m_146908_() * ((float)Math.PI / 180))))).m_82541_().m_82490_((double)knockbackStrength);
        target.m_20334_(-vec3d2.f_82479_, target.m_20096_() ? 0.28 : 0.0, -vec3d2.f_82481_);
        target.f_19812_ = true;
    }

    public float levelupDamageMod(float damage) {
        LivingEntity livingEntity;
        int percent = ClientNetworking.getAppropriateConfig().standLevelingSettings.bonusStandDmgByMaxLevel;
        if (percent > 0 && (livingEntity = this.self) instanceof Player) {
            byte maxlevel;
            Player PE = (Player)livingEntity;
            if (this.getMaxLevel() >= 1 && (maxlevel = this.getMaxLevel()) > 1) {
                byte level = ((IPlayerEntity)PE).roundabout$getStandLevel();
                ItemStack sdisc = ((StandUser)PE).roundabout$getStandDisc();
                if (this.hasGoldenDisc()) {
                    level = maxlevel;
                }
                damage *= (float)(1.0 + (double)(((float)(maxlevel - 1) - (float)(maxlevel - 1 - (level - 1))) / (float)(maxlevel - 1)) * (0.01 * (double)percent));
            }
        }
        return damage;
    }

    @Override
    public ResourceLocation getIconYes(int slot) {
        return StandIcons.SQUARE_ICON;
    }

    public BlockHitResult getAheadVec(float distOut) {
        Vec3 vec3d = this.self.m_20299_(1.0f);
        Vec3 vec3d2 = this.self.m_20252_(1.0f);
        return this.getSelf().m_9236_().m_45547_(new ClipContext(vec3d, vec3d.m_82520_(vec3d2.f_82479_ * (double)distOut, vec3d2.f_82480_ * (double)distOut, vec3d2.f_82481_ * (double)distOut), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.getSelf()));
    }

    public float getLevelMultiplier() {
        return (float)((double)ClientNetworking.getAppropriateConfig().standLevelingSettings.standExperienceNeededForLevelupMultiplier.intValue() * 0.01);
    }

    public final void spreadRadialClientPacket(double range, boolean skipSelf, String packet) {
        if (!this.self.m_9236_().f_46443_) {
            ServerLevel serverWorld = (ServerLevel)this.self.m_9236_();
            Vec3 userLocation = new Vec3(this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_());
            for (int j = 0; j < serverWorld.m_6907_().size(); ++j) {
                BlockPos blockPos;
                ServerPlayer serverPlayerEntity = (ServerPlayer)((ServerLevel)this.self.m_9236_()).m_6907_().get(j);
                if ((ServerLevel)serverPlayerEntity.m_9236_() != serverWorld || skipSelf && this.self.m_7306_((Entity)serverPlayerEntity) || !(blockPos = serverPlayerEntity.m_20183_()).m_203195_((Position)userLocation, range)) continue;
                ModMessageEvents.sendToPlayer(serverPlayerEntity, packet, new Object[0]);
            }
        }
    }

    public final void spreadRadialClientPacket(double range, boolean skipSelf, String packet, Object ... vargs) {
        if (!this.self.m_9236_().f_46443_) {
            ServerLevel serverWorld = (ServerLevel)this.self.m_9236_();
            Vec3 userLocation = new Vec3(this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_());
            for (int j = 0; j < serverWorld.m_6907_().size(); ++j) {
                BlockPos blockPos;
                ServerPlayer serverPlayerEntity = (ServerPlayer)((ServerLevel)this.self.m_9236_()).m_6907_().get(j);
                if ((ServerLevel)serverPlayerEntity.m_9236_() != serverWorld || skipSelf && this.self.m_7306_((Entity)serverPlayerEntity) || !(blockPos = serverPlayerEntity.m_20183_()).m_203195_((Position)userLocation, range)) continue;
                ModMessageEvents.sendToPlayer(serverPlayerEntity, packet, vargs);
            }
        }
    }

    public boolean isWorthinessType(LivingEntity LE) {
        if (this.worthinessType() == 2) {
            return MainUtil.isHumanoid(LE);
        }
        return true;
    }

    public StandPowers generateStandPowersPre(LivingEntity entity) {
        ((StandUser)entity).roundabout$setGuardPoints(this.getMaxGuardPoints());
        StandPowers powers = this.generateStandPowers(entity);
        return powers.isStandEnabled() ? powers : new StandPowers(entity);
    }

    public boolean setPowerClash() {
        this.attackTimeDuring = 0;
        this.setActivePower((byte)6);
        this.poseStand((byte)3);
        this.setClashProgress(0.0f);
        this.clashIncrement = 0;
        this.clashMod = (int)Math.round(Math.random() * 8.0);
        this.animateStand((byte)12);
        if (this.self instanceof Player && !this.self.m_9236_().f_46443_) {
            ((ServerPlayer)this.self).m_5661_((Component)Component.m_237115_((String)"text.roundabout.barrage_clash"), true);
        }
        return true;
    }

    public void initiateClash(Entity entity) {
        ((StandUser)entity).roundabout$getStandPowers().setClashOp(this.self);
        ((StandUser)this.self).roundabout$getStandPowers().setClashOp((LivingEntity)entity);
        this.clashStarter = 0;
        ((StandUser)entity).roundabout$getStandPowers().clashStarter = 1;
        ((StandUser)entity).roundabout$tryPower(6, true);
        ((StandUser)this.self).roundabout$tryPower(6, true);
        StandEntity standEntity = ((StandUser)entity).roundabout$getStand();
        StandEntity standSelf = ((StandUser)this.self).roundabout$getStand();
        if (standEntity != null && standSelf != null) {
            ((StandUser)entity).roundabout$getStandPowers().playBarrageClashSound();
            ((StandUser)this.self).roundabout$getStandPowers().playBarrageClashSound();
            Vec3 CenterPoint = entity.m_20182_().m_82549_(this.self.m_20182_()).m_82490_(0.5);
            Vec3 entityPoint = this.offsetBarrageVector(CenterPoint.m_82546_(CenterPoint.m_82546_(entity.m_20182_()).m_82541_().m_82490_(0.95)), this.getLookAtEntityYaw(entity, (Entity)this.self));
            Vec3 selfPoint = this.offsetBarrageVector(CenterPoint.m_82546_(CenterPoint.m_82546_(this.self.m_20182_()).m_82541_().m_82490_(0.95)), this.getLookAtEntityYaw((Entity)this.self, entity));
            standEntity.m_20343_(entityPoint.m_7096_(), entityPoint.m_7098_() + (double)this.getYOffSet((LivingEntity)standEntity), entityPoint.m_7094_());
            Direction gdir = ((IGravityEntity)this.self).roundabout$getGravityDirection();
            Vec2 grot = new Vec2(this.getLookAtEntityYaw((Entity)standEntity, (Entity)standSelf), this.getLookAtEntityPitch((Entity)standEntity, (Entity)standSelf));
            grot = RotationUtil.rotWorldToPlayer(grot, gdir);
            standEntity.m_146926_(grot.f_82471_);
            standEntity.m_146922_(grot.f_82470_);
            grot = new Vec2(this.getLookAtEntityYaw((Entity)standSelf, (Entity)standEntity), this.getLookAtEntityPitch((Entity)standSelf, (Entity)standEntity));
            grot = RotationUtil.rotWorldToPlayer(grot, gdir);
            standSelf.m_20343_(selfPoint.m_7096_(), selfPoint.m_7098_() + (double)this.getYOffSet((LivingEntity)standSelf), selfPoint.m_7094_());
            standSelf.m_146926_(grot.f_82471_);
            standSelf.m_146922_(grot.f_82470_);
        }
    }

    private Vec3 offsetBarrageVector(Vec3 vec3d, float yaw) {
        Vec3 vec3d2 = DamageHandler.getRotationVector(0.0f, yaw + 90.0f);
        return vec3d.m_82520_(vec3d2.f_82479_ * 0.3, 0.0, vec3d2.f_82481_ * 0.3);
    }

    public void breakClash(LivingEntity winner, LivingEntity loser) {
        if (this.StandDamageEntityAttack((Entity)loser, this.getClashBreakStrength((Entity)loser), 1.0E-4f, (Entity)winner)) {
            ((StandUser)winner).roundabout$getStandPowers().stopSoundsIfNearby((byte)100, 100.0, false);
            ((StandUser)loser).roundabout$getStandPowers().stopSoundsIfNearby((byte)100, 100.0, false);
            ((StandUser)winner).roundabout$getStandPowers().playBarrageEndNoise(0.0f, (Entity)loser);
            this.takeDeterminedKnockbackWithY(winner, (Entity)loser, this.getBarrageFinisherKnockback());
            ((StandUser)winner).roundabout$getStandPowers().animateStand((byte)13);
            ((StandUser)loser).roundabout$tryPower(0, true);
        }
    }

    public void TieClash(LivingEntity user1, LivingEntity user2) {
        ((StandUser)user1).roundabout$getStandPowers().stopSoundsIfNearby((byte)100, 100.0, false);
        ((StandUser)user2).roundabout$getStandPowers().stopSoundsIfNearby((byte)100, 100.0, false);
        ((StandUser)user1).roundabout$getStandPowers().playBarrageEndNoise(0.0f, (Entity)user2);
        ((StandUser)user2).roundabout$getStandPowers().playBarrageEndNoise(-0.05f, (Entity)user1);
        user1.f_19864_ = true;
        user2.f_19864_ = true;
        user1.m_147240_((double)0.55f, user2.m_20185_() - user1.m_20185_(), user2.m_20189_() - user1.m_20189_());
        user2.m_147240_((double)0.55f, user1.m_20185_() - user2.m_20185_(), user1.m_20189_() - user2.m_20189_());
    }

    public void updateClashing() {
        LivingEntity entity;
        if (this.getStandEntity(this.self) != null) {
            // empty if block
        }
        if ((entity = this.getClashOp()) != null && entity.m_6084_() && this.self.m_6084_()) {
            if (this.attackTimeDuring <= 60) {
                StandEntity standEntity = ((StandUser)entity).roundabout$getStand();
                StandEntity standSelf = ((StandUser)this.self).roundabout$getStand();
                if (standSelf != null && standEntity != null && !this.self.m_9236_().f_46443_) {
                    standSelf.m_146926_(this.getLookAtEntityPitch((Entity)standSelf, (Entity)standEntity));
                    standSelf.m_146922_(this.getLookAtEntityYaw((Entity)standSelf, (Entity)standEntity));
                    standEntity.m_146926_(this.getLookAtEntityPitch((Entity)standEntity, (Entity)standSelf));
                    standEntity.m_146922_(this.getLookAtEntityYaw((Entity)standEntity, (Entity)standSelf));
                }
                if (!(this.self instanceof Player)) {
                    this.RoundaboutEnemyClash();
                }
                if (!this.self.m_9236_().f_46443_) {
                    if (this.getClashDone() && ((StandUser)entity).roundabout$getStandPowers().getClashDone() || !((StandUser)this.self).roundabout$getActive() || !((StandUser)entity).roundabout$getActive()) {
                        this.updateClashing2();
                    } else {
                        this.playBarrageNoise(this.attackTimeDuring + this.clashStarter, (Entity)entity);
                    }
                }
            } else if (!this.self.m_9236_().f_46443_) {
                this.updateClashing2();
            }
        } else {
            this.endClash();
        }
    }

    public void endClash() {
        if (!this.self.m_9236_().f_46443_) {
            ((StandUser)this.self).roundabout$tryPower(14, true);
            LivingEntity entity = this.getClashOp();
            if (entity != null) {
                ((StandUser)this.self).roundabout$tryPower(14, true);
            }
        }
    }

    private void updateClashing2() {
        if (this.getClashOp() != null) {
            boolean thisActive = ((StandUser)this.self).roundabout$getActive();
            boolean opActive = ((StandUser)this.getClashOp()).roundabout$getActive();
            if (thisActive && !opActive) {
                this.breakClash(this.self, this.getClashOp());
            } else if (!thisActive && opActive) {
                this.breakClash(this.getClashOp(), this.self);
            } else if (thisActive && opActive) {
                if (this.getClashProgress() == ((StandUser)this.getClashOp()).roundabout$getStandPowers().getClashProgress()) {
                    this.TieClash(this.self, this.getClashOp());
                } else if (this.getClashProgress() > ((StandUser)this.getClashOp()).roundabout$getStandPowers().getClashProgress()) {
                    this.breakClash(this.self, this.getClashOp());
                } else {
                    this.breakClash(this.getClashOp(), this.self);
                }
            }
            ((StandUser)this.self).roundabout$setAttackTimeDuring(-10);
            ((StandUser)this.getClashOp()).roundabout$setAttackTimeDuring(-10);
            ((StandUser)this.self).roundabout$getStandPowers().syncActivePower();
            ((StandUser)this.getClashOp()).roundabout$getStandPowers().syncActivePower();
        }
    }

    public boolean getClashDone() {
        return this.clashDone;
    }

    public void setClashDone(boolean clashDone) {
        this.clashDone = clashDone;
    }

    @Nullable
    public LivingEntity getClashOp() {
        return this.clashOp;
    }

    public void setClashOp(@Nullable LivingEntity clashOp) {
        this.clashOp = clashOp;
    }

    public float getClashOpProgress() {
        return this.clashOpProgress;
    }

    public void setClashOpProgress(float clashOpProgress1) {
        this.clashOpProgress = clashOpProgress1;
    }

    public float getClashProgress() {
        return this.clashProgress;
    }

    public void setClashProgress(float clashProgress1) {
        LivingEntity livingEntity;
        this.clashProgress = clashProgress1;
        if (!this.self.m_9236_().f_46443_ && this.clashOp != null && (livingEntity = this.clashOp) instanceof ServerPlayer) {
            ServerPlayer SP = (ServerPlayer)livingEntity;
            S2CPacketUtil.updateBarrageClashS2C((Player)SP, this.self.m_19879_(), this.clashProgress);
        }
    }

    public boolean isClashing() {
        return this.activePower == 6 && this.attackTimeDuring > -1;
    }

    public boolean isBarrageCharging() {
        return this.activePower == 4;
    }

    public boolean isBarraging() {
        return this.activePower == 5 || this.activePower == 4;
    }

    public boolean isBarrageAttacking() {
        return this.activePower == 5;
    }

    public void updateBarrageCharge() {
        if (this.attackTimeDuring >= this.getBarrageWindup()) {
            ((StandUser)this.self).roundabout$tryPower(5, true);
        }
    }

    public void updateBarrage() {
        if (this.attackTimeDuring == -2 && this.getSelf() instanceof Player) {
            ((StandUser)this.self).roundabout$tryPower(3, true);
        } else if (this.attackTimeDuring > this.getBarrageLength()) {
            this.attackTimeDuring = -20;
        } else if (this.attackTimeDuring > 0) {
            this.setAttackTime(this.getBarrageRecoilTime() - 1 - Math.round((float)this.attackTimeDuring / (float)this.getBarrageLength() * (float)(this.getBarrageRecoilTime() - 1)));
            this.standBarrageHit();
        }
    }

    private void RoundaboutEnemyClash() {
        if (this.isClashing()) {
            if (this.clashIncrement < 0) {
                ++this.clashIncrement;
                if (this.clashIncrement == 0) {
                    this.setClashProgress(0.0f);
                }
            }
            ++this.clashIncrement;
            if (this.clashIncrement < 6 + this.clashMod) {
                this.setClashProgress(this.clashIncrement < 10 ? (float)this.clashIncrement * 0.1f : 0.8f + 2.0f / (float)(this.clashIncrement - 9) * 0.1f);
            } else {
                this.setClashDone(true);
            }
        }
    }

    public boolean preCanInterruptPower(DamageSource sauce, Entity interrupter, boolean isStandDamage) {
        LivingEntity LE;
        StandUser user;
        if (ClientNetworking.getAppropriateConfig().generalStandSettings.spiritOutInterruption.booleanValue() && sauce != null && interrupter instanceof LivingEntity && (user = (StandUser)(LE = (LivingEntity)interrupter)).roundabout$hasAStand() && !user.roundabout$getActive()) {
            return false;
        }
        boolean interrupt = false;
        if (interrupter != null) {
            if (this.isBarraging() && ClientNetworking.getAppropriateConfig().generalStandSettings.barragesAreAlwaysInterruptable.booleanValue()) {
                ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
                return true;
            }
            if (isStandDamage && ClientNetworking.getAppropriateConfig().generalStandSettings.standsInterruptSomeStandAttacks.booleanValue()) {
                interrupt = true;
            } else if (this instanceof TWAndSPSharedPowers && this.getActivePower() == 7 && ClientNetworking.getAppropriateConfig().timeStopSettings.timeStopIsAlwaysInterruptable.booleanValue()) {
                interrupt = true;
            } else if (interrupter instanceof Player && ClientNetworking.getAppropriateConfig().generalStandSettings.playersInterruptSomeStandAttacks.booleanValue()) {
                interrupt = true;
            } else if (interrupter instanceof Mob && ClientNetworking.getAppropriateConfig().generalStandSettings.mobsInterruptSomeStandAttacks.booleanValue()) {
                interrupt = true;
            }
        } else {
            interrupt = true;
        }
        if (interrupt) {
            return this.canInterruptPower();
        }
        return false;
    }

    @Override
    public void preButtonInput4(boolean keyIsDown, Options options) {
        if (this.hasStandActive(this.getSelf()) && !this.isClashing() && !((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity((Entity)this.getSelf())) {
            ((StandUser)this.getSelf()).roundabout$setIdleTime(0);
            this.buttonInput4(keyIsDown, options);
        }
    }

    @Override
    public void preButtonInput3(boolean keyIsDown, Options options) {
        if (this.hasStandActive(this.getSelf()) && !this.isClashing() && !((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity((Entity)this.getSelf())) {
            ((StandUser)this.getSelf()).roundabout$setIdleTime(0);
            this.buttonInput3(keyIsDown, options);
        }
    }

    @Override
    public void preButtonInput2(boolean keyIsDown, Options options) {
        if (this.hasStandActive(this.getSelf()) && !this.isClashing() && !((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity((Entity)this.getSelf())) {
            ((StandUser)this.getSelf()).roundabout$setIdleTime(0);
            this.buttonInput2(keyIsDown, options);
        }
    }

    @Override
    public void preButtonInput1(boolean keyIsDown, Options options) {
        if (this.hasStandActive(this.getSelf()) && !this.isClashing() && !((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity((Entity)this.getSelf())) {
            ((StandUser)this.getSelf()).roundabout$setIdleTime(0);
            this.buttonInput1(keyIsDown, options);
        }
    }

    public void preCheckButtonInputAttack(boolean keyIsDown, Options options) {
        if (this.hasStandActive(this.getSelf()) && !this.isGuarding()) {
            this.buttonInputAttack(keyIsDown, options);
        }
    }

    public void preCheckButtonInputUse(boolean keyIsDown, Options options) {
        if (this.hasStandActive(this.getSelf())) {
            this.buttonInputUse(keyIsDown, options);
        }
    }

    public void preCheckButtonInputBarrage(boolean keyIsDown, Options options) {
        if (this.hasStandActive(this.getSelf())) {
            this.buttonInputBarrage(keyIsDown, options);
        }
    }

    public boolean preCheckButtonInputGuard(boolean keyIsDown, Options options) {
        if (this.hasStandActive(this.getSelf())) {
            return this.buttonInputGuard(keyIsDown, options);
        }
        return false;
    }

    public void tickOverlayTicks() {
        if (this.timeRewindOverlayTicks > -1) {
            ++this.timeRewindOverlayTicks;
            if (this.timeRewindOverlayTicks >= 20) {
                this.timeRewindOverlayTicks = -1;
            }
        }
    }

    public float getOverlayFromOverlayTicks(float delta) {
        float ticks = (float)this.timeRewindOverlayTicks + delta;
        float distanceFromPeak = Math.abs(ticks - 10.0f);
        float normalized = 1.0f - distanceFromPeak / 10.0f;
        return Math.max(0.0f, Math.min(1.0f, normalized)) * 0.45f;
    }

    public Vec3 getRandPos(Entity ent) {
        Vec3 funnyVec = new Vec3(0.0, (double)ent.m_20206_() * 0.65, 0.0);
        Direction gd = ((IGravityEntity)ent).roundabout$getGravityDirection();
        if (gd != Direction.DOWN) {
            funnyVec = RotationUtil.vecPlayerToWorld(funnyVec, gd);
        }
        return new Vec3(ent.m_20208_(1.0) + funnyVec.f_82479_, this.getRandomY(ent, 0.33) + funnyVec.f_82480_, ent.m_20262_(1.0) + funnyVec.f_82481_);
    }

    public double getRandomY(Entity ent, double $$0) {
        return ent.m_20227_((2.0 * Math.random() - 1.0) * $$0);
    }

    public SimpleParticleType getImpactParticle() {
        float random = (float)(Math.random() * 3.0);
        SimpleParticleType punchpart = random > 2.0f ? ModParticles.PUNCH_IMPACT_A : (random > 1.0f ? ModParticles.PUNCH_IMPACT_B : ModParticles.PUNCH_IMPACT_C);
        return punchpart;
    }

    public void hitParticles(Entity entity) {
        Vec3 vec = this.getRandPos(entity);
        ((ServerLevel)this.self.m_9236_()).m_8767_((ParticleOptions)this.getImpactParticle(), vec.f_82479_, vec.f_82480_, vec.f_82481_, 1, 0.0, 0.0, 0.0, 1.0);
    }

    public void hitParticlesCenter(Entity entity) {
        Vec3 funnyVec = new Vec3(0.0, (double)entity.m_20206_() * 0.65, 0.0);
        Direction gd = ((IGravityEntity)entity).roundabout$getGravityDirection();
        if (gd != Direction.DOWN) {
            funnyVec = RotationUtil.vecPlayerToWorld(funnyVec, gd);
        }
        ((ServerLevel)this.self.m_9236_()).m_8767_((ParticleOptions)this.getImpactParticle(), entity.m_20185_() + funnyVec.f_82479_, entity.m_20186_() + funnyVec.f_82480_, entity.m_20189_() + funnyVec.f_82481_, 1, 0.0, 0.0, 0.0, 1.0);
    }

    public void barrageImpact(Entity entity, int hitNumber) {
        if (this.isBarrageAttacking()) {
            if (this.bonusBarrageConditions()) {
                boolean lastHit;
                boolean sideHit = false;
                if (hitNumber > 1000) {
                    if (!ClientNetworking.getAppropriateConfig().generalStandSettings.barrageHasAreaOfEffect.booleanValue()) {
                        return;
                    }
                    hitNumber -= 1000;
                    sideHit = true;
                }
                boolean bl = lastHit = hitNumber >= this.getBarrageLength();
                if (entity != null) {
                    if (entity instanceof LivingEntity && ((StandUser)entity).roundabout$isBarraging() && ((StandUser)entity).roundabout$getAttackTimeDuring() > -1 && !((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity(entity)) {
                        this.initiateClash(entity);
                    } else {
                        float pow;
                        this.hitParticles(entity);
                        float knockbackStrength = 0.0f;
                        Vec3 prevVelocity = entity.m_20184_();
                        if (lastHit) {
                            pow = this.getBarrageFinisherStrength(entity);
                            knockbackStrength = this.getBarrageFinisherKnockback();
                        } else {
                            pow = this.getBarrageHitStrength(entity);
                            float mn = this.getBarrageLength() - hitNumber;
                            mn = mn == 0.0f ? 0.015f : 0.015f / mn;
                            knockbackStrength = 0.014f - mn;
                        }
                        if (sideHit) {
                            pow /= 4.0f;
                            knockbackStrength /= 6.0f;
                        }
                        if (this.StandRushDamageEntityAttack(entity, pow, 1.0E-4f, (Entity)this.self)) {
                            if (entity instanceof LivingEntity) {
                                LivingEntity LE = (LivingEntity)entity;
                                if (lastHit) {
                                    this.setDazed((LivingEntity)entity, (byte)0);
                                    if (!sideHit) {
                                        ((StandUser)LE).roundabout$setDestructionTrailTicks(80);
                                        this.addEXP(8, LE);
                                        this.playBarrageEndNoise(0.0f, entity);
                                    }
                                } else {
                                    this.setDazed((LivingEntity)entity, (byte)3);
                                    if (!sideHit) {
                                        this.playBarrageNoise(hitNumber, entity);
                                    }
                                }
                            }
                            this.barrageImpact2(entity, lastHit, knockbackStrength);
                        } else if (lastHit) {
                            this.knockShield2(entity, 200);
                            if (!sideHit) {
                                this.playBarrageBlockEndNoise(0.0f, entity);
                            }
                        } else {
                            entity.m_20256_(prevVelocity);
                            this.playBarrageBlockNoise();
                        }
                    }
                } else if (!sideHit) {
                    this.playBarrageMissNoise(hitNumber);
                }
                if (lastHit) {
                    this.animateStand((byte)13);
                    this.attackTimeDuring = -10;
                }
            } else {
                ((StandUser)this.self).roundabout$tryPower(0, true);
            }
        } else {
            ((StandUser)this.self).roundabout$tryPower(0, true);
        }
    }

    public void barrageImpact2(Entity entity, boolean lastHit, float knockbackStrength) {
        if (entity instanceof LivingEntity) {
            if (lastHit) {
                this.takeDeterminedKnockbackWithY(this.self, entity, knockbackStrength);
            } else {
                this.takeKnockbackUp(entity, knockbackStrength);
            }
        }
    }

    public void standBarrageHit() {
        block6: {
            block5: {
                if (!(this.self instanceof Player)) break block5;
                if (!this.isPacketPlayer()) break block6;
                List<Entity> listE = this.getTargetEntityList(this.self, -1.0f);
                int id = -1;
                if (this.storeEnt != null) {
                    id = this.storeEnt.m_19879_();
                }
                C2SPacketUtil.standBarrageHitPacket(id, this.attackTimeDuring);
                if (!listE.isEmpty() && ClientNetworking.getAppropriateConfig().generalStandSettings.barrageHasAreaOfEffect.booleanValue()) {
                    for (int i = 0; i < listE.size(); ++i) {
                        if (this.storeEnt != null && listE.get(i).m_7306_(this.storeEnt) || listE.get(i) instanceof StandEntity || !((double)listE.get(i).m_20270_((Entity)this.self) < 3.5)) continue;
                        C2SPacketUtil.standBarrageHitPacket(listE.get(i).m_19879_(), this.attackTimeDuring + 1000);
                    }
                }
                if (this.attackTimeDuring != this.getBarrageLength()) break block6;
                this.attackTimeDuring = -10;
                break block6;
            }
            Entity targetEntity = this.getTargetEntity(this.self, -1.0f);
            List<Entity> listE = this.getTargetEntityList(this.self, -1.0f);
            this.barrageImpact(this.storeEnt, this.attackTimeDuring);
            if (!listE.isEmpty()) {
                for (int i = 0; i < listE.size(); ++i) {
                    if (this.storeEnt != null && listE.get(i).m_7306_(this.storeEnt) || listE.get(i) instanceof StandEntity || !((double)listE.get(i).m_20270_((Entity)this.self) < 3.5)) continue;
                    this.barrageImpact(listE.get(i), this.attackTimeDuring + 1000);
                }
            }
        }
        this.findDeflectables();
    }

    public StandPowers(LivingEntity self) {
        super(self);
    }

    @Override
    public void baseTickPower() {
        Player PE;
        LivingEntity livingEntity;
        if (this.self.m_9236_().m_5776_()) {
            if (this.self instanceof Player) {
                this.tickOverlayTicks();
            }
            if (this.displayStand != null && this.displayStand.getFadeOut() < this.displayStand.MaxFade) {
                this.displayStand.incFadeOut((byte)1);
            }
        } else if (this.softenTicks > 0) {
            this.softenTicks -= 2;
        }
        if ((livingEntity = this.self) instanceof Player && (PE = (Player)livingEntity).m_5833_()) {
            ((StandUser)this.getSelf()).roundabout$setActive(false);
        }
        if (this.self.m_6084_() && !this.self.m_213877_()) {
            if (this.self.m_9236_().f_46443_) {
                this.updateGoBeyondTarget();
                if (!this.kickStarted && this.getAttackTimeDuring() <= -1) {
                    this.kickStarted = true;
                }
            }
            if (this.isClashing()) {
                if (this.attackTimeDuring != -1) {
                    ++this.attackTimeDuring;
                    this.updateClashing();
                }
            } else if (!this.self.m_9236_().f_46443_ || this.kickStarted) {
                if (this.attackTimeDuring != -1) {
                    ++this.attackTimeDuring;
                    if (this.attackTimeDuring == -1) {
                        ((StandUser)this.self).roundabout$tryPower(0, true);
                    } else if (!this.isAttackInept(this.activePower)) {
                        if (this.activePower == 1) {
                            this.updateAttack();
                        } else if (this.isBarraging()) {
                            if (this.bonusBarrageConditions()) {
                                if (this.isBarrageCharging()) {
                                    this.updateBarrageCharge();
                                } else {
                                    this.updateBarrage();
                                }
                            } else {
                                ((StandUser)this.self).roundabout$tryPower(0, true);
                            }
                        } else {
                            this.updateUniqueMoves();
                        }
                    } else {
                        this.resetAttackState();
                    }
                }
                ++this.attackTime;
                if (this.attackTime > this.attackTimeMax) {
                    this.setActivePowerPhase((byte)0);
                }
                if (this.interruptCD > 0) {
                    --this.interruptCD;
                }
            }
            this.tickDash();
        } else {
            StandUser user = (StandUser)this.getSelf();
            StandEntity stnd = user.roundabout$getStand();
            if (stnd != null) {
                user.roundabout$setStand(null);
            }
        }
        if (this.self.m_9236_().f_46443_) {
            this.tickSounds();
        }
        if (this.scopeLevel != 0 && !this.canScope()) {
            this.setScopeLevel(0);
            this.scopeTime = -1;
        }
        if (((StandUser)this.self).roundabout$getStandDisc().m_41619_()) {
            ((StandUser)this.self).roundabout$setStandPowers(new StandPowers(this.self));
        }
        if (!this.hasStandActive(this.self)) {
            this.getStandUserSelf().roundabout$setStandAnimation((byte)0);
        }
    }

    public void getSkinInDirection(boolean right, boolean sealed) {
        StandUser SE = (StandUser)this.getSelf();
        byte currentSkin = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        List<Byte> skins = this.getSkinList();
        if (!skins.isEmpty() && skins.size() > 1) {
            int skinind = 0;
            for (int i = 0; i < skins.size(); ++i) {
                if (skins.get(i) != currentSkin) continue;
                skinind = i;
            }
            if (right) {
                if (++skinind >= skins.size()) {
                    skinind = 0;
                }
                SE.roundabout$setStandSkin(skins.get(skinind));
            } else {
                if (--skinind < 0) {
                    skinind = skins.size() - 1;
                }
                SE.roundabout$setStandSkin(skins.get(skinind));
            }
            if (!sealed) {
                ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
                SE.roundabout$summonStand(this.getSelf().m_9236_(), true, false);
            }
        }
    }

    public void getPoseInDirection(boolean right) {
        StandUser SE = (StandUser)this.getSelf();
        byte currentSkin = ((StandUser)this.getSelf()).roundabout$getIdlePos();
        List<Byte> poses = this.getPosList();
        if (!poses.isEmpty() && poses.size() > 1) {
            int skinind = 0;
            for (int i = 0; i < poses.size(); ++i) {
                if (poses.get(i) != currentSkin) continue;
                skinind = i;
            }
            if (right) {
                if (++skinind >= poses.size()) {
                    skinind = 0;
                }
                SE.roundabout$setIdlePosX(poses.get(skinind));
            } else {
                if (--skinind < 0) {
                    skinind = poses.size() - 1;
                }
                SE.roundabout$setIdlePosX(poses.get(skinind));
            }
        }
    }

    public float getTimestopRange() {
        return ClientNetworking.getAppropriateConfig().timeStopSettings.blockRangeNegativeOneIsInfinite.intValue();
    }

    public boolean fullTSChargeBonus() {
        return false;
    }

    public void timeTickStopPower() {
    }

    public boolean isStoppingTime() {
        return false;
    }

    public int getChargedTSTicks() {
        return this.chargedTSTicks;
    }

    public void setChargedTSTicks(int chargedTSSeconds) {
        this.chargedTSTicks = chargedTSSeconds;
    }

    public int getMaxTSTime() {
        return 0;
    }

    public int getMaxChargeTSTime() {
        return 0;
    }

    public boolean getIsTsCharging() {
        return false;
    }

    public Entity getGoBeyondTarget() {
        return this.goBeyondTarget;
    }

    public void setGoBeyondTarget(Entity goBeyondTarget) {
        this.goBeyondTarget = goBeyondTarget;
    }

    public void updateGoBeyondTarget() {
        this.goBeyondTarget = null;
    }

    public boolean hasGoldenDisc() {
        ItemStack stack = ((StandUser)this.getSelf()).roundabout$getStandDisc();
        return !stack.m_41619_() && stack.m_41720_() instanceof MaxStandDiscItem;
    }

    public boolean hasMoreThanOneSkin() {
        List<Byte> skinList = this.getSkinList();
        return skinList != null && !skinList.isEmpty() && skinList.size() > 1;
    }

    public boolean hasMoreThanOnePos() {
        List<Byte> posList = this.getPosList();
        return posList != null && !posList.isEmpty() && posList.size() > 1;
    }

    public void findDeflectables() {
        float halfReach = (float)((double)this.getReach() * 0.5);
        Vec3 pointVec = DamageHandler.getRayPoint(this.self, halfReach);
        List<Entity> arrows = this.arrowGrabHitbox(this.self, DamageHandler.genHitbox(this.self, pointVec.f_82479_, pointVec.f_82480_, pointVec.f_82481_, halfReach, halfReach, halfReach), this.getReach());
        if (!arrows.isEmpty() && ClientNetworking.getAppropriateConfig().generalStandSettings.barrageDeflectsArrows.booleanValue()) {
            for (int i = 0; i < arrows.size(); ++i) {
                this.deflectArrowsAndBullets(arrows.get(i));
            }
        }
    }

    public Component getStandName() {
        Item item;
        ItemStack disc = ((StandUser)this.getSelf()).roundabout$getStandDisc();
        if (!disc.m_41619_() && (item = disc.m_41720_()) instanceof StandDiscItem) {
            StandDiscItem SDI = (StandDiscItem)item;
            return SDI.getDisplayName2();
        }
        return Component.m_237119_();
    }

    public boolean setPowerSpecial(int lastMove) {
        return false;
    }

    @Override
    public boolean setPowerMovement(int lastMove) {
        return false;
    }

    public boolean setPowerSneakMovement(int lastMove) {
        return false;
    }

    public boolean getSummonCD() {
        return this.summonCD <= 0;
    }

    public void setSummonCD(int summonCD) {
        this.summonCD = summonCD;
    }

    public int getSummonCD2() {
        return this.summonCD;
    }
}

