/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.fates.powers;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.access.IGravityEntity;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.KeyInputRegistry;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.projectile.KnifeEntity;
import net.hydra.jojomod.entity.projectile.ThrownObjectEntity;
import net.hydra.jojomod.entity.stand.FollowingStandEntity;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.AbilityIconInstance;
import net.hydra.jojomod.event.index.OffsetIndex;
import net.hydra.jojomod.event.powers.CooldownInstance;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.event.powers.StandUserClient;
import net.hydra.jojomod.event.powers.TimeStop;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.util.C2SPacketUtil;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.hydra.jojomod.util.gravity.GravityAPI;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class AbilityScapeBasis {
    public final LivingEntity self;
    public int attackTime = -1;
    public int attackTimeDuring = -1;
    public int attackTimeMax = -1;
    public byte activePower = 0;
    public byte activePowerPhase = 0;
    public final byte activePowerPhaseMax = (byte)3;
    public boolean kickStarted = true;
    public int storedInt = 0;
    public Vec3 savedPos;
    public int interruptCD = 0;
    public static final byte NONE = 0;
    public int scopeTime = -1;
    public int scopeLevel = 0;
    public static final int squareHeight = 24;
    public static final int squareWidth = 24;
    public boolean heldDownSwitch = false;
    public boolean isHoldingSneakToggle = false;
    private boolean held1 = false;
    private boolean held2 = false;
    private boolean held3 = false;
    private boolean held4 = false;
    public boolean impactBrace = false;
    public int impactAirTime = -1;
    public int impactSlowdown = -1;
    public boolean inputDash = false;
    public Entity storeEnt = null;

    public AbilityScapeBasis(LivingEntity self) {
        this.self = self;
    }

    public void kickStartClient() {
        this.kickStarted = true;
    }

    public void updateMovesFromPacket(byte activePower) {
    }

    public boolean isServerControlledCooldown(CooldownInstance ci, byte num) {
        return false;
    }

    public boolean canUseStillStandingRecharge(byte bt) {
        return true;
    }

    public boolean getReducedDamage(Entity entity) {
        LivingEntity LE;
        return entity instanceof Player || entity instanceof StandEntity || entity instanceof LivingEntity && !((StandUser)(LE = (LivingEntity)entity)).roundabout$getStandDisc().m_41619_() && ClientNetworking.getAppropriateConfig().generalStandUserMobSettings.standUserMobsTakePlayerDamageMultipliers != false;
    }

    public boolean canChangePower(int move, boolean forced) {
        return (this.activePower == 0 || forced) && !this.isDazed(this.self);
    }

    public void tryPower(int move) {
        this.tryPower(move, true);
    }

    public boolean tryPower(int move, boolean forced) {
        if (this.canChangePower(move, forced)) {
            if (move == 0) {
                this.setPowerNone();
            } else if (move == 12) {
                this.setPowerMovement(move);
            } else {
                this.setPowerOther(move, this.getActivePower());
            }
        }
        return false;
    }

    public float getReach() {
        return 5.0f;
    }

    public boolean setPowerOther(int move, int lastMove) {
        return false;
    }

    public boolean setPowerNone() {
        this.attackTimeDuring = -1;
        this.setActivePower((byte)0);
        return true;
    }

    public float inputSpeedModifiers(float basis) {
        return basis;
    }

    public boolean tryPosPower(int move, boolean forced, Vec3 pos) {
        this.tryPower(move, forced);
        return true;
    }

    public boolean tryBlockPosPower(int move, boolean forced, BlockPos blockPos) {
        this.tryPower(move, forced);
        return true;
    }

    public boolean tryBlockPosPower(int move, boolean forced, BlockPos blockPos, BlockHitResult blockhit) {
        this.tryPower(move, forced);
        return true;
    }

    public boolean tryIntPower(int move, boolean forced, int chargeTime) {
        this.tryPower(move, forced);
        if (this.canChangePower(move, forced) && move == 12) {
            this.storedInt = chargeTime;
        }
        return true;
    }

    public boolean tryTripleIntPower(int move, boolean forced, int chargeTime, int move2, int move3) {
        this.tryPower(move, forced);
        return true;
    }

    public void tryPowerPacket(byte packet) {
        if (this.self.m_9236_().m_5776_()) {
            C2SPacketUtil.tryPowerPacket(packet);
        }
    }

    public void tryIntPowerPacket(byte packet, int integer) {
        if (this.self.m_9236_().m_5776_()) {
            C2SPacketUtil.tryIntPowerPacket(packet, integer);
        }
    }

    public void tryIntToServerPacket(byte packet, int integer) {
        if (this.self.m_9236_().m_5776_()) {
            C2SPacketUtil.intToServerPacket(packet, integer);
        }
    }

    public void tryTripleIntPacket(byte packet, int in1, int in2, int in3) {
        if (this.self.m_9236_().m_5776_()) {
            C2SPacketUtil.tryTripleIntPacket(packet, in1, in2, in3);
        }
    }

    public void tryBlockPosPowerPacket(byte packet, BlockPos pos) {
        if (this.self.m_9236_().m_5776_()) {
            C2SPacketUtil.tryBlockPosPowerPacket(packet, pos);
        }
    }

    public void tryBlockPosPowerPacket(byte packet, BlockPos pos, HitResult hitResult) {
        if (this.self.m_9236_().m_5776_()) {
            C2SPacketUtil.tryBlockPosPowerPacket(packet, pos, hitResult);
        }
    }

    public void tryPosPowerPacket(byte packet, Vec3 pos) {
        if (this.self.m_9236_().m_5776_()) {
            C2SPacketUtil.tryPosPowerPacket(packet, pos);
        }
    }

    public StandUser getStandUserSelf() {
        return (StandUser)this.self;
    }

    public int getAttackTime() {
        return this.attackTime;
    }

    public int getAttackTimeDuring() {
        return this.attackTimeDuring;
    }

    public byte getActivePower() {
        return this.activePower;
    }

    public byte getActivePowerPhase() {
        return this.activePowerPhase;
    }

    public byte getActivePowerPhaseMax() {
        return this.activePowerPhaseMax;
    }

    public void setAttackTime(int attackTime) {
        this.attackTime = attackTime;
    }

    public void setAttackTimeDuring(int attackTimeDuring) {
        this.attackTimeDuring = attackTimeDuring;
    }

    public void setAttackTimeMax(int attackTimeMax) {
        this.attackTimeMax = attackTimeMax;
    }

    public int getAttackTimeMax() {
        return this.attackTimeMax;
    }

    public void setMaxAttackTime(int attackTimeMax) {
        this.attackTimeMax = attackTimeMax;
    }

    public void setActivePower(byte activeMove) {
        this.activePower = activeMove;
    }

    public void setActivePowerPhase(byte activePowerPhase) {
        this.activePowerPhase = activePowerPhase;
    }

    public void xTryPower(byte index, boolean forced) {
    }

    public void tryPowerStuff() {
        this.syncActivePower();
        if (this.self.m_9236_().f_46443_) {
            this.kickStarted = false;
        }
    }

    public void tickPower() {
        if (this.getSelf().m_6084_() && !this.getSelf().m_213877_()) {
            if (this.impactSlowdown >= -1) {
                --this.impactSlowdown;
            }
            if (this.impactBrace) {
                if (((StandUser)this.getSelf()).roundabout$getActive()) {
                    if (this.getSelf().m_20096_()) {
                        this.impactBrace = false;
                        ((StandUser)this.getSelf()).roundabout$tryPower(17, true);
                        if (this.getSelf().m_9236_().f_46443_ && this.isPacketPlayer()) {
                            this.tryPowerPacket((byte)17);
                        }
                    } else if (this.getSelf().m_20069_() || this.getSelf().m_21023_(MobEffects.f_19620_)) {
                        this.impactSlowdown = -1;
                        this.impactBrace = false;
                        ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
                        if (this.getSelf().m_9236_().f_46443_ && this.isPacketPlayer()) {
                            this.tryPowerPacket((byte)0);
                        }
                    } else {
                        if (this.impactAirTime > -1) {
                            --this.impactAirTime;
                        }
                        this.impactSlowdown = 15;
                        if (this.impactAirTime > -1 || this.getSelf().f_19797_ % 2 == 0) {
                            this.getSelf().f_19789_ -= 1.0f;
                            if (this.getSelf().f_19789_ < 0.0f) {
                                this.getSelf().f_19789_ = 0.0f;
                            }
                        }
                    }
                } else {
                    this.impactSlowdown = -1;
                    this.impactBrace = false;
                    ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
                    if (this.getSelf().m_9236_().f_46443_ && this.isPacketPlayer()) {
                        this.tryPowerPacket((byte)0);
                    }
                }
            }
        }
        this.baseTickPower();
    }

    public boolean isPacketPlayer() {
        if (this.self.m_9236_().f_46443_) {
            Minecraft mc = Minecraft.m_91087_();
            return mc.f_91074_ != null && mc.f_91074_.m_19879_() == this.self.m_19879_();
        }
        return false;
    }

    public void syncActivePower() {
        LivingEntity livingEntity;
        if (!this.self.m_9236_().f_46443_ && (livingEntity = this.self) instanceof ServerPlayer) {
            ServerPlayer SP = (ServerPlayer)livingEntity;
            S2CPacketUtil.sendActivePowerPacket((Player)SP, this.activePower);
        }
    }

    public void baseTickPower() {
        if (this.self.m_6084_() && !this.self.m_213877_()) {
            if (this.self.m_9236_().f_46443_ && !this.kickStarted && this.getAttackTimeDuring() <= -1) {
                this.kickStarted = true;
            }
            if (!this.self.m_9236_().f_46443_ || this.kickStarted) {
                if (this.attackTimeDuring != -1) {
                    ++this.attackTimeDuring;
                    if (this.attackTimeDuring == -1) {
                        this.xTryPower((byte)0, true);
                    } else if (!this.isAttackInept(this.activePower)) {
                        if (this.activePower == 1) {
                            this.updateAttack();
                        } else {
                            this.updateUniqueMoves();
                        }
                    } else {
                        this.resetAttackState();
                    }
                }
                ++this.attackTime;
                if (this.attackTime > this.attackTimeMax) {
                    this.setActivePowerPhase((byte)0);
                }
                if (this.interruptCD > 0) {
                    --this.interruptCD;
                }
            }
            this.tickDash();
        }
        if (this.self.m_9236_().f_46443_) {
            this.tickSounds();
        }
        if (this.scopeLevel != 0 && !this.canScope()) {
            this.setScopeLevel(0);
            this.scopeTime = -1;
        }
    }

    public void updateUniqueMoves() {
    }

    public void updateAttack() {
    }

    public boolean isAttackInept(byte activeP) {
        return this.self.m_6117_() || this.isDazed(this.self) || ((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity((Entity)this.getSelf());
    }

    public void resetAttackState() {
        if (this.shouldReset(this.getActivePower())) {
            this.interruptCD = 3;
            this.xTryPower((byte)0, true);
        }
    }

    public boolean shouldReset(byte activeP) {
        return this.self.m_6117_() && !this.isDazed(this.self) && !((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity((Entity)this.getSelf());
    }

    public boolean getInterruptCD() {
        return this.interruptCD <= 0;
    }

    public void setInterruptCD(int interruptCD) {
        this.interruptCD = interruptCD;
    }

    public void tickSounds() {
        if (this.self.m_9236_().f_46443_) {
            ((StandUserClient)this.self).roundabout$clientPlaySound();
            ((StandUserClient)this.self).roundabout$clientSoundCancel();
        }
    }

    public boolean canScope() {
        return false;
    }

    public void setScopeLevel(int level) {
        if (this.scopeLevel <= 0 && level > 0) {
            if (this.getSelf().m_9236_().m_5776_()) {
                C2SPacketUtil.trySingleBytePacket((byte)4);
            }
        } else if (this.scopeLevel > 0 && level <= 0 && this.getSelf().m_9236_().m_5776_()) {
            C2SPacketUtil.trySingleBytePacket((byte)5);
        }
        this.scopeLevel = level;
    }

    public void renderIcons(GuiGraphics context, int x, int y) {
    }

    public void renderAttackHud(GuiGraphics context, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
    }

    public void setSkillIcon(GuiGraphics context, int x, int y, int slot, ResourceLocation rl, byte CDI) {
        this.setSkillIcon(context, x, y, slot, rl, CDI, false);
    }

    public ResourceLocation getIconYes(int slot) {
        return StandIcons.SQUARE_ICON;
    }

    public void setSkillIcon(GuiGraphics context, int x, int y, int slot, ResourceLocation rl, byte CDI, boolean locked) {
        RenderSystem.enableBlend();
        context.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        CooldownInstance cd = null;
        if (CDI >= 0 && !this.getPowerCooldowns().isEmpty() && this.getPowerCooldowns().size() >= CDI) {
            cd = this.getPowerCooldowns().get(CDI);
        }
        x += slot * 25;
        --y;
        if (locked) {
            RenderSystem.enableBlend();
            context.m_280163_(StandIcons.LOCKED_SQUARE_ICON, x - 3, y - 3, 0.0f, 0.0f, 24, 24, 24, 24);
        } else {
            Component special1Key;
            RenderSystem.enableBlend();
            context.m_280163_(this.getIconYes(slot), x - 3, y - 3, 0.0f, 0.0f, 24, 24, 24, 24);
            Font renderer = Minecraft.m_91087_().f_91062_;
            if (slot == 4) {
                Component special4Key = KeyInputRegistry.abilityFourKey.m_90863_();
                special4Key = AbilityScapeBasis.fixKey(special4Key);
                context.m_280614_(renderer, special4Key, x - 1, y + 11, 0xFFFFFF, true);
            } else if (slot == 3) {
                Component special3Key = KeyInputRegistry.abilityThreeKey.m_90863_();
                special3Key = AbilityScapeBasis.fixKey(special3Key);
                context.m_280614_(renderer, special3Key, x - 1, y + 11, 0xFFFFFF, true);
            } else if (slot == 2) {
                Component special2Key = KeyInputRegistry.abilityTwoKey.m_90863_();
                special2Key = AbilityScapeBasis.fixKey(special2Key);
                context.m_280614_(renderer, special2Key, x - 1, y + 11, 0xFFFFFF, true);
            } else if (slot == 1) {
                special1Key = KeyInputRegistry.abilityOneKey.m_90863_();
                special1Key = AbilityScapeBasis.fixKey(special1Key);
                context.m_280614_(renderer, special1Key, x - 1, y + 11, 0xFFFFFF, true);
            }
            special1Key = KeyInputRegistry.abilityOneKey.m_90863_();
        }
        if (cd != null && cd.time >= 0 || this.isAttackIneptVisually(CDI, slot)) {
            RenderSystem.enableBlend();
            context.m_280246_(0.62f, 0.62f, 0.62f, 0.8f);
            context.m_280163_(rl, x, y, 0.0f, 0.0f, 18, 18, 18, 18);
            if (cd != null && cd.time >= 0) {
                float blit = 20.0f * (1.0f - (float)(1 + cd.time) / (float)(1 + cd.maxTime));
                int b = Math.round(blit);
                RenderSystem.enableBlend();
                context.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                ResourceLocation COOLDOWN_TEX = StandIcons.COOLDOWN_ICON;
                if (cd.isFrozen()) {
                    COOLDOWN_TEX = StandIcons.FROZEN_COOLDOWN_ICON;
                }
                context.m_280163_(COOLDOWN_TEX, x - 1, y - 1 + b, 0.0f, (float)b, 20, 20 - b, 20, 20);
                int num = (int)(Math.floor((double)cd.time / 20.0) + 1.0);
                int offset = x + 3;
                if (num <= 9) {
                    offset = x + 7;
                }
                if (!cd.isFrozen()) {
                    context.m_280056_(Minecraft.m_91087_().f_91062_, "" + num, offset, y, 0xFFFFFF, true);
                }
            }
            context.m_280246_(1.0f, 1.0f, 1.0f, 0.9f);
        } else {
            RenderSystem.enableBlend();
            context.m_280163_(rl, x, y, 0.0f, 0.0f, 18, 18, 18, 18);
        }
    }

    public boolean isAttackIneptVisually(byte activeP, int slot) {
        return this.isDazed(this.self) || ((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity((Entity)this.getSelf());
    }

    public AbilityIconInstance drawSingleGUIIcon(GuiGraphics context, int size, int startingLeft, int startingTop, int levelToUnlock, String nameSTR, String instructionStr, ResourceLocation draw, int extra, byte level, boolean bypass) {
        MutableComponent name;
        if (level < levelToUnlock && !bypass) {
            context.m_280163_(StandIcons.LOCKED_SQUARE_ICON, startingLeft, startingTop, 0.0f, 0.0f, size, size, size, size);
            context.m_280163_(StandIcons.LOCKED, startingLeft + 2, startingTop + 2, 0.0f, 0.0f, size - 4, size - 4, size - 4, size - 4);
            name = Component.m_237115_((String)"ability.roundabout.locked").m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.DARK_GRAY);
        } else {
            context.m_280163_(StandIcons.SQUARE_ICON, startingLeft, startingTop, 0.0f, 0.0f, size, size, size, size);
            context.m_280163_(draw, startingLeft + 2, startingTop + 2, 0.0f, 0.0f, size - 4, size - 4, size - 4, size - 4);
            name = Component.m_237115_((String)nameSTR).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.DARK_PURPLE);
        }
        MutableComponent instruction = level < levelToUnlock && !bypass ? Component.m_237115_((String)"ability.roundabout.locked.ctrl").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.RED) : (extra <= 0 ? Component.m_237115_((String)instructionStr).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.BLUE) : Component.m_237110_((String)instructionStr, (Object[])new Object[]{"" + extra}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.BLUE));
        MutableComponent description = level < levelToUnlock && !bypass ? Component.m_237110_((String)"ability.roundabout.locked.desc", (Object[])new Object[]{"" + levelToUnlock}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.RED) : Component.m_237115_((String)(nameSTR + ".desc"));
        return new AbilityIconInstance(size, startingLeft, startingTop, levelToUnlock, (Component)name, (Component)instruction, (Component)description, extra);
    }

    public void switchRowsKey(boolean keyIsDown, Options options) {
        if (!this.heldDownSwitch) {
            if (keyIsDown) {
                this.heldDownSwitch = true;
                this.isHoldingSneakToggle = !this.isHoldingSneakToggle;
            }
        } else if (!keyIsDown) {
            this.heldDownSwitch = false;
        }
    }

    public boolean isHoldingSneak() {
        if (this.self.m_9236_().f_46443_) {
            Minecraft mc = Minecraft.m_91087_();
            return mc.f_91066_.f_92090_.m_90857_() && !this.isHoldingSneakToggle || this.isHoldingSneakToggle && !mc.f_91066_.f_92090_.m_90857_();
        }
        return this.self.m_6047_();
    }

    public List<AbilityIconInstance> drawGUIIcons(GuiGraphics context, float delta, int mouseX, int mouseY, int leftPos, int topPos, byte level, boolean bypas) {
        ArrayList $$1 = Lists.newArrayList();
        return $$1;
    }

    public static Component fixKey(Component textIn) {
        String X = textIn.getString();
        if (X.length() > 1) {
            String[] split = X.split("\\s");
            if (split.length > 1) {
                return Component.m_130674_((String)("" + split[0].charAt(0) + split[1].charAt(0)));
            }
            if (split[0].length() > 1) {
                return Component.m_130674_((String)("" + split[0].charAt(0) + split[0].charAt(1)));
            }
            return Component.m_130674_((String)("" + split[0].charAt(0)));
        }
        return textIn;
    }

    public LivingEntity getSelf() {
        return this.self;
    }

    public StandUser getUserData(LivingEntity User) {
        return (StandUser)User;
    }

    public boolean isClient() {
        return this.getSelf().m_9236_().m_5776_();
    }

    public boolean bonusBarrageConditions() {
        return true;
    }

    public List<CooldownInstance> getPowerCooldowns() {
        if (this.self != null) {
            return this.getUserData(this.self).rdbt$getPowerCooldowns();
        }
        return new ArrayList<CooldownInstance>();
    }

    public void setPowerCooldowns(List<CooldownInstance> powerCooldowns) {
        if (this.self != null) {
            this.getUserData(this.self).rdbt$setPowerCooldowns(powerCooldowns);
        }
    }

    public void syncAllCooldowns() {
        try {
            LivingEntity livingEntity = this.self;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)livingEntity;
                byte cin = -1;
                for (CooldownInstance ci : this.getPowerCooldowns()) {
                    cin = (byte)(cin + 1);
                    S2CPacketUtil.sendMaxCooldownSyncPacket((Player)sp, cin, ci.time, ci.maxTime);
                }
            }
        }
        catch (Exception e) {
            Roundabout.LOGGER.info("???");
        }
    }

    public boolean isDazed(LivingEntity entity) {
        return this.getUserData(entity).roundabout$isDazed();
    }

    public void setDazed(LivingEntity entity, byte dazeTime) {
        if (1.0 - entity.m_21133_(Attributes.f_22278_) <= 0.0) {
            return;
        }
        if (MainUtil.isBossMob(entity)) {
            return;
        }
        StandEntity stand = this.getStandEntity(entity);
        if (stand != null && !stand.getHeldItem().m_41619_()) {
            double $$3 = stand.m_20188_() - (double)0.3f;
            ItemEntity $$4 = new ItemEntity(stand.m_9236_(), stand.m_20185_(), $$3, stand.m_20189_(), stand.getHeldItem());
            $$4.m_32010_(40);
            $$4.m_32052_(stand.m_20148_());
            stand.m_9236_().m_7967_((Entity)$$4);
            stand.setHeldItem(ItemStack.f_41583_);
        }
        if (dazeTime > 0) {
            ((StandUser)entity).roundabout$tryPower(0, true);
            ((StandUser)entity).roundabout$getStandPowers().animateStand((byte)14);
        } else {
            ((StandUser)entity).roundabout$getStandPowers().animateStand((byte)0);
        }
        this.getUserData(entity).roundabout$setDazed(dazeTime);
    }

    public void setDazedSafely(LivingEntity entity, byte dazeTime) {
        if (dazeTime > 0) {
            ((StandUser)entity).roundabout$tryPower(0, true);
            ((StandUser)entity).roundabout$getStandPowers().animateStand((byte)14);
        } else {
            ((StandUser)entity).roundabout$getStandPowers().animateStand((byte)0);
        }
        this.getUserData(entity).roundabout$setDazed(dazeTime);
    }

    public StandEntity getStandEntity(LivingEntity User) {
        return this.getUserData(User).roundabout$getStand();
    }

    public boolean hasStandEntity(LivingEntity User) {
        return this.getUserData(User).roundabout$hasStandOut();
    }

    public boolean hasStandActive(LivingEntity User) {
        return this.getUserData(User).roundabout$getActive();
    }

    public void setCooldown(byte power, int cooldown) {
        if (!this.getPowerCooldowns().isEmpty() && this.getPowerCooldowns().size() >= power) {
            this.getPowerCooldowns().get((int)power).time = cooldown;
            this.getPowerCooldowns().get((int)power).maxTime = cooldown;
        }
    }

    public void setCooldownMax(byte power, int cooldown, int maxCooldown) {
        if (!this.getPowerCooldowns().isEmpty() && this.getPowerCooldowns().size() >= power) {
            this.getPowerCooldowns().get((int)power).time = cooldown;
            this.getPowerCooldowns().get((int)power).maxTime = maxCooldown;
        }
    }

    public CooldownInstance getCooldown(byte power) {
        if (!this.getPowerCooldowns().isEmpty() && this.getPowerCooldowns().size() >= power) {
            return this.getPowerCooldowns().get(power);
        }
        return null;
    }

    public boolean onCooldown(byte power) {
        if (!this.getPowerCooldowns().isEmpty() && this.getPowerCooldowns().size() >= power) {
            return this.getPowerCooldowns().get((int)power).time >= 0;
        }
        return false;
    }

    public boolean hasCooldowns() {
        ArrayList<CooldownInstance> CDCopy = new ArrayList<CooldownInstance>(this.getPowerCooldowns()){};
        for (int i = 0; i < CDCopy.size(); i = (int)((byte)(i + 1))) {
            CooldownInstance ci = (CooldownInstance)CDCopy.get(i);
            if (ci.time < 0) continue;
            return true;
        }
        return false;
    }

    public void refreshCooldowns() {
        ArrayList<CooldownInstance> CDCopy = new ArrayList<CooldownInstance>(this.getPowerCooldowns()){};
        for (int i = 0; i < CDCopy.size(); i = (int)((byte)(i + 1))) {
            CooldownInstance ci = (CooldownInstance)CDCopy.get(i);
            ci.time = -1;
        }
        this.setPowerCooldowns((List<CooldownInstance>)CDCopy);
    }

    public void tickDash() {
        if (this.getSelf() instanceof Player) {
            byte pos;
            if (((IPlayerEntity)this.getSelf()).roundabout$getDodgeTime() >= 0) {
                this.cancelConsumableItem(this.getSelf());
            }
            if (((IPlayerEntity)this.getSelf()).roundabout$getClientDodgeTime() >= 10) {
                ((IPlayerEntity)this.getSelf()).roundabout$setClientDodgeTime(-1);
                if (!this.getSelf().m_9236_().f_46443_) {
                    ((IPlayerEntity)this.getSelf()).roundabout$setDodgeTime(-1);
                    pos = ((IPlayerEntity)this.getSelf()).roundabout$GetPos();
                    if (pos == 2 || pos == 3) {
                        ((IPlayerEntity)this.getSelf()).roundabout$SetPos((byte)0);
                    }
                }
            } else if (((IPlayerEntity)this.getSelf()).roundabout$getClientDodgeTime() >= 0) {
                ((IPlayerEntity)this.getSelf()).roundabout$setClientDodgeTime(((IPlayerEntity)this.getSelf()).roundabout$getClientDodgeTime() + 1);
            }
            if (((IPlayerEntity)this.getSelf()).roundabout$getDodgeTime() >= 10) {
                ((IPlayerEntity)this.getSelf()).roundabout$setDodgeTime(-1);
                pos = ((IPlayerEntity)this.getSelf()).roundabout$GetPos();
                if (pos == 2 || pos == 3) {
                    ((IPlayerEntity)this.getSelf()).roundabout$SetPos((byte)0);
                }
            } else if (((IPlayerEntity)this.getSelf()).roundabout$getDodgeTime() >= 0 && this.getSelf().m_9236_().f_46443_) {
                ((IPlayerEntity)this.getSelf()).roundabout$setDodgeTime(((IPlayerEntity)this.getSelf()).roundabout$getDodgeTime() + 1);
            }
        }
    }

    public void cancelConsumableItem(LivingEntity entity) {
        ItemStack itemStack = entity.m_21211_();
        Item item = itemStack.m_41720_();
        if (item.m_41472_() || item instanceof PotionItem) {
            entity.m_21253_();
            if (entity instanceof Player) {
                entity.m_5810_();
            }
        }
    }

    public boolean isGuarding() {
        return this.activePower == 3;
    }

    public void powerActivate(PowerContext context) {
        switch (context) {
            case SKILL_3_NORMAL: {
                this.dash();
            }
        }
    }

    public void buttonInput1(boolean keyIsDown, Options options) {
        if (keyIsDown) {
            if (this.held1) {
                return;
            }
            this.held1 = true;
            if (!this.isHoldingSneak() && !this.isGuarding()) {
                this.powerActivate(PowerContext.SKILL_1_NORMAL);
                return;
            }
            if (this.isHoldingSneak() && !this.isGuarding()) {
                this.powerActivate(PowerContext.SKILL_1_CROUCH);
                return;
            }
            if (!this.isHoldingSneak() && this.isGuarding()) {
                this.powerActivate(PowerContext.SKILL_1_GUARD);
                return;
            }
            if (this.isHoldingSneak() && this.isGuarding()) {
                this.powerActivate(PowerContext.SKILL_1_CROUCH_GUARD);
                return;
            }
        } else {
            this.held1 = false;
        }
    }

    public void buttonInput2(boolean keyIsDown, Options options) {
        if (keyIsDown) {
            if (this.held2) {
                return;
            }
            this.held2 = true;
            if (!this.isHoldingSneak() && !this.isGuarding()) {
                this.powerActivate(PowerContext.SKILL_2_NORMAL);
                return;
            }
            if (this.isHoldingSneak() && !this.isGuarding()) {
                this.powerActivate(PowerContext.SKILL_2_CROUCH);
                return;
            }
            if (!this.isHoldingSneak() && this.isGuarding()) {
                this.powerActivate(PowerContext.SKILL_2_GUARD);
                return;
            }
            if (this.isHoldingSneak() && this.isGuarding()) {
                this.powerActivate(PowerContext.SKILL_2_CROUCH_GUARD);
                return;
            }
        } else {
            this.held2 = false;
        }
    }

    public void buttonInput3(boolean keyIsDown, Options options) {
        if (keyIsDown) {
            if (this.held3) {
                return;
            }
            this.held3 = true;
            if (!this.isHoldingSneak() && !this.isGuarding()) {
                this.powerActivate(PowerContext.SKILL_3_NORMAL);
                return;
            }
            if (this.isHoldingSneak() && !this.isGuarding()) {
                this.powerActivate(PowerContext.SKILL_3_CROUCH);
                return;
            }
            if (!this.isHoldingSneak() && this.isGuarding()) {
                this.powerActivate(PowerContext.SKILL_3_GUARD);
                return;
            }
            if (this.isHoldingSneak() && this.isGuarding()) {
                this.powerActivate(PowerContext.SKILL_3_CROUCH_GUARD);
                return;
            }
        } else {
            this.held3 = false;
        }
    }

    public void buttonInput4(boolean keyIsDown, Options options) {
        if (keyIsDown) {
            if (this.held4) {
                return;
            }
            this.held4 = true;
            if (!this.isHoldingSneak() && !this.isGuarding()) {
                this.powerActivate(PowerContext.SKILL_4_NORMAL);
                return;
            }
            if (this.isHoldingSneak() && !this.isGuarding()) {
                this.powerActivate(PowerContext.SKILL_4_CROUCH);
                return;
            }
            if (!this.isHoldingSneak() && this.isGuarding()) {
                this.powerActivate(PowerContext.SKILL_4_GUARD);
                return;
            }
            if (this.isHoldingSneak() && this.isGuarding()) {
                this.powerActivate(PowerContext.SKILL_4_CROUCH_GUARD);
                return;
            }
        } else {
            this.held4 = false;
        }
    }

    public void preButtonInput4(boolean keyIsDown, Options options) {
        if (!this.hasStandActive(this.getSelf()) && !((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity((Entity)this.getSelf())) {
            ((StandUser)this.getSelf()).roundabout$setIdleTime(0);
            this.buttonInput4(keyIsDown, options);
        }
    }

    public void preButtonInput3(boolean keyIsDown, Options options) {
        if (!this.hasStandActive(this.getSelf()) && !((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity((Entity)this.getSelf())) {
            ((StandUser)this.getSelf()).roundabout$setIdleTime(0);
            this.buttonInput3(keyIsDown, options);
        }
    }

    public void preButtonInput2(boolean keyIsDown, Options options) {
        if (!this.hasStandActive(this.getSelf()) && !((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity((Entity)this.getSelf())) {
            ((StandUser)this.getSelf()).roundabout$setIdleTime(0);
            this.buttonInput2(keyIsDown, options);
        }
    }

    public void preButtonInput1(boolean keyIsDown, Options options) {
        if (!this.hasStandActive(this.getSelf()) && !((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity((Entity)this.getSelf())) {
            ((StandUser)this.getSelf()).roundabout$setIdleTime(0);
            this.buttonInput1(keyIsDown, options);
        }
    }

    public boolean doVault() {
        if (!this.self.m_20096_()) {
            Vec3 vec3d = this.getSelf().m_20299_(1.0f);
            Direction gravD = ((IGravityEntity)this.self).roundabout$getGravityDirection();
            Vec3 vec3d2 = this.getSelf().m_20252_(1.0f);
            Vec3 vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * 2.0, vec3d2.f_82480_ * 2.0, vec3d2.f_82481_ * 2.0);
            BlockHitResult blockHit = this.getSelf().m_9236_().m_45547_(new ClipContext(vec3d, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.getSelf()));
            boolean logicCheck = (double)(blockHit.m_82425_().m_123342_() + 1) > this.getSelf().m_20186_();
            BlockPos aboveCheck = blockHit.m_82425_().m_7494_();
            if (gravD != Direction.DOWN) {
                BlockPos abv = blockHit.m_82425_().m_121945_(gravD.m_122424_());
                BlockPos att = blockHit.m_82425_();
                Vec3 blockHitVec = RotationUtil.vecPlayerToWorld(new Vec3((double)abv.m_123341_(), (double)att.m_123342_(), (double)att.m_123343_()), gravD);
                Vec3 playerVec = RotationUtil.vecPlayerToWorld(this.getSelf().m_20182_(), gravD);
                aboveCheck = abv;
                boolean bl = logicCheck = blockHitVec.f_82480_ + 1.0 > playerVec.f_82480_;
            }
            if (this.getSelf().m_9236_().m_8055_(blockHit.m_82425_()).m_280296_() && logicCheck && !this.getSelf().m_9236_().m_8055_(aboveCheck).m_280296_()) {
                if (!this.onCooldown((byte)6)) {
                    this.setCooldown((byte)6, ClientNetworking.getAppropriateConfig().generalStandSettings.vaultingCooldown);
                    double mag = this.getSelf().m_20318_(0.0f).m_82554_(new Vec3(blockHit.m_82450_().f_82479_, blockHit.m_82450_().f_82480_, blockHit.m_82450_().f_82481_)) * 1.68 + 1.0;
                    Vec3 vec3 = new Vec3((blockHit.m_82450_().f_82479_ - this.getSelf().m_20185_()) / mag, (blockHit.m_82450_().f_82480_ - this.getSelf().m_20186_()) / mag, (blockHit.m_82450_().f_82481_ - this.getSelf().m_20189_()) / mag);
                    if (gravD != Direction.DOWN) {
                        vec3 = RotationUtil.vecWorldToPlayer(vec3, gravD);
                    }
                    MainUtil.takeUnresistableKnockbackWithY2((Entity)this.getSelf(), vec3.f_82479_, 0.35 + Math.max(vec3.f_82480_, 0.0), vec3.f_82481_);
                    ((StandUser)this.getSelf()).roundabout$tryPower(19, true);
                    this.tryPowerPacket((byte)19);
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public boolean canVault() {
        if (this.self.m_20096_()) {
            return false;
        }
        Vec3 vec3d = this.getSelf().m_20299_(0.0f);
        Vec3 vec3d2 = this.getSelf().m_20252_(0.0f);
        Vec3 vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * 2.0, vec3d2.f_82480_ * 2.0, vec3d2.f_82481_ * 2.0);
        BlockHitResult blockHit = this.getSelf().m_9236_().m_45547_(new ClipContext(vec3d, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.getSelf()));
        Direction gravD = ((IGravityEntity)this.self).roundabout$getGravityDirection();
        boolean logicCheck = (double)(blockHit.m_82425_().m_123342_() + 1) > this.getSelf().m_20186_();
        BlockPos aboveCheck = blockHit.m_82425_().m_7494_();
        if (gravD != Direction.DOWN) {
            BlockPos abv = blockHit.m_82425_().m_121945_(gravD.m_122424_());
            BlockPos att = blockHit.m_82425_();
            Vec3 blockHitVec = RotationUtil.vecPlayerToWorld(new Vec3((double)abv.m_123341_(), (double)att.m_123342_(), (double)att.m_123343_()), gravD);
            Vec3 playerVec = RotationUtil.vecPlayerToWorld(this.getSelf().m_20182_(), gravD);
            aboveCheck = abv;
            boolean bl = logicCheck = blockHitVec.f_82480_ + 1.0 > playerVec.f_82480_;
        }
        return this.getSelf().m_9236_().m_8055_(blockHit.m_82425_()).m_280296_() && logicCheck && !this.getSelf().m_9236_().m_8055_(aboveCheck).m_280296_();
    }

    public boolean fallBraceInit() {
        this.getSelf().f_19789_ -= 20.0f;
        if (this.getSelf().f_19789_ < 0.0f) {
            this.getSelf().f_19789_ = 0.0f;
        }
        this.impactBrace = true;
        this.impactAirTime = 15;
        this.setAttackTimeDuring(0);
        this.setActivePower((byte)15);
        if (!this.getSelf().m_9236_().m_5776_()) {
            this.playFallBraceInitSound();
        }
        return true;
    }

    public void playFallBraceInitSound() {
        this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.STAND_LEAP_EVENT, SoundSource.PLAYERS, 2.3f, (float)(0.78 + Math.random() * 0.04));
    }

    public void playFallBraceImpactSounds() {
        this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.FALL_BRACE_EVENT, SoundSource.PLAYERS, 1.0f, (float)(0.98 + Math.random() * 0.04));
    }

    public void playFallBraceImpactParticles() {
        ((ServerLevel)this.getSelf().m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.getSelf().m_9236_().m_8055_(this.getSelf().m_20097_())), this.getSelf().m_20185_(), (double)this.getSelf().m_20097_().m_123342_() + 1.1, this.getSelf().m_20189_(), 50, 1.1, 0.05, 1.1, 0.4);
        ((ServerLevel)this.getSelf().m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.getSelf().m_9236_().m_8055_(this.getSelf().m_20097_())), this.getSelf().m_20185_(), (double)this.getSelf().m_20097_().m_123342_() + 1.1, this.getSelf().m_20189_(), 30, 1.0, 0.05, 1.0, 0.4);
    }

    public boolean vaultOrFallBraceFails() {
        if (!this.doVault()) {
            if (this.canFallBrace()) {
                this.doFallBraceClient();
            } else {
                return true;
            }
        }
        return false;
    }

    public void doFallBraceClient() {
        ((StandUser)this.getSelf()).roundabout$tryPower(15, true);
        this.tryPowerPacket((byte)15);
    }

    public boolean fallBrace() {
        this.impactBrace = false;
        if (this.getActivePower() == 15 && this.attackTimeDuring >= 0) {
            this.cancelConsumableItem(this.getSelf());
            this.setAttackTimeDuring(-15);
            if (!this.getSelf().m_9236_().m_5776_()) {
                this.playFallBraceImpactParticles();
                this.playFallBraceImpactSounds();
                int degrees = (int)(this.getSelf().m_146908_() % 360.0f);
                MainUtil.takeUnresistableKnockbackWithY((Entity)this.getSelf(), 1.2f, Mth.m_14031_((float)((float)degrees * ((float)Math.PI / 180))), Mth.m_14031_((float)-0.20943952f), -Mth.m_14089_((float)((float)degrees * ((float)Math.PI / 180))));
            }
        }
        return true;
    }

    public boolean canFallBrace() {
        return this.getSelf().f_19789_ > 3.0f && this.impactSlowdown <= -1 && !((StandUser)this.self).roundabout$isBubbleEncased();
    }

    public boolean vault() {
        this.cancelConsumableItem(this.getSelf());
        this.setAttackTimeDuring(-7);
        this.setActivePower((byte)19);
        this.getSelf().m_183634_();
        if (!this.getSelf().m_9236_().m_5776_()) {
            this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.DODGE_EVENT, SoundSource.PLAYERS, 1.5f, (float)(0.8 + Math.random() * 0.04));
        }
        return true;
    }

    public boolean setPowerMovement(int lastMove) {
        if (this.getSelf() instanceof Player) {
            this.cancelConsumableItem(this.getSelf());
            this.setPowerNone();
            if (!this.getSelf().m_9236_().m_5776_()) {
                ((IPlayerEntity)this.getSelf()).roundabout$setClientDodgeTime(0);
                ((IPlayerEntity)this.getSelf()).roundabout$setDodgeTime(0);
                if (this.storedInt < 0) {
                    ((IPlayerEntity)this.getSelf()).roundabout$SetPos((byte)3);
                } else {
                    ((IPlayerEntity)this.getSelf()).roundabout$SetPos((byte)2);
                }
                int degrees = (int)(this.getSelf().m_146908_() % 360.0f);
                int offset = switch (this.storedInt) {
                    case 1 -> -90;
                    case 2 -> -45;
                    case -1 -> -135;
                    case 3 -> 90;
                    case 4 -> 45;
                    case -2 -> 135;
                    case -3 -> 180;
                    default -> 0;
                };
                degrees = (degrees + offset) % 360;
                for (int i = 0; i < 3; ++i) {
                    float j = 0.1f;
                    if (i == 1) {
                        degrees -= 20;
                    } else if (i == 2) {
                        degrees += 40;
                    } else {
                        j = 0.2f;
                    }
                    Vec3 cvec = new Vec3(0.0, 0.1, 0.0);
                    Vec3 dvec = new Vec3((double)Mth.m_14031_((float)((float)degrees * ((float)Math.PI / 180))) * 0.3, (double)(Mth.m_14031_((float)-0.34906584f) * -j), (double)(-Mth.m_14089_((float)((float)degrees * ((float)Math.PI / 180)))) * 0.3);
                    Direction gravD = ((IGravityEntity)this.self).roundabout$getGravityDirection();
                    if (gravD != Direction.DOWN) {
                        cvec = RotationUtil.vecPlayerToWorld(cvec, gravD);
                        dvec = RotationUtil.vecPlayerToWorld(dvec, gravD);
                    }
                    ((ServerLevel)this.getSelf().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.getSelf().m_20185_() + cvec.f_82479_, this.getSelf().m_20186_() + cvec.f_82480_, this.getSelf().m_20189_() + cvec.f_82481_, 0, dvec.f_82479_, dvec.f_82480_, dvec.f_82481_, 0.8);
                }
            }
        }
        if (!this.getSelf().m_9236_().m_5776_()) {
            this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.DODGE_EVENT, SoundSource.PLAYERS, 1.5f, (float)(0.98 + Math.random() * 0.04));
        }
        return true;
    }

    public void dash() {
        Options options = Minecraft.m_91087_().f_91066_;
        this.inputDash = true;
        if (this.getSelf().m_9236_().f_46443_ && !((TimeStop)this.getSelf().m_9236_()).CanTimeStopEntity((Entity)this.getSelf()) && this.getSelf().m_20096_() && !this.onCooldown((byte)6)) {
            int forward = 0;
            int strafe = 0;
            if (options.f_92085_.m_90857_()) {
                forward = (byte)(forward + 1);
            }
            if (options.f_92087_.m_90857_()) {
                forward = (byte)(forward - 1);
            }
            if (options.f_92086_.m_90857_()) {
                strafe = (byte)(strafe + 1);
            }
            if (options.f_92088_.m_90857_()) {
                strafe = (byte)(strafe - 1);
            }
            int degrees = (int)(this.getSelf().m_146908_() % 360.0f);
            int backwards = 0;
            if (strafe > 0 && forward == 0) {
                degrees -= 90;
                degrees %= 360;
                backwards = 1;
            } else if (strafe > 0 && forward > 0) {
                degrees -= 45;
                degrees %= 360;
                backwards = 2;
            } else if (strafe > 0) {
                degrees -= 135;
                degrees %= 360;
                backwards = -1;
            } else if (strafe < 0 && forward == 0) {
                degrees += 90;
                degrees %= 360;
                backwards = 3;
            } else if (strafe < 0 && forward > 0) {
                degrees += 45;
                degrees %= 360;
                backwards = 4;
            } else if (strafe < 0) {
                degrees += 135;
                degrees %= 360;
                backwards = -2;
            } else if (forward < 0) {
                degrees += 180;
                degrees %= 360;
                backwards = -3;
            }
            int cdTime = ClientNetworking.getAppropriateConfig().generalStandSettings.dashCooldown;
            if (this.getSelf() instanceof Player) {
                ((IPlayerEntity)this.getSelf()).roundabout$setClientDodgeTime(0);
                if (options.f_92089_.m_90857_()) {
                    cdTime = ClientNetworking.getAppropriateConfig().generalStandSettings.jumpingDashCooldown;
                }
            }
            this.setCooldown((byte)6, cdTime);
            MainUtil.takeUnresistableKnockbackWithY((Entity)this.getSelf(), 0.91f, Mth.m_14031_((float)((float)degrees * ((float)Math.PI / 180))), Mth.m_14031_((float)-0.34906584f), -Mth.m_14089_((float)((float)degrees * ((float)Math.PI / 180))));
            ((StandUser)this.getSelf()).roundabout$tryPower(12, true);
            this.tryIntPowerPacket((byte)12, backwards);
        }
    }

    public List<Entity> getTargetEntityList(LivingEntity User, float distMax) {
        return this.getTargetEntityList(User, distMax, 25.0f);
    }

    public List<Entity> getTargetEntityList(LivingEntity User, float distMax, float angle) {
        StandEntity SE;
        StandEntity SE2;
        Entity targetEntity;
        if (!(distMax >= 0.0f)) {
            distMax = this.getDistanceOut(User, this.getReach(), false);
        }
        if ((targetEntity = this.rayCastEntity(User, distMax)) != null && User instanceof StandEntity && (SE2 = (StandEntity)User).getUser() != null && SE2.getUser().m_7306_(targetEntity) || targetEntity != null && (!targetEntity.m_6084_() || targetEntity.m_213877_())) {
            targetEntity = null;
        }
        float halfReach = (float)((double)distMax * 0.5);
        Vec3 pointVec = DamageHandler.getRayPoint(User, halfReach);
        List<Entity> listE = this.StandGrabHitbox(User, DamageHandler.genHitbox(User, pointVec.f_82479_, pointVec.f_82480_, pointVec.f_82481_, halfReach, halfReach, halfReach), distMax);
        if (targetEntity == null) {
            targetEntity = this.StandAttackHitboxNear(User, listE, angle);
        }
        if (targetEntity instanceof StandEntity && (SE = (StandEntity)targetEntity).redirectKnockbackToUser() && SE.getUser() != null) {
            targetEntity = SE.getUser();
        }
        if (targetEntity instanceof EnderDragonPart) {
            EnderDragonPart EDP = (EnderDragonPart)targetEntity;
            targetEntity = EDP.f_31010_;
        }
        this.storeEnt = targetEntity;
        return listE;
    }

    public Entity getTargetEntityThroughWalls(LivingEntity User, float distMax, float angle) {
        LivingEntity LE;
        StandEntity SE;
        Entity targetEntity;
        if (!(distMax >= 0.0f)) {
            distMax = this.getDistanceOut(User, this.getReach(), false);
        }
        if ((targetEntity = this.rayCastEntityThroughWalls(User, distMax)) != null && User instanceof StandEntity && (SE = (StandEntity)User).getUser() != null && SE.getUser().m_7306_(targetEntity) || targetEntity != null && (!targetEntity.m_6084_() || targetEntity.m_213877_())) {
            targetEntity = null;
        }
        if (targetEntity == null) {
            float halfReach = (float)((double)distMax * 0.5);
            Vec3 pointVec = DamageHandler.getRayPoint(User, halfReach);
            targetEntity = this.StandAttackHitboxNear(User, this.StandGrabHitbox(User, DamageHandler.genHitbox(User, pointVec.f_82479_, pointVec.f_82480_, pointVec.f_82481_, halfReach, halfReach, halfReach), distMax, angle, true), angle, true);
        }
        if (targetEntity instanceof StandEntity && (SE = (StandEntity)targetEntity).redirectKnockbackToUser() && SE.getUser() != null) {
            targetEntity = SE.getUser();
        }
        if (targetEntity instanceof EnderDragonPart) {
            EnderDragonPart EDP = (EnderDragonPart)targetEntity;
            targetEntity = EDP.f_31010_;
        }
        if (targetEntity instanceof LivingEntity && ((StandUser)(LE = (LivingEntity)targetEntity)).roundabout$isParallelRunning()) {
            return null;
        }
        return targetEntity;
    }

    public List<Entity> getTargetEntityListThroughWalls(LivingEntity User, float distMax, float angle) {
        LivingEntity LE;
        StandEntity SE;
        StandEntity SE2;
        Entity targetEntity;
        if (!(distMax >= 0.0f)) {
            distMax = this.getDistanceOut(User, this.getReach(), false);
        }
        if ((targetEntity = this.rayCastEntityThroughWalls(User, distMax)) != null && User instanceof StandEntity && (SE2 = (StandEntity)User).getUser() != null && SE2.getUser().m_7306_(targetEntity) || targetEntity != null && (!targetEntity.m_6084_() || targetEntity.m_213877_())) {
            targetEntity = null;
        }
        float halfReach = (float)((double)distMax * 0.5);
        Vec3 pointVec = DamageHandler.getRayPoint(User, halfReach);
        List<Entity> listE = this.StandGrabHitbox(User, DamageHandler.genHitbox(User, pointVec.f_82479_, pointVec.f_82480_, pointVec.f_82481_, halfReach, halfReach, halfReach), distMax, angle, true);
        if (targetEntity == null) {
            targetEntity = this.StandAttackHitboxNear(User, listE, angle);
        }
        if (targetEntity instanceof StandEntity && (SE = (StandEntity)targetEntity).redirectKnockbackToUser() && SE.getUser() != null) {
            targetEntity = SE.getUser();
        }
        if (targetEntity instanceof EnderDragonPart) {
            EnderDragonPart EDP = (EnderDragonPart)targetEntity;
            targetEntity = EDP.f_31010_;
        }
        if (targetEntity instanceof LivingEntity && ((StandUser)(LE = (LivingEntity)targetEntity)).roundabout$isParallelRunning()) {
            return null;
        }
        this.storeEnt = targetEntity;
        if (!listE.contains(targetEntity) && targetEntity != null) {
            listE.add(targetEntity);
        }
        return listE;
    }

    public Entity getTargetEntity(LivingEntity User, float distMax) {
        return this.getTargetEntity(User, distMax, 25.0f);
    }

    public Entity getTargetEntity(LivingEntity User, float distMax, float angle) {
        LivingEntity LE;
        StandEntity SE;
        Entity targetEntity;
        if (!(distMax >= 0.0f)) {
            distMax = this.getDistanceOut(User, this.getReach(), false);
        }
        if ((targetEntity = this.rayCastEntity(User, distMax)) != null && User instanceof StandEntity && (SE = (StandEntity)User).getUser() != null && SE.getUser().m_7306_(targetEntity) || targetEntity != null && (!targetEntity.m_6084_() || targetEntity.m_213877_())) {
            targetEntity = null;
        }
        if (targetEntity == null) {
            float halfReach = (float)((double)distMax * 0.5);
            Vec3 pointVec = DamageHandler.getRayPoint(User, halfReach);
            targetEntity = this.StandAttackHitboxNear(User, this.StandGrabHitbox(User, DamageHandler.genHitbox(User, pointVec.f_82479_, pointVec.f_82480_, pointVec.f_82481_, halfReach, halfReach, halfReach), distMax), angle);
        }
        if (targetEntity instanceof StandEntity && (SE = (StandEntity)targetEntity).redirectKnockbackToUser() && SE.getUser() != null) {
            targetEntity = SE.getUser();
        }
        if (targetEntity instanceof EnderDragonPart) {
            EnderDragonPart EDP = (EnderDragonPart)targetEntity;
            targetEntity = EDP.f_31010_;
        }
        if (targetEntity instanceof LivingEntity && ((StandUser)(LE = (LivingEntity)targetEntity)).roundabout$isParallelRunning()) {
            return null;
        }
        return targetEntity;
    }

    public int getTargetEntityId() {
        Entity targetEntity = this.getTargetEntity(this.self, -1.0f);
        int id = targetEntity != null ? targetEntity.m_19879_() : -1;
        return id;
    }

    public int getTargetEntityId(float angle) {
        Entity targetEntity = this.getTargetEntity(this.self, -1.0f, angle);
        int id = targetEntity != null ? targetEntity.m_19879_() : -1;
        return id;
    }

    public int getTargetEntityId2(float distance) {
        Entity targetEntity = this.getTargetEntity(this.self, distance);
        int id = targetEntity != null ? targetEntity.m_19879_() : -1;
        return id;
    }

    public int getTargetEntityId2(float distance, LivingEntity userr, float angle) {
        Entity targetEntity = this.getTargetEntityGenerous(userr, distance, angle);
        int id = targetEntity != null ? targetEntity.m_19879_() : -1;
        return id;
    }

    public Entity getTargetEntityGenerous(LivingEntity User, float distMax, float angle) {
        StandEntity SE;
        Entity targetEntity = this.rayCastEntity(User, distMax);
        if (targetEntity != null && User instanceof StandEntity && (SE = (StandEntity)User).getUser() != null && SE.getUser().m_7306_(targetEntity) || targetEntity != null && targetEntity.m_7306_((Entity)User)) {
            targetEntity = null;
        }
        if (targetEntity == null) {
            float halfReach = (float)((double)distMax * 0.5);
            Vec3 pointVec = DamageHandler.getRayPoint(User, halfReach);
            targetEntity = this.StandAttackHitboxNear(User, this.StandGrabHitbox(User, DamageHandler.genHitbox(User, pointVec.f_82479_, pointVec.f_82480_, pointVec.f_82481_, halfReach, halfReach, halfReach), distMax, angle), angle);
        }
        if (targetEntity instanceof StandEntity && (SE = (StandEntity)targetEntity).redirectKnockbackToUser() && SE.getUser() != null) {
            targetEntity = SE.getUser();
        }
        return targetEntity;
    }

    public Entity StandAttackHitboxNear(LivingEntity User, List<Entity> entities, float angle) {
        return this.StandAttackHitboxNear(User, entities, angle, false);
    }

    public Entity StandAttackHitboxNear(LivingEntity User, List<Entity> entities, float angle, boolean throughWalls) {
        float nearestDistance = -1.0f;
        Entity nearestMob = null;
        if (entities != null) {
            for (Entity value : entities) {
                FollowingStandEntity SE;
                StandEntity SE1;
                if (value.m_20147_() || !value.m_6084_() || value.m_20148_() == User.m_20148_() || !MainUtil.isStandPickable(value) && !(value instanceof StandEntity) || value instanceof StandEntity && (SE1 = (StandEntity)value).getUser() != null && SE1.getUser().m_7306_((Entity)User)) continue;
                float distanceTo = value.m_20270_((Entity)User);
                float range = this.getReach();
                if (value instanceof FollowingStandEntity && OffsetIndex.OffsetStyle((SE = (FollowingStandEntity)value).getOffsetType()) == 0) {
                    range = 0.0f;
                }
                if (!(nearestDistance < 0.0f) && !(distanceTo < nearestDistance) || !(distanceTo <= range) || !this.canActuallyHit(value) && !throughWalls) continue;
                nearestDistance = distanceTo;
                nearestMob = value;
            }
        }
        return nearestMob;
    }

    public double getBlockDistanceOut(LivingEntity entity, double range) {
        Vec3 vec3dST = entity.m_20299_(0.0f);
        Vec3 vec3d2ST = entity.m_20252_(0.0f);
        Vec3 vec3d3ST = vec3dST.m_82520_(vec3d2ST.f_82479_ * range, vec3d2ST.f_82480_ * range, vec3d2ST.f_82481_ * range);
        BlockHitResult blockHit = entity.m_9236_().m_45547_(new ClipContext(vec3dST, vec3d3ST, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)entity));
        double bhit = Math.sqrt(blockHit.m_82448_((Entity)entity));
        if (bhit < range) {
            range = bhit;
        }
        return range;
    }

    public float getDistanceOut(LivingEntity entity, float range, boolean offset) {
        float distanceFront = this.getRayDistance((Entity)entity, range);
        if (offset) {
            Entity targetEntity = this.rayCastEntity(entity, distanceFront);
            if (targetEntity != null && targetEntity.m_20270_((Entity)entity) < distanceFront) {
                distanceFront = targetEntity.m_20270_((Entity)entity);
            }
            distanceFront -= 1.0f;
            distanceFront = Math.max(Math.min(distanceFront, 1.7f), 0.4f);
        }
        return distanceFront;
    }

    public float getDistanceOutAccurate(Entity entity, float range, boolean offset) {
        float distanceFront = this.getRayDistance(entity, range);
        if (offset) {
            Entity targetEntity = this.getTargetEntity(this.self, this.getReach());
            if (targetEntity != null && targetEntity.m_20270_(entity) < distanceFront) {
                distanceFront = targetEntity.m_20270_(entity);
            }
            distanceFront -= 1.0f;
            distanceFront = Math.max(Math.min(distanceFront, 1.7f), 0.4f);
        }
        return distanceFront;
    }

    public float getRayDistance(Entity entity, float range) {
        Vec3 vec3d = entity.m_20299_(0.0f);
        Vec3 vec3d2 = entity.m_20252_(0.0f);
        Vec3 vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * (double)range, vec3d2.f_82480_ * (double)range, vec3d2.f_82481_ * (double)range);
        BlockHitResult blockHit = entity.m_9236_().m_45547_(new ClipContext(vec3d, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
        if (blockHit.m_6662_() != HitResult.Type.MISS) {
            return Mth.m_14116_((float)((float)entity.m_20238_(blockHit.m_82450_())));
        }
        return range;
    }

    public Vec3 getRayBlock(Entity entity, float range) {
        Vec3 vec3d = entity.m_20299_(0.0f);
        Vec3 vec3d2 = entity.m_20252_(0.0f);
        Vec3 vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * (double)range, vec3d2.f_82480_ * (double)range, vec3d2.f_82481_ * (double)range);
        BlockHitResult blockHit = entity.m_9236_().m_45547_(new ClipContext(vec3d, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
        return blockHit.m_82450_();
    }

    public float getPivotPoint(Vector3d pointToRotate, Vector3d axisStart, Vector3d axisEnd) {
        Vector3d d = new Vector3d(axisEnd.x - axisStart.x, axisEnd.y - axisStart.y, axisEnd.z - axisStart.z).normalize();
        Vector3d v = new Vector3d(pointToRotate.x - axisStart.x, pointToRotate.y - axisStart.y, pointToRotate.z - axisStart.z).normalize();
        double t = v.dot((Vector3dc)d);
        return (float)pointToRotate.distance((Vector3dc)axisStart.add((Vector3dc)d.mul(t)));
    }

    public static float angleDistance(float alpha, float beta) {
        float phi = Math.abs(beta - alpha) % 360.0f;
        float distance = phi > 180.0f ? 360.0f - phi : phi;
        return distance;
    }

    public float getLookAtEntityPitch(Entity user, Entity targetEntity) {
        double f;
        double d = targetEntity.m_146892_().f_82479_ - user.m_146892_().f_82479_;
        double e = targetEntity.m_146892_().f_82481_ - user.m_146892_().f_82481_;
        if (targetEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)targetEntity;
            f = livingEntity.m_146892_().f_82480_ - user.m_146892_().f_82480_;
        } else {
            f = (targetEntity.m_20191_().f_82289_ + targetEntity.m_20191_().f_82292_) / 2.0 - user.m_146892_().f_82480_;
        }
        Vec3 vec = new Vec3(d, f, e);
        double g = Math.sqrt(vec.f_82479_ * vec.f_82479_ + vec.f_82481_ * vec.f_82481_);
        return (float)(-(Mth.m_14136_((double)vec.f_82480_, (double)g) * 57.2957763671875));
    }

    public Entity rayCastEntity(LivingEntity User, float reach) {
        StandEntity SE2;
        Entity entityHitResult = MainUtil.raytraceEntityStand(User.m_9236_(), User, reach);
        if (!(entityHitResult == null || !entityHitResult.m_6084_() || entityHitResult.m_213877_() || entityHitResult.m_7306_((Entity)User) || User instanceof StandEntity && (SE2 = (StandEntity)User).getUser() != null && SE2.getUser().m_20159_() && SE2.getUser().m_20202_().m_20148_() == entityHitResult.m_20148_())) {
            return entityHitResult;
        }
        return null;
    }

    public Entity rayCastEntityThroughWalls(LivingEntity User, float reach) {
        StandEntity SE2;
        Entity entityHitResult = MainUtil.raytraceEntityStandThroughWalls(User.m_9236_(), User, reach);
        if (!(entityHitResult == null || !entityHitResult.m_6084_() || entityHitResult.m_213877_() || entityHitResult.m_7306_((Entity)User) || User instanceof StandEntity && (SE2 = (StandEntity)User).getUser() != null && SE2.getUser().m_20159_() && SE2.getUser().m_20202_().m_20148_() == entityHitResult.m_20148_())) {
            return entityHitResult;
        }
        return null;
    }

    public float getLookAtEntityYaw(Entity user, Entity targetEntity) {
        Vec3 uservec = user.m_146892_();
        double d = targetEntity.m_146892_().f_82479_ - uservec.f_82479_;
        double e = targetEntity.m_146892_().f_82481_ - uservec.f_82481_;
        Vec3 vec = new Vec3(d, 0.0, e);
        return (float)(Mth.m_14136_((double)vec.f_82481_, (double)vec.f_82479_) * 57.2957763671875) - 90.0f;
    }

    public float getLookAtPlacePitch(Entity user, Vec3 vec) {
        double d = vec.m_7096_() - user.m_146892_().f_82479_;
        double e = vec.m_7094_() - user.m_146892_().f_82481_;
        double f = vec.m_7098_() - user.m_146892_().f_82480_;
        double g = Math.sqrt(d * d + e * e);
        return (float)(-(Mth.m_14136_((double)f, (double)g) * 57.2957763671875));
    }

    public float getLookAtPlaceYaw(Entity user, Vec3 vec) {
        double d = vec.m_7096_() - user.m_146892_().f_82479_;
        double e = vec.m_7094_() - user.m_146892_().f_82481_;
        return (float)(Mth.m_14136_((double)e, (double)d) * 57.2957763671875) - 90.0f;
    }

    public void forceLook(Entity stand, Vec3 blockCenterPlus) {
        Direction gravityDirection2 = GravityAPI.getGravityDirection(stand);
        if (gravityDirection2 == Direction.DOWN) {
            return;
        }
        double $$3 = blockCenterPlus.f_82479_ - stand.m_146892_().f_82479_;
        double $$4 = blockCenterPlus.f_82481_ - stand.m_146892_().f_82481_;
        double $$6 = blockCenterPlus.f_82480_ - stand.m_146892_().f_82480_;
        double $$8 = Math.sqrt($$3 * $$3 + $$4 * $$4);
        float $$9 = (float)(Mth.m_14136_((double)$$4, (double)$$3) * 180.0 / 3.1415927410125732) - 90.0f;
        float $$10 = (float)(-(Mth.m_14136_((double)$$6, (double)$$8) * 180.0 / 3.1415927410125732));
        stand.m_146926_(this.rotlerp(stand.m_146909_(), $$10, 30.0f));
        stand.m_146922_(this.rotlerp(stand.m_146908_(), $$9, 30.0f));
    }

    private float rotlerp(float $$0, float $$1, float $$2) {
        float $$3 = Mth.m_14177_((float)($$1 - $$0));
        if ($$3 > $$2) {
            $$3 = $$2;
        }
        if ($$3 < -$$2) {
            $$3 = -$$2;
        }
        return $$0 + $$3;
    }

    public List<Entity> StandGrabHitbox(LivingEntity User, List<Entity> entities, float maxDistance) {
        return this.StandGrabHitbox(User, entities, maxDistance, 25.0f);
    }

    public List<Entity> StandGrabHitbox(LivingEntity User, List<Entity> entities, float maxDistance, float angle) {
        return this.StandGrabHitbox(User, entities, maxDistance, 25.0f, false);
    }

    public List<Entity> StandGrabHitbox(LivingEntity User, List<Entity> entities, float maxDistance, float angle, boolean throughWalls) {
        ArrayList<Entity> hitEntities = new ArrayList<Entity>(entities){};
        for (Entity value : entities) {
            StandEntity SE2;
            StandEntity SE;
            if (!value.m_20152_() || !MainUtil.isStandPickable(value) && !(value instanceof StandEntity) || !value.m_6097_() && !(value instanceof StandEntity) || value.m_20147_() || !value.m_6084_() || User.m_20159_() && User.m_20202_().m_20148_() == value.m_20148_() || value.m_7306_((Entity)User) || ((StandUser)User).roundabout$getStand() != null && ((StandUser)User).roundabout$getStand().m_7306_((Entity)User) || User instanceof StandEntity && (SE = (StandEntity)User).getUser() != null && SE.getUser().m_7306_(value) || User instanceof StandEntity && (SE2 = (StandEntity)User).getUser() != null && SE2.getUser().m_20159_() && SE2.getUser().m_20202_().m_20148_() == value.m_20148_()) {
                hitEntities.remove(value);
                continue;
            }
            Direction gravD = ((IGravityEntity)User).roundabout$getGravityDirection();
            Vec2 lookVec = new Vec2(this.getLookAtEntityYaw((Entity)User, value), this.getLookAtEntityPitch((Entity)User, value));
            if (gravD != Direction.DOWN) {
                lookVec = RotationUtil.rotPlayerToWorld(lookVec.f_82470_, lookVec.f_82471_, gravD);
            }
            if (!(AbilityScapeBasis.angleDistance(lookVec.f_82470_, User.m_6080_() % 360.0f) <= angle) || !(AbilityScapeBasis.angleDistance(lookVec.f_82471_, User.m_146909_()) <= angle)) {
                hitEntities.remove(value);
                continue;
            }
            if (this.canActuallyHit(value) || throughWalls) continue;
            hitEntities.remove(value);
        }
        return hitEntities;
    }

    public boolean canActuallyHit(Entity entity) {
        boolean isBlocked;
        if (ClientNetworking.getAppropriateConfig().generalStandSettings.standPunchesGoThroughDoorsAndCorners.booleanValue()) {
            return true;
        }
        Vec3 from = new Vec3(this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_());
        Vec3 to = entity.m_20299_(1.0f);
        BlockHitResult result = this.self.m_9236_().m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.self));
        boolean bl = isBlocked = result.m_6662_() != HitResult.Type.MISS && result.m_82450_().m_82554_(from) < to.m_82554_(from);
        if (isBlocked) {
            from = this.self.m_20299_(1.0f);
            to = entity.m_20299_(1.0f);
            result = this.self.m_9236_().m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.self));
            isBlocked = result.m_6662_() != HitResult.Type.MISS && result.m_82450_().m_82554_(from) < to.m_82554_(from);
        }
        return !isBlocked;
    }

    public boolean knockShield(Entity entity, int duration) {
        if (entity != null && entity.m_6084_() && !entity.m_213877_() && entity instanceof LivingEntity && ((LivingEntity)entity).m_21254_()) {
            StandUser standUser = this.getUserData((LivingEntity)entity);
            if (standUser.roundabout$isGuarding() && !standUser.roundabout$getGuardBroken()) {
                standUser.roundabout$breakGuard();
            }
            if (entity instanceof Player) {
                ItemStack itemStack = ((LivingEntity)entity).m_21211_();
                Item item = itemStack.m_41720_();
                if (item.m_6164_(itemStack) == UseAnim.BLOCK) {
                    ((LivingEntity)entity).m_21253_();
                    ((Player)entity).m_5810_();
                }
                ((Player)entity).m_36335_().m_41524_(Items.f_42740_, duration);
                entity.m_9236_().m_7605_(entity, (byte)30);
            }
            return true;
        }
        return false;
    }

    public boolean knockShield2(Entity entity, int duration) {
        if (entity != null && entity.m_6084_() && !entity.m_213877_() && entity instanceof LivingEntity && ((LivingEntity)entity).m_21254_()) {
            if (entity instanceof Player) {
                ItemStack itemStack = ((LivingEntity)entity).m_21211_();
                Item item = itemStack.m_41720_();
                if (item.m_6164_(itemStack) == UseAnim.BLOCK) {
                    ((LivingEntity)entity).m_21253_();
                    ((Player)entity).m_5810_();
                }
                ((Player)entity).m_36335_().m_41524_(Items.f_42740_, duration);
                entity.m_9236_().m_7605_(entity, (byte)30);
            }
            return true;
        }
        return false;
    }

    public List<Entity> arrowGrabHitbox(LivingEntity User, List<Entity> entities, float maxDistance) {
        return this.arrowGrabHitbox(User, entities, maxDistance, 90.0f);
    }

    public List<Entity> arrowGrabHitbox(LivingEntity User, List<Entity> entities, float maxDistance, float angle) {
        ArrayList<Entity> hitEntities = new ArrayList<Entity>(entities){};
        for (Entity value : entities) {
            Direction gravD = ((IGravityEntity)User).roundabout$getGravityDirection();
            Vec2 lookVec = new Vec2(this.getLookAtEntityYaw((Entity)User, value), this.getLookAtEntityPitch((Entity)User, value));
            if (gravD != Direction.DOWN) {
                lookVec = RotationUtil.rotPlayerToWorld(lookVec.f_82470_, lookVec.f_82471_, gravD);
            }
            if (!(value instanceof Arrow || value instanceof KnifeEntity || value instanceof ThrownObjectEntity)) {
                hitEntities.remove(value);
                continue;
            }
            if (!(AbilityScapeBasis.angleDistance(lookVec.f_82470_, User.m_6080_() % 360.0f) <= angle) || !(AbilityScapeBasis.angleDistance(lookVec.f_82471_, User.m_146909_()) <= angle)) {
                hitEntities.remove(value);
                continue;
            }
            if (!(value.m_20270_((Entity)User) > maxDistance)) continue;
            hitEntities.remove(value);
        }
        return hitEntities;
    }

    public boolean StandAttackHitbox(List<Entity> entities, float pow, float knockbackStrength) {
        boolean hitSomething = false;
        float nearestDistance = -1.0f;
        if (entities != null) {
            for (Entity value : entities) {
                if (!this.StandDamageEntityAttack(value, pow, knockbackStrength, (Entity)this.self)) continue;
                hitSomething = true;
            }
        }
        return hitSomething;
    }

    public boolean StandDamageEntityAttack(Entity target, float pow, float knockbackStrength, Entity attacker) {
        if (attacker instanceof TamableAnimal) {
            TamableAnimal TT;
            TamableAnimal TA = (TamableAnimal)attacker;
            if (target instanceof TamableAnimal && (TT = (TamableAnimal)target).m_269323_() != null && TA.m_269323_() != null && TT.m_269323_().m_7306_((Entity)TA.m_269323_())) {
                return false;
            }
        } else if (attacker instanceof AbstractVillager) {
            AbstractVillager av1 = (AbstractVillager)attacker;
            if (target instanceof AbstractVillager) {
                AbstractVillager av2 = (AbstractVillager)target;
                if (!(av1.m_5448_() != null && av1.m_5448_().m_7306_((Entity)av2) || av2.m_5448_() != null && av2.m_5448_().m_7306_((Entity)av1))) {
                    return false;
                }
            }
        }
        if (DamageHandler.StandDamageEntity(target, pow, attacker)) {
            if (attacker instanceof LivingEntity) {
                LivingEntity LE = (LivingEntity)attacker;
                LE.m_21335_(target);
            }
            if (target instanceof LivingEntity && knockbackStrength > 0.0f) {
                ((LivingEntity)target).m_147240_((double)(knockbackStrength * 0.5f), (double)Mth.m_14031_((float)(attacker.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(attacker.m_146908_() * ((float)Math.PI / 180)))));
            }
            return true;
        }
        return false;
    }

    public boolean StandRushDamageEntityAttack(Entity target, float pow, float knockbackStrength, Entity attacker) {
        if (attacker instanceof TamableAnimal) {
            TamableAnimal TT;
            TamableAnimal TA = (TamableAnimal)attacker;
            if (target instanceof TamableAnimal && (TT = (TamableAnimal)target).m_269323_() != null && TA.m_269323_() != null && TT.m_269323_().m_7306_((Entity)TA.m_269323_())) {
                return false;
            }
        } else if (attacker instanceof AbstractVillager && target instanceof AbstractVillager) {
            return false;
        }
        if (DamageHandler.StandRushDamageEntity(target, pow, attacker)) {
            if (attacker instanceof LivingEntity) {
                LivingEntity LE = (LivingEntity)attacker;
                LE.m_21335_(target);
            }
            if (target instanceof LivingEntity && knockbackStrength > 0.0f) {
                ((LivingEntity)target).m_147240_((double)(knockbackStrength * 0.5f), (double)Mth.m_14031_((float)(attacker.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(attacker.m_146908_() * ((float)Math.PI / 180)))));
            }
            return true;
        }
        return false;
    }
}

