/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.mixin.gravity;

import net.hydra.jojomod.util.gravity.GravityAPI;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class}, priority=1001)
public abstract class GravityPlayerMixin
extends LivingEntity {
    @Shadow
    @Final
    private Abilities f_36077_;
    @Unique
    private float roundabout$tempStoreYRot = 0.0f;
    @Unique
    private boolean roundabout$tempStoreYRotShifted = false;

    @Shadow
    public abstract EntityDimensions m_6972_(Pose var1);

    @Shadow
    protected abstract boolean m_36343_();

    @Shadow
    protected abstract boolean m_36386_();

    @Shadow
    public abstract void m_36378_(double var1, double var3, double var5);

    @Shadow
    public abstract void m_36246_(Stat<?> var1);

    @Shadow
    public abstract void m_36399_(float var1);

    @Shadow
    public abstract void m_6278_(Stat<?> var1, int var2);

    @Shadow
    public abstract void m_36222_(ResourceLocation var1, int var2);

    protected GravityPlayerMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Unique
    public Player rdbt$this() {
        return (Player)this;
    }

    @Inject(method={"checkMovementStatistics(DDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$checkMovementStatistics(double $$0, double $$1, double $$2, CallbackInfo ci) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this.rdbt$this());
        if (gravityDirection == Direction.DOWN || gravityDirection == Direction.UP) {
            return;
        }
        ci.cancel();
        if (gravityDirection == Direction.EAST || gravityDirection == Direction.WEST) {
            this.rdbt$checkMovementStatistics2($$1, $$0, $$2);
        } else {
            this.rdbt$checkMovementStatistics2($$0, $$2, $$1);
        }
    }

    @Unique
    public void rdbt$checkMovementStatistics2(double $$0, double $$1, double $$2) {
        if (!this.m_20159_()) {
            if (this.m_6069_()) {
                int $$3 = Math.round((float)Math.sqrt($$0 * $$0 + $$1 * $$1 + $$2 * $$2) * 100.0f);
                if ($$3 > 0) {
                    this.m_36222_(Stats.f_12924_, $$3);
                    this.m_36399_(0.01f * (float)$$3 * 0.01f);
                }
            } else if (this.m_204029_(FluidTags.f_13131_)) {
                int $$4 = Math.round((float)Math.sqrt($$0 * $$0 + $$1 * $$1 + $$2 * $$2) * 100.0f);
                if ($$4 > 0) {
                    this.m_36222_(Stats.f_13001_, $$4);
                    this.m_36399_(0.01f * (float)$$4 * 0.01f);
                }
            } else if (this.m_20069_()) {
                int $$5 = Math.round((float)Math.sqrt($$0 * $$0 + $$2 * $$2) * 100.0f);
                if ($$5 > 0) {
                    this.m_36222_(Stats.f_12997_, $$5);
                    this.m_36399_(0.01f * (float)$$5 * 0.01f);
                }
            } else if (this.m_6147_()) {
                if ($$1 > 0.0) {
                    this.m_36222_(Stats.f_12999_, (int)Math.round($$1 * 100.0));
                }
            } else if (this.m_20096_()) {
                int $$6 = Math.round((float)Math.sqrt($$0 * $$0 + $$2 * $$2) * 100.0f);
                if ($$6 > 0) {
                    if (this.m_20142_()) {
                        this.m_36222_(Stats.f_12996_, $$6);
                        this.m_36399_(0.1f * (float)$$6 * 0.01f);
                    } else if (this.m_6047_()) {
                        this.m_36222_(Stats.f_12995_, $$6);
                        this.m_36399_(0.0f * (float)$$6 * 0.01f);
                    } else {
                        this.m_36222_(Stats.f_12994_, $$6);
                        this.m_36399_(0.0f * (float)$$6 * 0.01f);
                    }
                }
            } else if (this.m_21255_()) {
                int $$7 = Math.round((float)Math.sqrt($$0 * $$0 + $$1 * $$1 + $$2 * $$2) * 100.0f);
                this.m_36222_(Stats.f_12923_, $$7);
            } else {
                int $$8 = Math.round((float)Math.sqrt($$0 * $$0 + $$2 * $$2) * 100.0f);
                if ($$8 > 25) {
                    this.m_36222_(Stats.f_13000_, $$8);
                }
            }
        }
    }

    @Inject(method={"travel"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$gravityTravel(Vec3 $$0, CallbackInfo ci) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this.rdbt$this());
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        ci.cancel();
        double $$1 = this.m_20185_();
        double $$2 = this.m_20186_();
        double $$3 = this.m_20189_();
        if (this.m_6069_() && !this.m_20159_()) {
            double $$4 = RotationUtil.vecWorldToPlayer((Vec3)this.m_20154_(), (Direction)gravityDirection).f_82480_;
            double $$5 = $$4 < -0.2 ? 0.085 : 0.06;
            Vec3 rotate = new Vec3(0.0, 0.9, 0.0);
            rotate = RotationUtil.vecPlayerToWorld(rotate, GravityAPI.getGravityDirection((Entity)this));
            if ($$4 <= 0.0 || this.f_20899_ || !this.m_9236_().m_8055_(BlockPos.m_274561_((double)(this.m_20185_() - rotate.f_82479_), (double)(this.m_20186_() + 1.0 - 0.1 - rotate.f_82480_ + 0.9), (double)(this.m_20189_() - rotate.f_82481_))).m_60819_().m_76178_()) {
                Vec3 $$6 = this.m_20184_();
                this.m_20256_($$6.m_82520_(0.0, ($$4 - $$6.f_82480_) * $$5, 0.0));
            }
        }
        if (this.f_36077_.f_35935_ && !this.m_20159_()) {
            double $$7 = this.m_20184_().f_82480_;
            super.m_7023_($$0);
            Vec3 $$8 = this.m_20184_();
            this.m_20334_($$8.f_82479_, $$7 * 0.6, $$8.f_82481_);
            this.m_183634_();
            this.m_20115_(7, false);
        } else {
            super.m_7023_($$0);
        }
        this.m_36378_(this.m_20185_() - $$1, this.m_20186_() - $$2, this.m_20189_() - $$3);
    }

    @Inject(method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$dropGravity(ItemStack $$0, boolean $$1, boolean $$2, CallbackInfoReturnable<ItemEntity> cir) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        if ($$0.m_41619_()) {
            cir.setReturnValue(null);
        } else {
            if (this.m_9236_().f_46443_) {
                this.m_6674_(InteractionHand.MAIN_HAND);
            }
            Vec3 vec3d = this.m_146892_().m_82546_(RotationUtil.vecPlayerToWorld(0.0, 0.3, 0.0, gravityDirection));
            ItemEntity $$4 = new ItemEntity(this.m_9236_(), vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, $$0);
            $$4.m_32010_(40);
            if ($$2) {
                $$4.m_32052_(this.m_20148_());
            }
            if ($$1) {
                float $$5 = this.f_19796_.m_188501_() * 0.5f;
                float $$6 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                Vec3 world = RotationUtil.vecPlayerToWorld((double)(-Mth.m_14031_((float)$$6) * $$5), (double)0.2f, (double)(Mth.m_14089_((float)$$6) * $$5), gravityDirection);
                GravityAPI.setWorldVelocity((Entity)$$4, world);
            } else {
                float $$7 = 0.3f;
                float $$8 = Mth.m_14031_((float)(this.m_146909_() * ((float)Math.PI / 180)));
                float $$9 = Mth.m_14089_((float)(this.m_146909_() * ((float)Math.PI / 180)));
                float $$10 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                float $$11 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                float $$12 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                float $$13 = 0.02f * this.f_19796_.m_188501_();
                Vec3 world = RotationUtil.vecPlayerToWorld((double)(-$$10 * $$9 * 0.3f) + Math.cos($$12) * (double)$$13, (double)(-$$8 * 0.3f + 0.1f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)($$11 * $$9 * 0.3f) + Math.sin($$12) * (double)$$13, gravityDirection);
                GravityAPI.setWorldVelocity((Entity)$$4, world);
            }
            cir.setReturnValue((Object)$$4);
        }
    }

    @Inject(method={"maybeBackOffFromEdge(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/entity/MoverType;)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$inject_adjustMovementForSneaking(Vec3 movement, MoverType type, CallbackInfoReturnable<Vec3> cir) {
        Entity this_ = (Entity)this;
        Direction gravityDirection = GravityAPI.getGravityDirection(this_);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        Vec3 playerMovement = RotationUtil.vecWorldToPlayer(movement, gravityDirection);
        if (!this.f_36077_.f_35935_ && (type == MoverType.SELF || type == MoverType.PLAYER) && this.m_36343_() && this.m_36386_()) {
            double d = playerMovement.f_82479_;
            double e = playerMovement.f_82481_;
            double var7 = 0.05;
            while (d != 0.0 && this_.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82383_(RotationUtil.vecPlayerToWorld(d, (double)(-this.m_274421_()), 0.0, gravityDirection)))) {
                if (d < 0.05 && d >= -0.05) {
                    d = 0.0;
                    continue;
                }
                if (d > 0.0) {
                    d -= 0.05;
                    continue;
                }
                d += 0.05;
            }
            while (e != 0.0 && this_.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82383_(RotationUtil.vecPlayerToWorld(0.0, (double)(-this.m_274421_()), e, gravityDirection)))) {
                if (e < 0.05 && e >= -0.05) {
                    e = 0.0;
                    continue;
                }
                if (e > 0.0) {
                    e -= 0.05;
                    continue;
                }
                e += 0.05;
            }
            while (d != 0.0 && e != 0.0 && this_.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82383_(RotationUtil.vecPlayerToWorld(d, (double)(-this.m_274421_()), e, gravityDirection)))) {
                d = d < 0.05 && d >= -0.05 ? 0.0 : (d > 0.0 ? (d -= 0.05) : (d += 0.05));
                if (e < 0.05 && e >= -0.05) {
                    e = 0.0;
                    continue;
                }
                if (e > 0.0) {
                    e -= 0.05;
                    continue;
                }
                e += 0.05;
            }
            cir.setReturnValue((Object)RotationUtil.vecPlayerToWorld(d, playerMovement.f_82480_, e, gravityDirection));
        } else {
            cir.setReturnValue((Object)movement);
        }
    }

    @Inject(method={"isAboveGround"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$isAboveGround(CallbackInfoReturnable<Boolean> cir) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        Vec3 world = RotationUtil.vecPlayerToWorld(0.0, (double)(this.f_19789_ - this.m_274421_()), 0.0, gravityDirection);
        cir.setReturnValue((Object)(this.m_20096_() || this.f_19789_ < this.m_274421_() && !this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82386_(world.f_82479_, world.f_82480_, world.f_82481_)) ? 1 : 0));
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;knockback(DDD)V")})
    private void roundabout$attackY1(Entity target, CallbackInfo ci) {
        Direction attackerGravityDirection;
        Direction targetGravityDirection = GravityAPI.getGravityDirection(target);
        if (targetGravityDirection == (attackerGravityDirection = GravityAPI.getGravityDirection((Entity)this))) {
            return;
        }
        this.roundabout$tempStoreYRot = this.m_146908_();
        this.roundabout$tempStoreYRotShifted = true;
        this.m_146922_(RotationUtil.rotWorldToPlayer((Vec2)RotationUtil.rotPlayerToWorld((float)this.m_146908_(), (float)this.m_146909_(), (Direction)attackerGravityDirection), (Direction)targetGravityDirection).f_82470_);
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;knockback(DDD)V", shift=At.Shift.AFTER)})
    private void roundabout$attackY2(Entity target, CallbackInfo ci) {
        if (this.roundabout$tempStoreYRotShifted) {
            this.roundabout$tempStoreYRotShifted = false;
            this.m_146922_(this.roundabout$tempStoreYRot);
        }
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;push(DDD)V")})
    private void roundabout$attackY1push(Entity target, CallbackInfo ci) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        this.roundabout$tempStoreYRot = this.m_146908_();
        this.roundabout$tempStoreYRotShifted = true;
        this.m_146922_(RotationUtil.rotPlayerToWorld((float)this.m_146908_(), (float)this.m_146909_(), (Direction)gravityDirection).f_82470_);
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;push(DDD)V", shift=At.Shift.AFTER)})
    private void roundabout$attackY2push(Entity target, CallbackInfo ci) {
        if (this.roundabout$tempStoreYRotShifted) {
            this.roundabout$tempStoreYRotShifted = false;
            this.m_146922_(this.roundabout$tempStoreYRot);
        }
    }

    @Inject(method={"addParticlesAroundSelf"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$addParticlesAroundSelf(ParticleOptions $$0, CallbackInfo ci) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        ci.cancel();
        for (int $$1 = 0; $$1 < 5; ++$$1) {
            double $$2 = this.f_19796_.m_188583_() * 0.02;
            double $$3 = this.f_19796_.m_188583_() * 0.02;
            double $$4 = this.f_19796_.m_188583_() * 0.02;
            Vec3 vec3d = RotationUtil.maskPlayerToWorld(this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), gravityDirection);
            this.m_9236_().m_7106_($$0, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, $$2, $$3, $$4);
        }
    }
}

