/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.mixin.shaders;

import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.access.IShaderGameRenderer;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.event.powers.TimeStop;
import net.hydra.jojomod.util.config.ClientConfig;
import net.hydra.jojomod.util.config.ConfigManager;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.zetalasis.client.shader.RCoreShader;
import net.zetalasis.client.shader.RPostShaderRegistry;
import net.zetalasis.client.shader.callback.RenderCallbackRegistry;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class ShaderGameRenderer
implements IShaderGameRenderer {
    @Unique
    public int roundabout$tsShaderStatus = 0;
    @Unique
    private int roundabout$frameCount = 0;
    @Shadow
    @Nullable
    private PostChain f_109050_;
    @Shadow
    @Final
    Minecraft f_109059_;
    @Shadow
    @Final
    private Map<String, ShaderInstance> f_172578_;

    @Override
    public void roundabout$loadEffect(ResourceLocation $$0) {
        this.m_109128_($$0);
    }

    @Override
    public boolean roundabout$tsShaderStatus() {
        return this.roundabout$tsShaderStatus == 1;
    }

    @Override
    public float roundabout$getFrameCount() {
        return this.roundabout$frameCount;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;doEntityOutline()V", shift=At.Shift.AFTER)})
    private void roundabout$renderShaders(float tickDelta, long $$1, boolean renderLevel, CallbackInfo ci) {
        RenderCallbackRegistry.roundabout$GAME_RENDERER_FINISH(tickDelta);
        if (RPostShaderRegistry.DESATURATE != null && ((IShaderGameRenderer)Minecraft.m_91087_().f_91063_).roundabout$tsShaderStatus()) {
            RPostShaderRegistry.DESATURATE.roundabout$setUniform("InvProjMat", RPostShaderRegistry.InverseProjectionMatrix);
            RPostShaderRegistry.DESATURATE.roundabout$process(tickDelta);
        }
    }

    @Inject(method={"reloadShaders"}, at={@At(value="HEAD")})
    private void roundabout$reloadShaders(ResourceProvider provider, CallbackInfo ci) {
        RPostShaderRegistry.bootstrap();
        try {
            RCoreShader.roundabout$meltDodgeProgram = Objects.requireNonNull(this.roundabout$registerShader(provider, "meltdodge")).getProgram();
            RCoreShader.roundabout$loveTrainProgram = Objects.requireNonNull(this.roundabout$registerShader(provider, "lovetrainlines")).getProgram();
        }
        catch (Exception e) {
            Roundabout.LOGGER.info("Oops, something went wrong loading shaders");
        }
        Roundabout.LOGGER.info("Reloaded shaders!");
    }

    @Unique
    private RCoreShader roundabout$registerShader(ResourceProvider provider, String name) {
        try {
            RCoreShader shader = new RCoreShader(provider, name);
            if (shader.getProgram() == null) {
                throw new IOException("Shader was null!");
            }
            shader.getProgram().m_173350_("DiffuseSampler", (Object)this.f_109059_.m_91385_().m_83975_());
            return shader;
        }
        catch (IOException e) {
            Roundabout.LOGGER.warn("roundabout${} failed to load!", (Object)name);
            return null;
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$renderLevel(float $$0, long $$1, PoseStack $$2, CallbackInfo ci) {
        ++this.roundabout$frameCount;
    }

    @Inject(method={"checkEntityPostEffect(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="TAIL")}, cancellable=true)
    private void roundabout$checkEntityPostEffect(Entity $$0, CallbackInfo ci) {
        ClientConfig clientConfig = ConfigManager.getClientConfig();
        if (clientConfig != null && clientConfig.timeStopSettings != null && ConfigManager.getClientConfig().timeStopSettings.simpleTimeStopShader.booleanValue()) {
            if (this.f_109059_.f_91074_ != null && ((TimeStop)this.f_109059_.f_91074_.m_9236_()).inTimeStopRange((Entity)this.f_109059_.f_91074_)) {
                if (ClientUtil.getScreenFreeze() && ((TimeStop)this.f_109059_.f_91074_.m_9236_()).isTimeStoppingEntity((LivingEntity)this.f_109059_.f_91074_)) {
                    // empty if block
                }
            } else {
                this.f_109050_ = null;
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void roundabout$tick(CallbackInfo ci) {
        ClientConfig clientConfig = ConfigManager.getClientConfig();
        if (clientConfig != null && clientConfig.timeStopSettings != null && ConfigManager.getClientConfig().timeStopSettings.simpleTimeStopShader.booleanValue()) {
            boolean changed = false;
            if (this.f_109059_.f_91074_ != null && ((TimeStop)this.f_109059_.f_91074_.m_9236_()).inTimeStopRange((Entity)this.f_109059_.f_91074_)) {
                if (this.roundabout$tsShaderStatus == 0 && (!ClientUtil.getScreenFreeze() || ((TimeStop)this.f_109059_.f_91074_.m_9236_()).isTimeStoppingEntity((LivingEntity)this.f_109059_.f_91074_))) {
                    changed = true;
                    this.roundabout$tsShaderStatus = 1;
                }
            } else if (this.roundabout$tsShaderStatus == 1) {
                changed = true;
                this.roundabout$tsShaderStatus = 0;
                this.f_109050_ = null;
            }
            if (changed) {
                Minecraft mc = Minecraft.m_91087_();
                CameraType $$0 = mc.f_91066_.m_92176_();
                if ($$0.m_90612_() != mc.f_91066_.m_92176_().m_90612_()) {
                    mc.f_91063_.m_109106_(mc.f_91066_.m_92176_().m_90612_() ? mc.m_91288_() : null);
                }
                mc.f_91060_.m_109826_();
            }
        }
    }

    @Shadow
    void m_109128_(ResourceLocation $$0) {
    }

    @Shadow
    public abstract Minecraft m_172797_();
}

