/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.stand.powers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.block.D4CLightBlockEntity;
import net.hydra.jojomod.block.ModBlocks;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.D4CCloneEntity;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.item.InterdimensionalKeyItem;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.stand.powers.presets.NewPunchingStand;
import net.hydra.jojomod.util.C2SPacketUtil;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.zetalasis.world.DynamicWorld;
import org.jetbrains.annotations.Nullable;

public class PowersD4C
extends NewPunchingStand {
    public boolean betweenVision = false;
    private int betweenVisionTicks = 0;
    private boolean held2 = false;
    @Nullable
    public D4CCloneEntity targetingClone = null;
    @Nullable
    public AABB miningBox = null;
    @Nullable
    private BlockPos pos1 = null;
    public static int pRunningTimeLimit = 10;
    private volatile boolean isPRunning = false;
    public int pRunningFrames = 0;
    public static HashMap<Integer, DynamicWorld> queuedWorldTransports = new HashMap();
    private Thread parallelThread = null;
    public int meltDodgeTicks = -1;

    public PowersD4C(LivingEntity self) {
        super(self);
    }

    @Override
    public StandPowers generateStandPowers(LivingEntity entity) {
        return new PowersD4C(entity);
    }

    @Override
    public int getMaxGuardPoints() {
        return 12;
    }

    @Override
    public StandEntity getNewStandEntity() {
        return (StandEntity)ModEntities.D4C.m_20615_(this.getSelf().m_9236_());
    }

    @Override
    public void renderIcons(GuiGraphics context, int x, int y) {
        ClientUtil.fx.roundabout$onGUI(context);
        if (this.isGuarding()) {
            this.setSkillIcon(context, x, y, 1, StandIcons.D4C_GENERATE_KEY, (byte)4);
        } else if (!this.isHoldingSneak()) {
            this.setSkillIcon(context, x, y, 1, StandIcons.D4C_BETWEEN_VISION, (byte)0);
        } else {
            this.setSkillIcon(context, x, y, 1, StandIcons.D4C_DIMENSION_KIDNAP, (byte)0);
        }
        if (!InterdimensionalKeyItem.isLinked(this.getSelf().m_21206_())) {
            if (!this.isInD4CWorld()) {
                if (!this.isHoldingSneak()) {
                    this.setSkillIcon(context, x, y, 4, StandIcons.D4C_DIMENSION_HOP, (byte)3);
                } else {
                    this.setSkillIcon(context, x, y, 4, StandIcons.D4C_DIMENSION_HOP, (byte)3);
                }
            } else if (!this.isHoldingSneak()) {
                this.setSkillIcon(context, x, y, 4, StandIcons.D4C_DIMENSION_RETURN, (byte)3);
            } else {
                this.setSkillIcon(context, x, y, 4, StandIcons.D4C_DIMENSION_RETURN, (byte)3);
            }
        } else if (!this.isHoldingSneak()) {
            this.setSkillIcon(context, x, y, 4, StandIcons.D4C_DIMENSION_HOP_KEY, (byte)9);
        } else {
            this.setSkillIcon(context, x, y, 4, StandIcons.D4C_DIMENSION_HOP_KEY, (byte)9);
        }
        super.renderIcons(context, x, y);
    }

    @Override
    public void visualFrameTick() {
        if (this.betweenVision) {
            this.highlightBlocksInFrustum(1500, 100);
        }
        if (!this.isPRunning) {
            if (this.isHoldingSneak() && !this.isGuarding()) {
                Entity entity = MainUtil.getTargetEntity(this.getSelf(), 100.0f, 2);
                if (entity instanceof D4CCloneEntity) {
                    D4CCloneEntity clone;
                    this.targetingClone = clone = (D4CCloneEntity)entity;
                }
            } else {
                this.targetingClone = null;
            }
        }
    }

    @Override
    public void powerActivate(PowerContext context) {
        super.powerActivate(context);
        switch (context) {
            case SKILL_1_NORMAL: {
                if (this.onCooldown((byte)0)) {
                    return;
                }
                this.betweenVision = !this.betweenVision;
                this.setCooldown((byte)0, 20);
                break;
            }
            case SKILL_1_GUARD: {
                if (this.isPRunning) {
                    return;
                }
                if (this.onCooldown((byte)0)) {
                    return;
                }
                if (!this.isInD4CWorld()) {
                    return;
                }
                ((StandUser)this.getSelf()).roundabout$tryPower(44, true);
                this.tryPowerPacket((byte)44);
                this.setCooldown((byte)0, 20);
                break;
            }
            case SKILL_2_NORMAL: {
                if (this.onCooldown((byte)1) || !this.isBetweenTwoThings()) break;
                ((StandUser)this.getSelf()).roundabout$tryPower(23, true);
                this.tryPowerPacket((byte)23);
                this.setCooldown((byte)1, 80);
                break;
            }
            case SKILL_2_GUARD: {
                if (this.pos1 == null && this.miningBox != null) {
                    this.miningBox = null;
                    return;
                }
                if (this.miningBox == null) {
                    BlockHitResult result = this.getGrabBlock();
                    if (this.pos1 == null) {
                        if (result != null) {
                            this.pos1 = result.m_82425_();
                        }
                    } else if (result != null) {
                        this.miningBox = new AABB(this.pos1, result.m_82425_());
                        this.pos1 = null;
                    }
                }
                return;
            }
            case SKILL_2_CROUCH: {
                if (this.onCooldown((byte)5) || this.targetingClone == null) break;
                if (this.targetingClone.player != this.getSelf()) {
                    return;
                }
                C2SPacketUtil.intToServerPacket((byte)7, this.targetingClone.m_19879_());
                ((StandUser)this.getSelf()).roundabout$tryPower(24, true);
                this.tryPowerPacket((byte)24);
                this.setCooldown((byte)5, 40);
                this.targetingClone = null;
                break;
            }
            case SKILL_3_NORMAL: 
            case SKILL_3_CROUCH: {
                ((StandUser)this.getSelf()).roundabout$tryPower(25, true);
                this.tryPowerPacket((byte)25);
                this.setCooldown((byte)2, 80);
                break;
            }
            case SKILL_3_GUARD: {
                if (!this.isPRunning && !this.isBetweenTwoThings(this.getSelf().m_20183_())) break;
                ((StandUser)this.getSelf()).roundabout$tryPower(46, true);
                this.tryPowerPacket((byte)46);
                this.setCooldown((byte)8, 20);
                break;
            }
            case SKILL_4_NORMAL: {
                if (this.onCooldown((byte)3) || !this.isBetweenTwoThings()) break;
                if (!this.isHoldingSneak()) {
                    ((StandUser)this.getSelf()).roundabout$tryPower(27, true);
                    this.tryPowerPacket((byte)27);
                    break;
                }
                this.setCooldown((byte)3, 6000);
                ((StandUser)this.getSelf()).roundabout$tryPower(28, true);
                this.tryPowerPacket((byte)28);
            }
        }
    }

    private boolean generateKey() {
        if (this.getSelf().m_9236_().f_46443_) {
            return true;
        }
        if (!this.isInD4CWorld()) {
            return false;
        }
        Level level = this.getSelf().m_9236_();
        StandEntity entity = this.getStandEntity(this.getSelf());
        if (entity == null) {
            return false;
        }
        ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_235902_, entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), 1, 0.0, 0.0, 0.0, 1.0);
        ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123810_, entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), 25, (double)0.2f, (double)0.4f, (double)0.2f, (double)0.3f);
        ItemStack stack = ModItems.INTERDIMENSIONAL_KEY.m_7968_();
        InterdimensionalKeyItem.setLinkedDimension(stack, this.getSelf().m_9236_().m_46472_().m_135782_());
        ((ServerPlayer)this.getSelf()).m_36356_(stack);
        return true;
    }

    private void highlightBlocksInFrustum(int angle, int offset) {
        ++this.betweenVisionTicks;
        if (this.betweenVisionTicks < 10) {
            return;
        }
        this.betweenVisionTicks = 0;
        HashSet<BlockPos> highlighted = new HashSet<BlockPos>();
        for (int pitch = -angle; pitch < angle; pitch += offset) {
            for (int yaw = -angle; yaw < angle; yaw += offset) {
                BlockPos state = ClientUtil.raycastForBlockGivenAngle(Math.toRadians(pitch), Math.toRadians(yaw), 100);
                if (state == null || !highlighted.add(state) || !this.isBetweenTwoThings(state.m_7494_())) continue;
                this.getSelf().m_9236_().m_6493_((ParticleOptions)ModParticles.D4C_LINES, true, (double)((float)state.m_123341_() + 0.5f), (double)((float)state.m_123342_() + 1.0f), (double)((float)state.m_123343_() + 0.5f), 0.0, Math.random() * (double)0.04f - (double)0.02f, 0.0);
            }
        }
    }

    private BlockHitResult getGrabBlock() {
        Vec3 vec3d = this.getSelf().m_20299_(0.0f);
        Vec3 vec3d2 = this.getSelf().m_20252_(0.0f);
        Vec3 vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * 5.0, vec3d2.f_82480_ * 5.0, vec3d2.f_82481_ * 5.0);
        BlockHitResult blockHit = this.getSelf().m_9236_().m_45547_(new ClipContext(vec3d, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.getSelf()));
        if (blockHit.m_6662_() == HitResult.Type.BLOCK) {
            return blockHit;
        }
        return null;
    }

    private boolean spawnClone() {
        LivingEntity livingEntity = this.getSelf();
        if (!(livingEntity instanceof Player)) {
            return false;
        }
        Player PE = (Player)livingEntity;
        D4CCloneEntity entity = (D4CCloneEntity)ModEntities.D4C_CLONE.m_20615_(this.getSelf().m_9236_());
        if (entity == null) {
            Roundabout.LOGGER.error("Error in PowersD4C: clone entity was null after attempting to create it!");
            return false;
        }
        entity.m_20248_(this.getSelf().m_20185_(), this.getSelf().m_20186_(), this.getSelf().m_20189_());
        entity.setPlayer(PE);
        entity.m_146922_(this.getSelf().m_146908_());
        entity.m_146926_(this.getSelf().m_146909_());
        this.getSelf().m_9236_().m_7967_((Entity)entity);
        return true;
    }

    private void swapClone(D4CCloneEntity clone) {
        LivingEntity livingEntity = this.getSelf();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player PE = (Player)livingEntity;
        if (clone.player != PE) {
            return;
        }
        Vec3 clonePos = clone.m_20182_();
        float cloneXRot = clone.m_146909_();
        float cloneYRot = clone.m_146908_();
        float cloneHealth = clone.m_21223_();
        ArrayList<MobEffectInstance> cloneEffects = new ArrayList<MobEffectInstance>();
        for (Object effect : clone.m_21220_()) {
            cloneEffects.add(new MobEffectInstance((MobEffectInstance)effect));
        }
        ArrayList<MobEffectInstance> playerEffects = new ArrayList<MobEffectInstance>();
        for (MobEffectInstance effect : PE.m_21220_()) {
            playerEffects.add(new MobEffectInstance(effect));
        }
        clone.m_6021_(PE.m_20185_(), PE.m_20186_(), PE.m_20189_());
        clone.m_146922_(PE.m_146908_());
        clone.m_146926_(PE.m_146909_());
        clone.m_21153_(PE.m_21223_());
        PE.m_6021_(clonePos.f_82479_, clonePos.f_82480_, clonePos.f_82481_);
        PE.m_7678_(clonePos.f_82479_, clonePos.f_82480_, clonePos.f_82481_, cloneXRot, cloneYRot);
        PE.m_21153_(cloneHealth);
        for (MobEffectInstance effect : clone.m_21220_()) {
            clone.m_21195_(effect.m_19544_());
        }
        for (MobEffectInstance effect : PE.m_21220_()) {
            PE.m_21195_(effect.m_19544_());
        }
        for (MobEffectInstance effect : cloneEffects) {
            PE.m_7292_(new MobEffectInstance(effect));
        }
        for (MobEffectInstance effect : playerEffects) {
            clone.m_7292_(new MobEffectInstance(effect));
        }
        StandUser SU = (StandUser)PE;
        StandUser CSU = (StandUser)((Object)clone);
        byte playerLocacacaCurse = SU.roundabout$getLocacacaCurse();
        byte cloneLocacacaCurse = CSU.roundabout$getLocacacaCurse();
        SU.roundabout$setLocacacaCurse(cloneLocacacaCurse);
        CSU.roundabout$setLocacacaCurse(playerLocacacaCurse);
        byte playerOnStandFire = SU.roundabout$getOnStandFire();
        byte cloneOnStandFire = CSU.roundabout$getOnStandFire();
        SU.roundabout$setOnStandFire(cloneOnStandFire);
        CSU.roundabout$setOnStandFire(playerOnStandFire);
    }

    private void yoinkCurrency() {
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            Player pe = (Player)livingEntity;
            int count = 0;
            Inventory inventory = pe.m_150109_();
            for (int i = 0; i < inventory.f_35974_.size(); ++i) {
                ItemStack stack = (ItemStack)inventory.f_35974_.get(i);
                if (!stack.m_150930_(Items.f_42616_) && !stack.m_150930_(Items.f_42110_)) continue;
                count += stack.m_41613_();
                pe.m_36176_(stack.m_41777_(), false);
                inventory.m_6836_(i, ItemStack.f_41583_);
            }
            if (count >= 1) {
                pe.m_5661_((Component)Component.m_237110_((String)"item.roundabout.d4c.lost_emeralds", (Object[])new Object[]{count}), true);
            }
        }
    }

    private boolean teleportToD4CWorld() {
        if (this.getSelf().m_20194_() == null) {
            return false;
        }
        StandEntity thisEntity = this.getStandEntity(this.getSelf());
        if (thisEntity == null) {
            return false;
        }
        if (InterdimensionalKeyItem.isLinked(this.getSelf().m_21206_())) {
            this.setAttackTimeDuring(0);
            this.setActivePower((byte)33);
            this.animateStand((byte)30);
            this.poseStand((byte)2);
        } else {
            this.setAttackTimeDuring(0);
            this.setActivePower((byte)27);
            this.animateStand((byte)30);
            this.poseStand((byte)2);
        }
        return true;
    }

    private void updateTeleport() {
        if (InterdimensionalKeyItem.isLinked(this.getSelf().m_21206_())) {
            if (this.getSelf().m_9236_().f_46443_ && !this.getSelf().m_9236_().m_46472_().m_135782_().m_135815_().equals("overworld")) {
                this.setCooldown((byte)3, 400);
            }
            if (this.getSelf().m_20194_() == null) {
                return;
            }
            if (this.attackTimeDuring > 39) {
                this.attackTimeDuring = -1;
                this.animateStand((byte)0);
                MinecraftServer server = this.getSelf().m_20194_();
                ServerLevel oldLevel = server.m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)InterdimensionalKeyItem.getLinkedDimension(this.getSelf().m_21206_())));
                if (oldLevel == null) {
                    Roundabout.LOGGER.error("Exception while teleporting to linked level: oldLevel was null!");
                    return;
                }
                this.yoinkCurrency();
                ServerPlayer player = (ServerPlayer)this.getSelf();
                player.m_8999_(oldLevel, player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_146908_(), player.m_146909_());
                ((StandUser)player).roundabout$summonStand((Level)oldLevel, true, false);
                return;
            }
        } else {
            if (this.getSelf().m_9236_().f_46443_ && !this.getSelf().m_9236_().m_46472_().m_135782_().m_135815_().equals("overworld")) {
                this.setCooldown((byte)3, 4000);
            }
            if (this.attackTimeDuring > 39) {
                this.attackTimeDuring = -1;
                this.animateStand((byte)0);
                MinecraftServer server = this.getSelf().m_20194_();
                if (server == null) {
                    return;
                }
                ServerLevel overworld = server.m_129783_();
                ServerPlayer player = (ServerPlayer)this.getSelf();
                if (player.m_9236_() != player.m_20194_().m_129783_() && DynamicWorld.isWorldDynamic(player.m_9236_())) {
                    this.yoinkCurrency();
                    player.m_8999_(overworld, player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_146908_(), player.m_146909_());
                    ((StandUser)player).roundabout$summonStand((Level)overworld, true, false);
                    DynamicWorld.deregisterWorld(player.m_20194_(), player.m_9236_().m_46472_().m_135782_().m_135815_());
                    return;
                }
                DynamicWorld world = DynamicWorld.generateD4CWorld(player.m_20194_());
                if (world.getLevel() != null) {
                    this.yoinkCurrency();
                    queuedWorldTransports.put(player.m_19879_(), world);
                    world.broadcastPacketsToPlayers(player.m_20194_());
                    return;
                }
            }
        }
    }

    private boolean teleportToD4CWorldKidnap() {
        if (this.getSelf().m_20194_() == null) {
            return false;
        }
        BlockPos thisPosition = this.getSelf().m_20183_();
        int radius = 5;
        List entities = this.getSelf().m_20194_().m_129783_().m_45971_(LivingEntity.class, TargetingConditions.f_26872_, this.getSelf(), new AABB(thisPosition).m_82400_((double)radius));
        DynamicWorld world = DynamicWorld.generateD4CWorld(this.getSelf().m_20194_());
        if (world.getLevel() == null) {
            return false;
        }
        this.yoinkCurrency();
        queuedWorldTransports.put(this.getSelf().m_19879_(), world);
        for (LivingEntity entity : entities) {
            if (entity.equals((Object)this.getSelf()) || entity instanceof StandEntity) continue;
            if (entity instanceof Player) {
                queuedWorldTransports.put(entity.m_19879_(), world);
                continue;
            }
            entity.m_264318_(world.getLevel(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), Set.of(RelativeMovement.X, RelativeMovement.Y, RelativeMovement.Z), entity.m_146908_(), entity.m_146909_());
        }
        world.broadcastPacketsToPlayers(this.getSelf().m_20194_());
        return true;
    }

    private boolean meltDodge() {
        if (this.getSelf().m_9236_().f_46443_) {
            return false;
        }
        this.meltDodgeTicks = 0;
        return true;
    }

    public void ejectParallelRunning() {
        if (this.parallelThread != null) {
            this.parallelThread.interrupt();
        }
    }

    private boolean parallelRunning() {
        if (this.isPRunning) {
            if (this.parallelThread != null && this.parallelThread.isAlive()) {
                this.parallelThread.interrupt();
                Roundabout.LOGGER.info("Parallel running interrupted");
            }
            return false;
        }
        LivingEntity self = this.getSelf();
        Level level = self.m_9236_();
        BlockPos bottom = self.m_20183_();
        BlockPos top = bottom.m_7494_();
        double oldX = self.m_20185_();
        double oldY = self.m_20186_();
        double oldZ = self.m_20189_();
        float yaw = self.m_6080_();
        float pitch = self.m_146909_();
        float yRot = self.m_146908_();
        this.isPRunning = true;
        ((StandUser)self).roundabout$setParallelRunning(true);
        this.scopeLevel = 3;
        this.parallelThread = new Thread(() -> {
            Runnable cleanup = () -> {
                this.isPRunning = false;
                ((StandUser)self).roundabout$setParallelRunning(false);
                if (!level.f_46443_) {
                    if (level.m_8055_(bottom).m_60713_(ModBlocks.D4C_LIGHT_BLOCK)) {
                        level.m_7731_(bottom, Blocks.f_50016_.m_49966_(), 3);
                    }
                    if (level.m_8055_(top).m_60713_(ModBlocks.D4C_LIGHT_BLOCK)) {
                        level.m_7731_(top, Blocks.f_50016_.m_49966_(), 3);
                    }
                }
                if (!this.isBetweenTwoThings(self.m_20183_())) {
                    self.m_6021_(oldX, oldY, oldZ);
                    self.m_146926_(pitch);
                    self.m_5616_(yaw);
                    self.m_5618_(yRot);
                }
                this.scopeLevel = 0;
                Roundabout.LOGGER.info("Stopped P Running");
                if (!this.getSelf().m_9236_().f_46443_) {
                    S2CPacketUtil.ejectParallelRunningPacket((Player)((ServerPlayer)this.getSelf()));
                }
                this.setCooldown((byte)8, pRunningTimeLimit + 5);
            };
            try {
                Thread.sleep((long)pRunningTimeLimit * 1000L);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                if (level.f_46443_) {
                    Minecraft.m_91087_().execute(cleanup);
                } else {
                    self.m_20194_().execute(cleanup);
                }
            }
        });
        this.parallelThread.start();
        UUID uuid = this.getSelf().m_20148_();
        if (!level.f_46443_ && self.m_20194_() != null) {
            D4CLightBlockEntity d4cBe;
            BlockEntity be;
            if (level.m_8055_(bottom).m_60795_()) {
                level.m_7731_(bottom, ModBlocks.D4C_LIGHT_BLOCK.m_49966_(), 3);
                be = level.m_7702_(bottom);
                if (be instanceof D4CLightBlockEntity) {
                    d4cBe = (D4CLightBlockEntity)be;
                    d4cBe.setOwner(uuid);
                }
            }
            if (level.m_8055_(top).m_60795_()) {
                level.m_7731_(top, ModBlocks.D4C_LIGHT_BLOCK.m_49966_(), 3);
                be = level.m_7702_(top);
                if (be instanceof D4CLightBlockEntity) {
                    d4cBe = (D4CLightBlockEntity)be;
                    d4cBe.setOwner(uuid);
                }
            }
        }
        return true;
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        return super.tryPower(move, forced);
    }

    @Override
    public boolean isAttackIneptVisually(byte activeP, int slot) {
        switch (activeP) {
            case 4: {
                return !this.isInD4CWorld();
            }
            case 8: {
                return !this.isBetweenTwoThings();
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                return !this.isBetweenTwoThings() && !this.isPRunning;
            }
        }
        return super.isAttackIneptVisually(activeP, slot);
    }

    @Override
    public void tickPower() {
        super.tickPower();
    }

    public void meltDodge(AbstractArrow arrow) {
    }

    public boolean isBetweenTwoThings() {
        return this.isBetweenTwoThings(this.getSelf().m_20183_());
    }

    public boolean isBlockSolid(BlockPos pos) {
        BlockState state = this.getSelf().m_9236_().m_8055_(pos);
        return state.m_280296_() && !state.m_60795_() && !state.m_60713_(ModBlocks.D4C_LIGHT_BLOCK);
    }

    public boolean isBetweenTwoThings(BlockPos pos) {
        return this.isBlockSolid(pos.m_121996_(new Vec3i(0, 1, 0))) && this.isBlockSolid(pos.m_121996_(new Vec3i(0, -2, 0))) && !this.isBlockSolid(pos) && !this.isBlockSolid(pos.m_121996_(new Vec3i(0, -1, 0)));
    }

    public boolean isInD4CWorld() {
        return this.getSelf().m_9236_().m_46472_().m_135782_().toString().startsWith("roundabout:d4c-");
    }

    @Override
    public List<Byte> getSkinList() {
        return Arrays.asList((byte)0, (byte)1, (byte)2, (byte)3, (byte)4, (byte)5);
    }

    @Override
    public boolean setPowerOther(int move, int lastMove) {
        switch (move) {
            case 44: {
                return this.generateKey();
            }
            case 23: {
                return this.spawnClone();
            }
            case 25: {
                return this.meltDodge();
            }
            case 46: {
                return this.parallelRunning();
            }
            case 27: 
            case 33: {
                return this.teleportToD4CWorld();
            }
            case 28: {
                return this.teleportToD4CWorldKidnap();
            }
        }
        return super.setPowerOther(move, lastMove);
    }

    @Override
    public void updateIntMove(int in) {
        Entity targeted = this.getSelf().m_9236_().m_6815_(in);
        if (targeted instanceof D4CCloneEntity) {
            D4CCloneEntity clone = (D4CCloneEntity)targeted;
            this.swapClone(clone);
        }
        super.updateIntMove(in);
    }

    @Override
    public void updateUniqueMoves() {
        if (this.getActivePower() == 27 || this.getActivePower() == 33) {
            this.updateTeleport();
        }
        super.updateUniqueMoves();
    }

    @Override
    public boolean isWip() {
        return true;
    }

    @Override
    public Component ifWipListDevStatus() {
        return Component.m_237115_((String)"roundabout.dev_status.dropped").m_130940_(ChatFormatting.AQUA);
    }

    @Override
    public Component ifWipListDev() {
        return Component.m_237113_((String)"Zeta").m_130940_(ChatFormatting.YELLOW);
    }

    @Override
    public Component getSkinName(byte skinId) {
        switch (skinId) {
            case 1: {
                return Component.m_237115_((String)"skins.roundabout.d4c.wonder_festival");
            }
            case 2: {
                return Component.m_237115_((String)"skins.roundabout.d4c.promo");
            }
            case 3: {
                return Component.m_237115_((String)"skins.roundabout.d4c.promo_l");
            }
            case 4: {
                return Component.m_237115_((String)"skins.roundabout.d4c.special");
            }
            case 5: {
                return Component.m_237115_((String)"skins.roundabout.d4c.grand");
            }
        }
        return Component.m_237115_((String)"skins.roundabout.d4c.base");
    }
}

