/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.stand.powers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.AbilityIconInstance;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.stand.powers.presets.NewPunchingStand;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class PowersKillerQueen
extends NewPunchingStand {
    public float standReach = 5.0f;
    public boolean wentForCharge = false;

    @Override
    public void powerActivate(PowerContext context) {
        switch (context) {
            // Empty switch
        }
    }

    @Override
    public List<Byte> getSkinList() {
        return Arrays.asList((byte)0);
    }

    public PowersKillerQueen(LivingEntity self) {
        super(self);
    }

    @Override
    public StandPowers generateStandPowers(LivingEntity entity) {
        return new PowersKillerQueen(entity);
    }

    @Override
    public int getMaxGuardPoints() {
        return 15;
    }

    @Override
    public void handleStandAttack(Player player, Entity target) {
        super.handleStandAttack(player, target);
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        return super.tryPower(move, forced);
    }

    @Override
    public StandEntity getNewStandEntity() {
        return (StandEntity)ModEntities.KILLER_QUEEN.m_20615_(this.getSelf().m_9236_());
    }

    @Override
    public void tickMobAI(LivingEntity attackTarget) {
        if (attackTarget != null && attackTarget.m_6084_()) {
            Entity targetEntity;
            if (this.getActivePower() == 1 || this.getActivePower() == 5 || attackTarget.m_20270_((Entity)this.getSelf()) <= 5.0f) {
                this.getSelf().m_146926_(this.getLookAtEntityPitch((Entity)this.getSelf(), (Entity)attackTarget));
                float yrot = this.getLookAtEntityYaw((Entity)this.getSelf(), (Entity)attackTarget);
                this.getSelf().m_146922_(yrot);
                this.getSelf().m_5616_(yrot);
            }
            if ((targetEntity = this.getTargetEntity(this.self, -1.0f)) != null && targetEntity.m_7306_((Entity)attackTarget) && this.attackTimeDuring <= -1) {
                double RNG = Math.random();
                if (RNG < 0.35 && targetEntity instanceof Player && this.activePowerPhase <= 0 && !this.wentForCharge) {
                    this.wentForCharge = true;
                    ((StandUser)this.getSelf()).roundabout$tryPower(4, true);
                } else {
                    Objects.requireNonNull(this);
                    if (this.activePowerPhase < 3 || this.attackTime >= this.attackTimeMax) {
                        this.wentForCharge = false;
                        ((StandUser)this.getSelf()).roundabout$tryPower(1, true);
                    }
                }
            }
        }
    }

    @Override
    public boolean setPowerAttack() {
        if (this.activePowerPhase >= 3) {
            this.activePowerPhase = 1;
        } else {
            this.activePowerPhase = (byte)(this.activePowerPhase + 1);
            this.attackTimeMax = this.activePowerPhase == 3 ? 37 : 27;
        }
        this.attackTimeDuring = 0;
        this.setActivePower((byte)1);
        this.setAttackTime(0);
        this.animateStand(this.activePowerPhase);
        this.poseStand((byte)1);
        return true;
    }

    @Override
    public void punchImpact(Entity entity) {
        this.setAttackTimeDuring(-10);
        if (entity != null) {
            float knockbackStrength;
            float pow;
            if (this.getActivePowerPhase() >= this.getActivePowerPhaseMax()) {
                pow = this.getHeavyPunchStrength(entity);
                knockbackStrength = 1.0f;
            } else {
                pow = this.getPunchStrength(entity);
                knockbackStrength = 0.2f;
            }
            if (this.StandDamageEntityAttack(entity, pow, 0.0f, (Entity)this.self)) {
                this.takeDeterminedKnockback(this.self, entity, knockbackStrength);
            } else {
                Objects.requireNonNull(this);
                if (this.activePowerPhase >= 3) {
                    this.knockShield2(entity, 40);
                }
            }
        } else {
            float distMax = this.getDistanceOut(this.self, this.standReach, false);
            float halfReach = (float)((double)distMax * 0.5);
            Vec3 pointVec = DamageHandler.getRayPoint(this.self, halfReach);
            if (!this.self.m_9236_().f_46443_) {
                ((ServerLevel)this.self.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, pointVec.f_82479_, pointVec.f_82480_, pointVec.f_82481_, 1, 0.0, 0.0, 0.0, 1.0);
            }
        }
    }

    @Override
    public boolean setPowerBarrageCharge() {
        this.animateStand((byte)11);
        this.attackTimeDuring = 0;
        this.setActivePower((byte)4);
        this.poseStand((byte)1);
        this.clashDone = false;
        this.playBarrageChargeSound();
        return true;
    }

    @Override
    public void setPowerBarrage() {
        this.attackTimeDuring = 0;
        this.setActivePower((byte)5);
        this.poseStand((byte)1);
        this.setAttackTimeMax(this.getBarrageRecoilTime());
        this.setActivePowerPhase(this.getActivePowerPhaseMax());
        this.animateStand((byte)12);
        this.playBarrageCrySound();
    }

    @Override
    public void updateMovesFromPacket(byte activePower) {
        if (activePower == 5) {
            Objects.requireNonNull(this);
            this.setActivePowerPhase((byte)3);
        }
        super.updateMovesFromPacket(activePower);
    }

    @Override
    public byte chooseBarrageSound() {
        return 6;
    }

    @Override
    protected Byte getSummonSound() {
        return (byte)18;
    }

    @Override
    public SoundEvent getSoundFromByte(byte soundChoice) {
        Roundabout.LOGGER.info("" + soundChoice);
        switch (soundChoice) {
            case 6: {
                return ModSounds.KILLER_QUEEN_BARRAGE_EVENT;
            }
            case 18: {
                return ModSounds.KILLER_QUEEN_SUMMON_EVENT;
            }
        }
        return super.getSoundFromByte(soundChoice);
    }

    @Override
    public boolean tryBlockPosPower(int move, boolean forced, BlockPos blockPos) {
        if (move == 21) {
            // empty if block
        }
        return true;
    }

    @Override
    public void buttonInput2(boolean KeyIsDown, Options options) {
    }

    @Override
    public void renderIcons(GuiGraphics context, int x, int y) {
        if (this.isHoldingSneak()) {
            this.setSkillIcon(context, x, y, 1, StandIcons.LOCKED, (byte)0);
        } else {
            this.setSkillIcon(context, x, y, 1, StandIcons.LOCKED, (byte)-1);
        }
        this.setSkillIcon(context, x, y, 2, StandIcons.LOCKED, (byte)1);
        if (this.isHoldingSneak()) {
            this.setSkillIcon(context, x, y, 3, StandIcons.LOCKED, (byte)0);
        } else {
            this.setSkillIcon(context, x, y, 3, StandIcons.DODGE, (byte)0);
        }
        this.setSkillIcon(context, x, y, 4, StandIcons.LOCKED, (byte)3);
    }

    @Override
    public List<AbilityIconInstance> drawGUIIcons(GuiGraphics context, float delta, int mouseX, int mouseY, int leftPos, int topPos, byte level, boolean bypas) {
        ArrayList $$1 = Lists.newArrayList();
        return $$1;
    }

    @Override
    public void renderAttackHud(GuiGraphics context, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        StandUser standUser = (StandUser)playerEntity;
        boolean standOn = standUser.roundabout$getActive();
        int j = scaledHeight / 2 - 7 - 4;
        int k = scaledWidth / 2 - 8;
        float attackTimeDuring = standUser.roundabout$getAttackTimeDuring();
        if (standOn && standUser.roundabout$isClashing()) {
            int ClashTime = 15 - Math.round(attackTimeDuring / 60.0f * 15.0f);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 30, ClashTime, 6);
        } else if (standOn && standUser.roundabout$getStandPowers().isBarrageAttacking() && attackTimeDuring > -1.0f) {
            int ClashTime = 15 - Math.round(attackTimeDuring / (float)standUser.roundabout$getStandPowers().getBarrageLength() * 15.0f);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 30, ClashTime, 6);
        } else if (standOn && standUser.roundabout$getStandPowers().isBarrageCharging()) {
            int ClashTime = Math.round(attackTimeDuring / (float)standUser.roundabout$getStandPowers().getBarrageWindup() * 15.0f);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 30, ClashTime, 6);
        } else {
            float attackTime;
            float finalATime;
            int barTexture = 0;
            Entity TE = standUser.roundabout$getTargetEntity((LivingEntity)playerEntity, -1.0f);
            float attackTimeMax = standUser.roundabout$getAttackTimeMax();
            if (attackTimeMax > 0.0f && (finalATime = (attackTime = (float)standUser.roundabout$getAttackTime()) / attackTimeMax) <= 1.0f) {
                barTexture = standUser.roundabout$getActivePowerPhase() == standUser.roundabout$getActivePowerPhaseMax() ? 24 : (TE != null ? 12 : 18);
                context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
                int finalATimeInt = Math.round(finalATime * 15.0f);
                context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, barTexture, finalATimeInt, 6);
            }
            if (standOn && TE != null && barTexture == 0) {
                context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 0, 15, 6);
            }
        }
    }

    @Override
    public boolean isWip() {
        return true;
    }

    @Override
    public Component ifWipListDevStatus() {
        return Component.m_237115_((String)"roundabout.dev_status.paused").m_130940_(ChatFormatting.AQUA);
    }

    @Override
    public Component ifWipListDev() {
        return Component.m_237113_((String)"Ashley").m_130940_(ChatFormatting.YELLOW);
    }

    @Override
    public Component getSkinName(byte skinId) {
        switch (skinId) {
            case 0: {
                return Component.m_237115_((String)"skins.roundabout.killer_queen.base");
            }
        }
        return Component.m_237115_((String)"skins.roundabout.killer_queen.base");
    }
}

