/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.hydra.jojomod.access.IKeyMapping;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.client.KeyInputRegistry;
import net.hydra.jojomod.event.index.Corpses;
import net.hydra.jojomod.event.index.ShapeShifts;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.networking.ModPacketHandler;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class CorpseBagScreen
extends Screen {
    static final ResourceLocation CORPSE_CHOOSER_LOCATION = new ResourceLocation("roundabout", "textures/gui/corpse_chooser.png");
    private static final int SPRITE_SHEET_WIDTH = 256;
    private static final int SPRITE_SHEET_HEIGHT = 256;
    private static final int SLOT_AREA = 26;
    private static final int SLOT_PADDING = 5;
    private static final int SLOT_AREA_PADDED = 31;
    private static final int HELP_TIPS_OFFSET_Y = 5;
    private static final int ALL_SLOTS_WIDTH = corpseIcon.VALUES.length * 31 - 5;
    private corpseIcon currentlyHovered = null;
    private int firstMouseX;
    private int firstMouseY;
    private boolean setFirstMousePos;
    public boolean zHeld;
    public final ItemStack stack;
    private final List<PoseSlot> slots = Lists.newArrayList();
    public int zombies = 0;
    public int skeletons = 0;
    public int spiders = 0;
    public int villagers = 0;
    public int creepers = 0;

    public CorpseBagScreen() {
        super(GameNarrator.f_93310_);
        this.stack = null;
    }

    public CorpseBagScreen(ItemStack stack) {
        super(GameNarrator.f_93310_);
        this.stack = stack;
    }

    private ShapeShifts getDefaultSelected() {
        LocalPlayer pl = Minecraft.m_91087_().f_91074_;
        if (pl != null) {
            return ShapeShifts.getShiftFromByte(((IPlayerEntity)pl).roundabout$getShapeShift());
        }
        return ShapeShifts.PLAYER;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.zHeld = true;
        LocalPlayer pl = Minecraft.m_91087_().f_91074_;
        if (this.stack != null && !this.stack.m_41619_()) {
            CompoundTag $$1 = this.stack.m_41698_("bodies");
            this.zombies = $$1.m_128451_("zombie");
            this.skeletons = $$1.m_128451_("skeleton");
            this.spiders = $$1.m_128451_("spider");
            this.villagers = $$1.m_128451_("villager");
            this.creepers = $$1.m_128451_("creeper");
        } else {
            this.zombies = 0;
            this.skeletons = 0;
            this.spiders = 0;
            this.villagers = 0;
            this.creepers = 0;
        }
        this.currentlyHovered = corpseIcon.NONE;
        for (int i = 0; i < corpseIcon.VALUES.length; ++i) {
            corpseIcon pIcon = corpseIcon.VALUES[i];
            this.slots.add(new PoseSlot(pIcon, this.f_96543_ / 2 + pIcon.xoff - 13, this.f_96544_ / 2 + pIcon.yoff - 44));
        }
    }

    public boolean m_6348_(double $$0, double $$1, int $$2) {
        this.switchToHoveredGameMode();
        this.f_96541_.m_91152_(null);
        return true;
    }

    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        if (this.checkToClose()) {
            return;
        }
        guiGraphics.m_280168_().m_85836_();
        RenderSystem.enableBlend();
        int k = this.f_96543_ / 2 - 62;
        int l = this.f_96544_ / 2 - 31 - 39;
        guiGraphics.m_280163_(CORPSE_CHOOSER_LOCATION, k, l, 0.0f, 0.0f, 125, 63, 256, 256);
        guiGraphics.m_280168_().m_85849_();
        super.m_88315_(guiGraphics, i, j, f);
        if (this.currentlyHovered != null) {
            guiGraphics.m_280653_(this.f_96547_, this.currentlyHovered.getName(), this.f_96543_ / 2, this.f_96544_ / 2 - 31 - 32, -1);
        }
        if (!this.setFirstMousePos) {
            this.firstMouseX = i;
            this.firstMouseY = j;
            this.setFirstMousePos = true;
        }
        boolean bl = this.firstMouseX == i && this.firstMouseY == j;
        for (PoseSlot MobSlot2 : this.slots) {
            MobSlot2.m_88315_(guiGraphics, i, j, f);
            MobSlot2.setSelected(this.currentlyHovered == MobSlot2.icon);
            if (bl || !MobSlot2.m_198029_()) continue;
            this.currentlyHovered = MobSlot2.icon;
        }
        if (!this.stack.m_150930_(ModItems.CREATIVE_BODY_BAG)) {
            for (int m = 0; m < corpseIcon.VALUES.length; ++m) {
                corpseIcon pIcon = corpseIcon.VALUES[m];
                if (pIcon.id == corpseIcon.NONE.id) continue;
                int num = 0;
                if (pIcon == corpseIcon.ZOMBIE) {
                    num = this.zombies;
                } else if (pIcon == corpseIcon.SKELETON) {
                    num = this.skeletons;
                } else if (pIcon == corpseIcon.CREEPER) {
                    num = this.creepers;
                } else if (pIcon == corpseIcon.SPIDER) {
                    num = this.spiders;
                } else if (pIcon == corpseIcon.VILLAGER) {
                    num = this.villagers;
                }
                guiGraphics.m_280488_(this.f_96547_, "" + num, this.f_96543_ / 2 + pIcon.xoff - 13, this.f_96544_ / 2 + pIcon.yoff - 44, -1);
            }
        }
    }

    private void switchToHoveredGameMode() {
        this.switchToHoveredGameMode(this.f_96541_, this.currentlyHovered);
    }

    private void switchToHoveredGameMode(Minecraft minecraft, corpseIcon pIcon) {
        if (minecraft.f_91072_ == null || minecraft.f_91074_ == null) {
            return;
        }
        if (this.stack != null && !this.stack.m_41619_() && minecraft.f_91074_ != null) {
            Vec3 vec3d = minecraft.f_91074_.m_20299_(0.0f);
            Vec3 vec3d2 = minecraft.f_91074_.m_20252_(0.0f);
            Vec3 vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * 5.0, vec3d2.f_82480_ * 5.0, vec3d2.f_82481_ * 5.0);
            BlockHitResult blockHit = minecraft.f_91074_.m_9236_().m_45547_(new ClipContext(vec3d, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)minecraft.f_91074_));
            Vector3f vc = minecraft.f_91074_.m_20182_().m_252839_();
            if (blockHit.m_6662_() == HitResult.Type.BLOCK) {
                vc = blockHit.m_82425_().m_252807_().m_252839_().add(0.0f, 1.0f, 0.0f);
            }
            ModPacketHandler.PACKET_ACCESS.itemContextToServer(pIcon.id, this.stack, (byte)3, vc);
        }
    }

    public boolean sameKeyOne(KeyMapping key1, Options options) {
        return key1.m_90857_() || key1.m_90850_(options.f_92058_) && options.f_92058_.m_90857_() || key1.m_90850_(options.f_92057_) && options.f_92057_.m_90857_();
    }

    public boolean sameKeyOneX(KeyMapping key1, Options options) {
        return InputConstants.m_84830_((long)this.f_96541_.m_91268_().m_85439_(), (int)((IKeyMapping)key1).roundabout$justTellMeTheKey().m_84873_()) || key1.m_90850_(options.f_92058_) && InputConstants.m_84830_((long)this.f_96541_.m_91268_().m_85439_(), (int)((IKeyMapping)options.f_92058_).roundabout$justTellMeTheKey().m_84873_()) || key1.m_90850_(options.f_92057_) && InputConstants.m_84830_((long)this.f_96541_.m_91268_().m_85439_(), (int)((IKeyMapping)options.f_92057_).roundabout$justTellMeTheKey().m_84873_());
    }

    private boolean checkToClose() {
        if (this.f_96541_ != null && this.sameKeyOneX(KeyInputRegistry.abilityTwoKey, this.f_96541_.f_91066_)) {
            this.switchToHoveredGameMode();
            this.f_96541_.m_91152_(null);
            return true;
        }
        Options options = Minecraft.m_91087_().f_91066_;
        return false;
    }

    public boolean m_7933_(int i, int j, int k) {
        return super.m_7933_(i, j, k);
    }

    public boolean m_7043_() {
        return false;
    }

    public static enum corpseIcon {
        ZOMBIE((Component)Component.m_237115_((String)"entity.minecraft.zombie"), new ResourceLocation("roundabout", "textures/gui/corpse_icons/zombie.png"), Corpses.ZOMBIE.id, -31, 31),
        SKELETON((Component)Component.m_237115_((String)"entity.minecraft.skeleton"), new ResourceLocation("roundabout", "textures/gui/corpse_icons/skeleton.png"), Corpses.SKELETON.id, 0, 0),
        CREEPER((Component)Component.m_237115_((String)"entity.minecraft.creeper"), new ResourceLocation("roundabout", "textures/gui/corpse_icons/creeper.png"), Corpses.CREEPER.id, 31, 0),
        VILLAGER((Component)Component.m_237115_((String)"entity.minecraft.villager"), new ResourceLocation("roundabout", "textures/gui/corpse_icons/villager.png"), Corpses.VILLAGER.id, -31, 0),
        SPIDER((Component)Component.m_237115_((String)"entity.minecraft.spider"), new ResourceLocation("roundabout", "textures/gui/corpse_icons/spider.png"), Corpses.SPIDER.id, 31, 31),
        NONE((Component)Component.m_237115_((String)"roundabout.corpse.none"), new ResourceLocation("roundabout", "textures/gui/pose_icons/jonathan.png"), Corpses.NONE.id, 0, 31);

        protected static final corpseIcon[] VALUES;
        private static final int ICON_AREA = 16;
        protected static final int ICON_TOP_LEFT = 5;
        final Component name;
        final ResourceLocation rl;
        final byte id;
        final int xoff;
        final int yoff;

        static corpseIcon getByte(Corpses corpse) {
            return switch (corpse) {
                default -> throw new IncompatibleClassChangeError();
                case Corpses.ZOMBIE -> ZOMBIE;
                case Corpses.SKELETON -> SKELETON;
                case Corpses.CREEPER -> CREEPER;
                case Corpses.VILLAGER -> VILLAGER;
                case Corpses.SPIDER -> SPIDER;
                case Corpses.NONE -> NONE;
            };
        }

        private corpseIcon(Component component, ResourceLocation rl, byte id, int xoff, int yoff) {
            this.name = component;
            this.rl = rl;
            this.id = id;
            this.xoff = xoff;
            this.yoff = yoff;
        }

        void drawIcon(GuiGraphics guiGraphics, int i, int j) {
            guiGraphics.m_280163_(this.rl, i - 1, j - 1, 0.0f, 0.0f, 18, 18, 18, 18);
        }

        Component getName() {
            return this.name;
        }

        static {
            VALUES = new corpseIcon[]{ZOMBIE, SKELETON, VILLAGER, CREEPER, SPIDER, NONE};
        }
    }

    public class PoseSlot
    extends AbstractWidget {
        final corpseIcon icon;
        private boolean isSelected;

        public PoseSlot(corpseIcon pIcon, int i, int j) {
            super(i, j, 26, 26, pIcon.getName());
            this.icon = pIcon;
        }

        public void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
            if (!this.icon.equals((Object)corpseIcon.NONE)) {
                guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                if (!CorpseBagScreen.this.stack.m_150930_(ModItems.CREATIVE_BODY_BAG) && (this.icon.equals((Object)corpseIcon.CREEPER) && CorpseBagScreen.this.creepers <= 0 || this.icon.equals((Object)corpseIcon.SKELETON) && CorpseBagScreen.this.skeletons <= 0 || this.icon.equals((Object)corpseIcon.ZOMBIE) && CorpseBagScreen.this.zombies <= 0 || this.icon.equals((Object)corpseIcon.SPIDER) && CorpseBagScreen.this.spiders <= 0 || this.icon.equals((Object)corpseIcon.VILLAGER) && CorpseBagScreen.this.villagers <= 0)) {
                    guiGraphics.m_280246_(0.5f, 0.5f, 0.5f, 0.7f);
                }
                this.drawSlot(guiGraphics);
                guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                this.icon.drawIcon(guiGraphics, this.m_252754_() + 5, this.m_252907_() + 5);
                if (this.isSelected) {
                    this.drawSelection(guiGraphics);
                }
            }
        }

        public void m_168797_(NarrationElementOutput narrationElementOutput) {
            this.m_168802_(narrationElementOutput);
        }

        public boolean m_198029_() {
            return super.m_198029_() || this.isSelected;
        }

        public void setSelected(boolean bl) {
            this.isSelected = bl;
        }

        private void drawSlot(GuiGraphics guiGraphics) {
            guiGraphics.m_280163_(CORPSE_CHOOSER_LOCATION, this.m_252754_(), this.m_252907_(), 144.0f, 0.0f, 26, 26, 256, 256);
        }

        private void drawSelection(GuiGraphics guiGraphics) {
            guiGraphics.m_280163_(CORPSE_CHOOSER_LOCATION, this.m_252754_(), this.m_252907_(), 170.0f, 0.0f, 26, 26, 256, 256);
        }
    }
}

