/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.mixin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.hydra.jojomod.access.IEntityAndData;
import net.hydra.jojomod.access.ILivingEntityAccess;
import net.hydra.jojomod.access.IMob;
import net.hydra.jojomod.access.IPermaCasting;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.block.FogBlock;
import net.hydra.jojomod.block.ModBlocks;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.corpses.FallenMob;
import net.hydra.jojomod.entity.projectile.MatchEntity;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.ModEffects;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.index.OffsetIndex;
import net.hydra.jojomod.event.index.ShapeShifts;
import net.hydra.jojomod.event.index.StandFireType;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.event.powers.TimeStop;
import net.hydra.jojomod.event.powers.stand.PowersJustice;
import net.hydra.jojomod.event.powers.stand.PowersMagiciansRed;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.item.StandDiscItem;
import net.hydra.jojomod.networking.ModPacketHandler;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class StandUserEntity
extends Entity
implements StandUser {
    @Shadow
    protected boolean f_20890_;
    @Shadow
    public float f_20885_;
    @Shadow
    public float f_20883_;
    @Shadow
    protected double f_20905_;
    @Shadow
    protected double f_20906_;
    @Shadow
    protected double f_20904_;
    @Unique
    public int roundabout$remainingFireTicks = -1;
    @Unique
    public LivingEntity roundabout$fireStarter;
    @Unique
    public int roundabout$fireStarterID;
    @Shadow
    protected boolean f_20899_;
    @Shadow
    private float f_20953_;
    @Unique
    private int roundabout$leapTicks = -1;
    @Unique
    private int roundabout$detectTicks = -1;
    @Unique
    private final int roundabout$maxLeapTicks = 60;
    @Shadow
    @Final
    private Map<MobEffect, MobEffectInstance> f_20945_;
    @Unique
    private final LivingEntity roundabout$User = (LivingEntity)this;
    @Unique
    @org.jetbrains.annotations.Nullable
    private StandEntity roundabout$Stand;
    @Unique
    @org.jetbrains.annotations.Nullable
    private LivingEntity roundabout$thrower;
    @Unique
    @org.jetbrains.annotations.Nullable
    private ImmutableList<StandEntity> roundabout$followers = ImmutableList.of();
    @Unique
    private static final EntityDataAccessor<Integer> ROUNDABOUT$STAND_ID = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Unique
    private static final EntityDataAccessor<Boolean> ROUNDABOUT$STAND_ACTIVE = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    private static final EntityDataAccessor<Byte> ROUNDABOUT_TS_DAMAGE = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    @Unique
    private static final EntityDataAccessor<Byte> ROUNDABOUT$LOCACACA_CURSE = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    @Unique
    private static final EntityDataAccessor<Byte> ROUNDABOUT$ON_STAND_FIRE = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    @Unique
    private static final EntityDataAccessor<Integer> ROUNDABOUT$BLEED_LEVEL = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Unique
    private static final EntityDataAccessor<Integer> ROUNDABOUT$IS_BOUND_TO = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Unique
    private static final EntityDataAccessor<Boolean> ROUNDABOUT$ONLY_BLEEDING = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    private static final EntityDataAccessor<ItemStack> ROUNDABOUT$STAND_DISC = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    @Unique
    private StandPowers roundabout$Powers;
    @Unique
    private StandPowers roundabout$RejectionStandPowers = null;
    @Unique
    private ItemStack roundabout$RejectionStandDisc = null;
    @Unique
    public final float roundabout$maxGuardPoints = 15.0f;
    @Unique
    private float roundabout$GuardPoints = this.roundabout$getMaxGuardPoints();
    @Unique
    private boolean roundabout$GuardBroken = false;
    @Unique
    private int roundabout$GuardCooldown = 0;
    @Unique
    public boolean roundabout$blip = false;
    @Unique
    public Vector3f roundabout$blipVector;
    @Unique
    private int roundabout$gasTicks = -1;
    @Unique
    private int roundabout$gasRenderTicks = -1;
    private int roundabout$maxGasTicks = 200;
    private int roundabout$maxBucketGasTicks = 600;
    @Unique
    private int roundabout$IdleTime = -1;
    @Unique
    private byte roundabout$dazeTime = 0;
    @Unique
    private int roundabout$TSHurtTime = 0;
    @Unique
    private int roundabout$postTSHurtTime = 0;
    @Unique
    private int roundabout$extraIFrames = 0;
    @Unique
    private int roundabout$gasolineIFRAMES = 0;
    @Unique
    public boolean roundabout$toggleFightOrFlight = false;
    @Unique
    public boolean roundabout$isDrown = false;
    @Unique
    @Nullable
    private Entity roundabout$stringHolder;
    @Unique
    public byte roundabout$idlePos = 0;
    @Unique
    public byte roundabout$standSkin = 0;
    @Unique
    boolean roundabout$tsJump = false;
    @Unique
    float roundabout$storedDamage = 0.0f;
    @Unique
    Entity roundabout$storedAttacker;
    @Unique
    private int roundabout$restrainTicks = -1;
    @Unique
    private int roundabout$knifeIFrameTicks = 0;
    @Unique
    private int roundabout$stackedKnivesAndMatches = 0;
    @Unique
    private int roundabout$knifeDespawnTicks = 0;
    @Unique
    private int roundaboutTSHurtSound = 0;
    public boolean roundabout$isRedBound = false;
    @Shadow
    protected int f_20938_;
    @Unique
    public ItemStack roundabout$itemParityClient = ItemStack.f_41583_;
    @Unique
    public int roundabout$sealedTicks = -1;
    @Unique
    public int roundabout$maxSealedTicks = -1;
    @Shadow
    protected float f_20898_;

    @Shadow
    public abstract float m_6080_();

    @Shadow
    public abstract float m_21223_();

    @Shadow
    public abstract float m_21233_();

    @Shadow
    public abstract boolean m_6469_(DamageSource var1, float var2);

    @Shadow
    public abstract void m_269405_(double var1, double var3);

    @Shadow
    public abstract void m_5634_(float var1);

    @Shadow
    public abstract boolean m_6084_();

    @Shadow
    @Nullable
    public abstract MobEffectInstance m_21124_(MobEffect var1);

    public StandUserEntity(EntityType<?> $$0, Level $$1) {
        super($$0, $$1);
    }

    @Shadow
    protected abstract int m_7305_(int var1);

    @Shadow
    public boolean m_21023_(MobEffect $$0) {
        return this.f_20945_.containsKey($$0);
    }

    @Override
    @Unique
    @org.jetbrains.annotations.Nullable
    public LivingEntity roundabout$getFireStarter() {
        return this.roundabout$fireStarter;
    }

    @Override
    @Unique
    public void roundabout$setFireStarter(LivingEntity le) {
        this.roundabout$fireStarter = le;
    }

    @Override
    @Unique
    public int roundabout$getFireStarterID() {
        return this.roundabout$fireStarterID;
    }

    @Override
    @Unique
    public void roundabout$setFireStarterID(int le) {
        this.roundabout$fireStarterID = le;
    }

    @Override
    @Unique
    public int roundabout$getIdleTime() {
        return this.roundabout$IdleTime;
    }

    @Override
    @Unique
    public void roundabout$setIdleTime(int roundaboutIdleTime) {
        this.roundabout$IdleTime = roundaboutIdleTime;
    }

    @Override
    @Unique
    public void roundabout$setThrower(LivingEntity thrower) {
        this.roundabout$thrower = thrower;
    }

    @Override
    @Unique
    public void roundabout$setBlip(Vector3f vec) {
        this.roundabout$blip = true;
        this.roundabout$blipVector = vec;
    }

    @Override
    @Unique
    public LivingEntity roundabout$getThrower() {
        return this.roundabout$thrower;
    }

    @Override
    @Unique
    public void roundabout$setSecondsOnStandFire(int $$0) {
        int $$1 = $$0 * 20;
        if (this.roundabout$remainingFireTicks < $$1) {
            this.roundabout$setRemainingStandFireTicks($$1);
        }
    }

    @Override
    @Unique
    public void roundabout$setRemainingStandFireTicks(int $$0) {
        this.roundabout$remainingFireTicks = $$0;
    }

    @Override
    @Unique
    public int roundabout$getRemainingFireTicks() {
        return this.roundabout$remainingFireTicks;
    }

    @Inject(method={"hasLineOfSight(Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="HEAD", shift=At.Shift.AFTER, ordinal=0)}, cancellable=true)
    public void roundabout$tickEffects(Entity $$0, CallbackInfoReturnable<Boolean> cir) {
        if (((IPermaCasting)this.m_9236_()).roundabout$inPermaCastFogRange($$0)) {
            if ($$0.m_9236_() != this.m_9236_()) {
                cir.setReturnValue((Object)false);
                return;
            }
            Vec3 $$1 = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
            Vec3 $$2 = new Vec3($$0.m_20185_(), $$0.m_20188_(), $$0.m_20189_());
            if ($$2.m_82554_($$1) > 128.0) {
                cir.setReturnValue((Object)false);
                return;
            }
            BlockHitResult clipX = this.m_9236_().m_45547_(new ClipContext($$1, $$2, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this));
            if (clipX.m_6662_() != HitResult.Type.MISS && this.m_9236_().m_8055_(clipX.m_82425_()).m_60734_() instanceof FogBlock) {
                cir.setReturnValue((Object)false);
                return;
            }
            cir.setReturnValue((Object)(this.m_9236_().m_45547_(new ClipContext($$1, $$2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS ? 1 : 0));
        }
    }

    @Inject(method={"tickEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/syncher/SynchedEntityData;get(Lnet/minecraft/network/syncher/EntityDataAccessor;)Ljava/lang/Object;", shift=At.Shift.AFTER, ordinal=0)}, cancellable=true)
    public void roundabout$tickEffects(CallbackInfo ci) {
        int bleedlvl;
        if (!this.m_9236_().f_46443_) {
            bleedlvl = -1;
            if (this.m_21023_(ModEffects.BLEED) && this.m_21124_(ModEffects.BLEED).m_19572_()) {
                bleedlvl = this.m_21124_(ModEffects.BLEED).m_19564_();
            }
            if (this.roundabout$getBleedLevel() != bleedlvl) {
                this.roundabout$setBleedLevel(bleedlvl);
            }
            boolean onlyBleeding = true;
            if (this.f_20945_.size() > 1) {
                for (MobEffect $$1 : this.f_20945_.keySet()) {
                    MobEffectInstance $$2 = this.f_20945_.get($$1);
                    if (!$$2.m_19572_() || $$2.m_19544_().equals(ModEffects.BLEED)) continue;
                    onlyBleeding = false;
                }
            }
            if (this.roundabout$getOnlyBleeding() != onlyBleeding) {
                this.roundabout$setOnlyBleeding(onlyBleeding);
            }
        } else if (ClientNetworking.getAppropriateConfig().disableBleedingAndBloodSplatters.booleanValue() && ((IPermaCasting)this.m_9236_()).roundabout$inPermaCastFogRange(this) && this.m_21223_() < this.m_21233_()) {
            this.m_9236_().m_7106_((ParticleOptions)ModParticles.FOG_CHAIN, this.m_20208_(0.5), this.m_20187_() + (double)this.m_20206_(), this.m_20262_(0.5), 0.0, 0.2, 0.0);
        }
        if (this.roundabout$getBleedLevel() > -1) {
            if (((IPermaCasting)this.m_9236_()).roundabout$inPermaCastFogRange(this)) {
                this.m_9236_().m_7106_((ParticleOptions)ModParticles.FOG_CHAIN, this.m_20208_(0.5), this.m_20187_() + (double)this.m_20206_(), this.m_20262_(0.5), 0.0, 0.2, 0.0);
            }
            bleedlvl = this.roundabout$getBleedLevel();
            int bloodticks = 8;
            if (bleedlvl == 1) {
                bloodticks = 6;
            } else if (bleedlvl > 1) {
                bloodticks = 4;
            }
            if (this.f_19797_ % bloodticks == 0 && this.m_6084_()) {
                SimpleParticleType bloodType = ModParticles.BLOOD;
                if (MainUtil.hasEnderBlood(this)) {
                    bloodType = ModParticles.ENDER_BLOOD;
                } else if (MainUtil.hasBlueBlood(this)) {
                    bloodType = ModParticles.BLUE_BLOOD;
                }
                this.m_9236_().m_7106_((ParticleOptions)bloodType, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
            if (this.roundabout$getOnlyBleeding()) {
                ci.cancel();
            }
        }
    }

    @Override
    @Unique
    public void roundabout$tryBlip() {
        if (this.roundabout$blip && this.roundabout$blipVector != null) {
            ((ILivingEntityAccess)((Object)this)).roundabout$setLerpSteps(0);
            this.f_19854_ = this.roundabout$blipVector.x;
            this.f_19855_ = this.roundabout$blipVector.y;
            this.f_19856_ = this.roundabout$blipVector.z;
            this.f_19790_ = this.roundabout$blipVector.x;
            this.f_19791_ = this.roundabout$blipVector.y;
            this.f_19792_ = this.roundabout$blipVector.z;
            ((ILivingEntityAccess)((Object)this)).roundabout$setLerp(this.roundabout$blipVector);
            this.m_6034_(this.roundabout$blipVector.x, this.roundabout$blipVector.y, this.roundabout$blipVector.z);
            this.roundabout$blip = false;
        } else if (ClientUtil.getWasFrozen() && !ClientUtil.getScreenFreeze() && !ClientUtil.isPlayer(this)) {
            StandEntity pilot;
            StandUser user;
            StandPowers powers;
            StandEntity SE;
            Entity entity = this;
            if (entity instanceof StandEntity && (SE = (StandEntity)entity).getUser() != null && (powers = (user = (StandUser)SE.getUser()).roundabout$getStandPowers()).isPiloting() && (pilot = powers.getPilotingStand()) != null && pilot.m_7306_((Entity)SE)) {
                return;
            }
            ((ILivingEntityAccess)((Object)this)).roundabout$setLerpSteps(0);
            this.f_19854_ = this.f_20904_;
            this.f_19855_ = this.f_20905_;
            this.f_19856_ = this.f_20906_;
            this.f_19790_ = this.f_20904_;
            this.f_19791_ = this.f_20905_;
            this.f_19792_ = this.f_20906_;
            ((ILivingEntityAccess)((Object)this)).roundabout$setLerp(new Vec3(this.f_20904_, this.f_20905_, this.f_20906_).m_252839_());
            this.m_6034_(this.f_20904_, this.f_20905_, this.f_20906_);
        }
    }

    @Inject(method={"setLastHurtByMob(Lnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void roundabout$setLastHurtByMob(LivingEntity $$0, CallbackInfo ci) {
        Player PE;
        IPlayerEntity ipe;
        ShapeShifts shift;
        LivingEntity liv = (LivingEntity)this;
        if (liv instanceof AbstractSkeleton) {
            Player PE2;
            IPlayerEntity ipe2;
            ShapeShifts shift2;
            if ($$0 instanceof Player && (shift2 = ShapeShifts.getShiftFromByte((ipe2 = (IPlayerEntity)(PE2 = (Player)$$0)).roundabout$getShapeShift())) != ShapeShifts.PLAYER && ShapeShifts.isSkeleton(shift2)) {
                ipe2.roundabout$shapeShiftSilent();
                ipe2.roundabout$setShapeShift(ShapeShifts.PLAYER.id);
            }
        } else if (liv instanceof Zombie) {
            Player PE3;
            IPlayerEntity ipe3;
            ShapeShifts shift3;
            if ($$0 instanceof Player && (shift3 = ShapeShifts.getShiftFromByte((ipe3 = (IPlayerEntity)(PE3 = (Player)$$0)).roundabout$getShapeShift())) != ShapeShifts.PLAYER && ShapeShifts.isZombie(shift3)) {
                ipe3.roundabout$shapeShiftSilent();
                ipe3.roundabout$setShapeShift(ShapeShifts.PLAYER.id);
            }
        } else if (liv instanceof Villager && $$0 instanceof Player && (shift = ShapeShifts.getShiftFromByte((ipe = (IPlayerEntity)(PE = (Player)$$0)).roundabout$getShapeShift())) != ShapeShifts.PLAYER && ShapeShifts.isVillager(shift)) {
            ipe.roundabout$shapeShiftSilent();
            ipe.roundabout$setShapeShift(ShapeShifts.PLAYER.id);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void roundabout$endTick(CallbackInfo ci) {
        if (!((LivingEntity)this instanceof Player)) {
            this.roundabout$getStandPowers().tickPowerEnd();
        }
    }

    @Override
    @Unique
    public void roundabout$setDrowning(boolean drown) {
        this.roundabout$isDrown = drown;
    }

    @Override
    @Unique
    public boolean roundabout$getDrowning() {
        return this.roundabout$isDrown;
    }

    @Override
    @Unique
    public int roundabout$getDetectTicks() {
        return this.roundabout$detectTicks;
    }

    @Override
    @Unique
    public void roundabout$setDetectTicks(int life) {
        this.roundabout$detectTicks = life;
    }

    @Override
    @Unique
    public boolean roundabout$canBeBound(Player $$0) {
        return !this.roundabout$isStringBound() && !(this instanceof Enemy);
    }

    @Override
    @Unique
    public void roundabout$tickString() {
        if (!this.m_9236_().f_46443_ && this.roundabout$stringHolder != null) {
            if (!this.m_6084_() || !this.roundabout$stringHolder.m_6084_() || this.roundabout$stringHolder.m_9236_() != this.m_9236_()) {
                this.roundabout$dropString();
            } else {
                TamableAnimal tm;
                LivingEntity live = (LivingEntity)this;
                if (live instanceof Mob) {
                    Mob mb = (Mob)live;
                    mb.m_21446_(this.roundabout$stringHolder.m_20183_(), 5);
                }
                float f = this.m_20270_(this.roundabout$stringHolder);
                if (live instanceof TamableAnimal && (tm = (TamableAnimal)live).m_21825_()) {
                    if (f > 10.0f) {
                        this.roundabout$dropString();
                    }
                    return;
                }
                if (f > 10.0f) {
                    this.roundabout$dropString();
                    if (live instanceof Mob) {
                        mb = (Mob)live;
                        ((IMob)mb).roundabout$getGoalSelector().m_25355_(Goal.Flag.MOVE);
                    }
                } else if (f > 6.0f) {
                    double d0 = (this.roundabout$stringHolder.m_20185_() - this.m_20185_()) / (double)f;
                    double d1 = (this.roundabout$stringHolder.m_20186_() - this.m_20186_()) / (double)f;
                    double d2 = (this.roundabout$stringHolder.m_20189_() - this.m_20189_()) / (double)f;
                    this.m_20256_(this.m_20184_().m_82520_(Math.copySign(d0 * d0 * 0.4, d0), Math.copySign(d1 * d1 * 0.4, d1), Math.copySign(d2 * d2 * 0.4, d2)));
                    this.m_245125_();
                } else if (live instanceof Mob) {
                    mb = (Mob)live;
                    ((IMob)mb).roundabout$getGoalSelector().m_25374_(Goal.Flag.MOVE);
                    float f1 = 2.0f;
                    Vec3 vec3 = new Vec3(this.roundabout$stringHolder.m_20185_() - this.m_20185_(), this.roundabout$stringHolder.m_20186_() - this.m_20186_(), this.roundabout$stringHolder.m_20189_() - this.m_20189_()).m_82541_().m_82490_((double)Math.max(f - 2.0f, 0.0f));
                    float speed = 1.0f;
                    mb.m_21573_().m_26519_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + vec3.f_82480_, this.m_20189_() + vec3.f_82481_, (double)speed);
                }
            }
        }
    }

    @Override
    @Unique
    public void roundabout$dropString() {
        this.roundabout$setBoundTo(null);
        this.roundabout$setRedBound(false);
    }

    @Override
    @Unique
    public boolean roundabout$isStringBound() {
        return this.roundabout$getBoundTo() != null;
    }

    @Override
    @Unique
    @Nullable
    public Entity roundabout$getBoundTo() {
        if (this.roundabout$getBoundToID() != 0 && this.m_9236_().f_46443_) {
            this.roundabout$stringHolder = this.m_9236_().m_6815_(this.roundabout$getBoundToID());
        }
        return this.roundabout$stringHolder;
    }

    @Override
    @Unique
    public void roundabout$setBoundToID(int bound) {
        this.m_20088_().m_135381_(ROUNDABOUT$IS_BOUND_TO, (Object)bound);
    }

    @Override
    @Unique
    public int roundabout$getBoundToID() {
        return (Integer)this.m_20088_().m_135370_(ROUNDABOUT$IS_BOUND_TO);
    }

    @Override
    @Unique
    public void roundabout$setBoundTo(Entity $$0) {
        if ($$0 != null) {
            this.roundabout$stringHolder = $$0;
            this.roundabout$setBoundToID($$0.m_19879_());
            if (this.m_20159_()) {
                this.m_8127_();
            }
        } else {
            this.roundabout$stringHolder = null;
            this.roundabout$setBoundToID(-1);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void roundabout$tick(CallbackInfo ci) {
        if (!this.m_9236_().m_5776_()) {
            if (this.roundabout$getActive() && this.roundabout$getStandPowers().canSummonStand() && (this.roundabout$getStand() == null || this.roundabout$getStand().m_9236_().m_220362_() != this.m_9236_().m_220362_() && OffsetIndex.OffsetStyle(this.roundabout$getStand().getOffsetType()) == 0)) {
                this.roundabout$summonStand(this.m_9236_(), true, false);
            }
        } else {
            int dt = this.roundabout$detectTicks;
            if (dt > -1) {
                this.roundabout$detectTicks = --dt;
            }
        }
        this.roundabout$getStandPowers().tickPower();
        this.roundabout$tickGuard();
        this.roundabout$tickDaze();
        if (this.roundabout$leapTicks > -1) {
            if (this.m_20096_() && this.roundabout$leapTicks < 55) {
                this.roundabout$leapTicks = -1;
            }
            this.roundabout$cancelConsumableItem((LivingEntity)this);
            --this.roundabout$leapTicks;
            if (!this.m_9236_().f_46443_) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.65f, 0.0f), 1.0f), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.1);
            }
        }
        if (this.roundabout$sealedTicks > -1) {
            --this.roundabout$sealedTicks;
            if (this.roundabout$sealedTicks <= -1) {
                this.roundabout$setDrowning(false);
            }
        }
        if (this.roundabout$gasolineIFRAMES > 0) {
            --this.roundabout$gasolineIFRAMES;
        }
        if (this.roundabout$knifeIFrameTicks > 0) {
            --this.roundabout$knifeIFrameTicks;
            if (this.roundabout$knifeIFrameTicks == 0) {
                this.roundabout$stackedKnivesAndMatches = 0;
            }
        }
        if (this.roundabout$knifeDespawnTicks > 0) {
            --this.roundabout$knifeDespawnTicks;
            if (this.roundabout$knifeDespawnTicks == 0 && (LivingEntity)this instanceof Player) {
                ((IPlayerEntity)((Object)this)).roundabout$setKnife((byte)0);
            }
        }
        if (this.roundabout$postTSHurtTime > 0) {
            --this.roundabout$postTSHurtTime;
        }
        if (this.roundabout$extraIFrames > 0) {
            --this.roundabout$extraIFrames;
        }
        if (this.roundabout$gasTicks > -1 && !this.m_9236_().f_46443_) {
            if (this.m_20070_()) {
                this.roundabout$setGasolineTime(-1);
            } else {
                this.roundabout$setGasolineTime(this.roundabout$gasTicks - 1);
                if (this.f_19797_ % 2 == 0) {
                    float width = this.m_20205_() / 2.0f;
                    float height = this.m_20206_() / 4.0f;
                    float height2 = this.m_20206_() / 2.0f;
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ModBlocks.GASOLINE_SPLATTER.m_49966_()), this.m_20185_(), this.m_20186_() + (double)height2, this.m_20189_(), 1, (double)width, (double)height, (double)width, 0.1);
                }
            }
        }
    }

    @Override
    public void roundabout$addFollower(StandEntity $$0) {
        if (this.roundabout$followers.isEmpty()) {
            this.roundabout$followers = ImmutableList.of((Object)((Object)$$0));
        } else {
            ArrayList $$1 = Lists.newArrayList(this.roundabout$followers);
            $$1.add($$0);
            this.roundabout$followers = ImmutableList.copyOf((Collection)$$1);
        }
    }

    @Override
    public void roundabout$removeFollower(StandEntity $$0) {
        this.roundabout$followers = this.roundabout$followers.size() == 1 && this.roundabout$followers.get(0) == $$0 ? ImmutableList.of() : (ImmutableList)this.roundabout$followers.stream().filter($$1 -> $$1 != $$0).collect(ImmutableList.toImmutableList());
    }

    @Override
    public final List<StandEntity> roundabout$getFollowers() {
        return this.roundabout$followers;
    }

    @Override
    public boolean roundabout$hasFollower(StandEntity $$0) {
        return this.roundabout$followers.contains((Object)$$0);
    }

    @Override
    public boolean roundabout$hasFollower(Predicate<Entity> $$0) {
        for (Entity $$1 : this.roundabout$followers) {
            if (!$$0.test($$1)) continue;
            return true;
        }
        return false;
    }

    public void roundabout$cancelConsumableItem(LivingEntity entity) {
        ItemStack itemStack = entity.m_21211_();
        Item item = itemStack.m_41720_();
        if (item.m_41472_() || item instanceof PotionItem) {
            entity.m_21253_();
            if (entity instanceof Player) {
                ((Player)entity).m_5810_();
            }
        }
    }

    @Override
    @Unique
    public byte roundabout$getIdlePos() {
        return this.roundabout$idlePos;
    }

    @Override
    @Unique
    public void roundabout$setIdlePosX(byte pos) {
        StandEntity stand;
        this.roundabout$idlePos = pos;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player PE = (Player)livingEntity;
            ((IPlayerEntity)PE).roundabout$setIdlePos(pos);
        }
        if ((stand = this.roundabout$getStand()) != null) {
            stand.setIdleAnimation(pos);
        }
    }

    @Override
    @Unique
    public byte roundabout$getStandSkin() {
        return this.roundabout$standSkin;
    }

    @Override
    @Unique
    public void roundabout$setStandSkin(byte skin) {
        StandEntity stand;
        this.roundabout$standSkin = skin;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player PE = (Player)livingEntity;
            ((IPlayerEntity)PE).roundabout$setStandSkin(skin);
        }
        if ((stand = this.roundabout$getStand()) != null) {
            stand.setSkin(skin);
        }
    }

    @Override
    @Unique
    public int roundabout$getGasolineTime() {
        return this.roundabout$gasTicks;
    }

    @Override
    @Unique
    public int roundabout$getGasolineRenderTime() {
        return this.roundabout$gasRenderTicks;
    }

    @Override
    @Unique
    public int roundabout$getMaxGasolineTime() {
        return this.roundabout$maxGasTicks;
    }

    @Override
    @Unique
    public int roundabout$getMaxBucketGasolineTime() {
        return this.roundabout$maxBucketGasTicks;
    }

    @Override
    @Unique
    public int roundabout$getLeapTicks() {
        return this.roundabout$leapTicks;
    }

    @Override
    @Unique
    public int roundabout$getMaxLeapTicks() {
        return this.roundabout$maxLeapTicks;
    }

    @Override
    @Unique
    public void roundabout$setLeapTicks(int leapTicks) {
        this.roundabout$leapTicks = leapTicks;
    }

    @Override
    @Unique
    public void roundabout$setGasolineTime(int gasTicks) {
        this.roundabout$gasTicks = gasTicks;
        this.roundabout$gasRenderTicks = gasTicks == -1 ? -1 : ++this.roundabout$gasRenderTicks;
        if ((LivingEntity)this instanceof Player && !((LivingEntity)this).m_9236_().f_46443_) {
            ModPacketHandler.PACKET_ACCESS.sendIntPacket((ServerPlayer)this, (byte)1, gasTicks);
        }
    }

    @Override
    @Unique
    public boolean roundabout$getTSJump() {
        return this.roundabout$tsJump;
    }

    @Override
    @Unique
    public void roundabout$setTSJump(boolean roundaboutTSJump) {
        if (ClientNetworking.getAppropriateConfig().timeStopSettings.enableHovering.booleanValue()) {
            this.roundabout$tsJump = roundaboutTSJump;
            if ((LivingEntity)this instanceof Player) {
                if (roundaboutTSJump && ((IPlayerEntity)((Object)this)).roundabout$GetPos() == 0) {
                    ((IPlayerEntity)((Object)this)).roundabout$SetPos((byte)1);
                } else if (!roundaboutTSJump && ((IPlayerEntity)((Object)this)).roundabout$GetPos() == 1) {
                    ((IPlayerEntity)((Object)this)).roundabout$SetPos((byte)0);
                }
            }
        }
    }

    @Override
    @Unique
    public float roundabout$getStoredDamage() {
        return this.roundabout$storedDamage;
    }

    @Override
    @Unique
    public byte roundabout$getStoredDamageByte() {
        if (this.m_20088_().m_285897_(ROUNDABOUT_TS_DAMAGE)) {
            return (Byte)this.m_20088_().m_135370_(ROUNDABOUT_TS_DAMAGE);
        }
        return 0;
    }

    @Override
    @Unique
    public void roundabout$setLocacacaCurse(byte locacacaCurse) {
        if (!this.m_9236_().f_46443_) {
            this.m_20088_().m_135381_(ROUNDABOUT$LOCACACA_CURSE, (Object)locacacaCurse);
        }
    }

    @Override
    @Unique
    public void roundabout$setOnStandFire(byte onStandFire) {
        if (!this.m_9236_().f_46443_) {
            this.m_20088_().m_135381_(ROUNDABOUT$ON_STAND_FIRE, (Object)onStandFire);
            if (onStandFire == StandFireType.FIRELESS.id) {
                this.roundabout$fireStarter = null;
            }
        }
    }

    @Override
    @Unique
    public void roundabout$setOnStandFire(byte onStandFire, LivingEntity LE) {
        if (!this.m_9236_().f_46443_) {
            StandPowers standPowers;
            this.m_20088_().m_135381_(ROUNDABOUT$ON_STAND_FIRE, (Object)onStandFire);
            if (onStandFire == StandFireType.FIRELESS.id) {
                this.roundabout$fireStarter = null;
            } else if (LE != null && (standPowers = ((StandUser)LE).roundabout$getStandPowers()) instanceof PowersMagiciansRed) {
                PowersMagiciansRed pm = (PowersMagiciansRed)standPowers;
                this.roundabout$fireStarter = LE;
                this.roundabout$fireStarterID = pm.snapNumber;
            }
        }
    }

    @Override
    @Unique
    public void roundabout$setOnlyBleeding(boolean only) {
        if (!this.m_9236_().f_46443_) {
            this.m_20088_().m_135381_(ROUNDABOUT$ONLY_BLEEDING, (Object)only);
        }
    }

    @Override
    @Unique
    public byte roundabout$getLocacacaCurse() {
        if (this.m_20088_().m_285897_(ROUNDABOUT$LOCACACA_CURSE)) {
            return (Byte)this.m_20088_().m_135370_(ROUNDABOUT$LOCACACA_CURSE);
        }
        return 0;
    }

    @Override
    @Unique
    public byte roundabout$getOnStandFire() {
        if (this.m_20088_().m_285897_(ROUNDABOUT$ON_STAND_FIRE)) {
            return (Byte)this.m_20088_().m_135370_(ROUNDABOUT$ON_STAND_FIRE);
        }
        return 0;
    }

    @Override
    @Unique
    public void roundabout$setBleedLevel(int bleedLevel) {
        if (!this.m_9236_().f_46443_) {
            this.m_20088_().m_135381_(ROUNDABOUT$BLEED_LEVEL, (Object)bleedLevel);
        }
    }

    @Override
    @Unique
    public int roundabout$getBleedLevel() {
        if (this.m_20088_().m_285897_(ROUNDABOUT$BLEED_LEVEL)) {
            return (Integer)this.m_20088_().m_135370_(ROUNDABOUT$BLEED_LEVEL);
        }
        return 0;
    }

    @Override
    @Unique
    public boolean roundabout$getOnlyBleeding() {
        if (this.m_20088_().m_285897_(ROUNDABOUT$ONLY_BLEEDING)) {
            return (Boolean)this.m_20088_().m_135370_(ROUNDABOUT$ONLY_BLEEDING);
        }
        return false;
    }

    @Override
    @Unique
    public StandPowers roundabout$getRejectionStandPowers() {
        return this.roundabout$RejectionStandPowers;
    }

    @Override
    @Unique
    public ItemStack roundabout$getRejectionStandDisc() {
        return this.roundabout$RejectionStandDisc;
    }

    @Override
    @Unique
    public void roundabout$setRejectionStandPowers(StandPowers powers) {
        if (!this.m_9236_().f_46443_) {
            this.roundabout$RejectionStandPowers = powers;
        }
    }

    @Override
    @Unique
    public void roundabout$setRejectionStandDisc(ItemStack disc) {
        if (!this.m_9236_().f_46443_) {
            this.roundabout$RejectionStandDisc = disc;
        }
    }

    @Override
    @Unique
    public ItemStack roundabout$getStandDisc() {
        if (this.m_20088_().m_285897_(ROUNDABOUT$STAND_DISC)) {
            return (ItemStack)this.m_20088_().m_135370_(ROUNDABOUT$STAND_DISC);
        }
        return ItemStack.f_41583_;
    }

    @Override
    @Unique
    public void roundabout$setStandDisc(ItemStack stack) {
        if (!this.m_9236_().f_46443_) {
            this.m_20088_().m_135381_(ROUNDABOUT$STAND_DISC, (Object)stack);
            Item item = stack.m_41720_();
            if (item instanceof StandDiscItem) {
                StandDiscItem SD = (StandDiscItem)item;
                MainUtil.extractDiscData((LivingEntity)this, SD, stack);
            }
        }
    }

    @Override
    @Unique
    public void roundabout$setStoredDamage(float roundaboutStoredDamage) {
        if (!((LivingEntity)this).m_9236_().f_46443_) {
            this.roundabout$storedDamage = roundaboutStoredDamage;
            if (roundaboutStoredDamage <= 0.0f) {
                ((LivingEntity)this).m_20088_().m_135381_(ROUNDABOUT_TS_DAMAGE, (Object)0);
            } else {
                ((LivingEntity)this).m_20088_().m_135381_(ROUNDABOUT_TS_DAMAGE, (Object)((byte)(2 + Math.round(Math.min(roundaboutStoredDamage / this.roundaboutGetMaxStoredDamage() * 6.0f, 6.0f)))));
            }
        }
    }

    @Override
    public int roundaboutGetTSHurtSound() {
        return this.roundaboutTSHurtSound;
    }

    @Override
    public void roundaboutSetTSHurtSound(int roundaboutTSHurtSound) {
        this.roundaboutTSHurtSound = roundaboutTSHurtSound;
    }

    @Override
    @Unique
    public Entity roundaboutGetStoredAttacker() {
        return this.roundabout$storedAttacker;
    }

    @Override
    @Unique
    public void roundaboutSetStoredAttacker(Entity roundaboutStoredAttacker) {
        this.roundabout$storedAttacker = roundaboutStoredAttacker;
    }

    @Override
    @Unique
    public float roundaboutGetMaxStoredDamage() {
        LivingEntity living = (LivingEntity)this;
        if (living instanceof Player) {
            return (float)((double)living.m_21233_() * ((double)ClientNetworking.getAppropriateConfig().timeStopSettings.playerDamageCapHealthPercent.intValue() * 0.01));
        }
        return living.m_21233_();
    }

    @ModifyVariable(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    public CompoundTag roundabout$addAdditionalSaveData(CompoundTag $$0) {
        if (!this.roundabout$getStandDisc().m_41619_() || $$0.m_128425_("roundabout.StandDisc", 10)) {
            ItemStack discy = this.roundabout$getStandDisc();
            CompoundTag compoundtag = new CompoundTag();
            $$0.m_128365_("roundabout.StandDisc", (Tag)MainUtil.saveToDiscData((LivingEntity)this, discy).m_41739_(compoundtag));
        }
        if (this.roundabout$getRejectionStandDisc() != null && !this.roundabout$getRejectionStandDisc().m_41619_() || $$0.m_128425_("roundabout.StandRejectionDisc", 10)) {
            CompoundTag compoundtag = new CompoundTag();
            if (this.roundabout$getRejectionStandDisc() == null) {
                this.roundabout$setRejectionStandDisc(ItemStack.f_41583_);
            }
            $$0.m_128365_("roundabout.StandRejectionDisc", (Tag)this.roundabout$getRejectionStandDisc().m_41739_(compoundtag));
        }
        return $$0;
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="HEAD")})
    public void roundabout$readAdditionalSaveData(CompoundTag $$0, CallbackInfo ci) {
        StandDiscItem SD;
        Item item;
        CompoundTag compoundtag;
        ItemStack itemstack;
        if ($$0.m_128425_("roundabout.StandDisc", 10) && !(itemstack = ItemStack.m_41712_((CompoundTag)(compoundtag = $$0.m_128469_("roundabout.StandDisc")))).m_41619_() && (item = itemstack.m_41720_()) instanceof StandDiscItem) {
            SD = (StandDiscItem)item;
            this.roundabout$setStandDisc(itemstack);
            SD.generateStandPowers((LivingEntity)this);
            MainUtil.extractDiscData((LivingEntity)this, SD, itemstack);
        }
        if ($$0.m_128425_("roundabout.StandRejectionDisc", 10) && !(itemstack = ItemStack.m_41712_((CompoundTag)(compoundtag = $$0.m_128469_("roundabout.StandRejectionDisc")))).m_41619_() && (item = itemstack.m_41720_()) instanceof StandDiscItem) {
            SD = (StandDiscItem)item;
            this.roundabout$setRejectionStandDisc(itemstack);
            SD.generateStandPowerRejection((LivingEntity)this);
        }
    }

    @ModifyVariable(method={"checkAutoSpinAttack(Lnet/minecraft/world/phys/AABB;Lnet/minecraft/world/phys/AABB;)V"}, at=@At(value="STORE"), ordinal=0)
    public List<Entity> roundabout$checkAutoSpin(List<Entity> list) {
        ArrayList<Entity> listE = new ArrayList<Entity>();
        for (Entity entity : list) {
            StandEntity se;
            if (entity instanceof StandEntity && (se = (StandEntity)entity).ignoreTridentSpin() || entity.m_7306_((Entity)this.roundabout$getThrower())) continue;
            listE.add(entity);
        }
        return listE;
    }

    @Unique
    public boolean roundabout$isStandUser() {
        return this.roundabout$getActive();
    }

    @Override
    public boolean roundabout$isRestrained() {
        StandEntity SE;
        Entity entity = this.m_20202_();
        return entity instanceof StandEntity && (SE = (StandEntity)entity).canRestrainWhileMounted();
    }

    @Override
    public int roundabout$getRestrainedTicks() {
        return this.roundabout$restrainTicks;
    }

    @Override
    public void roundabout$setRestrainedTicks(int restrain) {
        this.roundabout$restrainTicks = restrain;
    }

    @Override
    @Unique
    public boolean roundabout$isDazed() {
        return this.roundabout$dazeTime > 0;
    }

    @Override
    @Unique
    public void roundabout$setDazeTime(byte dazeTime) {
        this.roundabout$dazeTime = dazeTime;
    }

    @Override
    @Unique
    public void roundabout$setDazed(byte dazeTime) {
        this.roundabout$dazeTime = dazeTime;
        this.roundabout$syncDaze();
    }

    @Override
    @Unique
    public void roundabout$setRedBound(boolean roundabout$isRedBound) {
        this.roundabout$isRedBound = roundabout$isRedBound;
    }

    @Override
    @Unique
    public boolean roundabout$getActive() {
        if (((LivingEntity)this).m_20088_().m_285897_(ROUNDABOUT$STAND_ACTIVE) && ((LivingEntity)this).m_20088_().m_135370_(ROUNDABOUT$STAND_ACTIVE) instanceof Boolean) {
            return (Boolean)((LivingEntity)this).m_20088_().m_135370_(ROUNDABOUT$STAND_ACTIVE);
        }
        return false;
    }

    @Override
    public boolean roundabout$getMainhandOverride() {
        return this.roundabout$getActive();
    }

    @Override
    @Unique
    public float roundabout$getMaxGuardPoints() {
        Objects.requireNonNull(this);
        return (float)(15.0 * ((double)ClientNetworking.getAppropriateConfig().damageMultipliers.standGuardMultiplier.intValue() * 0.01));
    }

    @Override
    @Unique
    public float roundabout$getGuardCooldown() {
        return this.roundabout$GuardCooldown;
    }

    @Override
    @Unique
    public float roundabout$getGuardPoints() {
        return this.roundabout$GuardPoints;
    }

    @Override
    @Unique
    public void roundabout$setGuardPoints(float GuardPoints) {
        this.roundabout$GuardPoints = GuardPoints;
    }

    @Override
    @Unique
    public boolean roundabout$getGuardBroken() {
        return this.roundabout$GuardBroken;
    }

    @Override
    @Unique
    public void roundabout$breakGuard() {
        this.roundabout$GuardBroken = true;
        if (!this.m_9236_().f_46443_ && this.roundabout$getStandPowers().isGuarding()) {
            this.roundabout$getStandPowers().animateStand((byte)15);
        }
        this.roundabout$syncGuard();
    }

    @Override
    @Unique
    public void roundabout$setGuardBroken(boolean guardBroken) {
        this.roundabout$GuardBroken = guardBroken;
        if (!this.m_9236_().f_46443_) {
            if (guardBroken && this.roundabout$getStandPowers().isGuarding()) {
                this.roundabout$getStandPowers().animateStand((byte)15);
            } else if (!guardBroken && this.roundabout$getStandPowers().isGuarding()) {
                this.roundabout$getStandPowers().animateStand((byte)15);
            }
        }
    }

    @Override
    @Unique
    public void roundabout$damageGuard(float damage) {
        float finalGuard = this.roundabout$GuardPoints - damage;
        this.roundabout$GuardCooldown = 10;
        if (finalGuard <= 0.0f) {
            this.roundabout$GuardPoints = 0.0f;
            this.roundabout$breakGuard();
            this.roundabout$syncGuard();
        } else {
            this.roundabout$GuardPoints = finalGuard;
            this.roundabout$syncGuard();
        }
    }

    @Override
    @Unique
    public void roundabout$fixGuard() {
        this.roundabout$GuardPoints = this.roundabout$getMaxGuardPoints();
        this.roundabout$GuardBroken = false;
        if (!this.m_9236_().f_46443_ && this.roundabout$getStandPowers().isGuarding()) {
            this.roundabout$getStandPowers().animateStand((byte)10);
        }
        this.roundabout$syncGuard();
    }

    @Override
    @Unique
    public void roundabout$regenGuard(float regen) {
        float finalGuard = this.roundabout$GuardPoints + regen;
        if (finalGuard >= this.roundabout$getMaxGuardPoints()) {
            this.roundabout$fixGuard();
        } else {
            this.roundabout$GuardPoints = finalGuard;
            this.roundabout$syncGuard();
        }
    }

    @Unique
    public void roundabout$tickGuard() {
        if (this.roundabout$GuardPoints < this.roundabout$getMaxGuardPoints()) {
            if (this.roundabout$GuardBroken) {
                float guardRegen = this.roundabout$getMaxGuardPoints() / 100.0f;
                this.roundabout$regenGuard(guardRegen);
            } else if (!this.roundabout$isGuarding() && this.roundabout$shieldNotDisabled()) {
                float guardRegen = this.roundabout$getMaxGuardPoints() / 200.0f;
                this.roundabout$regenGuard(guardRegen);
            }
            if (this.roundabout$isGuarding() && !this.roundabout$shieldNotDisabled()) {
                this.roundabout$setAttackTimeDuring(0);
            }
        }
        if (this.roundabout$GuardCooldown > 0) {
            --this.roundabout$GuardCooldown;
        }
    }

    @Unique
    public void roundabout$tickDaze() {
        if (!this.roundabout$User.m_9236_().f_46443_ && this.roundabout$dazeTime > 0) {
            ((LivingEntity)this).m_5810_();
            this.roundabout$dazeTime = (byte)(this.roundabout$dazeTime - 1);
            if (this.roundabout$dazeTime <= 0) {
                this.roundabout$getStandPowers().animateStand((byte)0);
                this.roundabout$syncDaze();
            }
        }
    }

    @Unique
    public void roundabout$syncGuard() {
        if ((LivingEntity)this instanceof Player && !((LivingEntity)this).m_9236_().f_46443_) {
            ModPacketHandler.PACKET_ACCESS.StandGuardPointPacket((ServerPlayer)this, this.roundabout$getGuardPoints(), this.roundabout$getGuardBroken());
        }
    }

    @Shadow
    protected void m_21155_(int $$0, boolean $$1) {
    }

    @Override
    public void roundabout$startAutoSpinAttack(int p_204080_) {
        this.f_20938_ = p_204080_;
        if (!this.m_9236_().f_46443_) {
            this.m_21155_(4, true);
        }
    }

    @Unique
    public void roundabout$syncDaze() {
        if ((LivingEntity)this instanceof Player && !((LivingEntity)this).m_9236_().f_46443_) {
            ModPacketHandler.PACKET_ACCESS.DazeTimePacket((ServerPlayer)this, this.roundabout$dazeTime);
        }
    }

    @Override
    @Unique
    public float roundabout$getRayDistance(Entity entity, float range) {
        return this.roundabout$getStandPowers().getRayDistance(entity, range);
    }

    @Override
    @Unique
    public void roundabout$tryPower(int move, boolean forced) {
        if (!this.roundabout$isClashing() || move == 14) {
            this.roundabout$getStandPowers().tryPower(move, forced);
            this.roundabout$getStandPowers().syncCooldowns();
            if (this.m_9236_().f_46443_) {
                this.roundabout$getStandPowers().kickStarted = false;
            }
        }
    }

    @Override
    public void roundabout$tryChargedPower(int move, boolean forced, int chargeTime) {
        this.roundabout$getStandPowers().tryChargedPower(move, forced, chargeTime);
        this.roundabout$getStandPowers().syncCooldowns();
        if (this.m_9236_().f_46443_) {
            this.roundabout$getStandPowers().kickStarted = false;
        }
    }

    @Override
    public void roundabout$tryPosPower(int move, boolean forced, BlockPos blockPos) {
        this.roundabout$getStandPowers().tryPosPower(move, forced, blockPos);
        this.roundabout$getStandPowers().syncCooldowns();
        if (this.m_9236_().f_46443_) {
            this.roundabout$getStandPowers().kickStarted = false;
        }
    }

    @Unique
    public boolean roundabout$canAttack() {
        return this.roundabout$getStandPowers().canAttack();
    }

    @Override
    public int roundabout$getSummonCD2() {
        return this.roundabout$getStandPowers().getSummonCD2();
    }

    @Override
    public Entity roundabout$getTargetEntity(LivingEntity User, float distMax) {
        return this.roundabout$getStandPowers().getTargetEntity(User, distMax);
    }

    @Override
    public boolean roundabout$getSummonCD() {
        return this.roundabout$getStandPowers().getSummonCD();
    }

    @Override
    public void roundabout$setSummonCD(int summonCD) {
        this.roundabout$getStandPowers().setSummonCD(summonCD);
    }

    @Override
    public byte roundabout$getActivePower() {
        return this.roundabout$getStandPowers().getActivePower();
    }

    @Override
    public LivingEntity roundabout$getPowerUser() {
        return this.roundabout$getStandPowers().getSelf();
    }

    @Override
    public int roundabout$getAttackTimeMax() {
        return this.roundabout$getStandPowers().getAttackTimeMax();
    }

    @Override
    public int roundabout$getAttackTime() {
        return this.roundabout$getStandPowers().getAttackTime();
    }

    @Override
    public int roundabout$getAttackTimeDuring() {
        return this.roundabout$getStandPowers().getAttackTimeDuring();
    }

    @Override
    public boolean roundabout$getInterruptCD() {
        return this.roundabout$getStandPowers().getInterruptCD();
    }

    @Override
    public byte roundabout$getActivePowerPhase() {
        return this.roundabout$getStandPowers().getActivePowerPhase();
    }

    @Override
    public byte roundabout$getActivePowerPhaseMax() {
        return this.roundabout$getStandPowers().getActivePowerPhaseMax();
    }

    @Override
    public float roundabout$getStandReach() {
        return this.roundabout$getStandPowers().getReach();
    }

    @Override
    public boolean roundabout$isGuarding() {
        return this.roundabout$getStandPowers().isGuarding();
    }

    @Override
    public boolean roundabout$isBarraging() {
        return this.roundabout$getStandPowers().isBarraging();
    }

    @Override
    public boolean roundabout$isClashing() {
        return this.roundabout$getStandPowers().isClashing();
    }

    @Override
    public boolean roundabout$isGuardingEffectively() {
        if (this.roundabout$GuardBroken) {
            return false;
        }
        return this.roundabout$isGuardingEffectively2();
    }

    @Override
    public boolean roundabout$isGuardingEffectively2() {
        return this.roundabout$shieldNotDisabled() && this.roundabout$getStandPowers().isGuarding() && this.roundabout$getStandPowers().getAttackTimeDuring() >= ClientNetworking.getAppropriateConfig().standGuardDelayTicks;
    }

    @Override
    public boolean roundabout$shieldNotDisabled() {
        return !(this.roundabout$User instanceof Player) || !(((Player)this.roundabout$User).m_36335_().m_41521_(Items.f_42740_, 0.0f) > 0.0f);
    }

    @Override
    public float roundabout$getDistanceOut(LivingEntity entity, float range, boolean offset) {
        return this.roundabout$getStandPowers().getDistanceOut(entity, range, offset);
    }

    @Override
    public void roundabout$setAttackTimeDuring(int attackTimeDuring) {
        this.roundabout$getStandPowers().setAttackTimeDuring(attackTimeDuring);
    }

    @Override
    public void roundabout$setInterruptCD(int interruptCD) {
        this.roundabout$getStandPowers().setInterruptCD(interruptCD);
    }

    @Override
    public StandPowers roundabout$getStandPowers() {
        Item item;
        ItemStack standDisc;
        if (this.m_9236_().f_46443_ && !ItemStack.m_41728_((ItemStack)this.roundabout$itemParityClient, (ItemStack)(standDisc = this.roundabout$getStandDisc()))) {
            item = standDisc.m_41720_();
            if (item instanceof StandDiscItem) {
                StandDiscItem SE = (StandDiscItem)item;
                SE.generateStandPowers((LivingEntity)this);
                this.roundabout$itemParityClient = standDisc;
            } else {
                this.roundabout$setStandPowers(null);
                this.roundabout$itemParityClient = ItemStack.f_41583_;
            }
        }
        if (this.roundabout$Powers == null) {
            ItemStack StandDisc = this.roundabout$getStandDisc();
            if (!StandDisc.m_41619_() && (item = StandDisc.m_41720_()) instanceof StandDiscItem) {
                StandDiscItem SD = (StandDiscItem)item;
                SD.generateStandPowers((LivingEntity)this);
            } else {
                this.roundabout$Powers = new StandPowers(this.roundabout$User);
            }
        }
        return this.roundabout$Powers;
    }

    @Override
    public void roundabout$setStandPowers(StandPowers standPowers) {
        this.roundabout$Powers = standPowers;
    }

    @Override
    public void roundabout$setActive(boolean active) {
        if (!active) {
            this.roundabout$tryPower(0, true);
        }
        ((LivingEntity)this).m_20088_().m_135381_(ROUNDABOUT$STAND_ACTIVE, (Object)active);
    }

    @Override
    @Unique
    public void roundabout$setSealedTicks(int ticks) {
        this.roundabout$sealedTicks = ticks;
    }

    @Override
    @Unique
    public void roundabout$setMaxSealedTicks(int ticks) {
        this.roundabout$maxSealedTicks = ticks;
    }

    @Override
    @Unique
    public int roundabout$getSealedTicks() {
        return this.roundabout$sealedTicks;
    }

    @Override
    @Unique
    public int roundabout$getMaxSealedTicks() {
        return this.roundabout$maxSealedTicks;
    }

    @Override
    public void roundabout$standMount(StandEntity StandSet) {
        this.roundabout$setStand(StandSet);
        StandSet.setMaster(this.roundabout$User);
    }

    @Override
    public void roundabout$setStand(StandEntity StandSet) {
        this.roundabout$Stand = StandSet;
        if (StandSet == null) {
            ((LivingEntity)this).m_20088_().m_135381_(ROUNDABOUT$STAND_ID, (Object)-1);
        } else {
            ((LivingEntity)this).m_20088_().m_135381_(ROUNDABOUT$STAND_ID, (Object)StandSet.m_19879_());
        }
    }

    @Override
    public void roundabout$summonStand(Level theWorld, boolean forced, boolean sound) {
        boolean active;
        Player PE;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player && (PE = (Player)livingEntity).m_5833_()) {
            return;
        }
        if (!this.roundabout$getActive() || forced) {
            StandPowers thispowers = this.roundabout$getStandPowers();
            if (thispowers.canSummonStand()) {
                StandEntity stand = thispowers.getNewStandEntity();
                thispowers.playSummonEffects(forced);
                if (stand != null) {
                    ItemStack itemStack;
                    Item item;
                    InteractionHand hand = this.roundabout$User.m_7655_();
                    if (hand == InteractionHand.OFF_HAND && (item = (itemStack = this.roundabout$User.m_21211_()).m_41720_()).m_6164_(itemStack) == UseAnim.BLOCK) {
                        this.roundabout$User.m_21253_();
                    }
                    Vec3 spos = stand.getStandOffsetVector(this.roundabout$User);
                    stand.m_20248_(spos.m_7096_(), spos.m_7098_(), spos.m_7094_());
                    stand.setSkin(this.roundabout$getStandSkin());
                    stand.setIdleAnimation(this.roundabout$getIdlePos());
                    LivingEntity livingEntity2 = (LivingEntity)this;
                    if (livingEntity2 instanceof Player) {
                        Player PE2 = (Player)livingEntity2;
                        stand.playerSetProperties(PE2);
                        stand.setDistanceOut(((IPlayerEntity)PE2).roundabout$getDistanceOut());
                        stand.setAnchorPlace(((IPlayerEntity)PE2).roundabout$getAnchorPlace());
                        stand.setSizePercent(((IPlayerEntity)PE2).roundabout$getSizePercent());
                        stand.setIdleRotation(((IPlayerEntity)PE2).roundabout$getIdleRotation());
                        stand.setIdleYOffset(((IPlayerEntity)PE2).roundabout$getIdleYOffset());
                        if (!this.m_9236_().m_5776_()) {
                            IPlayerEntity ipe = (IPlayerEntity)((Object)this);
                            ModPacketHandler.PACKET_ACCESS.s2cPowerInventorySettings((ServerPlayer)((Player)this), ipe.roundabout$getAnchorPlace(), ipe.roundabout$getDistanceOut(), ipe.roundabout$getSizePercent(), ipe.roundabout$getIdleRotation(), ipe.roundabout$getIdleYOffset());
                        }
                    }
                    theWorld.m_7967_((Entity)stand);
                    if (sound && !((TimeStop)this.m_9236_()).CanTimeStopEntity(this)) {
                        thispowers.playSummonSound();
                    }
                    this.roundabout$standMount(stand);
                }
                active = true;
            } else {
                active = false;
            }
        } else {
            this.roundabout$tryPower(0, true);
            active = false;
        }
        this.roundabout$setActive(active);
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public StandEntity roundabout$getStand() {
        if (this.m_9236_().f_46443_ && ((LivingEntity)this).m_20088_().m_285897_(ROUNDABOUT$STAND_ID)) {
            return (StandEntity)this.m_9236_().m_6815_(((Integer)((LivingEntity)this).m_20088_().m_135370_(ROUNDABOUT$STAND_ID)).intValue());
        }
        if (this.roundabout$Stand != null && this.roundabout$Stand.m_213877_()) {
            this.roundabout$setStand(null);
        }
        return this.roundabout$Stand;
    }

    @Override
    public boolean roundabout$hasStandOut() {
        StandEntity standOut = this.roundabout$getStand();
        return standOut != null && standOut.m_6084_() && !standOut.m_213877_();
    }

    @Override
    public void roundabout$setDI(byte forward, byte strafe) {
        if (this.roundabout$Stand != null) {
            if (!this.roundabout$User.m_6144_() && this.roundabout$User.m_20142_()) {
                forward = (byte)(forward * 2);
            }
            this.roundabout$Stand.setMoveForward(forward);
        }
    }

    @Override
    public void roundabout$updateStandOutPosition(StandEntity stand) {
        this.roundabout$updateStandOutPosition(stand, Entity::m_6034_);
    }

    @Override
    public void roundabout$updateStandOutPosition(StandEntity stand, Entity.MoveFunction positionUpdater) {
        if (!this.roundabout$hasStandOut()) {
            return;
        }
        byte OT = stand.getOffsetType();
        if (OffsetIndex.OffsetStyle(OT) != 2) {
            Vec3 grabPos = stand.getStandOffsetVector(this.roundabout$User);
            positionUpdater.m_20372_((Entity)stand, grabPos.f_82479_, grabPos.f_82480_, grabPos.f_82481_);
            if (!this.m_9236_().m_5776_() || (LivingEntity)this instanceof Player) {
                stand.m_146922_(this.roundabout$User.m_6080_() % 360.0f);
                stand.m_146926_(this.roundabout$User.m_146909_());
                stand.m_5618_(this.roundabout$User.m_6080_() % 360.0f);
                stand.m_5616_(this.roundabout$User.m_6080_() % 360.0f);
                if (OffsetIndex.OffsetStyle(OT) == 1) {
                    float rot;
                    if (OT == 6) {
                        rot = this.roundabout$User.m_146908_() % 360.0f;
                    } else if (OT == 8) {
                        BlockHitResult dd = this.roundabout$getStandPowers().getAheadVec(30.0f);
                        rot = this.roundabout$User.m_6080_() % 360.0f;
                        stand.m_146926_(this.roundabout$getStandPowers().getLookAtPlacePitch((Entity)stand, dd.m_82425_().m_252807_()));
                    } else {
                        rot = (float)(((double)this.roundabout$User.m_6080_() - stand.getPunchYaw(stand.getAnchorPlace(), 0.36)) % 360.0);
                    }
                    stand.m_146922_(rot);
                    stand.m_5618_(rot);
                }
            }
        } else if (stand.lockPos()) {
            positionUpdater.m_20372_((Entity)stand, stand.m_20185_(), stand.m_20186_(), stand.m_20189_());
        }
    }

    @Override
    public void roundabout$onStandOutLookAround(StandEntity passenger) {
    }

    @Override
    public void roundabout$removeStandOut() {
        this.roundabout$Stand = null;
        ((LivingEntity)this).m_20088_().m_135381_(ROUNDABOUT$STAND_ID, (Object)-1);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void roundabout$initDataTrackerRoundabout(CallbackInfo ci) {
        ((LivingEntity)this).m_20088_().m_135372_(ROUNDABOUT$STAND_ID, (Object)-1);
        ((LivingEntity)this).m_20088_().m_135372_(ROUNDABOUT_TS_DAMAGE, (Object)0);
        ((LivingEntity)this).m_20088_().m_135372_(ROUNDABOUT$LOCACACA_CURSE, (Object)-1);
        ((LivingEntity)this).m_20088_().m_135372_(ROUNDABOUT$ON_STAND_FIRE, (Object)0);
        ((LivingEntity)this).m_20088_().m_135372_(ROUNDABOUT$BLEED_LEVEL, (Object)-1);
        ((LivingEntity)this).m_20088_().m_135372_(ROUNDABOUT$IS_BOUND_TO, (Object)-1);
        ((LivingEntity)this).m_20088_().m_135372_(ROUNDABOUT$ONLY_BLEEDING, (Object)true);
        ((LivingEntity)this).m_20088_().m_135372_(ROUNDABOUT$STAND_DISC, (Object)ItemStack.f_41583_);
        ((LivingEntity)this).m_20088_().m_135372_(ROUNDABOUT$STAND_ACTIVE, (Object)false);
    }

    @Inject(method={"handleEntityEvent"}, at={@At(value="HEAD")}, cancellable=true)
    public void roundabout$HandleStatus(byte $$0, CallbackInfo ci) {
        if ($$0 == 29 && this.roundabout$isGuarding()) {
            if (!this.roundabout$getGuardBroken()) {
                ((Entity)this).m_9236_().m_7785_(((Entity)this).m_20185_(), ((Entity)this).m_20186_(), ((Entity)this).m_20189_(), ModSounds.STAND_GUARD_SOUND_EVENT, ((Entity)this).m_5720_(), 0.8f, 0.9f + ((Entity)this).m_9236_().f_46441_.m_188501_() * 0.3f, false);
            } else {
                ((Entity)this).m_9236_().m_7785_(((Entity)this).m_20185_(), ((Entity)this).m_20186_(), ((Entity)this).m_20189_(), SoundEvents.f_12347_, ((Entity)this).m_5720_(), 1.0f, 1.5f, false);
            }
            ci.cancel();
        }
    }

    @Inject(method={"isBlocking"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$isBlockingRoundabout(CallbackInfoReturnable<Boolean> ci) {
        if (this.roundabout$isGuarding()) {
            ci.setReturnValue((Object)this.roundabout$isGuardingEffectively());
        }
    }

    @Inject(method={"doAutoAttackOnTouch"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$doAttackOnTouch(LivingEntity $$0, CallbackInfo ci) {
        if (!$$0.m_7306_((Entity)this.roundabout$getThrower())) {
            DamageSource $$5 = ModDamageTypes.of($$0.m_9236_(), ModDamageTypes.THROWN_OBJECT, (Entity)this.roundabout$getThrower());
            $$0.m_6469_($$5, 8.0f);
        }
    }

    @Inject(method={"getDamageAfterArmorAbsorb"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$ApplyArmorToDamage(DamageSource $$0, float $$1, CallbackInfoReturnable<Float> ci) {
        if ($$0.m_276093_(ModDamageTypes.STAND) || $$0.m_276093_(ModDamageTypes.CORPSE) || $$0.m_276093_(ModDamageTypes.CORPSE_ARROW) || $$0.m_276093_(ModDamageTypes.STAND_RUSH) || $$0.m_276093_(ModDamageTypes.CROSSFIRE) || $$0.m_276093_(ModDamageTypes.CORPSE_EXPLOSION)) {
            ci.setReturnValue((Object)Float.valueOf($$1));
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$RoundaboutDamage(DamageSource $$0, float $$1, CallbackInfoReturnable<Boolean> ci) {
        Object ent2;
        Entity entity;
        Entity entity2 = $$0.m_7639_();
        if (entity2 instanceof Player) {
            Player pe = (Player)entity2;
            if (!($$0.m_269014_() || $$0.m_276093_(DamageTypes.f_268440_) || $$0.m_276093_(ModDamageTypes.CORPSE) || $$0.m_276093_(ModDamageTypes.CORPSE_EXPLOSION) || $$0.m_276093_(ModDamageTypes.CORPSE_ARROW) || !((StandUser)pe).roundabout$getStandPowers().interceptDamageDealtEvent($$0, $$1, (LivingEntity)this))) {
                ci.setReturnValue((Object)false);
                return;
            }
        }
        if ($$0.m_276093_(DamageTypes.f_268739_) && (entity = $$0.m_7639_()) instanceof FallenMob) {
            FallenMob FM = (FallenMob)entity;
            if (!((LivingEntity)this instanceof Player) && FM.getController() == this.m_19879_()) {
                ci.setReturnValue((Object)false);
            }
            if (this.roundabout$getStandPowers().getReducedDamage(this)) {
                $$1 /= 3.2f;
                $$1 *= (float)((double)ClientNetworking.getAppropriateConfig().damageMultipliers.corpseDamageOnPlayers.intValue() * 0.01);
                $$1 = FM.getDamageMod($$1);
            } else {
                $$1 *= (float)((double)ClientNetworking.getAppropriateConfig().damageMultipliers.corpseDamageOnMobs.intValue() * 0.01);
                $$1 = FM.getDamageMod($$1);
            }
            ent2 = FM;
            if (FM.getController() > 0 && FM.getController() != this.m_19879_()) {
                ent2 = FM.controller;
            }
            ci.setReturnValue((Object)this.m_6469_(ModDamageTypes.of(this.m_9236_(), ModDamageTypes.CORPSE_ARROW, $$0.m_7640_(), ent2), $$1));
            return;
        }
        if ($$0.m_276093_(DamageTypes.f_268448_) && (ent2 = $$0.m_7639_()) instanceof FallenMob) {
            FallenMob FM = (FallenMob)((Object)ent2);
            if (this.roundabout$getStandPowers().getReducedDamage(this)) {
                $$1 /= 2.0f;
                $$1 *= (float)((double)ClientNetworking.getAppropriateConfig().damageMultipliers.corpseDamageOnPlayers.intValue() * 0.01);
                $$1 = FM.getDamageMod($$1);
            } else {
                $$1 *= (float)((double)ClientNetworking.getAppropriateConfig().damageMultipliers.corpseDamageOnMobs.intValue() * 0.01);
                $$1 = FM.getDamageMod($$1);
            }
            ent2 = FM;
            if (FM.getController() > 0 && FM.getController() != this.m_19879_()) {
                ent2 = FM.controller;
            }
            ci.setReturnValue((Object)this.m_6469_(ModDamageTypes.of(this.m_9236_(), ModDamageTypes.CORPSE_EXPLOSION, ent2, $$0.m_7640_()), $$1));
            return;
        }
        if ($$0.m_276093_(ModDamageTypes.GASOLINE_EXPLOSION) && this.roundabout$gasolineIFRAMES > 0) {
            ci.setReturnValue((Object)false);
            return;
        }
        if (this.roundabout$gasTicks > -1) {
            if ($$0.m_269533_(DamageTypeTags.f_268745_) || $$0.m_7640_() instanceof Projectile && $$0.m_7640_().m_6060_()) {
                float power = MainUtil.gasDamageMultiplier() * 17.0f;
                if ($$0.m_269533_(DamageTypeTags.f_268745_)) {
                    if ($$0.m_7640_() instanceof Projectile) {
                        if ($$0.m_7640_() instanceof MatchEntity) {
                            power = ((MatchEntity)$$0.m_7640_()).isBundle ? MainUtil.gasDamageMultiplier() * 23.0f : MainUtil.gasDamageMultiplier() * 18.0f;
                        }
                    } else {
                        power = MainUtil.gasDamageMultiplier() * 14.0f;
                    }
                }
                this.roundabout$setGasolineTime(-1);
                if (!this.m_9236_().f_46443_) {
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), 40, 0.0, 0.2, 0.0, 0.2);
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), 1, 0.5, 0.5, 0.5, 0.2);
                    MainUtil.gasExplode(null, (ServerLevel)this.m_9236_(), this.m_20097_(), 0, 2, 4, power);
                }
                ci.setReturnValue((Object)true);
                return;
            }
            if ($$0.m_276093_(ModDamageTypes.STAND_FIRE)) {
                float power = MainUtil.gasDamageMultiplier() * 10.0f;
                this.roundabout$setGasolineTime(-1);
                if (!this.m_9236_().f_46443_) {
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), 40, 0.0, 0.2, 0.0, 0.2);
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), 1, 0.5, 0.5, 0.5, 0.2);
                    MainUtil.gasExplode(null, (ServerLevel)this.m_9236_(), this.m_20097_(), 0, 2, 4, power);
                }
                ci.setReturnValue((Object)true);
                return;
            }
        }
        if ($$0.m_7640_() != null && !$$0.m_276093_(ModDamageTypes.STAND_FIRE)) {
            if (this.roundabout$getStandPowers().preCanInterruptPower($$0.m_7640_(), MainUtil.isStandDamage($$0))) {
                this.roundabout$tryPower(0, true);
                if (!((LivingEntity)this instanceof Player)) {
                    this.roundabout$setAttackTimeDuring(this.roundabout$getStandPowers().getMobRecoilTime());
                }
            }
            this.roundabout$setIdleTime(-1);
        }
    }

    @Inject(method={"addEatEffect"}, at={@At(value="HEAD")}, cancellable=true)
    protected void roundabout$addEatEffect(ItemStack $$0, Level $$1, LivingEntity $$2, CallbackInfo ci) {
        int hexLevel;
        if (this.m_21023_(ModEffects.HEX) && ((hexLevel = this.m_21124_(ModEffects.HEX).m_19564_()) >= 0 && $$0.m_150930_(Items.f_42437_) || hexLevel >= 1 && $$0.m_150930_(Items.f_42436_) || hexLevel >= 2)) {
            ci.cancel();
        }
    }

    @Override
    @Unique
    public boolean roundabout$isOnStandFire() {
        boolean $$0 = this.m_9236_() != null && this.m_9236_().f_46443_;
        return this.roundabout$remainingFireTicks > 0 || $$0 && this.roundabout$getOnStandFire() > 0;
    }

    @Inject(method={"playHurtSound"}, at={@At(value="HEAD")}, cancellable=true)
    protected void roundabout$PlayHurtSound(DamageSource $$0, CallbackInfo ci) {
        if (this.roundabout$isDazed() || $$0.m_276093_(ModDamageTypes.STAND_RUSH)) {
            ci.cancel();
        }
    }

    @Inject(method={"updatingUsingItem"}, at={@At(value="HEAD")}, cancellable=true)
    protected void roundabout$TickActiveItemStack(CallbackInfo ci) {
        if (this.roundabout$isDazed()) {
            ci.cancel();
        }
    }

    @Shadow
    protected float m_21161_(DamageSource $$0, float $$1) {
        return 0.0f;
    }

    @Shadow
    protected float m_6515_(DamageSource $$0, float $$1) {
        return 0.0f;
    }

    @Inject(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hurtCurrentlyUsedShield(F)V", shift=At.Shift.BEFORE)})
    private void roundabout$RoundaboutDamage2(DamageSource source, float amount, CallbackInfoReturnable<Boolean> ci) {
        if (this.roundabout$isGuarding()) {
            if (!source.m_269533_(DamageTypeTags.f_273918_) && this.roundabout$getGuardCooldown() > 0.0f) {
                return;
            }
            this.roundabout$damageGuard(amount);
        }
    }

    @ModifyVariable(method={"travel(Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="HEAD"))
    private Vec3 roundabout$Travel(Vec3 $$0) {
        if (this.roundabout$isDazed()) {
            return new Vec3(0.0, 0.0, 0.0);
        }
        return $$0;
    }

    @ModifyVariable(method={"travel(Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="STORE"))
    private double roundabout$Travel2(double $$1) {
        if (this.roundabout$isDazed()) {
            return 0.0;
        }
        return $$1;
    }

    @ModifyVariable(method={"travel(Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="STORE"), ordinal=0)
    private double roundabout$Travel3(double $$1) {
        float cooking = 0.2f;
        if ((LivingEntity)this instanceof Player && ((TimeStop)((LivingEntity)this).m_9236_()).isTimeStoppingEntity((LivingEntity)this)) {
            boolean TSJumping;
            boolean bl = TSJumping = ((IPlayerEntity)((Object)this)).roundabout$GetPos() == 1;
            if (TSJumping) {
                float cooking2 = (float)(((LivingEntity)this).m_20184_().f_82480_ + 0.2);
                if ((LivingEntity)this instanceof Player && ((Player)this).m_6047_()) {
                    if ((double)cooking2 >= 1.0E-4) {
                        cooking = 1.0E-4f;
                    }
                } else if ((double)cooking2 >= 0.1) {
                    cooking = 0.1f;
                }
                ((LivingEntity)this).m_20334_(((LivingEntity)this).m_20184_().f_82479_, (double)cooking, ((LivingEntity)this).m_20184_().f_82481_);
            }
            boolean $$2 = ((LivingEntity)this).m_20184_().f_82480_ <= 0.0;
            ((LivingEntity)this).m_183634_();
            if ($$2) {
                if (this.roundabout$getTSJump()) {
                    return 0.0;
                }
                return $$1;
            }
        }
        if (this.roundabout$leapTicks > -1) {
            ((LivingEntity)this).m_183634_();
        }
        return $$1;
    }

    @Inject(method={"jumpInLiquid"}, at={@At(value="HEAD")}, cancellable=true)
    protected void rooundabout$swimUpward(TagKey<Fluid> $$0, CallbackInfo ci) {
        if (this.roundabout$isClashing()) {
            ci.cancel();
        }
    }

    @Inject(method={"actuallyHurt"}, at={@At(value="HEAD")}, cancellable=true)
    protected void rooundabout$actuallyHurt(DamageSource $$0, float $$1, CallbackInfo ci) {
        if (!this.m_6673_($$0)) {
            Entity bound;
            Entity entity;
            LivingEntity livingEntity = (LivingEntity)this;
            if (livingEntity instanceof AbstractVillager) {
                AbstractVillager AV = (AbstractVillager)livingEntity;
                if (!($$0.m_7639_() instanceof AbstractVillager) && (livingEntity = $$0.m_7639_()) instanceof LivingEntity) {
                    LivingEntity LE = livingEntity;
                    AABB AAB = this.m_20191_().m_82377_(10.0, 8.0, 10.0);
                    List ENT = this.m_9236_().m_45971_(AbstractVillager.class, MainUtil.attackTargeting, (LivingEntity)this, AAB);
                    for (AbstractVillager $$3 : ENT) {
                        Player PE;
                        if (((StandUser)$$3).roundabout$getStandDisc().m_41619_() || $$3.m_5448_() != null || LE instanceof Player && (PE = (Player)LE).m_7500_()) continue;
                        $$3.m_6710_(LE);
                    }
                }
            }
            if ((entity = $$0.m_7639_()) instanceof Player) {
                Player pe = (Player)entity;
                if (!$$0.m_269014_() && !$$0.m_276093_(DamageTypes.f_268440_) && ((StandUser)pe).roundabout$getStandPowers().interceptSuccessfulDamageDealtEvent($$0, $$1, (LivingEntity)this)) {
                    ci.cancel();
                }
            }
            if ((bound = this.roundabout$getBoundTo()) != null && !$$0.m_269014_() && !$$0.m_276093_(ModDamageTypes.STAND_FIRE)) {
                this.roundabout$dropString();
            }
        }
    }

    @Inject(method={"checkFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    protected void rooundabout$checkFallDamage(double $$0, boolean $$1, BlockState $$2, BlockPos $$3, CallbackInfo ci) {
        if (this.roundabout$leapTicks > -1) {
            this.m_9236_().m_214171_(GameEvent.f_157770_, this.m_20318_(0.0f), GameEvent.Context.m_223719_((Entity)this, (BlockState)this.f_285638_.map(blockPos -> this.m_9236_().m_8055_(blockPos)).orElse(this.m_9236_().m_8055_($$3))));
        }
    }

    @Inject(method={"getDamageAfterArmorAbsorb"}, at={@At(value="RETURN")}, cancellable=true)
    protected void rooundabout$armorAbsorb(DamageSource $$0, float $$1, CallbackInfoReturnable<Float> cir) {
        if ((LivingEntity)this instanceof Mob && !this.roundabout$getStandDisc().m_41619_()) {
            if (this.m_21233_() > 1.0f) {
                if (this.m_21233_() <= 3.0f) {
                    $$1 *= 0.5f;
                } else if (this.m_21233_() <= 6.0f) {
                    $$1 *= 0.75f;
                }
            }
            if ($$0.m_276093_(DamageTypes.f_268566_) || $$0.m_276093_(DamageTypes.f_268534_) || $$0.m_276093_(DamageTypes.f_268511_)) {
                $$1 *= 0.5f;
            }
            cir.setReturnValue((Object)Float.valueOf($$1));
        }
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    protected void roundabout$die(DamageSource $$0, CallbackInfo ci) {
        StandEntity stnd = this.roundabout$getStand();
        if (stnd != null) {
            stnd.setMaster(null);
            stnd.setFollowing(null);
            this.roundabout$setStand(null);
        }
        if (!this.m_213877_() && !this.f_20890_ && ($$0.m_276093_(ModDamageTypes.STAND_FIRE) || $$0.m_276093_(ModDamageTypes.CROSSFIRE) || this.roundabout$isOnStandFire())) {
            this.m_7311_(1);
        }
    }

    @Inject(method={"die(Lnet/minecraft/world/damagesource/DamageSource;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setPose(Lnet/minecraft/world/entity/Pose;)V", shift=At.Shift.BEFORE)}, cancellable=true)
    public void roundabout$die2(DamageSource $$0, CallbackInfo ci) {
        Player PE;
        Entity entity;
        if ($$0.m_7640_() != null && (entity = $$0.m_7640_()) instanceof Player && ((PE = (Player)entity).m_21205_().m_150930_(ModItems.EXECUTIONER_AXE) || PE.m_21205_().m_150930_(ModItems.SCISSORS) && ((StandUser)PE).roundabout$getStandPowers() instanceof PowersJustice) && $$0.m_276093_(DamageTypes.f_268464_)) {
            LivingEntity ths = (LivingEntity)this;
            boolean marked = false;
            FallenMob mb = null;
            if (!ths.m_6162_()) {
                if (ths instanceof Zombie) {
                    marked = true;
                    mb = (FallenMob)ModEntities.FALLEN_ZOMBIE.m_20615_(this.m_9236_());
                } else if (ths instanceof Skeleton || ths instanceof Stray) {
                    marked = true;
                    mb = (FallenMob)ModEntities.FALLEN_SKELETON.m_20615_(this.m_9236_());
                } else if (ths instanceof Villager || ths instanceof Witch || ths instanceof AbstractIllager || ths instanceof WanderingTrader) {
                    marked = true;
                    mb = (FallenMob)ModEntities.FALLEN_VILLAGER.m_20615_(this.m_9236_());
                } else if (ths instanceof Spider && !(ths instanceof CaveSpider)) {
                    marked = true;
                    mb = (FallenMob)ModEntities.FALLEN_SPIDER.m_20615_(this.m_9236_());
                } else if (ths instanceof Creeper) {
                    marked = true;
                    mb = (FallenMob)ModEntities.FALLEN_CREEPER.m_20615_(this.m_9236_());
                }
            }
            if (mb != null) {
                mb.m_146884_(this.m_20182_());
                mb.m_146926_(this.m_146909_());
                mb.m_146922_(this.m_146908_());
                mb.m_5618_(this.f_20883_);
                mb.m_5616_(this.f_20885_);
                mb.f_20886_ = this.m_6080_();
                mb.m_146867_();
                this.m_9236_().m_7967_((Entity)mb);
            }
            if (marked) {
                this.m_146870_();
                ci.cancel();
            }
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$roundabouthurt(DamageSource $$0, float $$1, CallbackInfoReturnable<Boolean> ci) {
        LivingEntity living;
        StandEntity SE;
        Entity entity;
        if (this.roundabout$gasolineIFRAMES > 0 && $$0.m_276093_(ModDamageTypes.GASOLINE_EXPLOSION)) {
            ci.setReturnValue((Object)false);
            return;
        }
        if ($$0.m_276093_(ModDamageTypes.GASOLINE_EXPLOSION)) {
            this.roundabout$gasolineIFRAMES = 10;
            this.roundabout$knifeIFrameTicks = 10;
            this.roundabout$stackedKnivesAndMatches = ClientNetworking.getAppropriateConfig().damageMultipliers.maxKnivesInOneHit;
        }
        if (this.m_20202_() != null && (entity = this.m_20202_()) instanceof StandEntity && (SE = (StandEntity)entity).dismountOnHit() && ($$0.m_7640_() != null || $$0.m_276093_(DamageTypes.f_268612_))) {
            SE.m_20153_();
            if (SE.getUser() != null) {
                boolean candoit = true;
                Vec3 vec3d3 = SE.getUser().m_20156_();
                int i = 0;
                while ((float)i < this.m_20206_()) {
                    if (this.m_9236_().m_8055_(new BlockPos((int)vec3d3.m_7096_(), (int)(vec3d3.f_82480_ + (double)i), (int)vec3d3.f_82481_)).m_280296_()) {
                        candoit = false;
                        break;
                    }
                    ++i;
                }
                Vec3 qVec2 = Vec3.f_82478_;
                if (candoit) {
                    qVec2 = new Vec3(vec3d3.f_82479_, vec3d3.f_82480_, vec3d3.f_82481_);
                    this.m_142098_(vec3d3.f_82479_, vec3d3.f_82480_, vec3d3.f_82481_);
                } else {
                    qVec2 = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    this.m_142098_(SE.getUser().m_20185_(), SE.getUser().m_20186_(), SE.getUser().m_20189_());
                }
                if ((Entity)this instanceof Player) {
                    ((IEntityAndData)((Object)this)).roundabout$setQVec2Params(qVec2);
                }
            }
            if ($$0.m_276093_(DamageTypes.f_268612_)) {
                ci.setReturnValue((Object)false);
            }
        }
        LivingEntity entity2 = (LivingEntity)this;
        if (entity2.m_9236_().f_46443_) {
            ci.setReturnValue((Object)false);
            return;
        }
        if (((TimeStop)entity2.m_9236_()).CanTimeStopEntity((Entity)entity2)) {
            if (this.roundabout$TSHurtTime <= 0 || $$0.m_269533_(DamageTypeTags.f_273918_)) {
                LivingEntity LE;
                Entity entity3;
                float dmg = this.roundabout$getStoredDamage();
                float max = this.roundaboutGetMaxStoredDamage();
                if (((LivingEntity)this).m_6673_($$0)) {
                    ci.setReturnValue((Object)false);
                } else if (((LivingEntity)this).m_21224_()) {
                    ci.setReturnValue((Object)false);
                } else if ($$0.m_269533_(DamageTypeTags.f_268745_) && ((LivingEntity)this).m_21023_(MobEffects.f_19607_)) {
                    ci.setReturnValue((Object)false);
                }
                $$1 = this.m_21161_($$0, $$1);
                $$1 = this.m_6515_($$0, $$1);
                if (this.roundaboutTSHurtSound < 1) {
                    this.roundaboutTSHurtSound = 1;
                }
                if (this.roundaboutTSHurtSound < 2 && ($$0.m_276093_(ModDamageTypes.STAND) || $$0.m_276093_(ModDamageTypes.PENETRATING_STAND) || $$0.m_276093_(ModDamageTypes.STAND_RUSH))) {
                    this.roundaboutTSHurtSound = 2;
                }
                if (MainUtil.isStandDamage($$0) && (entity3 = $$0.m_7639_()) instanceof LivingEntity && ((StandUser)(LE = (LivingEntity)entity3)).roundabout$getStandPowers().fullTSChargeBonus()) {
                    if (!this.m_9236_().m_5776_()) {
                        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.74f, 0.73f, 0.98f), 1.0f), this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), 1, 0.3, 0.3, 0.3, 0.3);
                    }
                } else {
                    $$1 *= 0.66f;
                }
                if (dmg + $$1 > max) {
                    this.roundabout$setStoredDamage(max);
                } else {
                    this.roundabout$setStoredDamage(dmg + $$1);
                }
                if ($$0 != null && $$0.m_7639_() != null) {
                    if ($$0.m_7639_() instanceof LivingEntity) {
                        ((StandUser)$$0.m_7639_()).roundabout$getStandPowers().hasActedInTS = true;
                    }
                    this.roundaboutSetStoredAttacker($$0.m_7639_());
                } else {
                    this.roundaboutSetStoredAttacker(null);
                }
                this.roundabout$TSHurtTime = 7;
                Entity $$8 = $$0.m_7639_();
                if ($$8 != null && !$$0.m_269533_(DamageTypeTags.f_268415_)) {
                    double $$13 = $$8.m_20185_() - entity2.m_20185_();
                    double $$14 = $$8.m_20189_() - entity2.m_20189_();
                    while ($$13 * $$13 + $$14 * $$14 < 1.0E-4) {
                        $$13 = (Math.random() - Math.random()) * 0.01;
                        $$14 = (Math.random() - Math.random()) * 0.01;
                    }
                    entity2.m_147240_((double)0.4f, $$13, $$14);
                }
                ci.setReturnValue((Object)true);
                return;
            }
            ci.setReturnValue((Object)false);
            return;
        }
        boolean dothis = false;
        if ((float)this.f_19802_ > 10.0f && !$$0.m_269533_(DamageTypeTags.f_273918_)) {
            if (!($$1 <= this.f_20898_)) {
                dothis = true;
            }
        } else {
            dothis = true;
        }
        if (dothis && ((StandUser)(living = (LivingEntity)this)).roundabout$getStandPowers().interceptDamageEvent($$0, $$1)) {
            ci.setReturnValue((Object)false);
            return;
        }
        if (this.roundabout$getStoredDamage() > 0.0f && !$$0.m_276093_(ModDamageTypes.TIME)) {
            ci.setReturnValue((Object)false);
            return;
        }
        if ($$0.m_276093_(ModDamageTypes.TIME)) {
            this.roundabout$postTSHurtTime = 17;
        } else {
            if (this.roundabout$postTSHurtTime > 0 || this.roundabout$extraIFrames > 0) {
                ci.setReturnValue((Object)false);
                return;
            }
            if ($$0.m_276093_(ModDamageTypes.KNIFE) || $$0.m_276093_(ModDamageTypes.MATCH)) {
                int knifeCap;
                if ($$0.m_276093_(ModDamageTypes.KNIFE)) {
                    this.roundabout$gasolineIFRAMES = 10;
                }
                if (this.roundabout$stackedKnivesAndMatches < (knifeCap = ClientNetworking.getAppropriateConfig().damageMultipliers.maxKnivesInOneHit.intValue())) {
                    if (this.roundabout$stackedKnivesAndMatches <= 0) {
                        this.roundabout$knifeIFrameTicks = 9;
                        this.roundabout$knifeDespawnTicks = 300;
                    }
                    ++this.roundabout$stackedKnivesAndMatches;
                    if (this.roundabout$stackedKnivesAndMatches >= knifeCap) {
                        this.roundabout$extraIFrames = 8;
                    }
                    if ($$0.m_276093_(ModDamageTypes.KNIFE) && entity2 instanceof Player) {
                        ((IPlayerEntity)entity2).roundabout$addKnife();
                    }
                } else {
                    this.roundabout$gasolineIFRAMES = 10;
                    ci.setReturnValue((Object)false);
                    return;
                }
            }
        }
        if (!((TimeStop)entity2.m_9236_()).getTimeStoppingEntities().isEmpty() && ((TimeStop)entity2.m_9236_()).getTimeStoppingEntities().contains((Object)entity2) && ($$0.m_276093_(DamageTypes.f_268468_) || $$0.m_276093_(DamageTypes.f_268631_))) {
            ci.setReturnValue((Object)false);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")}, cancellable=true)
    protected void roundabout$tickTail(CallbackInfo ci) {
        ((IEntityAndData)((Object)this)).roundabout$tickQVec();
        this.roundabout$tickString();
    }

    @Shadow
    protected int m_7302_(int $$0) {
        return 0;
    }

    @Shadow
    protected abstract float m_6380_(Pose var1, EntityDimensions var2);

    @Inject(method={"baseTick"}, at={@At(value="HEAD")}, cancellable=true)
    protected void roundabout$BreathingCancel(CallbackInfo ci) {
        boolean cannotBreathInTs;
        if (this.roundabout$isDrown) {
            this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
        }
        if ((cannotBreathInTs = ClientNetworking.getAppropriateConfig().timeStopSettings.preventsBreathing.booleanValue()) && !((TimeStop)this.m_9236_()).getTimeStoppingEntities().isEmpty() && ((TimeStop)this.m_9236_()).getTimeStoppingEntities().contains((Object)((LivingEntity)this))) {
            ((IEntityAndData)((Object)this)).roundabout$setRoundaboutJamBreath(true);
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="TAIL")}, cancellable=true)
    protected void roundabout$BreathingCancel2(CallbackInfo ci) {
        block11: {
            block13: {
                block12: {
                    Player PE;
                    Object object;
                    boolean cannotBreathInTs = ClientNetworking.getAppropriateConfig().timeStopSettings.preventsBreathing;
                    if (cannotBreathInTs && ((IEntityAndData)((Object)this)).roundabout$getRoundaboutJamBreath()) {
                        ((IEntityAndData)((Object)this)).roundabout$setRoundaboutJamBreath(false);
                    }
                    if (this.m_9236_().m_5776_()) break block11;
                    if (this.m_20071_() || (object = (LivingEntity)this) instanceof Player && (PE = (Player)object).m_7500_()) break block12;
                    if (this.roundabout$fireStarter == null || !((object = ((StandUser)this.roundabout$fireStarter).roundabout$getStandPowers()) instanceof PowersMagiciansRed)) break block13;
                    PowersMagiciansRed PM = (PowersMagiciansRed)object;
                    if (PM.snapNumber == this.roundabout$fireStarterID) break block13;
                }
                if (this.roundabout$remainingFireTicks >= 0) {
                    this.roundabout$remainingFireTicks = -1;
                    this.roundabout$setOnStandFire(StandFireType.FIRELESS.id);
                }
            }
            if (((TimeStop)this.m_9236_()).getTimeStoppingEntities().isEmpty() || !((TimeStop)this.m_9236_()).getTimeStoppingEntities().contains((Object)((LivingEntity)this))) {
                if (this.roundabout$remainingFireTicks > 0) {
                    if (this.roundabout$remainingFireTicks % 20 == 0 && !this.m_20077_()) {
                        float fireDamage = 1.0f;
                        fireDamage = this.roundabout$getStandPowers().getReducedDamage((Entity)((LivingEntity)this)) ? (float)((double)fireDamage * ((double)ClientNetworking.getAppropriateConfig().damageMultipliers.standFireOnPlayers.intValue() * 0.01)) : (float)((double)fireDamage * ((double)ClientNetworking.getAppropriateConfig().damageMultipliers.standFireOnMobs.intValue() * 0.01));
                        this.m_6469_(ModDamageTypes.of(this.m_9236_(), ModDamageTypes.STAND_FIRE), fireDamage);
                    }
                    this.roundabout$setRemainingStandFireTicks(this.roundabout$remainingFireTicks - 1);
                }
                if (this.roundabout$remainingFireTicks <= 0) {
                    if (this.roundabout$getOnStandFire() > 0) {
                        this.roundabout$setOnStandFire(StandFireType.FIRELESS.id);
                    }
                    if (this.roundabout$remainingFireTicks == 0) {
                        this.roundabout$remainingFireTicks = -1;
                    }
                }
            }
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;tickEffects()V", shift=At.Shift.BEFORE)})
    protected void roundabout$baseTick(CallbackInfo ci) {
        byte curse = this.roundabout$getLocacacaCurse();
        if (curse > -1 && curse == 7 && this.f_19797_ % 20 == 0) {
            this.m_6469_(ModDamageTypes.of(this.m_9236_(), ModDamageTypes.HEART), 1.0f);
        }
        if (this.m_21023_(ModEffects.STAND_VIRUS)) {
            if (this.f_19797_ % 20 == 0 && !this.m_9236_().m_5776_() && this.m_6084_()) {
                this.m_6469_(ModDamageTypes.of(this.m_9236_(), ModDamageTypes.STAND_VIRUS), this.m_21124_(ModEffects.STAND_VIRUS).m_19564_() + 1);
            }
            if (this.roundabout$RejectionStandPowers != null) {
                this.roundabout$RejectionStandPowers.tickStandRejection(this.m_21124_(ModEffects.STAND_VIRUS));
            }
        } else if (!this.m_9236_().m_5776_() && this.roundabout$RejectionStandPowers != null) {
            this.roundabout$RejectionStandPowers = null;
            this.roundabout$RejectionStandDisc = null;
        }
    }

    @Override
    @Unique
    public void roundabout$clearFire() {
        this.m_7311_(0);
    }

    @Shadow
    public boolean m_6040_() {
        return false;
    }

    @Inject(method={"decreaseAirSupply"}, at={@At(value="HEAD")}, cancellable=true)
    protected void roundabout$decreaseAirSupply(int $$0, CallbackInfoReturnable<Integer> cir) {
        byte curse;
        boolean $$0P = (LivingEntity)this instanceof Player;
        int air = this.roundabout$getStandPowers().getAirAmount();
        if (air > 0 && this.roundabout$getActive() && this.m_204029_(FluidTags.f_13131_) && !this.m_9236_().m_8055_(BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20188_(), (double)this.m_20189_())).m_60713_(Blocks.f_50628_)) {
            boolean $$3;
            boolean bl = $$3 = !this.m_6040_() && !MobEffectUtil.m_19588_((LivingEntity)((LivingEntity)this)) && (!$$0P || !((Player)((LivingEntity)this)).m_150110_().f_35934_);
            if ($$3) {
                int $$1 = EnchantmentHelper.m_44918_((LivingEntity)((LivingEntity)this));
                int n = air = $$1 > 0 && this.f_19796_.m_188503_($$1 + 1) > 0 ? air : air - 1;
                if (air <= 0) {
                    air = 0;
                }
                this.roundabout$getStandPowers().setAirAmount(air);
                cir.setReturnValue((Object)$$0);
                return;
            }
        }
        if ((curse = this.roundabout$getLocacacaCurse()) > -1 && curse == 5) {
            int $$1 = EnchantmentHelper.m_44918_((LivingEntity)((LivingEntity)this));
            int n = $$1 = $$1 > 0 && this.f_19796_.m_188503_($$1 + 1) > 0 ? $$0 : $$0 - 4;
            if ($$1 < -20) {
                $$1 = -20;
            }
            cir.setReturnValue((Object)$$1);
        }
    }

    @Inject(method={"increaseAirSupply"}, at={@At(value="HEAD")}, cancellable=true)
    protected void roundabout$increaseAirSupply(int $$0, CallbackInfoReturnable<Integer> cir) {
    }

    @Override
    @Unique
    public int roundabout$increaseAirSupply(int $$0) {
        return this.m_7305_($$0);
    }

    @Inject(method={"completeUsingItem"}, at={@At(value="TAIL")}, cancellable=true)
    protected void roundabout$completeUsingItem(CallbackInfo ci) {
        LivingEntity entity;
        if (!this.m_9236_().f_46443_ && ((TimeStop)(entity = (LivingEntity)this).m_9236_()).isTimeStoppingEntity(entity)) {
            this.roundabout$getStandPowers().hasActedInTS = true;
        }
    }

    @Inject(method={"updateUsingItem"}, at={@At(value="HEAD")})
    protected void roundabout$UpdateUsingItem(ItemStack $$0, CallbackInfo ci) {
        this.roundabout$IdleTime = -1;
    }

    @Override
    @Unique
    public void roundabout$UniversalTick() {
        if (this.roundabout$TSHurtTime > 0) {
            --this.roundabout$TSHurtTime;
        }
        if (this.roundabout$getStandPowers().summonCD > 0) {
            --this.roundabout$getStandPowers().summonCD;
        }
    }

    @Inject(method={"jumpFromGround"}, at={@At(value="HEAD")}, cancellable=true)
    protected void roundabout$jumpFromGround(CallbackInfo ci) {
        byte curse = this.roundabout$getLocacacaCurse();
        if (this.roundabout$getStandPowers().cancelSprintJump() || curse > -1 && (curse == 2 || curse == 1)) {
            Vec3 $$0 = this.m_20184_();
            this.m_20334_($$0.f_82479_, this.m_6118_(), $$0.f_82481_);
            this.f_19812_ = true;
            ci.cancel();
        }
    }

    @Inject(method={"getSpeed"}, at={@At(value="HEAD")}, cancellable=true)
    public void roundabout$getSpeed(CallbackInfoReturnable<Float> cir) {
        AbstractVillager AV;
        LivingEntity livingEntity;
        byte curse;
        float basis = this.f_20953_;
        if (!this.roundabout$getStandDisc().m_41619_()) {
            if (this.roundabout$isClashing()) {
                cir.setReturnValue((Object)Float.valueOf(0.0f));
                return;
            }
            basis = this.roundabout$getStandPowers().inputSpeedModifiers(basis);
        }
        if ((curse = this.roundabout$getLocacacaCurse()) > -1) {
            if (curse == 2 || curse == 1) {
                basis *= 0.82f;
            } else if (curse == 5) {
                basis *= 0.85f;
            }
        }
        if (!this.roundabout$getStandDisc().m_41619_() && (livingEntity = (LivingEntity)this) instanceof AbstractVillager && (AV = (AbstractVillager)livingEntity).m_5448_() != null && !((IMob)((Object)this)).roundabout$getFightOrFlight()) {
            basis *= 0.5f;
        }
        if (basis != this.f_20953_) {
            cir.setReturnValue((Object)Float.valueOf(basis));
        }
    }

    @Shadow
    protected float m_6118_() {
        return 0.0f;
    }
}

