/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.networking.s2c;

import java.util.function.Supplier;
import net.hydra.jojomod.client.ClientUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ForgeCDSyncPacket {
    private final int attackTime;
    private final int attackTimeMax;
    private final int attackTimeDuring;
    private final byte activePower;
    private final byte activePowerPhase;

    public ForgeCDSyncPacket(int attackTime, int attackTimeMax, int attackTimeDuring, byte activePower, byte activePowerPhase) {
        this.attackTime = attackTime;
        this.attackTimeMax = attackTimeMax;
        this.attackTimeDuring = attackTimeDuring;
        this.activePower = activePower;
        this.activePowerPhase = activePowerPhase;
    }

    public ForgeCDSyncPacket(FriendlyByteBuf buf) {
        this.attackTime = buf.readInt();
        this.attackTimeMax = buf.readInt();
        this.attackTimeDuring = buf.readInt();
        this.activePower = buf.readByte();
        this.activePowerPhase = buf.readByte();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.attackTime);
        buf.writeInt(this.attackTimeMax);
        buf.writeInt(this.attackTimeDuring);
        buf.writeByte((int)this.activePower);
        buf.writeByte((int)this.activePowerPhase);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> ClientUtil.CDSyncPacket(this.attackTime, this.attackTimeMax, this.attackTimeDuring, this.activePower, this.activePowerPhase));
        return true;
    }
}

