/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.networking.s2c;

import java.util.function.Supplier;
import net.hydra.jojomod.client.ClientUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ForgeS2CPowerInventorySettingsPacket {
    private final int anchorPlace;
    private final float distanceOut;
    private final float idleOpacity;
    private final float combatOpacity;
    private final float enemyOpacity;

    public ForgeS2CPowerInventorySettingsPacket(int anchorPlace, float distanceOut, float idleOpacity, float combatOpacity, float enemyOpacity) {
        this.anchorPlace = anchorPlace;
        this.distanceOut = distanceOut;
        this.idleOpacity = idleOpacity;
        this.combatOpacity = combatOpacity;
        this.enemyOpacity = enemyOpacity;
    }

    public ForgeS2CPowerInventorySettingsPacket(FriendlyByteBuf buf) {
        this.anchorPlace = buf.readInt();
        this.distanceOut = buf.readFloat();
        this.idleOpacity = buf.readFloat();
        this.combatOpacity = buf.readFloat();
        this.enemyOpacity = buf.readFloat();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.anchorPlace);
        buf.writeFloat(this.distanceOut);
        buf.writeFloat(this.idleOpacity);
        buf.writeFloat(this.combatOpacity);
        buf.writeFloat(this.enemyOpacity);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> ClientUtil.handleLPPowerInventoryOptionsPacketS2C(this.anchorPlace, this.distanceOut, this.idleOpacity, this.combatOpacity, this.enemyOpacity));
        return true;
    }
}

