/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.stand;

import com.mojang.blaze3d.vertex.PoseStack;
import net.hydra.jojomod.entity.client.ModEntityRendererClient;
import net.hydra.jojomod.entity.stand.StandRenderer;
import net.hydra.jojomod.entity.stand.TheWorldEntity;
import net.hydra.jojomod.entity.stand.TheWorldModel;
import net.hydra.jojomod.entity.stand.TheWorldOverHeavenEyeLayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class TheWorldRenderer
extends StandRenderer<TheWorldEntity> {
    private static final ResourceLocation PART_3_SKIN = new ResourceLocation("roundabout", "textures/stand/the_world.png");
    private static final ResourceLocation PART_3_MANGA_SKIN = new ResourceLocation("roundabout", "textures/stand/the_world_manga.png");
    private static final ResourceLocation OVA_SKIN = new ResourceLocation("roundabout", "textures/stand/the_world_ova.png");
    private static final ResourceLocation HERITAGE_SKIN = new ResourceLocation("roundabout", "textures/stand/the_world_heritage.png");
    private static final ResourceLocation BLACK_SKIN = new ResourceLocation("roundabout", "textures/stand/the_world_black.png");
    private static final ResourceLocation PART_7_SKIN = new ResourceLocation("roundabout", "textures/stand/the_world_part_7.png");
    private static final ResourceLocation PART_7_BLUE = new ResourceLocation("roundabout", "textures/stand/the_world_part_7_blue.png");
    private static final ResourceLocation OVER_HEAVEN = new ResourceLocation("roundabout", "textures/stand/the_world_over_heaven.png");
    private static final ResourceLocation DARK_SKIN = new ResourceLocation("roundabout", "textures/stand/the_world_dark.png");
    private static final ResourceLocation AQUA_SKIN = new ResourceLocation("roundabout", "textures/stand/the_world_aqua.png");
    private static final ResourceLocation ARCADE_SKIN = new ResourceLocation("roundabout", "textures/stand/the_world_arcade.png");
    private static final ResourceLocation AGOGO_SKIN = new ResourceLocation("roundabout", "textures/stand/the_world_agogo.png");
    private static final ResourceLocation BETA_SKIN = new ResourceLocation("roundabout", "textures/stand/the_world_beta.png");

    public TheWorldRenderer(EntityRendererProvider.Context context) {
        super(context, new TheWorldModel(context.m_174023_(ModEntityRendererClient.THE_WORLD_LAYER)), 0.0f);
        this.m_115326_((RenderLayer)new TheWorldOverHeavenEyeLayer(this));
    }

    @Override
    public ResourceLocation getTextureLocation(TheWorldEntity entity) {
        byte BT = entity.getSkin();
        if (BT == 1) {
            return PART_3_SKIN;
        }
        if (BT == 2) {
            return PART_3_MANGA_SKIN;
        }
        if (BT == 4) {
            return OVA_SKIN;
        }
        if (BT == 3) {
            return HERITAGE_SKIN;
        }
        if (BT == 5) {
            return BLACK_SKIN;
        }
        if (BT == 9) {
            return DARK_SKIN;
        }
        if (BT == 6) {
            return PART_7_SKIN;
        }
        if (BT == 8) {
            return PART_7_BLUE;
        }
        if (BT == 7) {
            return OVER_HEAVEN;
        }
        if (BT == 10) {
            return AQUA_SKIN;
        }
        if (BT == 11) {
            return ARCADE_SKIN;
        }
        if (BT == 12) {
            return AGOGO_SKIN;
        }
        if (BT == 13) {
            return BETA_SKIN;
        }
        return PART_3_SKIN;
    }

    @Override
    public void render(TheWorldEntity mobEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        float factor = 0.5f + mobEntity.getSizePercent() / 2.0f;
        if (mobEntity.m_6162_()) {
            matrixStack.m_85841_(0.5f * factor, 0.5f * factor, 0.5f * factor);
        } else {
            matrixStack.m_85841_(0.87f * factor, 0.87f * factor, 0.87f * factor);
        }
        super.render(mobEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    @Nullable
    protected RenderType getRenderType(TheWorldEntity entity, boolean showBody, boolean translucent, boolean showOutline) {
        return super.m_7225_((LivingEntity)entity, showBody, true, showOutline);
    }
}

