/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.world;

import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.networking.ModPacketHandler;
import net.hydra.jojomod.world.DynamicWorldAccessor;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.dimension.LevelStem;
import org.jetbrains.annotations.Nullable;

public class DynamicWorld {
    private ServerLevel level;
    private final String name;
    public static HashMap<String, ServerLevel> levels = new HashMap();

    public DynamicWorld(MinecraftServer server, String name, @Nullable ServerPlayer player) {
        this.name = name;
        DynamicWorldAccessor accessor = DynamicWorldAccessor.getFrom(server);
        ResourceKey LEVEL_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)Roundabout.location(name));
        MappedRegistry<LevelStem> manager = DynamicWorld.getLevelStemRegistry(server);
        DynamicWorldAccessor managerAccessor = DynamicWorldAccessor.getFrom(manager);
        boolean isFrozen = managerAccessor.roundabout$isFrozen();
        managerAccessor.roundabout$setFrozen(false);
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256862_, (ResourceLocation)LEVEL_KEY.m_135782_());
        if (!manager.m_142003_(key)) {
            manager.m_255290_(key, (Object)new LevelStem(server.m_129783_().m_6018_().m_204156_(), server.m_129783_().m_7726_().m_8481_()), Lifecycle.stable());
        }
        managerAccessor.roundabout$setFrozen(isFrozen);
        this.level = new ServerLevel(server, accessor.roundabout$getExecutor(), accessor.roundabout$getLevelStorageAccess(), accessor.roundabout$getLevelData(), LEVEL_KEY, accessor.roundabout$getLevelStem(), accessor.roundabout$getProgressListener(), false, accessor.roundabout$getObfuscatedSeed(), new ArrayList(), false, null);
        server.m_129783_().m_6857_().m_61929_((BorderChangeListener)new BorderChangeListener.DelegateBorderChangeListener(this.level.m_6857_()));
        accessor.roundabout$addWorld((ResourceKey<Level>)LEVEL_KEY, this.level);
        this.level.m_8793_(() -> true);
        levels.put(name, this.level);
        for (ServerPlayer sp : server.m_6846_().m_11314_()) {
            ModPacketHandler.PACKET_ACCESS.sendNewDynamicWorld(sp, name, this.level, player);
        }
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    private static MappedRegistry<LevelStem> getLevelStemRegistry(MinecraftServer server) {
        RegistryAccess.Frozen registryManager = server.m_206579_();
        Registry temp = registryManager.m_175515_(Registries.f_256862_);
        return (MappedRegistry)temp;
    }

    private static String generateRandomStringByWords(int numWords) {
        String[] words = new String[]{"boat", "ship", "airplane", "sword", "car", "train", "bike", "rocket", "submarine", "zeppelin", "spiral-staircase", "desolation-row", "fig-tart", "rhinoceros-beetle", "singularity-point", "giotto", "angel", "hydrangea", "secret-emperor"};
        Random random = new Random();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < numWords; ++i) {
            if (i > 0) {
                result.append("-");
            }
            result.append(words[random.nextInt(words.length)]);
        }
        return result.toString();
    }

    public static DynamicWorld generateD4CWorld(MinecraftServer server) {
        return new DynamicWorld(server, "d4c-" + DynamicWorld.generateRandomStringByWords(7) + "-" + server.m_129783_().m_213780_().m_216332_(0, 999999), null);
    }

    public static DynamicWorld generateD4CWorld(MinecraftServer server, ServerPlayer player) {
        DynamicWorld world = new DynamicWorld(server, "d4c-" + DynamicWorld.generateRandomStringByWords(7) + "-" + server.m_129783_().m_213780_().m_216332_(0, 999999), player);
        return world;
    }
}

