/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.stand.powers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.hydra.jojomod.access.IGravityEntity;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.client.hud.StandHudRender;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.AbilityIconInstance;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.item.MaxStandDiscItem;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.stand.powers.presets.NewDashPreset;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_315;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3988;
import net.minecraft.class_8111;

public class PowersWalkingHeart
extends NewDashPreset {
    public class_2350 heelDirection = class_2350.field_11033;
    public int hitsSinceAttached = 0;
    public int shootTicks = 0;
    public int lastTick = 0;
    public int heelExtension = 0;
    public boolean holdDownClick = false;
    public boolean consumeClickInput = false;
    public int pauseGrowthTicks = 0;
    public int justFlippedTicks = 0;
    public int mercyTicks = 0;
    public static final byte VISAGE_NOISE = 104;
    public static final byte IMPALE_NOISE = 105;
    public int currentKickTicks = 0;

    public PowersWalkingHeart(class_1309 self) {
        super(self);
    }

    @Override
    public StandEntity getNewStandEntity() {
        return (StandEntity)ModEntities.WALKING_HEART.method_5883(this.getSelf().method_37908());
    }

    @Override
    public StandPowers generateStandPowers(class_1309 entity) {
        return new PowersWalkingHeart(entity);
    }

    @Override
    public boolean isStandEnabled() {
        return ClientNetworking.getAppropriateConfig().walkingHeartSettings.enableWalkingHeart;
    }

    public boolean canWallWalkConfig() {
        return ClientNetworking.getAppropriateConfig().walkingHeartSettings.enableWallWalking;
    }

    public int walkingCDPerHit() {
        return ClientNetworking.getAppropriateConfig().walkingHeartSettings.walkingHeartCooldownPerHit;
    }

    public int walkingMaxHits() {
        return ClientNetworking.getAppropriateConfig().walkingHeartSettings.walkingHeartMaxHits;
    }

    @Override
    public List<Byte> getPosList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)0);
        $$1.add((byte)1);
        $$1.add((byte)2);
        $$1.add((byte)3);
        $$1.add((byte)4);
        return $$1;
    }

    @Override
    public byte getMaxLevel() {
        return 4;
    }

    @Override
    public boolean interceptSuccessfulDamageDealtEvent(class_1282 $$0, float $$1, class_1309 target) {
        if (this.hasStandActive(this.getSelf()) && $$0.method_49708(class_8111.field_42320) && this.hasExtendedHeelsForWalking()) {
            this.addEXP(1);
        }
        return false;
    }

    @Override
    public int getExpForLevelUp(int currentLevel) {
        int amt = currentLevel == 1 ? 200 : (currentLevel == 2 ? 400 : 800);
        amt = (int)((float)amt * this.getLevelMultiplier());
        return amt;
    }

    @Override
    public void levelUp() {
        class_1309 class_13092;
        if (!this.getSelf().method_37908().method_8608() && (class_13092 = this.getSelf()) instanceof class_1657) {
            class_1657 PE = (class_1657)class_13092;
            IPlayerEntity ipe = (IPlayerEntity)PE;
            byte level = ipe.roundabout$getStandLevel();
            if (level == 4) {
                ((class_3222)this.self).method_7353((class_2561)class_2561.method_43471((String)"leveling.roundabout.levelup.max.skins").method_27692(class_124.field_1075), true);
            } else if (level == 2 || level == 3) {
                ((class_3222)this.self).method_7353((class_2561)class_2561.method_43471((String)"leveling.roundabout.levelup.skins").method_27692(class_124.field_1075), true);
            }
        }
        super.levelUp();
    }

    @Override
    public void powerActivate(PowerContext context) {
        switch (context) {
            case SKILL_1_NORMAL: 
            case SKILL_1_CROUCH: {
                this.spikeAttackModeToggleClient();
                break;
            }
            case SKILL_2_NORMAL: 
            case SKILL_2_CROUCH: {
                this.extendHeels();
                break;
            }
            case SKILL_3_NORMAL: 
            case SKILL_3_CROUCH: {
                this.dashOrWallLatch();
                break;
            }
            case SKILL_4_NORMAL: 
            case SKILL_4_CROUCH: {
                this.unlockSpiderClient();
            }
        }
    }

    public void unlockSpiderClient() {
        class_1309 class_13092 = this.getSelf();
        if (class_13092 instanceof class_1657) {
            class_1799 stack;
            boolean bypass;
            class_1657 PE = (class_1657)class_13092;
            class_1799 goldDisc = ((StandUser)PE).roundabout$getStandDisc();
            boolean bl = bypass = PE.method_7337() || !goldDisc.method_7960() && goldDisc.method_7909() instanceof MaxStandDiscItem;
            if (!((IPlayerEntity)PE).roundabout$getUnlockedBonusSkin() && !bypass && !(stack = this.self.method_6047()).method_7960() && stack.method_31574(class_1802.field_8786) && stack.method_7947() >= 64) {
                this.tryPowerPacket((byte)36);
            }
        }
    }

    public void extendHeels() {
        if ((!this.onCooldown((byte)2) && !this.onCooldown((byte)1) || this.hasExtendedHeelsForWalking()) && !this.inCombatMode()) {
            ((StandUser)this.getSelf()).roundabout$tryPower(23, true);
            this.tryPowerPacket((byte)23);
        }
    }

    public void dashOrWallLatch() {
        if (this.inCombatMode()) {
            return;
        }
        if (this.canLatchOntoWall() && this.canWallWalkConfig()) {
            this.doWallLatchClient();
        } else if (!this.hasExtendedHeelsForWalking()) {
            this.dash();
        }
    }

    public void doWallLatchClient() {
        if (!this.onCooldown((byte)2) && !this.onCooldown((byte)1)) {
            ((StandUser)this.getSelf()).roundabout$tryPower(25, true);
            this.tryPowerPacket((byte)25);
        }
    }

    public class_2350 getHeelDirection() {
        return this.heelDirection;
    }

    public void setHeelDirection(class_2350 dir) {
        this.heelDirection = dir;
    }

    public boolean hasExtendedHeelsForWalking() {
        return this.getStandUserSelf().roundabout$getUniqueStandModeToggle();
    }

    public boolean canLatchOntoWall() {
        if (this.onCooldown((byte)1)) {
            return false;
        }
        if (this.self.method_24828() && !this.hasExtendedHeelsForWalking() || !this.self.method_24828() && this.hasExtendedHeelsForWalking()) {
            return false;
        }
        class_243 mpos = this.self.method_30950(1.0f);
        class_2350 gravdir = ((IGravityEntity)this.self).roundabout$getGravityDirection();
        switch (gravdir) {
            case field_11033: {
                mpos = mpos.method_1031(0.0, (double)0.1f, 0.0);
                break;
            }
            case field_11036: {
                mpos = mpos.method_1031(0.0, (double)-0.1f, 0.0);
                break;
            }
            case field_11043: {
                mpos = mpos.method_1031(0.0, 0.0, (double)0.1f);
                break;
            }
            case field_11035: {
                mpos = mpos.method_1031(0.0, 0.0, (double)-0.1f);
                break;
            }
            case field_11039: {
                mpos = mpos.method_1031((double)0.1f, 0.0, 0.0);
                break;
            }
            case field_11034: {
                mpos = mpos.method_1031((double)-0.1f, 0.0, 0.0);
            }
        }
        class_2338 pos1 = class_2338.method_49638((class_2374)mpos);
        class_2350 rd = RotationUtil.getRealFacingDirection2(this.self);
        if (rd == gravdir) {
            return false;
        }
        pos1 = pos1.method_10093(RotationUtil.getRealFacingDirection2(this.self));
        class_2680 bs = this.self.method_37908().method_8320(pos1);
        return MainUtil.isBlockWalkable(bs);
    }

    public void setHeelAttachCooldown() {
        int attachment = this.getHeelUnattachCooldown();
        if (attachment > 0) {
            this.setCooldown((byte)1, this.getHeelUnattachCooldown());
            S2CPacketUtil.sendCooldownSyncPacket((class_1657)((class_3222)this.getSelf()), (byte)1, this.getHeelUnattachCooldown());
        }
    }

    public int getHeelUnattachCooldown() {
        return this.hitsSinceAttached * this.walkingCDPerHit();
    }

    public void hitHeelExtendedState() {
        int maxhits;
        if (this.hasExtendedHeelsForWalking() && (maxhits = this.walkingMaxHits()) >= 0) {
            ++this.hitsSinceAttached;
            if (this.hitsSinceAttached > maxhits) {
                this.toggleSpikes(false);
            }
        }
    }

    @Override
    public void onActuallyHurt(class_1282 $$0, float $$1) {
        if ($$0.method_5529() != null && !$$0.method_49708(class_8111.field_42330)) {
            this.hitHeelExtendedState();
        }
    }

    public void regularExtendHeels() {
        boolean isAnchored = this.hasExtendedHeelsForWalking();
        if (isAnchored) {
            if (!this.self.method_37908().method_8608()) {
                this.toggleSpikes(false);
            }
        } else if (!this.inCombatMode() && this.self.method_24828()) {
            this.setCooldown((byte)2, 8);
            if (!this.self.method_37908().method_8608()) {
                this.setHeelDirection(class_2350.field_11033);
                this.toggleSpikes(true);
            }
        }
    }

    @Override
    public void tickStandRejection(class_1293 effect) {
        if (!this.getSelf().method_37908().method_8608()) {
            if (effect.method_5584() == 80) {
                MainUtil.makeBleed((class_1297)this.self, 0, 900, (class_1297)this.self);
                this.self.method_37908().method_8396(null, this.self.method_24515(), ModSounds.SPIKE_HIT_EVENT, class_3419.field_15248, 1.0f, 1.0f);
                if (MainUtil.getMobBleed((class_1297)this.self)) {
                    MainUtil.makeMobBleed((class_1297)this.self);
                }
            }
            if (effect.method_5584() == 50) {
                MainUtil.makeBleed((class_1297)this.self, 1, 900, (class_1297)this.self);
                this.self.method_37908().method_8396(null, this.self.method_24515(), ModSounds.SPIKE_HIT_EVENT, class_3419.field_15248, 1.0f, 1.0f);
                if (MainUtil.getMobBleed((class_1297)this.self)) {
                    MainUtil.makeMobBleed((class_1297)this.self);
                }
            }
            if (effect.method_5584() == 20) {
                MainUtil.makeBleed((class_1297)this.self, 2, 900, (class_1297)this.self);
                this.self.method_37908().method_8396(null, this.self.method_24515(), ModSounds.SPIKE_HIT_EVENT, class_3419.field_15248, 1.0f, 1.0f);
                if (MainUtil.getMobBleed((class_1297)this.self)) {
                    MainUtil.makeMobBleed((class_1297)this.self);
                }
            }
        }
    }

    public void spikeAttackModeToggleClient() {
        if (!this.hasExtendedHeelsForWalking() || ((IGravityEntity)this.self).roundabout$getGravityDirection() == class_2350.field_11033) {
            if (!this.inCombatMode() && this.getShootTicks() > 0) {
                return;
            }
            this.tryPower(27, true);
            this.tryPowerPacket((byte)27);
            this.getStandUserSelf().roundabout$getStandPowers().tryPower(0, true);
            this.tryPowerPacket((byte)0);
            ClientUtil.stopDestroyingBlock();
        }
    }

    public void wallLatch() {
        if (this.canLatchOntoWall() && this.canWallWalkConfig()) {
            this.setCooldown((byte)2, 6);
            if (!this.self.method_37908().method_8608()) {
                this.self.method_37908().method_8396(null, this.self.method_24515(), ModSounds.WALL_LATCH_EVENT, class_3419.field_15248, 1.0f, 1.0f);
                this.toggleSpikes(true);
                class_2350 gd = RotationUtil.getRealFacingDirection2(this.self);
                this.setHeelDirection(gd);
                ((IGravityEntity)this.self).roundabout$setGravityDirection(gd);
                this.justFlippedTicks = 7;
            }
        }
    }

    public void grantFallImmunity() {
        if (ClientNetworking.getAppropriateConfig().walkingHeartSettings.fallProtectionOnRelease.booleanValue()) {
            ((StandUser)this.getSelf()).roundabout$setLeapTicks(((StandUser)this.getSelf()).roundabout$getMaxLeapTicks());
            ((StandUser)this.getSelf()).roundabout$setLeapIntentionally(true);
        }
    }

    public void toggleSpikes(boolean toggle) {
        boolean getTog;
        if (!this.self.method_37908().method_8608() && toggle != (getTog = this.getStandUserSelf().roundabout$getUniqueStandModeToggle())) {
            if (toggle) {
                this.self.method_37908().method_8396(null, this.self.method_24515(), ModSounds.EXTEND_SPIKES_EVENT, class_3419.field_15248, 1.0f, 1.0f);
            } else {
                this.setHeelAttachCooldown();
                this.self.method_37908().method_8396(null, this.self.method_24515(), ModSounds.EXTEND_SPIKES_EVENT, class_3419.field_15248, 1.0f, 1.5f);
            }
        }
        this.getStandUserSelf().roundabout$setUniqueStandModeToggle(toggle);
    }

    @Override
    public void renderIcons(class_332 context, int x, int y) {
        this.setSkillIcon(context, x, y, 1, StandIcons.SPIKE_ATTACK_MODE, (byte)0);
        if (this.hasExtendedHeelsForWalking()) {
            this.setSkillIcon(context, x, y, 2, StandIcons.GROUND_IMPLANT, (byte)1);
        } else {
            this.setSkillIcon(context, x, y, 2, StandIcons.GROUND_IMPLANT_OUT, (byte)1);
        }
        if ((this.canLatchOntoWall() || this.hasExtendedHeelsForWalking()) && this.canWallWalkConfig()) {
            this.setSkillIcon(context, x, y, 3, StandIcons.WALL_WALK, (byte)2);
        } else {
            this.setSkillIcon(context, x, y, 3, StandIcons.DODGE, (byte)6);
        }
        class_1309 class_13092 = this.getSelf();
        if (class_13092 instanceof class_1657) {
            class_1799 stack;
            boolean bypass;
            class_1657 PE = (class_1657)class_13092;
            class_1799 goldDisc = ((StandUser)PE).roundabout$getStandDisc();
            boolean bl = bypass = PE.method_7337() || !goldDisc.method_7960() && goldDisc.method_7909() instanceof MaxStandDiscItem;
            if (!((IPlayerEntity)PE).roundabout$getUnlockedBonusSkin() && !bypass && !(stack = this.self.method_6047()).method_7960() && stack.method_31574(class_1802.field_8786) && stack.method_7947() >= 64) {
                this.setSkillIcon(context, x, y, 4, StandIcons.SPIDER_SKIN, (byte)0);
            }
        }
    }

    @Override
    public boolean isAttackIneptVisually(byte activeP, int slot) {
        if (slot == 3 && this.hasExtendedHeelsForWalking() && !this.canLatchOntoWall()) {
            return true;
        }
        if (slot == 1 && this.hasExtendedHeelsForWalking() && ((IGravityEntity)this.self).roundabout$getGravityDirection() != class_2350.field_11033) {
            return true;
        }
        if (slot == 1 && (this.isBlockedByStone() || this.getShootTicks() > 0 && !this.inCombatMode())) {
            return true;
        }
        if ((slot == 2 || slot == 3) && this.inCombatMode()) {
            return true;
        }
        return super.isAttackIneptVisually(activeP, slot);
    }

    @Override
    protected Byte getSummonSound() {
        return (byte)18;
    }

    @Override
    public class_3414 getSoundFromByte(byte soundChoice) {
        byte bt = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (soundChoice == 18) {
            return ModSounds.SUMMON_WALKING_EVENT;
        }
        return super.getSoundFromByte(soundChoice);
    }

    @Override
    public float inputSpeedModifiers(float basis) {
        if (this.inCombatMode()) {
            return 0.0f;
        }
        return super.inputSpeedModifiers(basis);
    }

    public boolean inCombatMode() {
        return this.getStandUserSelf().roundabout$getCombatMode();
    }

    @Override
    public boolean cancelJump() {
        return this.inCombatMode();
    }

    @Override
    public boolean cancelSprint() {
        return this.inCombatMode();
    }

    public void switchModes() {
        if (this.getStandUserSelf().roundabout$getCombatMode()) {
            this.getStandUserSelf().roundabout$setCombatMode(false);
            if (!this.self.method_37908().method_8608()) {
                this.self.method_37908().method_43128(null, this.self.method_23317(), this.self.method_23318(), this.self.method_23321(), ModSounds.HEEL_STOMP_EVENT, this.self.method_5634(), 1.0f, 1.0f);
            }
        } else {
            if (this.hasExtendedHeelsForWalking() && ((IGravityEntity)this.self).roundabout$getGravityDirection() != class_2350.field_11033 || this.isBlockedByStone()) {
                return;
            }
            this.self.method_5728(false);
            this.getStandUserSelf().roundabout$setCombatMode(true);
            if (!this.self.method_37908().method_8608()) {
                this.self.method_37908().method_43128(null, this.self.method_23317(), this.self.method_23318(), this.self.method_23321(), ModSounds.HEEL_RAISE_EVENT, this.self.method_5634(), 1.0f, 1.0f);
            }
        }
    }

    public int getMaxShootTicks() {
        class_1309 class_13092 = this.self;
        if (class_13092 instanceof class_1657) {
            boolean bypass;
            class_1657 PE = (class_1657)class_13092;
            byte Level = ((IPlayerEntity)PE).roundabout$getStandLevel();
            class_1799 goldDisc = ((StandUser)PE).roundabout$getStandDisc();
            boolean bl = bypass = PE.method_7337() || !goldDisc.method_7960() && goldDisc.method_7909() instanceof MaxStandDiscItem;
            if (Level > 3 || bypass) {
                return 10000;
            }
            if (Level > 2) {
                return 10000 - this.getUseTicks();
            }
            if (Level > 1) {
                return 10000 - this.getUseTicks() - this.getUseTicks();
            }
            return 10000 - this.getUseTicks() - this.getUseTicks() - this.getUseTicks() - this.getUseTicks();
        }
        return 10000;
    }

    public int getShootTicks() {
        return this.shootTicks;
    }

    public void setShootTicks(int shootTicks) {
        this.shootTicks = class_3532.method_15340((int)shootTicks, (int)0, (int)this.getMaxShootTicks());
        if (this.shootTicks >= this.getMaxShootTicks() && this.self.method_37908().method_8608()) {
            this.tryPowerPacket((byte)27);
        }
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        switch (move) {
            case 23: {
                this.regularExtendHeels();
                break;
            }
            case 25: {
                this.wallLatch();
                break;
            }
            case 27: {
                this.switchModes();
                break;
            }
            case 33: {
                this.useSpikeAttack();
                break;
            }
            case 52: {
                this.useSpikeAttack2();
                break;
            }
            case 34: {
                this.missSound();
                break;
            }
            case 22: {
                this.hitSound();
                break;
            }
            case 36: {
                this.spiderUnlock();
            }
        }
        return super.tryPower(move, forced);
    }

    @Override
    public boolean interceptAttack() {
        return this.inCombatMode();
    }

    public void spiderUnlock() {
        class_1309 class_13092 = this.getSelf();
        if (class_13092 instanceof class_1657) {
            class_1799 stack;
            boolean bypass;
            class_1657 PE = (class_1657)class_13092;
            class_1937 lv = this.getSelf().method_37908();
            class_1799 goldDisc = ((StandUser)PE).roundabout$getStandDisc();
            StandUser user = (StandUser)PE;
            boolean bl = bypass = PE.method_7337() || !goldDisc.method_7960() && goldDisc.method_7909() instanceof MaxStandDiscItem;
            if (!(((IPlayerEntity)PE).roundabout$getUnlockedBonusSkin() || bypass || (stack = this.self.method_6047()).method_7960() || !stack.method_31574(class_1802.field_8786) || stack.method_7947() < 64 || lv.method_8608())) {
                IPlayerEntity ipe = (IPlayerEntity)PE;
                ipe.roundabout$setUnlockedBonusSkin(true);
                lv.method_43128(null, PE.method_23317(), PE.method_23318(), PE.method_23321(), ModSounds.UNLOCK_SKIN_EVENT, PE.method_5634(), 2.0f, 1.0f);
                ((class_3218)lv).method_14199((class_2394)class_2398.field_11207, PE.method_23317(), PE.method_23318() + (double)PE.method_5751(), PE.method_23321(), 10, 0.5, 0.5, 0.5, 0.2);
                user.roundabout$setStandSkin((byte)8);
                ((class_3222)ipe).method_7353((class_2561)class_2561.method_43471((String)"unlock_skin.roundabout.walking_heart.spider"), true);
                user.roundabout$summonStand(lv, true, false);
                stack.method_7934(64);
            }
        }
    }

    @Override
    public boolean tryIntPower(int move, boolean forced, int chargeTime) {
        class_1297 ent;
        if (move == 44 && (ent = this.self.method_37908().method_8469(chargeTime)) != null) {
            this.HeelSpikeDamageEntityAttack(ent, this.getSpikeDamage(ent), 0.5f, (class_1297)this.self, false);
            return true;
        }
        if (move == 45 && (ent = this.self.method_37908().method_8469(chargeTime)) != null) {
            this.HeelSpikeDamageEntityAttack(ent, this.getSpikeDamage(ent), 0.7f, (class_1297)this.self, true);
            return true;
        }
        return super.tryIntPower(move, forced, chargeTime);
    }

    public float getSpikeDamage(class_1297 entity) {
        if (this.getReducedDamage(entity)) {
            return this.levelupDamageMod((float)((double)2.1f * ((double)ClientNetworking.getAppropriateConfig().walkingHeartSettings.walkingHeartAttackMultOnPlayers.intValue() * 0.01)));
        }
        return this.levelupDamageMod((float)(3.0 * ((double)ClientNetworking.getAppropriateConfig().walkingHeartSettings.walkingHeartAttackMultOnMobs.intValue() * 0.01)));
    }

    @Override
    public boolean interceptAllInteractions() {
        return this.inCombatMode();
    }

    public boolean HeelSpikeDamageEntityAttack(class_1297 target, float pow, float knockbackStrength, class_1297 attacker, boolean rightClick) {
        class_1309 LE;
        if (target == null) {
            return false;
        }
        this.hitParticlesCenter(target);
        if (attacker instanceof class_1321) {
            class_1321 TT;
            class_1321 TA = (class_1321)attacker;
            if (target instanceof class_1321 && (TT = (class_1321)target).method_35057() != null && TA.method_35057() != null && TT.method_35057().method_5779((class_1297)TA.method_35057())) {
                return false;
            }
        } else if (attacker instanceof class_3988 && target instanceof class_3988) {
            return false;
        }
        if (DamageHandler.HeelSpikeStandDamageEntity(target, pow, attacker)) {
            if (attacker instanceof class_1309) {
                LE = (class_1309)attacker;
                LE.method_6114(target);
            }
            if (target instanceof class_1309) {
                LE = (class_1309)target;
                this.addEXP(3, LE);
                float mod = -1.0f;
                if (rightClick) {
                    mod = 1.0f;
                }
                LE.field_6037 = true;
                LE.method_6005((double)(knockbackStrength * 0.5f), (double)(mod * class_3532.method_15374((float)(this.self.method_36454() * ((float)Math.PI / 180)))), (double)(mod * -class_3532.method_15362((float)(this.self.method_36454() * ((float)Math.PI / 180)))));
                MainUtil.makeBleed((class_1297)LE, 0, 300, (class_1297)this.self);
            }
            return true;
        }
        if (target instanceof class_1309) {
            LE = (class_1309)target;
            float mod = -1.0f;
            if (rightClick) {
                mod = 1.0f;
            }
            LE.field_6037 = true;
            LE.method_6005((double)(knockbackStrength * 0.5f), (double)(mod * class_3532.method_15374((float)(this.self.method_36454() * ((float)Math.PI / 180)))), (double)(mod * -class_3532.method_15362((float)(this.self.method_36454() * ((float)Math.PI / 180)))));
        }
        return false;
    }

    public final void sendHeelPacket(double range) {
        if (!this.self.method_37908().field_9236) {
            class_3218 serverWorld = (class_3218)this.self.method_37908();
            class_243 userLocation = new class_243(this.self.method_23317(), this.self.method_23318(), this.self.method_23321());
            for (int j = 0; j < serverWorld.method_18456().size(); ++j) {
                class_2338 blockPos;
                class_3222 serverPlayerEntity = (class_3222)((class_3218)this.self.method_37908()).method_18456().get(j);
                if ((class_3218)serverPlayerEntity.method_37908() != serverWorld || !(blockPos = serverPlayerEntity.method_24515()).method_19769((class_2374)userLocation, range)) continue;
                S2CPacketUtil.heelExtend((class_1657)serverPlayerEntity, this.self.method_5628());
            }
        }
    }

    public void hitSound() {
        this.sendHeelPacket(120.0);
        this.self.method_37908().method_8396(null, this.self.method_24515(), ModSounds.SPIKE_HIT_EVENT, class_3419.field_15248, 2.0f, (float)(0.98 + Math.random() * 0.04));
    }

    public void missSound() {
        this.sendHeelPacket(120.0);
        this.self.method_37908().method_8396(null, this.self.method_24515(), ModSounds.SPIKE_MISS_EVENT, class_3419.field_15248, 2.0f, (float)(0.98 + Math.random() * 0.04));
    }

    @Override
    public boolean replaceHudActively() {
        return this.inCombatMode() || this.getShootTicks() > 0;
    }

    @Override
    public void getReplacementHUD(class_332 context, class_1657 cameraPlayer, int screenWidth, int screenHeight, int x) {
        StandHudRender.renderWalkingHeartHud(context, cameraPlayer, screenWidth, screenHeight, x);
    }

    public void useSpikeAttackF(boolean rightClick) {
        this.setCooldown((byte)3, 3);
        this.setAttackTimeDuring(-10);
        this.setActivePower((byte)33);
        if (this.self.method_37908().method_8608()) {
            List<class_1297> TE = ClientNetworking.getAppropriateConfig().miscellaneousSettings.wallPassingHitboxes == false ? this.getTargetEntityList(this.self, 7.0f, 10.0f) : this.getTargetEntityListThroughWalls(this.self, 7.0f, 10.0f);
            if (TE == null || TE.isEmpty()) {
                this.tryPowerPacket((byte)34);
            } else {
                this.tryPowerPacket((byte)22);
                for (class_1297 value : TE) {
                    if (rightClick) {
                        this.tryIntPowerPacket((byte)45, value.method_5628());
                        continue;
                    }
                    this.tryIntPowerPacket((byte)44, value.method_5628());
                }
            }
        }
    }

    public void useSpikeAttack2() {
        this.useSpikeAttackF(true);
    }

    public boolean isBlockedByStone() {
        byte curse = ((StandUser)this.self).roundabout$getLocacacaCurse();
        class_1309 class_13092 = this.self;
        if (class_13092 instanceof class_1657) {
            class_1657 PE = (class_1657)class_13092;
            if (curse == 2 && PE.method_6068() == class_1306.field_6183) {
                return true;
            }
            if (curse == 1 && PE.method_6068() == class_1306.field_6182) {
                return true;
            }
        }
        return false;
    }

    public void useSpikeAttack() {
        this.useSpikeAttackF(false);
    }

    @Override
    public void tickPower() {
        class_1657 PE;
        class_1309 class_13092;
        if (this.lastTick != this.self.field_6012) {
            this.setHeelExtension(this.getHeelExtension() - 1);
            this.lastTick = this.self.field_6012;
        }
        if (this.self.method_37908().method_8608()) {
            if (!this.inCombatMode()) {
                this.currentKickTicks = 0;
            } else if (this.currentKickTicks < PowersWalkingHeart.chargeKickTicks()) {
                ++this.currentKickTicks;
            }
            if (this.hasExtendedHeelsForWalking() && !this.getStandUserSelf().rdbt$getJumping() && !this.self.method_24828() && this.self.method_18798().field_1351 < 0.0) {
                this.self.method_18799(this.self.method_18798().method_1031(0.0, -0.14, 0.0));
            }
        } else {
            if (this.inCombatMode() && this.isBlockedByStone()) {
                this.switchModes();
            }
            if (this.hasExtendedHeelsForWalking()) {
                if (this.justFlippedTicks > 0) {
                    --this.justFlippedTicks;
                } else {
                    boolean isOnValidBlock;
                    class_243 newVec = new class_243(0.0, -0.2, 0.0);
                    class_243 newVec2 = new class_243(0.0, -1.0, 0.0);
                    class_243 newVec4 = new class_243(0.0, -0.5, 0.0);
                    class_243 newVec5 = new class_243(0.0, -1.1, 0.0);
                    newVec = RotationUtil.vecPlayerToWorld(newVec, ((IGravityEntity)this.self).roundabout$getGravityDirection());
                    class_2338 pos = class_2338.method_49638((class_2374)this.self.method_30950(1.0f).method_1019(newVec));
                    newVec2 = RotationUtil.vecPlayerToWorld(newVec2, ((IGravityEntity)this.self).roundabout$getGravityDirection());
                    class_2338 pos2 = class_2338.method_49638((class_2374)this.self.method_30950(1.0f).method_1019(newVec2));
                    newVec4 = RotationUtil.vecPlayerToWorld(newVec4, ((IGravityEntity)this.self).roundabout$getGravityDirection());
                    class_2338 pos4 = class_2338.method_49638((class_2374)this.self.method_30950(1.0f).method_1019(newVec4));
                    newVec5 = RotationUtil.vecPlayerToWorld(newVec5, ((IGravityEntity)this.self).roundabout$getGravityDirection());
                    class_2338 pos5 = class_2338.method_49638((class_2374)this.self.method_30950(1.0f).method_1019(newVec5));
                    class_2680 state1 = this.self.method_37908().method_8320(pos);
                    class_2680 state2 = this.self.method_37908().method_8320(pos2);
                    class_2680 state4 = this.self.method_37908().method_8320(pos4);
                    class_2680 state5 = this.self.method_37908().method_8320(pos5);
                    boolean bl = isOnValidBlock = MainUtil.isBlockWalkableSimplified(state1) && MainUtil.isBlockWalkableSimplified(state2) && MainUtil.isBlockWalkableSimplified(state4) && MainUtil.isBlockWalkableSimplified(state5);
                    this.mercyTicks = this.self.method_24828() && MainUtil.isBlockWalkableSimplified(this.self.method_25936()) && isOnValidBlock ? 5 : (MainUtil.isBlockWalkable(this.self.method_37908().method_8320(pos)) || MainUtil.isBlockWalkable(this.self.method_37908().method_8320(pos2)) || MainUtil.isBlockWalkable(this.self.method_37908().method_8320(pos4)) || MainUtil.isBlockWalkable(this.self.method_37908().method_8320(pos5)) ? --this.mercyTicks : 0);
                    if (this.self.method_6113() || (!this.self.method_24828() || !isOnValidBlock) && this.mercyTicks <= 0 || this.self.method_5668() != this.self) {
                        this.heelDirection = class_2350.field_11033;
                        if (((IGravityEntity)this.self).roundabout$getGravityDirection() != this.heelDirection) {
                            this.grantFallImmunity();
                        }
                        this.toggleSpikes(false);
                        ((IGravityEntity)this.self).roundabout$setGravityDirection(this.heelDirection);
                        this.setHeelDirection(this.heelDirection);
                    }
                }
            } else {
                this.setHeelDirection(class_2350.field_11033);
            }
            if (!this.hasExtendedHeelsForWalking()) {
                this.hitsSinceAttached = 0;
            }
        }
        if ((class_13092 = this.self) instanceof class_1657 && (PE = (class_1657)class_13092).method_7337()) {
            this.setShootTicks(0);
        } else if (this.inCombatMode()) {
            if (this.getShootTicks() < this.getMaxShootTicks()) {
                this.setShootTicks(this.getShootTicks() + this.getRaiseTicks());
            }
        } else if (this.getPauseGrowthTicks() > 0) {
            --this.pauseGrowthTicks;
        } else if (this.getShootTicks() > 0) {
            this.setShootTicks(this.getShootTicks() - this.getLowerTicks());
        }
        super.tickPower();
    }

    public int getRaiseTicks() {
        return 40;
    }

    public int pauseTicks() {
        return 60;
    }

    public int getHeelExtension() {
        return this.heelExtension;
    }

    public void setHeelExtension(int extNum) {
        this.heelExtension = class_3532.method_15340((int)extNum, (int)0, (int)1000);
    }

    public int getLowerTicks() {
        return 60;
    }

    public boolean canShootSpikes(int useTicks) {
        return this.shootTicks + useTicks <= this.getMaxShootTicks();
    }

    public int getUseTicks() {
        return 1300;
    }

    @Override
    public boolean interceptGuard() {
        return this.inCombatMode();
    }

    @Override
    public boolean buttonInputGuard(boolean keyIsDown, class_315 options) {
        this.buttonInputSpike(keyIsDown, options, true);
        return true;
    }

    @Override
    public void buttonInputAttack(boolean keyIsDown, class_315 options) {
        this.buttonInputSpike(keyIsDown, options, false);
    }

    public void buttonInputSpike(boolean keyIsDown, class_315 options, boolean rightClick) {
        if (this.currentKickTicks < PowersWalkingHeart.chargeKickTicks()) {
            return;
        }
        if (!this.consumeClickInput) {
            if (this.holdDownClick) {
                if (!keyIsDown) {
                    this.holdDownClick = false;
                }
            } else if (keyIsDown && this.inCombatMode() && !this.holdDownClick && !this.onCooldown((byte)3) && (this.getActivePower() == 0 || this.getActivePower() == 33) && this.confirmShot(this.getUseTicks())) {
                class_1309 class_13092 = this.self;
                if (class_13092 instanceof class_1657) {
                    class_1657 PE = (class_1657)class_13092;
                    IPlayerEntity ipe = (IPlayerEntity)PE;
                    ipe.roundabout$getBubbleShotAim().method_41325();
                    ipe.roundabout$setBubbleShotAimPoints(10);
                }
                if (rightClick) {
                    this.tryPower(52, true);
                } else {
                    this.tryPower(33, true);
                }
            }
        } else if (!keyIsDown) {
            this.consumeClickInput = false;
        }
    }

    public boolean confirmShot(int useTicks) {
        if (this.canShootSpikes(useTicks)) {
            this.pauseGrowthTicks = this.pauseTicks();
            this.setShootTicks(this.shootTicks + useTicks);
            return true;
        }
        return false;
    }

    public int getPauseGrowthTicks() {
        return this.pauseGrowthTicks;
    }

    @Override
    public void updateUniqueMoves() {
        super.updateUniqueMoves();
    }

    public boolean deface() {
        StandEntity stand = this.getStandEntity(this.self);
        if (Objects.nonNull(stand)) {
            this.setAttackTimeDuring(0);
            this.setActivePower((byte)23);
            this.playStandUserOnlySoundsIfNearby((byte)105, 27.0, false, false);
            this.animateStand((byte)81);
            this.poseStand((byte)1);
            return true;
        }
        return false;
    }

    @Override
    public List<AbilityIconInstance> drawGUIIcons(class_332 context, float delta, int mouseX, int mouseY, int leftPos, int topPos, byte level, boolean bypass) {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 80, 0, "ability.roundabout.spike_attack_mode", "instruction.roundabout.press_skill", StandIcons.SPIKE_ATTACK_MODE, 1, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 99, 0, "ability.roundabout.heel_plant", "instruction.roundabout.press_skill", StandIcons.GROUND_IMPLANT, 2, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 118, 0, "ability.roundabout.dodge", "instruction.roundabout.press_skill", StandIcons.DODGE, 3, level, bypass));
        if (this.canWallWalkConfig()) {
            $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 80, 0, "ability.roundabout.wall_walk_move", "instruction.roundabout.press_skill", StandIcons.WALL_WALK, 3, level, bypass));
            $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 99, 0, "ability.roundabout.firm_swing", "instruction.roundabout.passive", StandIcons.FIRM_SWING, 0, level, bypass));
        } else {
            $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 80, 0, "ability.roundabout.firm_swing", "instruction.roundabout.passive", StandIcons.FIRM_SWING, 0, level, bypass));
        }
        return $$1;
    }

    @Override
    public List<Byte> getSkinList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)1);
        class_1309 class_13092 = this.getSelf();
        if (class_13092 instanceof class_1657) {
            boolean bypass;
            class_1657 PE = (class_1657)class_13092;
            byte Level = ((IPlayerEntity)PE).roundabout$getStandLevel();
            class_1799 goldDisc = ((StandUser)PE).roundabout$getStandDisc();
            boolean bl = bypass = PE.method_7337() || !goldDisc.method_7960() && goldDisc.method_7909() instanceof MaxStandDiscItem;
            if (Level > 1 || bypass) {
                $$1.add((byte)2);
                $$1.add((byte)3);
            }
            if (Level > 2 || bypass) {
                $$1.add((byte)6);
                $$1.add((byte)4);
            }
            if (Level > 3 || bypass) {
                $$1.add((byte)5);
                $$1.add((byte)7);
            }
            if (((IPlayerEntity)PE).roundabout$getUnlockedBonusSkin() || bypass) {
                $$1.add((byte)8);
            }
        }
        return $$1;
    }

    @Override
    public class_2561 getSkinName(byte skinId) {
        return PowersWalkingHeart.getSkinNameT(skinId);
    }

    public static class_2561 getSkinNameT(byte skinId) {
        if (skinId == 1) {
            return class_2561.method_43471((String)"skins.roundabout.walking_heart.base");
        }
        if (skinId == 2) {
            return class_2561.method_43471((String)"skins.roundabout.walking_heart.model");
        }
        if (skinId == 3) {
            return class_2561.method_43471((String)"skins.roundabout.walking_heart.purple");
        }
        if (skinId == 4) {
            return class_2561.method_43471((String)"skins.roundabout.walking_heart.verdant");
        }
        if (skinId == 5) {
            return class_2561.method_43471((String)"skins.roundabout.walking_heart.pale");
        }
        if (skinId == 6) {
            return class_2561.method_43471((String)"skins.roundabout.walking_heart.valentine");
        }
        if (skinId == 7) {
            return class_2561.method_43471((String)"skins.roundabout.walking_heart.gothic");
        }
        if (skinId == 8) {
            return class_2561.method_43471((String)"skins.roundabout.walking_heart.spider");
        }
        return class_2561.method_43471((String)"skins.roundabout.walking_heart.base");
    }

    public static int chargeKickTicks() {
        return 9;
    }

    @Override
    public void renderAttackHud(class_332 context, class_1657 playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        int j = scaledHeight / 2 - 7 - 4;
        int k = scaledWidth / 2 - 8;
        if (this.inCombatMode()) {
            class_1297 TE = this.getTargetEntityThroughWalls((class_1309)playerEntity, 7.0f, 10.0f);
            float finalATime = (float)this.currentKickTicks / (float)PowersWalkingHeart.chargeKickTicks();
            int barTexture = 0;
            if (TE != null) {
                barTexture = 18;
            }
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            int finalATimeInt = Math.round(finalATime * 15.0f);
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, barTexture, finalATimeInt, 6);
            if (TE != null) {
                // empty if block
            }
        }
    }
}

