/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.block;

import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import javax.annotation.Nullable;
import net.hydra.jojomod.block.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.ContainerSingleItem;

public class StereoBlockEntity
extends BlockEntity
implements Clearable,
ContainerSingleItem {
    private static final int SONG_END_PADDING = 20;
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    private int ticksSinceLastEvent;
    private long tickCount;
    private long recordStartedTick;
    private boolean isPlaying;

    public StereoBlockEntity(BlockPos $$0, BlockState $$1) {
        super(ModBlocks.STEREO_BLOCK_ENTITY, $$0, $$1);
    }

    public void m_142466_(CompoundTag $$0) {
        super.m_142466_($$0);
        if ($$0.m_128425_("RecordItem", 10)) {
            this.items.set(0, (Object)ItemStack.m_41712_((CompoundTag)$$0.m_128469_("RecordItem")));
        }
        this.isPlaying = $$0.m_128471_("IsPlaying");
        this.recordStartedTick = $$0.m_128454_("RecordStartTick");
        this.tickCount = $$0.m_128454_("TickCount");
    }

    protected void m_183515_(CompoundTag $$0) {
        super.m_183515_($$0);
        if (!this.m_272036_().m_41619_()) {
            $$0.m_128365_("RecordItem", (Tag)this.m_272036_().m_41739_(new CompoundTag()));
        }
        $$0.m_128379_("IsPlaying", this.isPlaying);
        $$0.m_128356_("RecordStartTick", this.recordStartedTick);
        $$0.m_128356_("TickCount", this.tickCount);
    }

    public boolean isRecordPlaying() {
        return !this.m_272036_().m_41619_() && this.isPlaying;
    }

    private void setHasRecordBlockState(@Nullable Entity $$0, boolean $$1) {
        if (this.f_58857_.m_8055_(this.m_58899_()) == this.m_58900_()) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)JukeboxBlock.f_54254_, (Comparable)Boolean.valueOf($$1)), 2);
            this.f_58857_.m_220407_(GameEvent.f_157792_, this.m_58899_(), GameEvent.Context.m_223719_((Entity)$$0, (BlockState)this.m_58900_()));
        }
    }

    @VisibleForTesting
    public void startPlaying() {
        this.recordStartedTick = this.tickCount;
        this.isPlaying = true;
        this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
        this.f_58857_.m_5898_(null, 1010, this.m_58899_(), Item.m_41393_((Item)this.m_272036_().m_41720_()));
        this.m_6596_();
    }

    private void stopPlaying() {
        this.isPlaying = false;
        this.f_58857_.m_220407_(GameEvent.f_238649_, this.m_58899_(), GameEvent.Context.m_223722_((BlockState)this.m_58900_()));
        this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
        this.f_58857_.m_46796_(1011, this.m_58899_(), 0);
        this.m_6596_();
    }

    private void tick(Level $$0, BlockPos $$1, BlockState $$2) {
        Item item;
        ++this.ticksSinceLastEvent;
        if (this.isRecordPlaying() && (item = this.m_272036_().m_41720_()) instanceof RecordItem) {
            RecordItem $$3 = (RecordItem)item;
            if (this.shouldRecordStopPlaying($$3)) {
                this.stopPlaying();
            } else if (this.shouldSendJukeboxPlayingEvent()) {
                this.ticksSinceLastEvent = 0;
                $$0.m_220407_(GameEvent.f_238690_, $$1, GameEvent.Context.m_223722_((BlockState)$$2));
                this.spawnMusicParticles($$0, $$1);
            }
        }
        ++this.tickCount;
    }

    private boolean shouldRecordStopPlaying(RecordItem $$0) {
        return this.tickCount >= this.recordStartedTick + (long)$$0.m_43036_() + 20L;
    }

    private boolean shouldSendJukeboxPlayingEvent() {
        return this.ticksSinceLastEvent >= 20;
    }

    public ItemStack m_8020_(int $$0) {
        return (ItemStack)this.items.get($$0);
    }

    public ItemStack m_7407_(int $$0, int $$1) {
        ItemStack $$2 = Objects.requireNonNullElse((ItemStack)this.items.get($$0), ItemStack.f_41583_);
        this.items.set($$0, (Object)ItemStack.f_41583_);
        if (!$$2.m_41619_()) {
            this.setHasRecordBlockState(null, false);
            this.stopPlaying();
        }
        return $$2;
    }

    public void m_6836_(int $$0, ItemStack $$1) {
        if ($$1.m_204117_(ItemTags.f_13158_) && this.f_58857_ != null) {
            this.items.set($$0, (Object)$$1);
            this.setHasRecordBlockState(null, true);
            this.startPlaying();
        }
    }

    public int m_6893_() {
        return 1;
    }

    public boolean m_6542_(Player $$0) {
        return Container.m_272074_((BlockEntity)this, (Player)$$0);
    }

    public boolean m_7013_(int $$0, ItemStack $$1) {
        return $$1.m_204117_(ItemTags.f_13158_) && this.m_8020_($$0).m_41619_();
    }

    public boolean m_271862_(Container $$0, int $$1, ItemStack $$2) {
        return $$0.m_216874_(ItemStack::m_41619_);
    }

    private void spawnMusicParticles(Level $$0, BlockPos $$1) {
        if ($$0 instanceof ServerLevel) {
            ServerLevel $$2 = (ServerLevel)$$0;
            Vec3 $$3 = Vec3.m_82539_((Vec3i)$$1).m_82520_(0.0, (double)0.6f, 0.0);
            float $$4 = (float)$$0.m_213780_().m_188503_(4) / 24.0f;
            $$2.m_8767_((ParticleOptions)ParticleTypes.f_123758_, $$3.m_7096_(), $$3.m_7098_(), $$3.m_7094_(), 0, (double)$$4, 0.0, 0.0, 1.0);
        }
    }

    public void popOutRecord() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockPos $$0 = this.m_58899_();
            ItemStack $$1 = this.m_272036_();
            if (!$$1.m_41619_()) {
                this.m_272108_();
                Vec3 $$2 = Vec3.m_272021_((Vec3i)$$0, (double)0.5, (double)0.4, (double)0.5).m_272010_(this.f_58857_.f_46441_, 0.4f);
                ItemStack $$3 = $$1.m_41777_();
                ItemEntity $$4 = new ItemEntity(this.f_58857_, $$2.m_7096_(), $$2.m_7098_(), $$2.m_7094_(), $$3);
                $$4.m_32060_();
                this.f_58857_.m_7967_((Entity)$$4);
            }
        }
    }

    public static void playRecordTick(Level $$0, BlockPos $$1, BlockState $$2, StereoBlockEntity $$3) {
        $$3.tick($$0, $$1, $$2);
    }

    @VisibleForTesting
    public void setRecordWithoutPlaying(ItemStack $$0) {
        this.items.set(0, (Object)$$0);
        this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
        this.m_6596_();
    }
}

