/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.npcs;

import com.mojang.logging.LogUtils;
import java.util.UUID;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.npcs.Aesthetician;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.item.StandDiscItem;
import net.hydra.jojomod.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ZombieAesthetician
extends Zombie {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<Boolean> DATA_CONVERTING_ID = SynchedEntityData.m_135353_(ZombieAesthetician.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int VILLAGER_CONVERSION_WAIT_MIN = 3600;
    private static final int VILLAGER_CONVERSION_WAIT_MAX = 6000;
    private static final int MAX_SPECIAL_BLOCKS_COUNT = 14;
    private static final int SPECIAL_BLOCK_RADIUS = 4;
    private int villagerConversionTime;
    @Nullable
    private UUID conversionStarter;
    @Nullable
    private Tag gossips;
    @Nullable
    private CompoundTag tradeOffers;
    private int villagerXp;
    public boolean isInitialized = false;
    private static final EntityDataAccessor<Integer> ROUNDABOUT$SKIN_NUMBER = SynchedEntityData.m_135353_(ZombieAesthetician.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ZombieAesthetician(EntityType<? extends ZombieAesthetician> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        if (!this.f_19804_.m_285897_(ROUNDABOUT$SKIN_NUMBER)) {
            this.f_19804_.m_135372_(DATA_CONVERTING_ID, (Object)false);
            this.f_19804_.m_135372_(ROUNDABOUT$SKIN_NUMBER, (Object)1);
        }
    }

    public void m_6863_(boolean $$0) {
    }

    public boolean m_6162_() {
        return false;
    }

    public void applySkin() {
        ((StandUser)((Object)this)).roundabout$setStandSkin((byte)3);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (this.gossips != null) {
            compoundTag.m_128365_("Gossips", this.gossips);
        }
        compoundTag.m_128379_("isInitialized", this.isInitialized);
        compoundTag.m_128405_("ConversionTime", this.isConverting() ? this.villagerConversionTime : -1);
        if (this.conversionStarter != null) {
            compoundTag.m_128362_("ConversionPlayer", this.conversionStarter);
        }
        compoundTag.m_128405_("Xp", this.villagerXp);
    }

    public void rollStand() {
        if (!this.isInitialized) {
            ItemStack stack = ((StandUser)((Object)this)).roundabout$getStandDisc();
            if ((stack == null || stack.m_41619_()) && this.getDisc() != null) {
                ((StandUser)((Object)this)).roundabout$setStandDisc(this.getDisc().m_7968_().m_41777_());
                this.applySkin();
            }
            this.isInitialized = true;
        }
    }

    public ItemStack getBasis() {
        return ModItems.AESTHETICIAN_MASK_ZOMBIE.m_7968_();
    }

    public StandDiscItem getDisc() {
        return (StandDiscItem)ModItems.STAND_DISC_CINDERELLA;
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.isInitialized = compoundTag.m_128471_("isInitialized");
        this.rollStand();
        if (compoundTag.m_128425_("Gossips", 9)) {
            this.gossips = compoundTag.m_128437_("Gossips", 10);
        }
        if (compoundTag.m_128425_("ConversionTime", 99) && compoundTag.m_128451_("ConversionTime") > -1) {
            this.startConverting(compoundTag.m_128403_("ConversionPlayer") ? compoundTag.m_128342_("ConversionPlayer") : null, compoundTag.m_128451_("ConversionTime"));
        }
        if (compoundTag.m_128425_("Xp", 3)) {
            this.villagerXp = compoundTag.m_128451_("Xp");
        }
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.isConverting()) {
            int i = this.getConversionProgress();
            this.villagerConversionTime -= i;
            if (this.villagerConversionTime <= 0) {
                this.finishConversion((ServerLevel)this.m_9236_());
            }
        }
        super.m_8119_();
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (itemStack.m_150930_(Items.f_42436_)) {
            if (this.m_21023_(MobEffects.f_19613_)) {
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                if (!this.m_9236_().f_46443_) {
                    this.startConverting(player.m_20148_(), this.f_19796_.m_188503_(2401) + 3600);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, interactionHand);
    }

    protected boolean m_7593_() {
        return false;
    }

    public boolean m_6785_(double d) {
        return !this.isConverting() && this.villagerXp == 0;
    }

    public boolean isConverting() {
        return (Boolean)this.m_20088_().m_135370_(DATA_CONVERTING_ID);
    }

    private void startConverting(@Nullable UUID uUID, int i) {
        this.conversionStarter = uUID;
        this.villagerConversionTime = i;
        this.m_20088_().m_135381_(DATA_CONVERTING_ID, (Object)true);
        this.m_21195_(MobEffects.f_19613_);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, i, Math.min(this.m_9236_().m_46791_().m_19028_() - 1, 0)));
        this.m_9236_().m_7605_((Entity)this, (byte)16);
    }

    public void m_7822_(byte b) {
        if (b == 16) {
            if (!this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20188_(), this.m_20189_(), SoundEvents.f_12644_, this.m_5720_(), 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() * 0.7f + 0.3f, false);
            }
        } else {
            super.m_7822_(b);
        }
    }

    private void finishConversion(ServerLevel serverLevel) {
        Player player;
        Aesthetician villager = (Aesthetician)this.m_21406_(ModEntities.AESTHETICIAN, false);
        if (villager != null) {
            ((StandUser)((Object)villager)).roundabout$setStandDisc(((StandUser)((Object)this)).roundabout$getStandDisc());
            villager.setSkinNumber(this.getSkinNumber());
        }
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            ItemStack itemStack = this.m_6844_(equipmentSlot);
            if (itemStack.m_41619_()) continue;
            if (EnchantmentHelper.m_44920_((ItemStack)itemStack)) {
                villager.m_141942_(equipmentSlot.m_20749_() + 300).m_142104_(itemStack);
                continue;
            }
            double d = this.m_21519_(equipmentSlot);
            if (!(d > 1.0)) continue;
            this.m_19983_(itemStack);
        }
        if (this.gossips != null) {
            villager.setGossips(this.gossips);
        }
        villager.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(villager.m_20183_()), MobSpawnType.CONVERSION, null, null);
        villager.refreshBrain(serverLevel);
        if (this.conversionStarter != null && (player = serverLevel.m_46003_(this.conversionStarter)) instanceof ServerPlayer) {
            serverLevel.m_8670_(ReputationEventType.f_26985_, (Entity)player, (ReputationEventHandler)villager);
        }
        villager.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
        if (!this.m_20067_()) {
            serverLevel.m_5898_((Player)null, 1027, this.m_20183_(), 0);
        }
    }

    private int getConversionProgress() {
        int i = 1;
        if (this.f_19796_.m_188501_() < 0.01f) {
            int j = 0;
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (int k = (int)this.m_20185_() - 4; k < (int)this.m_20185_() + 4 && j < 14; ++k) {
                for (int l = (int)this.m_20186_() - 4; l < (int)this.m_20186_() + 4 && j < 14; ++l) {
                    for (int m = (int)this.m_20189_() - 4; m < (int)this.m_20189_() + 4 && j < 14; ++m) {
                        BlockState blockState = this.m_9236_().m_8055_((BlockPos)mutableBlockPos.m_122178_(k, l, m));
                        if (!blockState.m_60713_(Blocks.f_50183_) && !(blockState.m_60734_() instanceof BedBlock)) continue;
                        if (this.f_19796_.m_188501_() < 0.3f) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
        }
        return i;
    }

    public SoundEvent m_7515_() {
        return ModSounds.FEMALE_ZOMBIE_AMBIENT_EVENT;
    }

    public SoundEvent m_7975_(DamageSource damageSource) {
        return ModSounds.FEMALE_ZOMBIE_HURT_EVENT;
    }

    public SoundEvent m_5592_() {
        return ModSounds.FEMALE_ZOMBIE_DEATH_EVENT;
    }

    public SoundEvent m_7660_() {
        return SoundEvents.f_12647_;
    }

    protected ItemStack m_5728_() {
        return ItemStack.f_41583_;
    }

    public void setSkinNumber(int Pos) {
        this.m_20088_().m_135381_(ROUNDABOUT$SKIN_NUMBER, (Object)Pos);
    }

    public int getSkinNumber() {
        return (Integer)this.m_20088_().m_135370_(ROUNDABOUT$SKIN_NUMBER);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.rollStand();
        RandomSource $$5 = serverLevelAccessor.m_213780_();
        if ($$5.m_188501_() < 0.2f) {
            this.setSkinNumber(2);
        } else if ($$5.m_188501_() < 0.4f) {
            this.setSkinNumber(3);
        } else if ($$5.m_188501_() < 0.6f) {
            this.setSkinNumber(4);
        } else if ($$5.m_188501_() < 0.8f) {
            this.setSkinNumber(5);
        }
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }
}

