/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.projectile;

import java.util.List;
import net.hydra.jojomod.block.ModBlocks;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class GasolineCanEntity
extends ThrowableItemProjectile {
    public float spinningCanX = 0.0f;
    public float spinningCanXo = 0.0f;
    public boolean done;
    public int bounces = 3;
    private int superThrowTicks = -1;
    private static final EntityDataAccessor<Boolean> ROUNDABOUT$SUPER_THROWN = SynchedEntityData.m_135353_(GasolineCanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public GasolineCanEntity(EntityType<? extends ThrowableItemProjectile> $$0, Level $$1) {
        super($$0, $$1);
    }

    public GasolineCanEntity(Level world, double p_36862_, double p_36863_, double p_36864_) {
        super(ModEntities.GASOLINE_CAN, p_36862_, p_36863_, p_36864_, world);
    }

    public GasolineCanEntity(LivingEntity living, Level $$1) {
        super(ModEntities.GASOLINE_CAN, living, $$1);
    }

    public void m_7380_(CompoundTag $$0) {
        $$0.m_128379_("roundabout.Finished", this.done);
        $$0.m_128405_("roundabout.Bounces", this.bounces);
        super.m_7380_($$0);
    }

    public void m_7378_(CompoundTag $$0) {
        this.done = $$0.m_128471_("roundabout.Finished");
        this.bounces = $$0.m_128451_("roundabout.Bounces");
        super.m_7378_($$0);
    }

    public void m_8119_() {
        Vec3 delta = this.m_20184_();
        if (this.m_9236_().f_46443_ || ((Boolean)this.m_20088_().m_135370_(ROUNDABOUT$SUPER_THROWN)).booleanValue()) {
            // empty if block
        }
        int spincount = 0;
        if (this.bounces <= 3) {
            spincount = -15;
        }
        this.spinningCanX = Mth.m_14177_((float)(this.spinningCanX += (float)spincount));
        if (this.m_6060_() && !this.m_9236_().f_46443_) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), 40, 0.0, 0.2, 0.0, 0.2);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), 1, 0.5, 0.5, 0.5, 0.2);
            MainUtil.gasExplode(null, (ServerLevel)this.m_9236_(), this.m_20097_(), 0, 2, 4, MainUtil.gasDamageMultiplier() * 14.0f);
            this.m_146870_();
            return;
        }
        super.m_8119_();
        if (((Boolean)this.m_20088_().m_135370_(ROUNDABOUT$SUPER_THROWN)).booleanValue()) {
            this.m_20256_(delta);
        }
        if (!this.m_9236_().f_46443_ && this.superThrowTicks > -1) {
            --this.superThrowTicks;
            if (this.superThrowTicks <= -1) {
                this.f_19804_.m_135381_(ROUNDABOUT$SUPER_THROWN, (Object)false);
            } else if ((this.f_19797_ + 2) % 4 == 0) {
                if (this.m_7846_().m_41720_() instanceof BlockItem) {
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ModParticles.AIR_CRACKLE, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                } else {
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ModParticles.AIR_CRACKLE, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public boolean m_271807_() {
        return this.m_6084_();
    }

    protected Item m_7881_() {
        return ModItems.GASOLINE_CAN;
    }

    protected void m_8060_(BlockHitResult $$0) {
        --this.bounces;
        if (this.getSuperThrow()) {
            this.m_20088_().m_135381_(ROUNDABOUT$SUPER_THROWN, (Object)false);
        }
        if (this.bounces < 0 || !$$0.m_82434_().equals((Object)Direction.UP)) {
            super.m_8060_($$0);
            if (!this.done) {
                SoundEvent $$6 = ModSounds.CAN_BOUNCE_END_EVENT;
                this.m_5496_($$6, 1.0f, 1.0f);
                this.scatterGoo($$0.m_82425_());
            }
            this.m_146870_();
        } else {
            SoundEvent $$6 = ModSounds.CAN_BOUNCE_EVENT;
            float volume = 1.0f;
            float pitch = 1.0f;
            if (this.bounces < 1) {
                this.done = true;
                $$6 = ModSounds.CAN_BOUNCE_END_EVENT;
            } else if (this.bounces == 1) {
                volume = 0.9f;
                pitch = 0.9f;
            }
            this.scatterGoo($$0.m_82425_());
            this.m_5496_($$6, volume, pitch);
            this.m_20334_(this.m_20184_().f_82479_ * 0.9, 0.18 + 0.04 * (double)this.bounces, this.m_20184_().f_82481_ * 0.9);
        }
    }

    private void initDataTrackerRoundabout(CallbackInfo ci) {
    }

    public void starThrowInit() {
        this.f_19804_.m_135381_(ROUNDABOUT$SUPER_THROWN, (Object)true);
        this.superThrowTicks = 50;
    }

    public boolean getSuperThrow() {
        return (Boolean)this.m_20088_().m_135370_(ROUNDABOUT$SUPER_THROWN);
    }

    public boolean m_6469_(DamageSource $$0, float $$1) {
        Entity hurter = $$0.m_7640_();
        if (hurter instanceof AbstractArrow && hurter.m_6060_()) {
            if (!this.m_9236_().f_46443_) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), 40, 0.0, 0.2, 0.0, 0.2);
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), 1, 0.5, 0.5, 0.5, 0.2);
                MainUtil.gasExplode(null, (ServerLevel)this.m_9236_(), this.m_20097_(), 0, 3, 4, MainUtil.gasDamageMultiplier() * 15.0f);
            }
            this.m_146870_();
            return true;
        }
        if (this.m_6673_($$0)) {
            return false;
        }
        this.m_5834_();
        return false;
    }

    protected void m_5790_(EntityHitResult $$0) {
        Entity $$1 = $$0.m_82443_();
        float $$2 = 2.0f;
        Entity $$4 = this.m_19749_();
        DamageSource $$5 = ModDamageTypes.of($$1.m_9236_(), (ResourceKey<DamageType>)DamageTypes.f_268534_, $$4);
        this.m_5496_(ModSounds.CAN_BOUNCE_END_EVENT, 0.8f, 1.6f);
        this.scatterGoo($$0.m_82443_().m_20097_());
        if ($$1.m_6469_($$5, $$2)) {
            if ($$1.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if ($$1 instanceof LivingEntity) {
                LivingEntity $$7 = (LivingEntity)$$1;
                $$1.m_20256_($$1.m_20184_().m_82542_(0.4, 0.4, 0.4));
            }
            this.m_146870_();
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ROUNDABOUT$SUPER_THROWN, (Object)false);
    }

    public void scatterGoo(BlockPos pos) {
        if (!this.m_9236_().f_46443_) {
            int splashRadius = 2;
            if (this.bounces == 2 || this.bounces == 1) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ModBlocks.GASOLINE_SPLATTER.m_49966_()), (double)this.m_20097_().m_123341_() + 0.5, (double)this.m_20097_().m_123342_() + 0.5, (double)this.m_20097_().m_123343_() + 0.5, 20, 0.8, 0.6, 0.8, 0.4);
                this.setGoo(pos, 0, 0, 0);
                this.setGoo(pos, 1, 0, 1);
                this.setGoo(pos, -1, 0, 1);
                this.setGoo(pos, 0, 1, 1);
                this.setGoo(pos, 0, -1, 1);
                this.setGoo(pos, 2, 0, 2);
                this.setGoo(pos, -2, 0, 2);
                this.setGoo(pos, 0, 2, 2);
                this.setGoo(pos, 0, -2, 2);
                this.setGoo(pos, 1, 1, 2);
                this.setGoo(pos, -1, 1, 2);
                this.setGoo(pos, 1, -1, 2);
                this.setGoo(pos, -1, -1, 2);
            } else if (this.bounces == 0) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ModBlocks.GASOLINE_SPLATTER.m_49966_()), (double)this.m_20097_().m_123341_() + 0.5, (double)this.m_20097_().m_123342_() + 0.5, (double)this.m_20097_().m_123343_() + 0.5, 10, 0.4, 0.3, 0.4, 0.4);
                this.setGoo(pos, 0, 0, 1);
                this.setGoo(pos, 1, 0, 2);
                this.setGoo(pos, -1, 0, 2);
                this.setGoo(pos, 0, 1, 2);
                this.setGoo(pos, 0, -1, 2);
                splashRadius = 1;
            }
            List<Entity> entities = MainUtil.hitbox(MainUtil.genHitbox(this.m_9236_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), splashRadius, splashRadius, splashRadius));
            if (!entities.isEmpty()) {
                for (Entity value : entities) {
                    if (!(value instanceof LivingEntity)) continue;
                    ((StandUser)value).roundabout$setGasolineTime(((StandUser)value).roundabout$getMaxGasolineTime());
                }
            }
        }
    }

    public void setGoo(BlockPos pos, int offsetX, int offsetZ, int level) {
        BlockPos blockPos = null;
        if (this.canPlaceGoo(pos, offsetX, 1, offsetZ)) {
            blockPos = new BlockPos(pos.m_123341_() + offsetX, pos.m_123342_() + 1, pos.m_123343_() + offsetZ);
        } else if (this.canPlaceGoo(pos, offsetX, 2, offsetZ)) {
            blockPos = new BlockPos(pos.m_123341_() + offsetX, pos.m_123342_() + 2, pos.m_123343_() + offsetZ);
        } else if (this.canPlaceGoo(pos, offsetX, 0, offsetZ)) {
            blockPos = new BlockPos(pos.m_123341_() + offsetX, pos.m_123342_(), pos.m_123343_() + offsetZ);
        } else if (this.canPlaceGoo(pos, offsetX, -1, offsetZ)) {
            blockPos = new BlockPos(pos.m_123341_() + offsetX, pos.m_123342_() - 1, pos.m_123343_() + offsetZ);
        }
        if (blockPos != null) {
            this.m_9236_().m_46597_(new BlockPos(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()), (BlockState)ModBlocks.GASOLINE_SPLATTER.m_49966_().m_61124_((Property)ModBlocks.GAS_CAN_LEVEL, (Comparable)Integer.valueOf(level)));
        }
    }

    public boolean canPlaceGoo(BlockPos pos, int offsetX, int offsetY, int offsetZ) {
        BlockPos blk = new BlockPos(pos.m_123341_() + offsetX, pos.m_123342_() + offsetY, pos.m_123343_() + offsetZ);
        if (this.m_9236_().m_46859_(blk)) {
            BlockPos $$8 = blk.m_7495_();
            if (this.m_9236_().m_8055_($$8).m_60783_((BlockGetter)this.m_9236_(), $$8, Direction.UP)) {
                return true;
            }
        }
        return false;
    }

    public void shootWithVariance(double $$0, double $$1, double $$2, float $$3, float $$4) {
        Vec3 $$5 = new Vec3($$0, $$1, $$2).m_82541_().m_82520_(this.f_19796_.m_216328_(0.0, 0.13 * (double)$$4), this.f_19796_.m_216328_(0.0, 0.13 * (double)$$4), this.f_19796_.m_216328_(0.0, 0.13 * (double)$$4)).m_82490_((double)$$3);
        this.m_20256_($$5);
        double $$6 = $$5.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)$$5.f_82479_, (double)$$5.f_82481_) * 180.0 / 3.1415927410125732));
        this.m_146926_((float)(Mth.m_14136_((double)$$5.f_82480_, (double)$$6) * 180.0 / 3.1415927410125732));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public void shootFromRotationWithVariance(Entity $$0, float $$1, float $$2, float $$3, float $$4, float $$5) {
        float $$6 = -Mth.m_14031_((float)($$2 * ((float)Math.PI / 180))) * Mth.m_14089_((float)($$1 * ((float)Math.PI / 180)));
        float $$7 = -Mth.m_14031_((float)(($$1 + $$3) * ((float)Math.PI / 180)));
        float $$8 = Mth.m_14089_((float)($$2 * ((float)Math.PI / 180))) * Mth.m_14089_((float)($$1 * ((float)Math.PI / 180)));
        this.shootWithVariance($$6, $$7, $$8, $$4, $$5);
        Vec3 $$9 = $$0.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_($$9.f_82479_, $$0.m_20096_() ? 0.0 : $$9.f_82480_, $$9.f_82481_));
    }

    protected float m_7139_() {
        if (this.getSuperThrow()) {
            return 0.0f;
        }
        return 0.04f;
    }
}

