/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.util.config;

import net.hydra.jojomod.util.config.ConfigManager;
import net.hydra.jojomod.util.config.annotation.BooleanOption;
import net.hydra.jojomod.util.config.annotation.CommentedOption;
import net.hydra.jojomod.util.config.annotation.FloatOption;
import net.hydra.jojomod.util.config.annotation.Groups;
import net.hydra.jojomod.util.config.annotation.IntOption;
import net.hydra.jojomod.util.config.annotation.NestedOption;

@Groups(value={"toggles", "vanilla", "added_vanilla", "modded"})
public class ClientConfig
implements Cloneable {
    private static ClientConfig LOCAL_INSTANCE = new ClientConfig();
    private static ClientConfig DEFAULT_INSTANCE = new ClientConfig();
    @NestedOption(group="modded")
    public GeneralSettings generalSettings;
    @BooleanOption(group="inherit", value=true)
    public Boolean pressingAbilityKeysSummonsStands;
    @IntOption(group="inherit", value=50, min=0, max=72000)
    public Integer maxMirrorRendersAtOnceSetToZeroToDisable;
    @BooleanOption(group="inherit", value=false)
    public Boolean mirrorFlipsRendering;
    @BooleanOption(group="inherit", value=false)
    public Boolean renderGasSplatterOverlay;
    @BooleanOption(group="inherit", value=true)
    public Boolean showCreativeTextOnWorthinessArrow;
    @IntOption(group="inherit", value=190)
    public Integer justiceFogBrightness;
    @BooleanOption(group="inherit", value=true)
    public Boolean renderJusticeHandsWhilePiloting;
    @BooleanOption(group="inherit", value=true)
    public Boolean renderArmorOnPlayerCloneAbilities;
    @BooleanOption(group="inherit", value=true)
    public Boolean magiciansRedTexturesMakeItEmmissive;
    @BooleanOption(group="inherit", value=false)
    public Boolean magiciansRedLashesMakeItEmmissive;
    @BooleanOption(group="inherit", value=true)
    public Boolean magiciansRedRenderOnFireInFirstPerson;
    @BooleanOption(group="inherit", value=true)
    public Boolean mandomRewindShowsVisualEffectsToNonMandomUsers;
    @BooleanOption(group="inherit", value=true)
    public Boolean mandomRewindAttemptsToSkipInterpolation;
    @FloatOption(group="inherit", value=0.44f, min=0.0f, max=1.0f)
    public Float invisibleBlockDepthF;
    @IntOption(group="inherit", value=50, min=0, max=72000)
    public Integer invisibleBlocksDistanceAwaySeenI;
    @NestedOption(group="modded")
    public ConfigSettings configSettings;
    @NestedOption(group="modded")
    public ParticleSettings particleSettings;
    @NestedOption(group="modded")
    public OpacitySettings opacitySettings;
    @NestedOption(group="modded")
    public DynamicSettings dynamicSettings;
    @NestedOption(group="modded")
    public VanillaMCTweaks vanillaMinecraftTweaks;
    @NestedOption(group="modded")
    public TimeStopSettings timeStopSettings;

    public static ClientConfig getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public ClientConfig clone() {
        return (ClientConfig)ConfigManager.GSON.fromJson(ConfigManager.GSON.toJson((Object)this), ClientConfig.class);
    }

    public static ClientConfig getLocalInstance() {
        return LOCAL_INSTANCE;
    }

    static void updateLocal(ClientConfig config) {
        LOCAL_INSTANCE = config;
    }

    public static class TimeStopSettings {
        @BooleanOption(group="inherit", value=false)
        public Boolean timeStopFreezesScreen;
        @BooleanOption(group="inherit", value=true)
        public Boolean tsStandsSeeTSTeleportAndDontFreeze;
        @BooleanOption(group="inherit", value=true)
        public Boolean simpleTimeStopShader;
    }

    public static class VanillaMCTweaks {
        @BooleanOption(group="inherit", value=true)
        public Boolean namedSBRHorseSkins;
        @BooleanOption(group="inherit", value=false)
        public Boolean onlyStandUsersCanSeeVanillaGhostMobs;
        @BooleanOption(group="inherit", value=true)
        public Boolean disableObviousExperimentalWarning;
    }

    public static class DynamicSettings {
        @IntOption(group="inherit", value=1, min=1, max=8)
        public Integer SoftAndWetCurrentlySelectedBubble;
    }

    public static class OpacitySettings {
        @FloatOption(group="inherit", value=100.0f, min=0.0f, max=100.0f)
        public Float opacityOfStand;
        @FloatOption(group="inherit", value=100.0f, min=0.0f, max=100.0f)
        public Float opacityWhileAttacking;
        @FloatOption(group="inherit", value=100.0f, min=0.0f, max=100.0f)
        public Float opacityOfOthers;
    }

    public static class ParticleSettings {
        @BooleanOption(group="inherit", value=true)
        public Boolean renderJusticeParticlesInFirstPerson;
        @BooleanOption(group="inherit", value=false)
        public Boolean renderJusticeParticlesWhilePilotingInFirstPerson;
        @IntOption(group="inherit", value=5, min=0, max=72000)
        public Integer justiceFogParticlesPerTick;
        @IntOption(group="inherit", value=3, min=0, max=72000)
        public Integer justiceSkinFlameParticlesPerTick;
        @IntOption(group="inherit", value=3, min=0, max=72000)
        public Integer cfhTicksPerFlameParticle;
        @IntOption(group="inherit", value=1, min=0, max=72000)
        public Integer bodyBagHoldingParticlesPerFiveTicks;
        @FloatOption(group="inherit", value=0.01f, min=0.0f, max=1.0f)
        public Float magiciansRedFirestormEmbersRate;
        @BooleanOption(group="inherit", value=true)
        public Boolean meteorsEmitParticles;
    }

    public static class ConfigSettings {
        @CommentedOption(comment="Offset of the Config Button (stand arrow button) in X coordinates")
        @IntOption(group="inherit", value=0, min=-1024, max=1024)
        public Integer configButtonOffsetX;
        @CommentedOption(comment="Offset of the Config Button (stand arrow button) in Y coordinates")
        @IntOption(group="inherit", value=0, min=-1024, max=1024)
        public Integer configButtonOffsetY;
        @CommentedOption(comment="Should Roundabout render the Config Button (stand arrow button) on the main menu?")
        @BooleanOption(group="inherit", value=true)
        public Boolean shouldShowConfigButton;
    }

    public static class GeneralSettings {
        @BooleanOption(group="inherit", value=true)
        public Boolean onlyStandUsersCanSeeStands;
    }
}

