/*
 * Decompiled with CFR 0.152.
 */
package net.zetalasis.hjson;

import java.io.IOException;
import java.io.Writer;
import java.util.regex.Pattern;
import net.zetalasis.hjson.HjsonDsf;
import net.zetalasis.hjson.HjsonOptions;
import net.zetalasis.hjson.HjsonParser;
import net.zetalasis.hjson.IHjsonDsfProvider;
import net.zetalasis.hjson.JsonArray;
import net.zetalasis.hjson.JsonObject;
import net.zetalasis.hjson.JsonValue;
import net.zetalasis.hjson.JsonWriter;

class HjsonWriter {
    private IHjsonDsfProvider[] dsfProviders;
    static String commonRange = "\\x7f-\\x9f\\x{00ad}\\x{0600}-\\x{0604}\\x{070f}\\x{17b4}\\x{17b5}\\x{200c}-\\x{200f}\\x{2028}-\\x{202f}\\x{2060}-\\x{206f}\\x{feff}\\x{fff0}-\\x{ffff}";
    static Pattern needsEscape = Pattern.compile("[\\\\\\\"\\x00-\\x1f" + commonRange + "]");
    static Pattern needsQuotes = Pattern.compile("^\\s|^\"|^'|^#|^/\\*|^//|^\\{|^\\}|^\\[|^\\]|^:|^,|\\s$|[\\x00-\\x1f\\x7f-\\x9f\\x{00ad}\\x{0600}-\\x{0604}\\x{070f}\\x{17b4}\\x{17b5}\\x{200c}-\\x{200f}\\x{2028}-\\x{202f}\\x{2060}-\\x{206f}\\x{feff}\\x{fff0}-\\x{ffff}]");
    static Pattern needsEscapeML = Pattern.compile("'''|^[\\s]+$|[\\x00-\\x08\\x0b-\\x1f" + commonRange + "]");
    static Pattern needsEscapeName = Pattern.compile("[,\\{\\[\\}\\]\\s:#\"']|//|/\\*");

    public HjsonWriter(HjsonOptions options) {
        this.dsfProviders = options != null ? options.getDsfProviders() : new IHjsonDsfProvider[0];
    }

    void nl(Writer tw, int level) throws IOException {
        tw.write(JsonValue.eol);
        for (int i = 0; i < level; ++i) {
            tw.write("  ");
        }
    }

    public void save(JsonValue value, Writer tw, int level, String separator, boolean noIndent) throws IOException {
        if (value == null) {
            tw.write(separator);
            tw.write("null");
            return;
        }
        String dsfValue = HjsonDsf.stringify(this.dsfProviders, value);
        if (dsfValue != null) {
            tw.write(separator);
            tw.write(dsfValue);
            return;
        }
        switch (value.getType()) {
            case OBJECT: {
                JsonObject obj = value.asObject();
                if (!noIndent) {
                    if (obj.size() > 0) {
                        this.nl(tw, level);
                    } else {
                        tw.write(separator);
                    }
                }
                tw.write(123);
                for (JsonObject.Member pair : obj) {
                    this.nl(tw, level + 1);
                    tw.write(HjsonWriter.escapeName(pair.getName()));
                    tw.write(":");
                    this.save(pair.getValue(), tw, level + 1, " ", false);
                }
                if (obj.size() > 0) {
                    this.nl(tw, level);
                }
                tw.write(125);
                break;
            }
            case ARRAY: {
                JsonArray arr = value.asArray();
                int n = arr.size();
                if (!noIndent) {
                    if (n > 0) {
                        this.nl(tw, level);
                    } else {
                        tw.write(separator);
                    }
                }
                tw.write(91);
                for (int i = 0; i < n; ++i) {
                    this.nl(tw, level + 1);
                    this.save(arr.get(i), tw, level + 1, "", true);
                }
                if (n > 0) {
                    this.nl(tw, level);
                }
                tw.write(93);
                break;
            }
            case BOOLEAN: {
                tw.write(separator);
                tw.write(value.isTrue() ? "true" : "false");
                break;
            }
            case STRING: {
                this.writeString(value.asString(), tw, level, separator);
                break;
            }
            default: {
                tw.write(separator);
                tw.write(value.toString());
            }
        }
    }

    static String escapeName(String name) {
        if (name.length() == 0 || needsEscapeName.matcher(name).find() || needsEscape.matcher(name).find()) {
            return "\"" + JsonWriter.escapeString(name) + "\"";
        }
        return name;
    }

    void writeString(String value, Writer tw, int level, String separator) throws IOException {
        if (value.length() == 0) {
            tw.write(separator + "\"\"");
            return;
        }
        char left = value.charAt(0);
        char right = value.charAt(value.length() - 1);
        char left1 = value.length() > 1 ? value.charAt(1) : (char)'\u0000';
        char left2 = value.length() > 2 ? value.charAt(2) : (char)'\u0000';
        boolean doEscape = needsQuotes.matcher(value).find();
        if (doEscape || HjsonParser.isWhiteSpace(left) || HjsonParser.isWhiteSpace(right) || left == '\"' || left == '\'' || left == '#' || left == '/' && (left1 == '*' || left1 == '/') || JsonValue.isPunctuatorChar(left) || HjsonParser.tryParseNumber(value, true) != null || HjsonWriter.startsWithKeyword(value)) {
            if (!needsEscape.matcher(value).find()) {
                tw.write(separator + "\"" + value + "\"");
            } else if (!needsEscapeML.matcher(value).find()) {
                this.writeMLString(value, tw, level, separator);
            } else {
                tw.write(separator + "\"" + JsonWriter.escapeString(value) + "\"");
            }
        } else {
            tw.write(separator + value);
        }
    }

    void writeMLString(String value, Writer tw, int level, String separator) throws IOException {
        String[] lines = value.replace("\r", "").split("\n", -1);
        if (lines.length == 1) {
            tw.write(separator + "'''");
            tw.write(lines[0]);
            tw.write("'''");
        } else {
            this.nl(tw, ++level);
            tw.write("'''");
            for (String line : lines) {
                this.nl(tw, line.length() > 0 ? level : 0);
                tw.write(line);
            }
            this.nl(tw, level);
            tw.write("'''");
        }
    }

    static boolean startsWithKeyword(String text) {
        int p;
        if (text.startsWith("true") || text.startsWith("null")) {
            p = 4;
        } else if (text.startsWith("false")) {
            p = 5;
        } else {
            return false;
        }
        while (p < text.length() && HjsonParser.isWhiteSpace(text.charAt(p))) {
            ++p;
        }
        if (p == text.length()) {
            return true;
        }
        char ch = text.charAt(p);
        return ch == ',' || ch == '}' || ch == ']' || ch == '#' || ch == '/' && text.length() > p + 1 && (text.charAt(p + 1) == '/' || text.charAt(p + 1) == '*');
    }
}

