/*
 * Decompiled with CFR 0.152.
 */
package dev.petalcat.petaldisconnect;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;

public class PetalConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File FILE = new File("config/petaldisconnect.json");
    public boolean enableQuickDisconnect = true;
    public boolean enableFocusCheck = false;
    public boolean enableAutoReconnect = true;

    public static PetalConfig load() {
        PetalConfig petalConfig;
        if (!FILE.exists()) {
            PetalConfig cfg = new PetalConfig();
            cfg.save();
            return cfg;
        }
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(FILE), "UTF-8");
        try {
            petalConfig = (PetalConfig)GSON.fromJson((Reader)reader, PetalConfig.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return new PetalConfig();
            }
        }
        reader.close();
        return petalConfig;
    }

    public void save() {
        try {
            File parent = FILE.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(FILE), "UTF-8");){
                GSON.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

