/*
 * Decompiled with CFR 0.152.
 */
package dev.petalcat.petaldisconnect;

import dev.petalcat.petaldisconnect.DisconnectReason;
import dev.petalcat.petaldisconnect.PetalConfig;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_412;
import net.minecraft.class_638;
import net.minecraft.class_639;
import net.minecraft.class_642;

public class PetalFocusWatcher {
    private static boolean disconnectOnFocusLoss = false;
    private static boolean autoReconnect = false;
    private static boolean lastFocused = true;
    private static class_642 lastServer = null;
    private static DisconnectReason lastReason = DisconnectReason.NONE;
    private static boolean disconnectRequestedByFocus = false;

    private static void log(String msg) {
        System.out.println("[PetalDisconnect] " + msg);
    }

    public static void init(PetalConfig config) {
        disconnectOnFocusLoss = config.enableFocusCheck;
        autoReconnect = config.enableAutoReconnect;
        PetalFocusWatcher.log("FocusWatcher initialized. focus=" + disconnectOnFocusLoss + " autoreconnect=" + autoReconnect);
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            if (disconnectRequestedByFocus) {
                lastReason = DisconnectReason.FOCUS_LOSS;
                PetalFocusWatcher.log("DISCONNECT event fired. Classified as FOCUS_LOSS.");
            } else {
                lastReason = DisconnectReason.SERVER;
                PetalFocusWatcher.log("DISCONNECT event fired. Classified as SERVER.");
            }
            disconnectRequestedByFocus = false;
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client == null) {
                return;
            }
            boolean focused = client.method_1569();
            class_638 world = client.field_1687;
            if (world != null && client.method_1558() != null) {
                lastServer = client.method_1558();
            }
            if (lastFocused && !focused) {
                PetalFocusWatcher.log("Focus LOST");
                if (world != null) {
                    if (disconnectOnFocusLoss) {
                        PetalFocusWatcher.log("Disconnecting due to focus loss");
                        disconnectRequestedByFocus = true;
                        client.method_73360((class_2561)class_2561.method_43470((String)"Disconnected due to focus loss"));
                    } else {
                        PetalFocusWatcher.log("Focus loss ignored due to config");
                    }
                }
            }
            if (!lastFocused && focused) {
                PetalFocusWatcher.log("Focus GAINED. lastReason=" + String.valueOf((Object)lastReason));
                if (autoReconnect && lastReason == DisconnectReason.FOCUS_LOSS) {
                    if (client.field_1687 == null) {
                        PetalFocusWatcher.log("Reconnecting because lastReason=FOCUS_LOSS");
                        PetalFocusWatcher.reconnectToLastServer(client);
                    } else {
                        PetalFocusWatcher.log("World is still loaded on focus regain; not reconnecting yet.");
                    }
                } else {
                    PetalFocusWatcher.log("NOT reconnecting. autoReconnect=" + autoReconnect + " lastReason=" + String.valueOf((Object)lastReason));
                }
                lastReason = DisconnectReason.NONE;
            }
            lastFocused = focused;
        });
    }

    private static void reconnectToLastServer(class_310 client) {
        if (lastServer == null) {
            PetalFocusWatcher.log("Cannot reconnect: lastServer = null");
            return;
        }
        PetalFocusWatcher.log("Reconnecting to " + PetalFocusWatcher.lastServer.field_3761);
        class_639 address = class_639.method_2950((String)PetalFocusWatcher.lastServer.field_3761);
        client.execute(() -> {
            client.method_1507(null);
            class_412.method_36877(null, (class_310)client, (class_639)address, (class_642)lastServer, (boolean)false, null);
        });
    }

    public static void updateConfig(PetalConfig config) {
        disconnectOnFocusLoss = config.enableFocusCheck;
        autoReconnect = config.enableAutoReconnect;
        PetalFocusWatcher.log("Config updated. focus=" + disconnectOnFocusLoss + " autoreconnect=" + autoReconnect);
    }
}

