package arm32x.minecraft.commandblockide;

import arm32x.minecraft.commandblockide.mixinextensions.server.CommandFunctionExtension;
import arm32x.minecraft.commandblockide.payloads.ApplyFunctionPayload;
import arm32x.minecraft.commandblockide.server.command.EditFunctionCommand;
import arm32x.minecraft.commandblockide.server.function.FunctionIO;
import arm32x.minecraft.commandblockide.util.PacketMerger;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2158;
import net.minecraft.class_2168;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CommandBlockIDE implements ModInitializer {
	@Override
	public void onInitialize() {
		CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) ->
				EditFunctionCommand.register(dispatcher));

		final PacketMerger functionMerger = new PacketMerger();
		PayloadTypeRegistry.playC2S().register(Packets.APPLY_FUNCTION, ApplyFunctionPayload.CODEC);
		ServerPlayNetworking.registerGlobalReceiver(Packets.APPLY_FUNCTION, (payload, context) -> {
			if (!context.player().method_64475(2)) {
				return;
			}
			Optional<class_2540> maybeMerged = Optional.empty();
			try {
				maybeMerged = functionMerger.append(payload.toBuf());
			} catch (PacketMerger.InvalidSplitPacketException e) {
				LOGGER.error("PacketMerger", e);
			}
			if (maybeMerged.isPresent()) {
				class_2540 merged = maybeMerged.get();
				class_2960 functionId = merged.method_10810();
				int lineCount = merged.method_10816();
				String[] lines = new String[lineCount];
				for (int index = 0; index < lineCount; index++) {
					lines[index] = merged.method_10800(Integer.MAX_VALUE >> 2);
				}

				class_3222 player = context.player();
				MinecraftServer server = context.server();
				server.execute(() -> {
					class_2561 feedbackMessage = FunctionIO.saveFunction(server, functionId, Arrays.asList(lines));
					player.method_64398(feedbackMessage);
				});
			}
		});
	}

	private static void updateFunctionLines(MinecraftServer server, class_2960 functionId, List<String> lines) {
		Optional<class_2158<class_2168>> maybeFunction = server.method_3740().method_12905(functionId);
		maybeFunction.ifPresent(function -> ((CommandFunctionExtension)function).ide$setOriginalLines(lines));
	}

	private static final Logger LOGGER = LogManager.getLogger();
}
