package arm32x.minecraft.commandblockide.client;

import arm32x.minecraft.commandblockide.Packets;
import arm32x.minecraft.commandblockide.client.gui.screen.CommandFunctionIDEScreen;
import arm32x.minecraft.commandblockide.payloads.EditFunctionPayload;
import arm32x.minecraft.commandblockide.payloads.UpdateFunctionCommandPayload;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_421;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Environment(EnvType.CLIENT)
public final class CommandBlockIDEClient implements ClientModInitializer {
	@Override
	public void onInitializeClient() {
		PayloadTypeRegistry.playS2C().register(Packets.EDIT_FUNCTION, EditFunctionPayload.CODEC);
		ClientPlayNetworking.registerGlobalReceiver(Packets.EDIT_FUNCTION, (payload, context) -> {
			class_310 client = context.client();
			client.execute(() -> client.method_1507(new CommandFunctionIDEScreen(payload.id(), payload.lineCount())));
		});
		PayloadTypeRegistry.playS2C().register(Packets.UPDATE_FUNCTION_COMMAND, UpdateFunctionCommandPayload.CODEC);
		ClientPlayNetworking.registerGlobalReceiver(Packets.UPDATE_FUNCTION_COMMAND, (payload, context) -> {
			class_310 client = context.client();
			client.execute(() -> {
				if (client.field_1755 instanceof CommandFunctionIDEScreen ide) {
					ide.update(payload.index(), payload.line());
				}
			});
		});
	}

	public static void showErrorScreen(Exception ex, @Nullable String currentAction) {
		if (currentAction != null) {
			LOGGER.error("Error screen shown while " + currentAction + ":", ex);
		} else {
			LOGGER.error("Error screen shown:", ex);
		}
		class_310.method_1551().method_1507(new class_421(
			class_2561.method_43469(currentAction != null ? "commandBlockIDE.errorWithContext" : "commandBlockIDE.error", currentAction),
			class_2561.method_43470(ex.toString())
		));
	}

	private static final Logger LOGGER = LogManager.getLogger();
}
