package arm32x.minecraft.commandblockide.client;

import java.util.*;
import java.util.stream.Stream;
import net.minecraft.class_2246;
import net.minecraft.class_2288;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_638;

public final class CommandChainTracer {
	private final class_638 world;

	public CommandChainTracer(class_638 world) {
		this.world = world;
	}

	/**
	 * Traces a command block chain forwards until the end.
	 * @return An {@link Iterable} returning the positions of the blocks in the chain.
	 * @see CommandChainTracer#traceBackwards
	 */
	public Iterable<class_2338> traceForwards(class_2338 startPosition) {
		return () -> new Forwards(startPosition);
	}

	/**
	 * Traces a command block chain backwards until the start. Stops early if
	 * multiple command blocks point to the same block.
	 * @return An {@link Iterable} returning the positions of the blocks in the chain.
	 * @see CommandChainTracer#traceForwards
	 */
	public Iterable<class_2338> traceBackwards(class_2338 startPosition) {
		return () -> new Backwards(startPosition);
	}

	private final class Forwards implements Iterator<class_2338> {
		private class_2338 position;
		private final Set<class_2338> visited = new HashSet<>();

		private Forwards(class_2338 startPosition) {
			position = startPosition;
			visited.add(startPosition);
		}

		@Override
		public boolean hasNext() {
			class_2680 blockState = world.method_8320(position);
			if (isCommandBlock(blockState)) {
				class_2350 facing = blockState.method_11654(class_2288.field_10791);
				class_2338 nextPosition = position.method_10093(facing);
				class_2680 nextBlockState = world.method_8320(nextPosition);
				return Stream.of(
					class_2246.field_10525,
					class_2246.field_10263,
					class_2246.field_10395
				).anyMatch(nextBlockState::method_27852) && !visited.contains(nextPosition);
			}
			return false;
		}

		@Override
		public class_2338 next() {
			class_2680 blockState = world.method_8320(position);
			if (isCommandBlock(blockState)) {
				class_2350 facing = blockState.method_11654(class_2288.field_10791);
				class_2338 nextPosition = position.method_10093(facing);
				class_2680 nextBlockState = world.method_8320(nextPosition);
				if (Stream.of(
						class_2246.field_10525,
						class_2246.field_10263,
						class_2246.field_10395
					).anyMatch(nextBlockState::method_27852) && !visited.contains(nextPosition)) {
					position = nextPosition;
					visited.add(position);
					return position;
				}
			}
			throw new NoSuchElementException();
		}
	}

	private final class Backwards implements Iterator<class_2338> {
		private class_2338 position;
		private final Set<class_2338> visited = new HashSet<>();

		private Backwards(class_2338 startPosition) {
			position = startPosition;
			visited.add(startPosition);
		}

		@Override
		public boolean hasNext() {
			class_2680 blockState = world.method_8320(position);
			if (Stream.of(
					class_2246.field_10525,
					class_2246.field_10263,
					class_2246.field_10395
				).anyMatch(blockState::method_27852)) {
				long resultCount = getStream(blockState).count();
				return resultCount == 1;
			}
			return false;
		}

		@Override
		public class_2338 next() {
			class_2680 blockState = world.method_8320(position);
			if (Stream.of(
					class_2246.field_10525,
					class_2246.field_10263,
					class_2246.field_10395
				).anyMatch(blockState::method_27852)) {
				List<class_2338> results = getStream(blockState).toList();
				if (results.size() != 1) {
					throw new NoSuchElementException();
				}
				position = results.getFirst();
				visited.add(position);
				return position;
			}
			throw new NoSuchElementException();
		}

		private Stream<class_2338> getStream(class_2680 blockState) {
			return Stream.of(class_2350.values())
				.filter((direction) -> direction != blockState.method_11654(class_2288.field_10791))
				.map((direction) -> position.method_10093(direction))
				.filter((pos) -> isCommandBlock(world.method_8320(pos)) && !visited.contains(pos))
				.filter((pos) -> pos.method_10093(world.method_8320(pos).method_11654(class_2288.field_10791)).equals(position));
		}
	}

	// TODO: Move to a proper utility class.
	public static boolean isCommandBlock(class_2680 blockState) {
		return blockState.method_27852(class_2246.field_10525) || blockState.method_27852(class_2246.field_10263) || blockState.method_27852(class_2246.field_10395);
	}
}
