package arm32x.minecraft.commandblockide.client.gui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_332;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6379;
import net.minecraft.client.gui.*;

public abstract class Container extends class_362 implements class_4068, class_6379 {
	protected final List<class_364> children = new ArrayList<>();
	protected final List<class_6379> selectables = new ArrayList<>();
	protected final List<class_4068> drawables = new ArrayList<>();

	protected <T extends class_364 & class_6379 & class_4068> T addDrawableChild(T child) {
		drawables.add(child);
		return addSelectableChild(child);
	}

	protected <T extends class_4068> T addDrawable(T drawable) {
		drawables.add(drawable);
		return drawable;
	}

	protected <T extends class_364 & class_6379> T addSelectableChild(T child) {
		children.add(child);
		selectables.add(child);
		return child;
	}

	protected void remove(class_364 child) {
		if (child instanceof class_4068) {
			drawables.remove(child);
		}
		if (child instanceof class_6379) {
			selectables.remove(child);
		}
		children.remove(child);
	}

	protected void clearChildren() {
		drawables.clear();
		children.clear();
		selectables.clear();
	}

	@Override
	public class_6380 method_37018() {
		return selectables.stream()
			.map(class_6379::method_37018)
			.max(Comparator.naturalOrder())
			.orElse(class_6380.field_33784);
	}

	@Override
	public List<? extends class_364> method_25396() { return children; }

	@Override
	public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
		for (class_4068 drawable : drawables) {
			drawable.method_25394(context, mouseX, mouseY, delta);
		}
	}
}
