package arm32x.minecraft.commandblockide.client.gui;

import arm32x.minecraft.commandblockide.mixin.client.EditBoxAccessor;
import arm32x.minecraft.commandblockide.mixin.client.TextFieldWidgetAccessor;
import arm32x.minecraft.commandblockide.util.OrderedTexts;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_11876;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_4717;
import net.minecraft.class_5481;
import net.minecraft.class_7530;
import net.minecraft.class_7533;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

@Environment(EnvType.CLIENT)
public class MultilineTextFieldWidget extends class_342 {
	/**
	 * Allows easy and convenient access to private fields in the superclass.
	 */
	private final TextFieldWidgetAccessor self = (TextFieldWidgetAccessor)this;

    // TODO: Allow the user to configure this or to indent with tabs.
    // Note that both the text field renderer and the command processor do not
    // support tabs yet.
	private static final int INDENT_SIZE = 4;

	// The amount of time the cursor will spend being either visible or
	// invisible before switching to the other state.
    private static final long CURSOR_BLINK_INTERVAL_MS = 300;

	private final class_7530 editBox;

	private boolean horizontalScrollEnabled;
	private int horizontalScroll = 0;
	private boolean verticalScrollEnabled;
	private int verticalScroll = 0;
	public static final double SCROLL_SENSITIVITY = 15.0;

	private int lineHeight = 12;
	private SyntaxHighlighter syntaxHighlighter = SyntaxHighlighter.NONE;

	private @Nullable Runnable cursorChangeListener = null;

	public MultilineTextFieldWidget(class_327 textRenderer, int x, int y, int width, int height, class_2561 text, boolean horizontalScrollEnabled, boolean verticalScrollEnabled) {
		super(textRenderer, x, y, width, height, text);
		this.horizontalScrollEnabled = horizontalScrollEnabled;
		this.verticalScrollEnabled = verticalScrollEnabled;

		// TODO: Support soft wrap.
		editBox = new class_7530(textRenderer, Integer.MAX_VALUE);
	}

	public MultilineTextFieldWidget(class_327 textRenderer, int x, int y, int width, int height, class_2561 text) {
		this(textRenderer, x, y, width, height, text, true, true);
		editBox.method_44413(() -> {
			scrollToEnsureCursorVisible();
			if (cursorChangeListener != null) {
				cursorChangeListener.run();
			}
		});
	}

	@Override
	public void method_1863(@Nullable Consumer<String> changedListener) {
		editBox.method_44415(Objects.requireNonNullElseGet(changedListener, () -> text -> {}));
	}

	public void setCursorChangeListener(@Nullable Runnable cursorChangeListener) {
		this.cursorChangeListener = cursorChangeListener;
	}

    @Override
    public void method_1852(String text) {
        editBox.method_72235(text);
    }

	@Override
	public String method_1882() {
        return editBox.method_44421();
    }

	@Override
	public String method_1866() {
        return editBox.method_44436();
    }

    @Override
    public void method_1890(Predicate<String> textPredicate) {
        throw new UnsupportedOperationException();
    }

	@Override
    @Deprecated
	public void method_73210(class_342.class_11734 formatter) {
		// Do nothing, since we use our own syntax highlighting system. I would
        // love to throw an UnsupportedOperationException, but this is called by
        // ChatInputSuggestor.
	}

    public SyntaxHighlighter getSyntaxHighlighter() {
        return syntaxHighlighter;
    }

    public void setSyntaxHighlighter(SyntaxHighlighter syntaxHighlighter) {
        this.syntaxHighlighter = syntaxHighlighter;
    }

	@Override
	public void method_1867(String text) {
        editBox.method_44420(text);
	}

    @Override
    public void method_1877(int wordOffset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void method_1878(int characterOffset) {
        editBox.method_44419(characterOffset);
    }

    @Override
    public int method_1853(int wordOffset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void method_1855(int offset, boolean hasShiftDown) {
		editBox.method_44417(hasShiftDown);
        editBox.method_44412(class_7533.field_39536, offset);
    }

    private void moveCursor(double mouseX, double mouseY, boolean hasShiftDown) {
        double virtualX = mouseX - getInnerX() + getHorizontalScroll();
        double virtualY = mouseY - getInnerY() + getVerticalScroll();

		int lineIndex = class_3532.method_15357(virtualY / getLineHeight());

		// Get a rough estimate of where the cursor should be.
		class_7530.class_7531 lineSubstring = editBox.method_44422(lineIndex);
		String line = method_1882().substring(lineSubstring.comp_862(), lineSubstring.comp_863());
		int charIndexInLine = self.getTextRenderer().method_27523(line, class_3532.method_15357(virtualX)).length();
		int charIndex = lineSubstring.comp_862() + charIndexInLine;

		// Refine the estimate by determining the nearest character boundary.
		double leftCharacterXDistance = Math.abs(getCharacterVirtualX(charIndex) - virtualX);
		double rightCharacterXDistance = Math.abs(getCharacterVirtualX(charIndex + 1) - virtualX);
		if (rightCharacterXDistance < leftCharacterXDistance) {
			charIndex++;
		}

		method_1883(charIndex, hasShiftDown);
    }

    @Override
    public void method_1883(int cursor, boolean hasShiftDown) {
		editBox.method_44417(hasShiftDown);
        editBox.method_44412(class_7533.field_39535, cursor);
    }

    @Override
    public void method_1875(int cursor) {
		method_1883(cursor, true);
    }

	@Override
	public void method_1884(int index) {
		((EditBoxAccessor)editBox).setSelectionEnd(index);
	}

	@Override
	public boolean method_25404(class_11908 input) {
		if (input.comp_4795() == GLFW.GLFW_KEY_TAB) {
            if (editBox.method_44435()) {
                logger.warn("Indenting selected lines is not yet supported");
            } else {
                int cursorLeft = method_1881() - getLineStartBefore(method_1881());
                String indent = " ".repeat(4 - cursorLeft % INDENT_SIZE);
                editBox.method_44420(indent);
            }
            return true;
        } else {
			return editBox.method_44428(input);
		}
    }

    @Override
    public boolean method_25402(class_11909 click, boolean doubled) {
        if (!this.method_1885()) {
            return false;
        }
        if (self.isFocusUnlocked()) {
            method_25365(method_25405(click.comp_4798(), click.comp_4799()));
        }
        if (method_25370() && method_25405(click.comp_4798(), click.comp_4799()) && click.method_74245() == 0) {
            moveCursor(click.comp_4798(), click.comp_4799(), click.method_74239());
            return true;
        }
        return false;
    }

    @Override
    public boolean method_25403(class_11909 click, double offsetX, double offsetY) {
        if (!this.method_1885()) {
            return false;
        }
        if (self.isFocusUnlocked()) {
            method_25365(method_25405(click.comp_4798(), click.comp_4799()));
        }
        if (method_25370() && method_25405(click.comp_4798(), click.comp_4799()) && click.method_74245() == 0) {
            moveCursor(click.comp_4798(), click.comp_4799(), true);
            editBox.method_44417(click.method_74239());
            return true;
        }
        return false;
    }

	@Override
	public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
		if (this.method_25405(mouseX, mouseY)) {
			boolean changed = setHorizontalScroll(getHorizontalScroll() - (int)Math.round(horizontalAmount * SCROLL_SENSITIVITY));
			changed = changed || setVerticalScroll(getVerticalScroll() - (int)Math.round(verticalAmount * SCROLL_SENSITIVITY));

			// This updates the position of the suggestions window.
			if (cursorChangeListener != null) {
				cursorChangeListener.run();
			}
			return changed;
		} else {
			return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
		}
	}

	@Override
	public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
		if (!method_1885()) {
			return;
		}

		if (method_1851()) {
			var textureId = TextFieldWidgetAccessor.getTextures().method_52729(method_37303(), method_25370());
			context.method_52706(class_10799.field_56883, textureId, method_46426(), method_46427(), method_25368(), method_25364());
		}

		context.method_44379(
			this.method_46426() + 1,
			this.method_46427() + 1,
			this.method_46426() + this.method_25368() - 1,
			this.method_46427() + this.method_25364() - 1
		);

		int textColor = self.invokeIsEditable() ? self.getEditableColor() : self.getUneditableColor();
		int x = getInnerX() - horizontalScroll;
		int y = getInnerY() - verticalScroll;

		long timeSinceLastSwitchFocusMs = class_156.method_658() - self.getLastSwitchFocusTime();
        boolean showCursor = method_25370() && timeSinceLastSwitchFocusMs / CURSOR_BLINK_INTERVAL_MS % 2 == 0;
		boolean lineCursor = method_1881() < method_1882().length() || method_1882().length() >= self.invokeGetMaxLength();

		int cursorLine = getCurrentLineIndex();
		int cursorY = y + lineHeight * cursorLine;

		List<class_5481> lines = getSyntaxHighlighter().highlight(method_1882());
		for (int index = 0; index < lines.size(); index++) {
			class_5481 line = lines.get(index);
            context.method_35720(self.getTextRenderer(), line, x, y + lineHeight * index, textColor);
		}

		if (showCursor) {
            // Figure out the cursor X position by measuring the text before it.
            // This assumes that the highlighter returns the same characters as
            // the original text, which is not enforced by the API.
            int indexOfLastNewlineBeforeCursor = getLineStartBefore(method_1881()) - 1;
            int codePointsBeforeCursor;
            if (indexOfLastNewlineBeforeCursor != -1) {
                codePointsBeforeCursor = method_1882().codePointCount(indexOfLastNewlineBeforeCursor, Math.max(method_1881() - 1, 0));
            } else {
                codePointsBeforeCursor = method_1882().codePointCount(0, method_1881());
            }
            class_5481 textBeforeCursor = OrderedTexts.limit(codePointsBeforeCursor, lines.get(cursorLine));
            int cursorX = x + self.getTextRenderer().method_30880(textBeforeCursor) - 1;

			if (lineCursor) {
				context.method_25294(cursorX, cursorY - 1, cursorX + 1, cursorY + 10, 0xFFD0D0D0);
			} else {
				context.method_25303(self.getTextRenderer(), "_", cursorX + 1, cursorY, textColor);
			}
		}

		if (method_25370() && editBox.method_44435()) {
			renderSelection(context, x, y);
		}

		context.method_44380();

        if (method_49606()) {
            context.method_74037(class_11876.field_62453);
        }
	}

	private void renderSelection(class_332 context, int x, int y) {
        var selection = editBox.method_44427();
        int normalizedSelectionStart = selection.comp_862();
        int normalizedSelectionEnd = selection.comp_863();

        int startX = x + self.getTextRenderer().method_1727(method_1882().substring(getLineStartBefore(normalizedSelectionStart), normalizedSelectionStart)) - 1;
        int startY = y + lineHeight * getLineIndex(normalizedSelectionStart) - 1;
        int endX = x + self.getTextRenderer().method_1727(method_1882().substring(getLineStartBefore(normalizedSelectionEnd), normalizedSelectionEnd)) - 1;
        int endY = y + lineHeight * getLineIndex(normalizedSelectionEnd) - 1;

        int leftEdge = getInnerX() - 1;
        int rightEdge = getInnerX() + this.method_1859() + 1;

        if (startY == endY) {
            // Selection spans one line
            context.method_72238(startX, startY, endX, endY + lineHeight - 1);
        } else {
            // Selection spans two or more lines
            context.method_72238(startX, startY, rightEdge, startY + lineHeight);
            if (!(startY - lineHeight == endY || endY - lineHeight == startY)) {
                // Selection spans three or more lines
                context.method_72238(leftEdge, startY + lineHeight, rightEdge, endY);
            }
            context.method_72238(leftEdge, endY, endX, endY + lineHeight - 1);
        }
	}

    @Override
    public void method_1880(int maxLength) {
        editBox.method_44411(maxLength);
    }

    @Override
    public int method_1881() {
        return editBox.method_44424();
    }

	public int getLineCount() {
        return editBox.method_44430();
	}

	public int getCurrentLineIndex() {
		return getLineIndex(method_1881());
	}

	private int getLineIndex(int charIndex) {
		return (int)method_1882()
			.substring(0, charIndex)
			.codePoints()
			.filter(point -> point == '\n')
			.count();
	}

	private int getLineStartBefore(int charIndex) {
		return method_1882().lastIndexOf('\n', Math.max(charIndex, 0) - 1) + 1;
	}

    // Naming things is hard.
    public boolean isBeforeFirstNonWhitespaceCharacterInLine(int charIndex) {
        return method_1882()
            .substring(getLineStartBefore(charIndex), charIndex)
            .chars()
            .allMatch(Character::isWhitespace);
    }

	public String getLine(int lineIndex) {
		var line = editBox.method_44422(lineIndex);
		return method_1882().substring(line.comp_862(), line.comp_863());
	}

	protected int getHorizontalScroll() {
		return horizontalScroll;
	}

	protected int getMaxHorizontalScroll() {
		return Math.max(0, Arrays.stream(method_1882().split("\n"))
			.mapToInt(self.getTextRenderer()::method_1727)
			.max()
			.orElse(0) + 8 - field_22758);
	}

	protected boolean setHorizontalScroll(int horizontalScroll) {
		int previous = this.horizontalScroll;
		this.horizontalScroll = class_3532.method_15340(horizontalScroll, 0, getMaxHorizontalScroll());
		return this.horizontalScroll != previous;
	}

	protected int getVerticalScroll() {
		return verticalScroll;
	}

	protected int getMaxVerticalScroll() {
		return Math.max(0, getLineCount() * getLineHeight() + 2 - field_22759);
	}

	protected boolean setVerticalScroll(int verticalScroll) {
		int previous = this.verticalScroll;
		this.verticalScroll = class_3532.method_15340(verticalScroll, 0, getMaxVerticalScroll());
		return this.verticalScroll != previous;
	}

	public boolean isHorizontalScrollEnabled() {
		return horizontalScrollEnabled;
	}

	public void setHorizontalScrollEnabled(boolean enabled) {
		horizontalScrollEnabled = enabled;
		horizontalScroll = 0;
	}

	public boolean isVerticalScrollEnabled() {
		return verticalScrollEnabled;
	}

	public void setVerticalScrollEnabled(boolean enabled) {
		verticalScrollEnabled = enabled;
		verticalScroll = 0;
	}

	protected void scrollToEnsureCursorVisible() {
		int virtualX = getCharacterVirtualX(method_1881());
		int virtualY = getCharacterVirtualY(method_1881());

		setHorizontalScroll(class_3532.method_15340(horizontalScroll, virtualX - method_1859(), virtualX));
		setVerticalScroll(class_3532.method_15340(verticalScroll, virtualY - getInnerHeight(), virtualY));
	}

	public int getLineHeight() {
		return lineHeight;
	}

	public void setLineHeight(int lineHeight) {
		this.lineHeight = lineHeight;
	}

    public int getCharacterVirtualX(int charIndex) {
		if (charIndex > method_1882().length()) {
			return 0;
		}
		String line = getLine(getLineIndex(charIndex));

		int indexInLine = charIndex - getLineStartBefore(charIndex);
		if (indexInLine > line.length()) {
			indexInLine = line.length();
		}

		return self.getTextRenderer().method_1727(line.substring(0, indexInLine));
	}

	public int getCharacterRealX(int charIndex) {
		return getInnerX() - horizontalScroll + getCharacterVirtualX(charIndex);
	}

	/**
	 * Gets the desired X position of the {@link class_4717} window.
	 *
	 * <p>This function is marked as deprecated because it <i>does not do what
	 * the method name says</i> and is only here to be called by
	 * {@code ChatInputSuggestor}.</p>
	 *
	 * @param charIndex The index of the character to place the suggestion
	 *                  window at.
	 * @return The desired X position of the suggestion window.
	 */
	@Deprecated
	@Override
	public int method_1889(int charIndex) {
		// Since getInnerX isn't a method in the original TextFieldWidget,
		// ChatInputSuggestor calls getCharacterX(0) instead.
		if (charIndex == 0) {
			return getInnerX();
		}
		// Enforce a lower bound on position. ChatInputSuggestor will enforce
		// the upper bound using getInnerWidth().
		return Math.max(getCharacterRealX(charIndex), getInnerX());
	}

	public int getCharacterVirtualY(int charIndex) {
		if (charIndex > method_1882().length()) {
			charIndex = method_1882().length();
		}
		int lineIndex = getLineIndex(charIndex);

		return lineIndex * getLineHeight();
	}

	public int getCharacterRealY(int charIndex) {
		return getInnerY() - verticalScroll + getCharacterVirtualY(charIndex);
	}

	private int getInnerX() {
		return this.method_46426() + (method_1851() ? 4 : 0);
	}

	private int getInnerY() {
		return this.method_46427() + (method_1851() ? 4 : 0);
	}

	private int getInnerHeight() {
		return method_1851() ? this.field_22759 - 6 : this.field_22759;
	}

    private static final Logger logger = LogManager.getLogger();

	@FunctionalInterface
	public interface SyntaxHighlighter {
        /**
         * A syntax highlighter that performs no highlighting.
         */
		SyntaxHighlighter NONE = text -> Arrays.stream(text.split("\n"))
            .map(line -> class_5481.method_30747(line, class_2583.field_24360))
            .toList();

		List<class_5481> highlight(String text);
	}
}
