package arm32x.minecraft.commandblockide.client.gui.button;

import arm32x.minecraft.commandblockide.client.Dirtyable;
import net.minecraft.class_11907;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7919;

public final class CommandBlockAutoButton extends IconButton implements Dirtyable {
	private boolean auto = false;

	private boolean dirty = false;

	public CommandBlockAutoButton(int x, int y) {
		super(x, y, 16, 16);
		method_47400(class_7919.method_47407(getTooltipText()));
	}

	@Override
	protected class_2960 getTexture() {
		return auto
			? class_2960.method_60655("minecraft", "textures/item/gunpowder.png")
			: class_2960.method_60655("minecraft", "textures/item/redstone.png");
	}

	@Override
	public class_5250 method_25360() {
		return method_32602(getTooltipText());
	}

	private class_2561 getTooltipText() {
		return auto
			? class_2561.method_43471("advMode.mode.autoexec.bat")
			: class_2561.method_43471("advMode.mode.redstoneTriggered");
	}

	@Override
	public void method_25306(class_11907 input) {
		auto = !auto;
		dirty = true;
		updateTooltip();
	}

	@Override
	public boolean isDirty() { return dirty; }

	public boolean isAuto() {
		return auto;
	}

	public void setAuto(boolean auto) {
		this.auto = auto;
		updateTooltip();
	}

	private void updateTooltip() {
		method_47400(class_7919.method_47407(getTooltipText()));
	}
}
