package arm32x.minecraft.commandblockide.client.gui.button;

import arm32x.minecraft.commandblockide.client.Dirtyable;
import net.minecraft.class_11907;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7919;

public final class CommandBlockTrackOutputButton extends IconButton implements Dirtyable {
	private boolean trackingOutput = false;

	private boolean dirty = false;

	public CommandBlockTrackOutputButton(int x, int y) {
		super(x, y, 16, 16);
		updateTooltip();
	}

	@Override
	protected class_2960 getTexture() {
		return trackingOutput
			? class_2960.method_60655("minecraft", "textures/item/writable_book.png")
			: class_2960.method_60655("minecraft", "textures/item/written_book.png");
	}

	@Override
	public class_5250 method_25360() {
		return method_32602(getTooltipText());
	}

	private class_2561 getTooltipText() {
		return trackingOutput
			? class_2561.method_43471("commandBlockIDE.lastOutput.on")
			: class_2561.method_43471("commandBlockIDE.lastOutput.off");
	}

	@Override
	public void method_25306(class_11907 input) {
		trackingOutput = !trackingOutput;
		dirty = true;
		updateTooltip();
	}

	@Override
	public boolean isDirty() { return dirty; }

	private void updateTooltip() {
		method_47400(class_7919.method_47407(getTooltipText()));
	}

	public boolean isTrackingOutput() {
		return trackingOutput;
	}

	public void setTrackingOutput(boolean trackingOutput) {
		this.trackingOutput = trackingOutput;
		updateTooltip();
	}
}
