package arm32x.minecraft.commandblockide.client.gui.button;

import arm32x.minecraft.commandblockide.client.Dirtyable;
import arm32x.minecraft.commandblockide.mixin.client.DrawContextAccessor;
import net.minecraft.class_10799;
import net.minecraft.class_11876;
import net.minecraft.class_11907;
import net.minecraft.class_2561;
import net.minecraft.class_2593;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_7919;

public final class CommandBlockTypeButton extends IconButton implements Dirtyable {
	private class_2593.class_2594 type = class_2593.class_2594.field_11924;
	private boolean conditional = false;

	private boolean dirty = false;

	public CommandBlockTypeButton(int x, int y) {
		super(x, y, 16, 16);
		updateTooltip();
	}

	@Override
	public void method_25306(class_11907 input) {
		if (input.method_74239()) {
			conditional = !conditional;
		} else {
			switch (type) {
				case field_11924 -> type = class_2593.class_2594.field_11923;
				case field_11923 -> type = class_2593.class_2594.field_11922;
				case field_11922 -> type = class_2593.class_2594.field_11924;
			}
		}
		dirty = true;
		updateTooltip();
	}

	@Override
	public class_5250 method_25360() {
		return method_32602(getTooltipText());
	}

	private class_2561 getTooltipText() {
		StringBuilder keyBuilder = new StringBuilder("commandBlockIDE.type.");
		keyBuilder.append(type.name().toLowerCase());
		if (conditional) {
			keyBuilder.append("Conditional");
		}
		return class_2561.method_43471(keyBuilder.toString());
	}

	@Override
	protected class_2960 getTexture() {
		StringBuilder idBuilder = new StringBuilder("textures/block/");
		switch (type) {
			case field_11924:
				break;
			case field_11923:
				idBuilder.append("repeating_");
				break;
			case field_11922:
				idBuilder.append("chain_");
				break;
		}
		idBuilder.append("command_block_");
		if (conditional) {
			idBuilder.append("conditional");
		} else {
			idBuilder.append("side");
		}
		idBuilder.append(".png");
		return class_2960.method_60655("minecraft", idBuilder.toString());
	}

	@Override
	public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
		var texture = getTexture();

		int color = field_22763 ? 0xFFFFFFFF : 0x7FFFFFFF;
		int shadowColor = 0x3F000000;

		if (field_22763) {
			context.method_25291(class_10799.field_56883, texture, method_46426() + 1, method_46427() + 1, 0, 0, iconWidth, iconHeight, 16, 64, shadowColor);
		}

        // The public version of drawTexturedQuad doesn't expose the color
        // parameter, which we need, so we have to use the private version.
		int x1 = method_46426(), x2 = x1 + 16, y1 = method_46427(), y2 = y1 + 16;
		float u1 = 0.0f, u2 = 1.0f, v1 = 0.0f, v2 = 0.25f;
		((DrawContextAccessor)context).invokeDrawTexturedQuad(class_10799.field_56883, texture, x1, x2, y1, y2, u2, u1, v2, v1, color);

        // super.renderWidget does this as well, but we don't call that here
        if (method_49606()) {
            context.method_74037(method_37303() ? class_11876.field_62455 : class_11876.field_62459);
        }
	}

	@Override
	public boolean isDirty() { return dirty; }

	private void updateTooltip() {
		method_47400(class_7919.method_47407(getTooltipText()));
	}

	public class_2593.class_2594 getBlockType() {
		return type;
	}

	public void setBlockType(class_2593.class_2594 type) {
		this.type = type;
		updateTooltip();
	}

	public boolean isConditional() {
		return conditional;
	}

	public void setConditional(boolean conditional) {
		this.conditional = conditional;
		updateTooltip();
	}
}
