package arm32x.minecraft.commandblockide.client.gui.button;

import net.minecraft.class_10799;
import net.minecraft.class_11876;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_5250;
import net.minecraft.class_6382;
import net.minecraft.class_9848;

public abstract class IconButton extends class_4264 {
	protected final int iconWidth;
	protected final int iconHeight;

	public IconButton(int x, int y, int width, int height) {
		this(x, y, width, height, width, height);
	}

	public IconButton(int x, int y, int width, int height, int iconWidth, int iconHeight) {
		super(x, y, width, height, class_2561.method_43473());
		this.iconWidth = iconWidth;
		this.iconHeight = iconHeight;
	}

	@Override
	public final class_2561 method_25369() {
		return class_2561.method_43473();
	}

	@Override
	protected abstract class_5250 method_25360();

	protected abstract class_2960 getTexture();

	/**
	 * Whether the standard Minecraft button background will be rendered. This
	 * does not affect the clickable area or the tooltip.
	 */
	public boolean drawsBackground() {
		return false;
	}

	@Override
	public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
		boolean drawsBackground = drawsBackground();
		if (drawsBackground) {
			super.method_48579(context, mouseX, mouseY, delta);
		}

		var texture = getTexture();

		int iconX = method_46426() + (field_22758 - iconWidth) / 2;
		int iconY = method_46427() + (field_22759 - iconHeight) / 2;

		if (drawsBackground) {
			float brightness = field_22763 ? 1.0f : (float)0xA0 / 0xFF;

			int color = class_9848.method_61318(1.0f, brightness, brightness, brightness);
			int shadowColor = class_9848.method_61318(1.0f, brightness / 4, brightness / 4, brightness / 4);

			context.method_25291(class_10799.field_56883, texture, iconX + 1, iconY + 1, 0, 0, iconWidth, iconHeight, iconWidth, iconHeight, shadowColor);
			context.method_25291(class_10799.field_56883, texture, iconX, iconY, 0, 0, iconWidth, iconHeight, iconWidth, iconHeight, color);
		} else {
			// RenderSystem.enableBlend();
			// RenderSystem.defaultBlendFunc();
			// RenderSystem.enableDepthTest();

			int color = field_22763 ? 0xFFFFFFFF : 0x7FFFFFFF;
			int shadowColor = 0x3F000000;

			if (field_22763) {
				context.method_25291(class_10799.field_56883, texture, iconX + 1, iconY + 1, 0, 0, iconWidth, iconHeight, iconWidth, iconHeight, shadowColor);
			}
			context.method_25291(class_10799.field_56883, texture, iconX, iconY, 0, 0, iconWidth, iconHeight, iconWidth, iconHeight, color);

			// RenderSystem.disableDepthTest();
			// RenderSystem.disableBlend();
		}

        // super.renderWidget does this as well, but that is only called for
        // icon buttons with a background
        if (method_49606()) {
            context.method_74037(method_37303() ? class_11876.field_62455 : class_11876.field_62459);
        }
	}

	@Override
	public void method_47399(class_6382 builder) {
		method_37021(builder);
	}
}
