package arm32x.minecraft.commandblockide.client.gui.editor;

import arm32x.minecraft.commandblockide.client.Dirtyable;
import arm32x.minecraft.commandblockide.client.gui.button.CommandBlockAutoButton;
import arm32x.minecraft.commandblockide.client.gui.button.CommandBlockTrackOutputButton;
import arm32x.minecraft.commandblockide.client.gui.button.CommandBlockTypeButton;
import arm32x.minecraft.commandblockide.client.storage.MultilineCommandStorage;
import arm32x.minecraft.commandblockide.client.update.DataCommandUpdateRequester;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_1918;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2593;
import net.minecraft.class_2870;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_746;

public final class CommandBlockEditor extends CommandEditor {
	private final class_2593 blockEntity;

	private final class_342 lastOutputField;

	private final CommandBlockTypeButton typeButton;
	private final CommandBlockAutoButton autoButton;
	private final CommandBlockTrackOutputButton trackOutputButton;

	private boolean commandFieldDirty = false;

	public CommandBlockEditor(class_437 screen, class_327 textRenderer, int x, int y, int width, int height, class_2593 blockEntity, int index) {
		super(screen, textRenderer, x, y, width, height, 40, 20, index);
		this.blockEntity = blockEntity;

		commandField.method_1880(32500);

		lastOutputField = new class_342(
			textRenderer,
			commandField.method_46426(), commandField.method_46427(),
			commandField.method_25368(), commandField.method_25364(),
			class_2561.method_43471("advMode.previousOutput")
				.method_10852(class_2561.method_43469("commandBlockIDE.narrator.editorIndex", index + 1))
		);
		lastOutputField.method_1888(false);
		lastOutputField.method_1880(32500);
		lastOutputField.method_1852(class_2561.method_43471("commandBlockIDE.unloaded").getString());
		lastOutputField.field_22764 = false;

		typeButton = addDrawableChild(new CommandBlockTypeButton(x + 20, y));
		typeButton.setBlockType(blockEntity.method_11039());
		typeButton.field_22763 = false;

		autoButton = addDrawableChild(new CommandBlockAutoButton(x + 40, y));
		autoButton.setAuto(typeButton.getBlockType() == class_2593.class_2594.field_11922);
		autoButton.field_22763 = false;

		trackOutputButton = addDrawableChild(new CommandBlockTrackOutputButton(x + width - 16, y));
		trackOutputButton.setTrackingOutput(true);
		trackOutputButton.field_22763 = false;
	}

	public void save(class_634 networkHandler) {
		if (isLoaded() && isDirty()) {
			class_1918 executor = blockEntity.method_11040();
			networkHandler.method_52787(new class_2870(
				class_2338.method_49638(executor.method_8300()),
				getSingleLineCommand(),
				typeButton.getBlockType(),
				trackOutputButton.isTrackingOutput(),
				typeButton.isConditional(),
				autoButton.isAuto()
			));
			executor.method_8287(trackOutputButton.isTrackingOutput());
			if (!trackOutputButton.isTrackingOutput()) {
				executor.method_8291(null);
			}
			saveMultilineCommand();
		}
	}

	private void saveMultilineCommand() {
		class_310 client = class_310.method_1551();
		String world = client.method_1542()
			? Objects.requireNonNull(client.method_1576()).method_27728().method_150()
			: Objects.requireNonNull(client.method_1558()).field_3752;

		MultilineCommandStorage.getInstance().add(commandField.method_1882(), getSingleLineCommand(), client.method_1542(), world, blockEntity.method_11016());
	}

	public void update() {
		class_1918 executor = blockEntity.method_11040();
		class_310 client = class_310.method_1551();
		commandField.method_1852(MultilineCommandStorage.getInstance().getRobust(
			executor.method_8289(),
			processor,
			client.method_1542(),
			client.method_1542()
				? Objects.requireNonNull(client.method_1576()).method_27728().method_150()
				: Objects.requireNonNull(client.method_1558()).field_3752,
			class_2338.method_49638(executor.method_8300())
		));
		typeButton.setBlockType(blockEntity.method_11039());
		typeButton.setConditional(blockEntity.method_11046());
		autoButton.setAuto(blockEntity.method_11042());
		trackOutputButton.setTrackingOutput(executor.method_8296());

		String lastOutput = executor.method_8292().getString();
		if (lastOutput.isEmpty()) {
			lastOutput = class_2561.method_43471("commandBlockIDE.lastOutput.none").getString();
		}
		lastOutputField.method_1852(lastOutput);

		suggestor.method_23933(commandField.method_20315());
		suggestor.method_23934();

		commandFieldDirty = false;
		setLoaded(true);
	}

	public void requestUpdate(class_746 player) {
		DataCommandUpdateRequester.getInstance().requestUpdate(player, blockEntity);
	}

	@Override
	public void commandChanged(String newCommand) {
		if (!newCommand.equals(blockEntity.method_11040().method_8289())) {
			commandFieldDirty = true;
		}
		super.commandChanged(newCommand);
	}

	@Override
	protected void renderCommandField(class_332 context, int mouseX, int mouseY, float delta) {
		if (trackOutputButton.method_25405(mouseX, mouseY)) {
			commandField.field_22764 = false;
			lastOutputField.field_22764 = true;
			lastOutputField.method_25394(context, mouseX, mouseY, delta);
		} else {
			commandField.field_22764 = true;
			lastOutputField.field_22764 = false;
			commandField.method_25394(context, mouseX, mouseY, delta);
		}
	}

	@Override
	public void setLoaded(boolean loaded) {
		super.setLoaded(loaded);
		typeButton.field_22763 = loaded;
		autoButton.field_22763 = loaded;
		trackOutputButton.field_22763 = loaded;
	}

	@Override
	public boolean isDirty() {
		return commandFieldDirty
			|| Stream.<Dirtyable>of(typeButton, autoButton, trackOutputButton).anyMatch(Dirtyable::isDirty);
	}

	@Override
	public void setY(int y) {
		super.setY(y);

		lastOutputField.method_46419(commandField.method_46427());

		typeButton.method_46419(y);
		autoButton.method_46419(y);
		trackOutputButton.method_46419(y);
	}

	@Override
	public void setWidth(int width) {
		super.setWidth(width);

		lastOutputField.method_25358(commandField.method_25368());

		trackOutputButton.method_46421(getX() + width - 16);
	}
}
